/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.Utility;

public class ChoiceFormat
extends NumberFormat {
    private double[] choiceLimits;
    private String[] choiceFormats;
    static final long SIGN = Long.MIN_VALUE;
    static final long EXPONENT = 0x7FF0000000000000L;
    static final long POSITIVEINFINITY = 0x7FF0000000000000L;

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        int n = 0;
        while (n < stringBufferArray.length) {
            stringBufferArray[n] = new StringBuffer();
            ++n;
        }
        double[] dArray = new double[30];
        String[] stringArray = new String[30];
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = Double.NaN;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == '<' || c == '#' || c == '\u2264') {
                if (stringBufferArray[0].equals("")) {
                    throw new IllegalArgumentException();
                }
                try {
                    d = Double.valueOf(stringBufferArray[0].toString());
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException();
                }
                if (c == '<') {
                    d = ChoiceFormat.nextDouble(d);
                }
                if (d <= d2) {
                    throw new IllegalArgumentException();
                }
                stringBufferArray[0].setLength(0);
                n3 = 1;
            } else if (c == '|') {
                dArray[n2] = d;
                stringArray[n2] = stringBufferArray[1].toString();
                ++n2;
                d2 = d;
                stringBufferArray[1].setLength(0);
                n3 = 0;
            } else {
                stringBufferArray[n3].append(c);
            }
            ++n4;
        }
        if (n3 == 1) {
            dArray[n2] = d;
            stringArray[n2] = stringBufferArray[1].toString();
            ++n2;
        }
        this.choiceLimits = new double[n2];
        System.arraycopy(dArray, 0, this.choiceLimits, 0, n2);
        this.choiceFormats = new String[n2];
        System.arraycopy(stringArray, 0, this.choiceFormats, 0, n2);
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.choiceLimits.length) {
            double d;
            if (n != 0) {
                stringBuffer.append('|');
            }
            double d2 = ChoiceFormat.previousDouble(this.choiceLimits[n]);
            double d3 = Math.abs(Math.IEEEremainder(this.choiceLimits[n], 1.0));
            if (d3 < (d = Math.abs(Math.IEEEremainder(d2, 1.0)))) {
                stringBuffer.append(String.valueOf(this.choiceLimits[n]));
                stringBuffer.append('#');
            } else {
                stringBuffer.append(String.valueOf(d2));
                stringBuffer.append('<');
            }
            stringBuffer.append(this.choiceFormats[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        this.choiceLimits = dArray;
        this.choiceFormats = stringArray;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = 0;
        while (n < this.choiceLimits.length) {
            if (!(d >= this.choiceLimits[n])) break;
            ++n;
        }
        if (--n < 0) {
            n = 0;
        }
        return stringBuffer.append(this.choiceFormats[n]);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.index;
        double d = Double.NaN;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < this.choiceFormats.length) {
            String string2 = this.choiceFormats[n3];
            if (string.regionMatches(n, string2, 0, string2.length())) {
                parsePosition.index = string2.length();
                d2 = this.choiceLimits[n3];
                if (parsePosition.index > n2) {
                    n2 = parsePosition.index;
                    d = d2;
                    if (n2 == string.length()) break;
                }
            }
            ++n3;
        }
        parsePosition.index = n2;
        return new Double(d);
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public Object clone() {
        ChoiceFormat choiceFormat = (ChoiceFormat)super.clone();
        choiceFormat.choiceLimits = (double[])this.choiceLimits.clone();
        choiceFormat.choiceFormats = (String[])this.choiceFormats.clone();
        return choiceFormat;
    }

    public int hashCode() {
        int n = this.choiceLimits.length;
        if (this.choiceFormats.length > 0) {
            n ^= this.choiceFormats[this.choiceFormats.length - 1].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        return Utility.arrayEquals(this.choiceLimits, (Object)choiceFormat.choiceLimits) && Utility.arrayEquals(this.choiceFormats, (Object)choiceFormat.choiceFormats);
    }

    public static double nextDouble(double d, boolean bl) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (d == 0.0) {
            double d2 = Double.longBitsToDouble(1L);
            if (bl) {
                return d2;
            }
            return -d2;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MAX_VALUE;
        if (l > 0L == bl) {
            if (l2 != 0x7FF0000000000000L) {
                ++l2;
            }
        } else {
            --l2;
        }
        long l3 = l & Long.MIN_VALUE;
        return Double.longBitsToDouble(l2 | l3);
    }
}

