/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long julianDayOffset = 2440588L;
    private static final int millisPerDay = 86400000;
    private static final int[] numDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] leapNumDays = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int[] maxDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private long gregorianCutover = -12219292800000L;
    private static final int[] MinValues = new int[]{0, 1, 0, 1, 1, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] GreatestMinValues = new int[]{0, 1, 0, 1, 1, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] LeastMaxValues = new int[]{1, 5000000, 11, 53, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final int[] MaxValues = new int[]{1, 5000000, 11, 54, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};

    private static final long millisToJulianDay(long l) {
        if (l >= 0L) {
            return 2440588L + l / 86400000L;
        }
        return 2440588L + (l - 86400000L + 1L) / 86400000L;
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    public GregorianCalendar() {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.time = System.currentTimeMillis();
        this.isTimeSet = true;
        this.areFieldsSet = false;
    }

    public GregorianCalendar(TimeZone timeZone) {
        super(timeZone, Locale.getDefault());
        this.set(0, 1);
        this.time = System.currentTimeMillis();
        this.isTimeSet = true;
        this.areFieldsSet = false;
    }

    public GregorianCalendar(Locale locale) {
        super(TimeZone.getDefault(), locale);
        this.set(0, 1);
        this.time = System.currentTimeMillis();
        this.isTimeSet = true;
        this.areFieldsSet = false;
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.set(0, 1);
        this.time = System.currentTimeMillis();
        this.isTimeSet = true;
        this.areFieldsSet = false;
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private final void timeToFields(long l) {
        long l2;
        int n = 1;
        long l3 = GregorianCalendar.millisToJulianDay(l);
        if (l >= this.gregorianCutover) {
            long l4 = (long)(((double)(l3 - 1867216L) - 0.25) / 36524.25);
            l2 = l3 + 1L + l4 - (long)(0.25 * (double)l4);
        } else {
            l2 = l3;
        }
        long l5 = l2 + 1524L;
        long l6 = (long)(6680.0 + ((double)(l5 - 2439870L) - 122.1) / 365.25);
        long l7 = (long)((double)(365L * l6) + 0.25 * (double)l6);
        long l8 = (long)((double)(l5 - l7) / 30.6001);
        int n2 = (int)(l5 - l7 - (long)(30.6001 * (double)l8));
        int n3 = (int)l8 - 1;
        if (n3 > 12) {
            n3 -= 12;
        } else if (n3 < 0) {
            n3 += 12;
        }
        int n4 = (int)(l6 - 4715L);
        if (n3 > 2) {
            --n4;
        }
        if (n4 <= 0) {
            n = 0;
            n4 = 1 - n4;
        }
        this.set(0, n);
        this.set(1, n4);
        this.set(2, n3 - 1);
        this.set(5, n2);
        int n5 = l3 >= -1L ? 1 + (int)((l3 + 1L) % 7L) : 1 + (int)((l3 + 1L) % 7L + 7L);
        this.set(7, n5);
        int n6 = this.isLeapYear(n4) ? leapNumDays[n3 - 1] + n2 : numDays[n3 - 1] + n2;
        this.set(6, n6);
        int n7 = (n5 - 1 - n6 + 1) % 7;
        if (n7 < 0) {
            n7 += 7;
        }
        int n8 = GregorianCalendar.weekNumber(n6, n5 - 1, n7, this.getFirstDayOfWeek() - 1, this.getMinimalDaysInFirstWeek());
        this.set(3, n8);
        n7 = (n5 - 1 - n2 + 1) % 7;
        if (n7 < 0) {
            n7 += 7;
        }
        n8 = GregorianCalendar.weekNumber(n2, n5 - 1, n7, this.getFirstDayOfWeek() - 1, this.getMinimalDaysInFirstWeek());
        this.set(4, n8);
    }

    private static int weekNumber(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n - 1) / 7 + 1;
        int n7 = (n4 + 6) % 7;
        if (n7 < n3) {
            n7 += 7;
        }
        if (n7 - n3 + 1 < n5) {
            --n6;
        }
        return n6;
    }

    private static int dateFrom(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 - n3;
        if (n6 < 0) {
            n6 += 7;
        }
        int n7 = (n - 1) * 7 + n6 + 1;
        int n8 = (n4 + 6) % 7;
        if (n8 < n3) {
            n8 += 7;
        }
        if (n8 - n3 + 1 < n5) {
            n7 -= 7;
        }
        return n7;
    }

    public boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected void computeFields() {
        if (!this.isTimeSet) {
            return;
        }
        long l = this.time;
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            l += (long)timeZone.getRawOffset();
        }
        this.timeToFields(l);
        int n = this.internalGet(0);
        int n2 = this.internalGet(1);
        int n3 = this.internalGet(2);
        int n4 = this.internalGet(5);
        int n5 = this.internalGet(7);
        int n6 = (int)(l % 86400000L);
        if (n6 < 0) {
            n6 += 86400000;
        }
        int n7 = 0;
        int n8 = 0;
        if (timeZone != null) {
            n7 = timeZone.getRawOffset();
            n8 = timeZone.getOffset(n, n2, n3, n4, n5, n6);
            l = this.time + (long)n8;
            if (n6 + (n8 -= n7) >= 86400000) {
                this.timeToFields(l);
                n5 = this.internalGet(7);
                n4 = this.internalGet(5);
                n3 = this.internalGet(2);
                n2 = this.internalGet(1);
                n = this.internalGet(0);
            }
            if ((n6 = (int)(l % 86400000L)) < 0) {
                n6 += 86400000;
            }
        }
        this.set(14, n6 % 1000);
        this.set(13, (n6 /= 1000) % 60);
        this.set(12, (n6 /= 60) % 60);
        this.set(11, n6 /= 60);
        this.set(9, n6 / 12);
        int n9 = n6 % 12;
        this.set(10, n9);
        this.set(15, n7);
        this.set(16, n8);
        this.set(8, (n4 - 1) / 7 + 1);
        this.areFieldsSet = true;
    }

    private boolean validateFields() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 <= 4) {
            if (this.isSet(n3) && !this.boundsCheck(this.internalGet(n3), n3)) {
                return false;
            }
            ++n3;
        }
        if (this.isSet(5)) {
            n2 = this.internalGet(1);
            n = this.internalGet(2);
            int n4 = this.internalGet(5);
            if (n == 1 && this.isLeapYear(n2) ? n4 < this.getMinimum(5) || n4 > 29 : n4 < this.getMinimum(5) || n4 > maxDaysInMonth[n]) {
                return false;
            }
        }
        if (this.isSet(6)) {
            n2 = this.internalGet(1);
            n = this.internalGet(6);
            if (this.isLeapYear(n2) ? n < 1 || n > 366 : n < 1 || n > 365) {
                return false;
            }
        }
        n3 = 7;
        while (n3 <= 16) {
            if (this.isSet(n3) && !this.boundsCheck(this.internalGet(n3), n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void computeTime() {
        if (!this.areFieldsSet) {
            return;
        }
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        this.isTimeSet = true;
        this.time = 0L;
        int n = this.internalGet(0);
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.internalGet(1);
        int n3 = 0;
        int n4 = 0;
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n2 = 1 - n2;
        }
        long l = 0L;
        if (this.isSet(2) && (this.isSet(5) || this.isSet(7) && (this.isSet(4) || this.isSet(8)))) {
            n3 = this.internalGet(2) + 1;
            if (n3 < 1) {
                throw new IllegalArgumentException();
            }
            if (n3 > 12) {
                n2 += n3 / 12;
                n3 %= 12;
            }
            if (n3 > 2) {
                ++n3;
            } else {
                --n2;
                n3 += 13;
            }
            l = (long)(Math.floor(365.25 * (double)n2) + Math.floor(30.6001 * (double)n3) + 1720995.0);
            if (!this.isSet(5)) throw new IllegalArgumentException();
            n4 = this.internalGet(5);
            l += (long)n4;
        } else {
            if (!this.isSet(6) && (!this.isSet(7) || !this.isSet(3))) throw new IllegalArgumentException();
            l = (long)(Math.floor(365.25 * (double)(--n2)) + 428.0 + 1720995.0);
            if (!this.isSet(6)) throw new IllegalArgumentException();
            l += (long)this.internalGet(6);
        }
        if (GregorianCalendar.julianDayToMillis(l) >= this.gregorianCutover) {
            long l2 = (long)(0.01 * (double)n2);
            l += 2L - l2 + (long)(0.25 * (double)l2);
        }
        this.time = GregorianCalendar.julianDayToMillis(l);
        int n5 = 0;
        if (this.isSet(11)) {
            n5 += this.internalGet(11) % 24;
        } else if (this.isSet(10)) {
            n5 += this.internalGet(10) % 12;
            n5 += 12 * this.internalGet(9);
        }
        n5 *= 60;
        n5 += this.internalGet(12);
        n5 *= 60;
        n5 += this.internalGet(13);
        n5 *= 1000;
        this.time += (long)(n5 += this.internalGet(14));
        int n6 = 0;
        if (this.isSet(15)) {
            n6 = this.internalGet(15);
            n6 += this.internalGet(16);
        } else {
            TimeZone timeZone = this.getTimeZone();
            if (timeZone != null) {
                if (this.isSet(2) && this.isSet(5)) {
                    int n7 = this.isSet(7) ? this.internalGet(7) : 1 + (int)((l + 1L) % 7L);
                    n6 = timeZone.getOffset(n, this.internalGet(1), this.internalGet(2), this.internalGet(5), n7, n5);
                } else {
                    long l3 = this.time;
                    this.setTimeInMillis(this.time - (long)timeZone.getRawOffset());
                    this.computeFields();
                    n6 = timeZone.getOffset(n, this.internalGet(1), this.internalGet(2), this.internalGet(5), this.internalGet(7), n5);
                    this.time = l3;
                }
            }
        }
        this.time -= (long)n6;
    }

    public Object clone() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)super.clone();
        gregorianCalendar.setLenient(this.isLenient());
        gregorianCalendar.setTimeZone(this.getTimeZone());
        gregorianCalendar.setFirstDayOfWeek(this.getFirstDayOfWeek());
        gregorianCalendar.setMinimalDaysInFirstWeek(this.getMinimalDaysInFirstWeek());
        return gregorianCalendar;
    }

    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        if (this.getTimeInMillis() != gregorianCalendar.getTimeInMillis()) {
            return false;
        }
        if (this.hashCode() != gregorianCalendar.hashCode()) {
            return false;
        }
        if (this.isLenient() != gregorianCalendar.isLenient()) {
            return false;
        }
        if (this.getFirstDayOfWeek() != gregorianCalendar.getFirstDayOfWeek()) {
            return false;
        }
        if (this.getMinimalDaysInFirstWeek() != gregorianCalendar.getMinimalDaysInFirstWeek()) {
            return false;
        }
        return this.getTimeZone().equals(gregorianCalendar.getTimeZone());
    }

    public boolean before(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return this.getTimeInMillis() < gregorianCalendar.getTimeInMillis();
    }

    public boolean after(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        return this.getTimeInMillis() > gregorianCalendar.getTimeInMillis();
    }

    public void add(int n, int n2) {
        if (!this.areFieldsSet) {
            this.computeFields();
        }
        if (n2 == 0) {
            return;
        }
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGet(0) == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                    return;
                }
                this.set(1, 1 - n3);
                this.set(0, 0);
                return;
            }
            if ((n3 -= n2) > 0) {
                this.set(1, n3);
                return;
            }
            this.set(1, 1 - n3);
            this.set(0, 1);
            return;
        }
        if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            if (n4 >= 0) {
                this.add(1, n4 / 12);
                this.set(2, n4 % 12);
                return;
            }
            this.add(1, (n4 + 1) / 12 - 1);
            if (n4 % 12 == 0) {
                this.set(2, 0);
                return;
            }
            this.set(2, n4 % 12 + 12);
            return;
        }
        long l = n2;
        switch (n) {
            case 0: 
            case 15: 
            case 16: {
                throw new IllegalArgumentException();
            }
            case 3: 
            case 4: 
            case 8: {
                l *= 604800000L;
                break;
            }
            case 9: {
                l *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                l *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                l *= 3600000L;
                break;
            }
            case 12: {
                l *= 60000L;
                break;
            }
            case 13: {
                l *= 1000L;
                break;
            }
        }
        this.time += l;
        this.setTimeInMillis(this.time);
        this.computeFields();
    }

    public void roll(int n, boolean bl) {
        if (!this.areFieldsSet) {
            this.computeFields();
        }
        if (bl) {
            switch (n) {
                case 0: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 16: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    this.set(1, (this.internalGet(1) + 1) % this.getMaximum(1));
                    return;
                }
                case 2: {
                    this.set(2, (this.internalGet(2) + 1) % 12);
                    return;
                }
                case 5: {
                    if (this.internalGet(2) == 1 && this.isLeapYear(this.internalGet(1))) {
                        this.set(5, this.internalGet(5) % 29 + 1);
                        return;
                    }
                    this.set(5, this.internalGet(5) % maxDaysInMonth[this.internalGet(2)] + 1);
                    return;
                }
                case 11: {
                    this.set(11, (this.internalGet(11) + 1) % 24);
                    return;
                }
                case 12: {
                    this.set(12, (this.internalGet(12) + 1) % 60);
                    return;
                }
                case 13: {
                    this.set(13, (this.internalGet(13) + 1) % 60);
                    return;
                }
                case 14: {
                    this.set(14, (this.internalGet(14) + 1) % 1000);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                throw new IllegalArgumentException();
            }
            case 1: {
                this.rollDown(1);
                return;
            }
            case 2: {
                this.rollDown(2);
                return;
            }
            case 5: {
                if (this.internalGet(5) == this.getMinimum(5)) {
                    if (this.internalGet(2) == 1 && this.isLeapYear(this.internalGet(1))) {
                        this.set(5, 29);
                        return;
                    }
                    this.set(5, maxDaysInMonth[this.internalGet(2)]);
                    return;
                }
                this.set(5, this.internalGet(5) - 1);
                return;
            }
            case 11: {
                this.rollDown(11);
                return;
            }
            case 12: {
                this.rollDown(12);
                return;
            }
            case 13: {
                this.rollDown(13);
                return;
            }
            case 14: {
                this.rollDown(14);
                return;
            }
        }
    }

    private void rollDown(int n) {
        if (this.internalGet(n) == this.getMinimum(n)) {
            this.set(n, this.getMaximum(n));
            return;
        }
        this.set(n, this.internalGet(n) - 1);
    }

    public int getMinimum(int n) {
        return MinValues[n];
    }

    public int getMaximum(int n) {
        return MaxValues[n];
    }

    public int getGreatestMinimum(int n) {
        return GreatestMinValues[n];
    }

    public int getLeastMaximum(int n) {
        return LeastMaxValues[n];
    }
}

