/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbc
extends JdbcOdbcObject {
    public static final int MajorVersion = 1;
    public static final int MinorVersion = 1001;

    public JdbcOdbc(String string) throws SQLException {
        try {
            if (JdbcOdbcObject.isTracing()) {
                Date date = new Date();
                String string2 = "";
                int n = 1001;
                if (n < 1000) {
                    string2 = String.valueOf(string2) + "0";
                }
                if (n < 100) {
                    string2 = String.valueOf(string2) + "0";
                }
                if (n < 10) {
                    string2 = String.valueOf(string2) + "0";
                }
                string2 = String.valueOf(string2) + "" + n;
                JdbcOdbcObject.trace("JDBC to ODBC Bridge " + 1 + "." + string2);
                JdbcOdbcObject.trace("Current Date/Time: " + date.toString());
                JdbcOdbcObject.trace("Loading " + string + "JdbcOdbc library");
            }
            System.loadLibrary(String.valueOf(string) + "JdbcOdbc");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Unable to load " + string + "JdbcOdbc library");
            }
            throw new SQLException("Unable to load " + string + "JdbcOdbc library");
        }
    }

    public synchronized int SQLAllocConnect(int n) throws SQLException {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Connection handle (SQLAllocConnect)");
        }
        byte[] byArray = new byte[1];
        n2 = this.allocConnect(n, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hDbc=" + n2);
        }
        return n2;
    }

    public synchronized int SQLAllocEnv() throws SQLException {
        int n = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Environment handle (SQLAllocEnv)");
        }
        byte[] byArray = new byte[1];
        n = this.allocEnv(byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hEnv=" + n);
        }
        return n;
    }

    public synchronized int SQLAllocStmt(int n) throws SQLException {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Statement Handle (SQLAllocStmt), hDbc=" + n);
        }
        byte[] byArray = new byte[1];
        n2 = this.allocStmt(n, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hStmt=" + n2);
        }
        return n2;
    }

    public synchronized void SQLBindColDefault(int n, int n2, byte[] byArray, byte[] byArray2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding default column (SQLBindCol), hStmt=" + n + ", ipar=" + n2 + ", length=" + byArray.length);
        }
        byte[] byArray3 = new byte[1];
        this.bindColDefault(n, n2, byArray, byArray2, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterAtExec(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3 + ", len=" + n4);
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterAtExec(n, n2, n3, n4, byArray, byArray2, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterBinary(int n, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) throws SQLException {
        int n4 = JdbcOdbcLimits.DEFAULT_IN_PRECISION;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN binary parameter (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3);
            JdbcOdbcObject.dumpByte(byArray, byArray.length);
        }
        byte[] byArray4 = new byte[1];
        this.bindInParameterBinary(n, n2, OdbcDef.jdbcTypeToOdbc(n3), byArray, n4, byArray2, byArray3, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterDate(int n, int n2, java.sql.Date date, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", rgbValue=" + date.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDate(n, n2, date.getYear() + 1900, date.getMonth() + 1, date.getDate(), byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterDouble(int n, int n2, int n3, int n4, double d, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter double (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3 + ", scale=" + n4 + ", rgbValue=" + d);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDouble(n, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, d, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterFloat(int n, int n2, int n3, int n4, float f, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter float (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3 + ", scale=" + n4 + ", rgbValue=" + f);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterFloat(n, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, f, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterInteger(int n, int n2, int n3, int n4, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter integer (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + "SQLtype=" + n3 + ", rgbValue=" + n4);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterInteger(n, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterNull(int n, int n2, int n3, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN NULL parameter (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterNull(n, n2, n3, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterString(int n, int n2, int n3, int n4, int n5, String string, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN string parameter (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + string);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterString(n, n2, OdbcDef.jdbcTypeToOdbc(n3), string, n4, n5, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterTime(int n, int n2, Time time, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", rgbValue=" + time.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterTime(n, n2, time.getHours(), time.getMinutes(), time.getSeconds(), byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindInParameterTimestamp(int n, int n2, Timestamp timestamp, byte[] byArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", rgbValue=" + timestamp.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterTimestamp(n, n2, timestamp.getYear() + 1900, timestamp.getMonth() + 1, timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos(), byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLBindOutParameterString(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + n + ", ipar=" + n2 + ", SQLtype=" + n3 + ", prec=" + (byArray.length - 1) + ", scale=" + n4);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterString(n, n2, n3, n4, byArray, byArray2, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0, 0, n);
        }
    }

    public synchronized String SQLBrowseConnect(int n, String string) throws SQLException, SQLWarning {
        String string2 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connecting (SQLBrowseConnect), hDbc=" + n + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[JdbcOdbcLimits.MAX_BROWSE_RESULT_LENGTH];
        this.browseConnect(n, string, byArray2, byArray);
        if (byArray[0] == 99) {
            string2 = new String(byArray2, 0);
            string2 = string2.trim();
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Attributes=" + string2);
        }
        return string2;
    }

    public synchronized void SQLCancel(int n) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Cancelling (SQLCancel), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        this.cancel(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized int SQLColAttributes(int n, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        int n4 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Column attributes (SQLColAttributes), hStmt=" + n + ", icol=" + n2 + ", type=" + n3);
        }
        byte[] byArray = new byte[1];
        n4 = this.colAttributes(n, n2, n3, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value (int)=" + n4);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n4);
                throw jdbcOdbcSQLWarning;
            }
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value (int)=" + n4);
        }
        return n4;
    }

    public synchronized String SQLColAttributesString(int n, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Column attributes (SQLColAttributes), hStmt=" + n + ", icol=" + n2 + ", type=" + n3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH];
        this.colAttributesString(n, n2, n3, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String(byArray2, 0);
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value (String)=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String(byArray2, 0);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value (String)=" + string.trim());
        }
        return string.trim();
    }

    public synchronized void SQLColumns(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLColumns), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        this.columns(n, string, string == null, string2, string2 == null, string3, string3 == null, string4, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLColumnPrivileges(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLColumnPrivileges), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        this.columnPrivileges(n, string, string == null, string2, string2 == null, string3, string3 == null, string4, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized boolean SQLDescribeParamNullable(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        boolean bl = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter nullable (SQLDescribeParam), hStmt=" + n + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 4, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (n3 == 1) {
            bl = true;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("nullable=" + bl);
        }
        return bl;
    }

    public synchronized int SQLDescribeParamPrecision(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter precision (SQLDescribeParam), hStmt=" + n + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("precision=" + n3);
        }
        return n3;
    }

    public synchronized int SQLDescribeParamScale(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter scale (SQLDescribeParam), hStmt=" + n + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("scale=" + n3);
        }
        return n3;
    }

    public synchronized int SQLDescribeParamType(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter type (SQLDescribeParam), hStmt=" + n + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 1, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("type=" + n3);
        }
        return n3;
    }

    public synchronized void SQLDisconnect(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Disconnecting (SQLDisconnect), hDbc=" + n);
        }
        byte[] byArray = new byte[1];
        this.disconnect(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public synchronized void SQLDriverConnect(int n, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connecting (SQLDriverConnect), hDbc=" + n + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        this.driverConnect(n, string, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public synchronized void SQLExecDirect(int n, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Executing (SQLExecDirect), hStmt=" + n + ", szSqlStr=" + string);
        }
        byte[] byArray = new byte[1];
        this.execDirect(n, string, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized boolean SQLExecute(int n) throws SQLException, SQLWarning {
        boolean bl = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Executing (SQLExecute), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        this.execute(n, byArray);
        if (byArray[0] == 99) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("SQL_NEED_DATA returned");
            }
            bl = true;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        return bl;
    }

    public synchronized boolean SQLFetch(int n) throws SQLException, SQLWarning {
        boolean bl = true;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Fetching (SQLFetch), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        this.fetch(n, byArray);
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        return bl;
    }

    public synchronized void SQLForeignKeys(int n, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLForeignKeys), hStmt=" + n + ", Pcatalog=" + string + ", Pschema=" + string2 + ", Ptable=" + string3 + ", Fcatalog=" + string4 + ", Fschema=" + string5 + ", Ftable=" + string6);
        }
        byte[] byArray = new byte[1];
        this.foreignKeys(n, string, string == null, string2, string2 == null, string3, string3 == null, string4, string4 == null, string5, string5 == null, string6, string6 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLFreeConnect(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Closing connection (SQLFreeConnect), hDbc=" + n);
        }
        byte[] byArray = new byte[1];
        this.freeConnect(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public synchronized void SQLFreeEnv(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Closing environment (SQLFreeEnv), hEnv=" + n);
        }
        byte[] byArray = new byte[1];
        this.freeEnv(n, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public synchronized void SQLFreeStmt(int n, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Free statement (SQLFreeStmt), hStmt=" + n + ", fOption=" + n2);
        }
        byte[] byArray = new byte[1];
        this.freeStmt(n, n2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public synchronized int SQLGetConnectOption(int n, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection Option (SQLGetConnectOption), hDbc=" + n + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getConnectOption(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("option value (int)=" + n2);
        }
        return n2;
    }

    public synchronized String SQLGetConnectOptionString(int n, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection Option (SQLGetConnectOption), hDbc=" + n + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH];
        this.getConnectOptionString(n, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        String string = new String(byArray2, 0);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("option value (int)=" + string.trim());
        }
        return string.trim();
    }

    public synchronized String SQLGetCursorName(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Cursor name (SQLGetCursorName), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH];
        this.getCursorName(n, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String(byArray2, 0);
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String(byArray2, 0);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + string.trim());
        }
        return string.trim();
    }

    public synchronized int SQLGetDataBinary(int n, int n2, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        return this.SQLGetDataBinary(n, n2, -2, byArray, byArray.length);
    }

    public synchronized int SQLGetDataBinary(int n, int n2, int n3, byte[] byArray, int n4) throws SQLException, JdbcOdbcSQLWarning {
        int n5 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get binary data (SQLGetData), hStmt=" + n + ", column=" + n2 + ", type=" + n3 + ", length=" + n4);
        }
        byte[] byArray2 = new byte[2];
        n5 = this.getDataBinary(n, n2, n3, byArray, n4, byArray2);
        if (byArray2[0] == 100) {
            n5 = -1;
            byArray2[0] = 0;
        }
        if (byArray2[0] != 0) {
            try {
                this.standardError(byArray2[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    if (n5 == -1) {
                        JdbcOdbcObject.trace("NULL");
                    } else if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("Bytes: " + n5);
                    }
                }
                jdbcOdbcSQLWarning.value = new Integer(n5);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            if (n5 == -1) {
                JdbcOdbcObject.trace("NULL");
            } else if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Bytes: " + n5);
            }
        }
        return n5;
    }

    public synchronized Double SQLGetDataDouble(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get double data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        double d = this.getDataDouble(n, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + d);
                    }
                    jdbcOdbcSQLWarning.value = new Double(d);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + d);
            }
            return new Double(d);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized Float SQLGetDataFloat(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get float data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        float f = this.getDataFloat(n, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + f);
                    }
                    jdbcOdbcSQLWarning.value = new Float(f);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + f);
            }
            return new Float(f);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized Integer SQLGetDataInteger(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get integer data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        int n3 = this.getDataInteger(n, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + n3);
                    }
                    jdbcOdbcSQLWarning.value = new Integer(n3);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + n3);
            }
            return new Integer(n3);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized String SQLGetDataString(int n, int n2, int n3, boolean bl) throws SQLException, JdbcOdbcSQLWarning {
        byte[] byArray;
        byte[] byArray2;
        int n4;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get string data (SQLGetData), hStmt=" + n + ", column=" + n2 + ", maxLen=" + n3);
        }
        if ((n4 = this.getDataString(n, n2, byArray2 = new byte[n3], byArray = new byte[2])) == 0) {
            byArray[1] = 1;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = n4 > 0 ? new String(byArray2, 0, 0, n4) : new String(byArray2, 0);
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = bl ? string.trim() : string;
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = n4 > 0 ? new String(byArray2, 0, 0, n4) : new String(byArray2, 0);
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            if (bl) {
                return string.trim();
            }
            return string;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized String SQLGetDataStringDate(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get date data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[11];
        this.getDataStringDate(n, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String(byArray2, 0);
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String(byArray2, 0);
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized String SQLGetDataStringTime(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get time data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[9];
        this.getDataStringTime(n, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String(byArray2, 0);
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String(byArray2, 0);
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized String SQLGetDataStringTimestamp(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get timestamp data (SQLGetData), hStmt=" + n + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[30];
        this.getDataStringTimestamp(n, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String(byArray2, 0);
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String(byArray2, 0);
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public synchronized int SQLGetInfo(int n, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info (SQLGetInfo), hDbc=" + n + ", fInfoType=" + s);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfo(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(" int value=" + n2);
        }
        return n2;
    }

    public synchronized int SQLGetInfoShort(int n, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info (SQLGetInfo), hDbc=" + n + ", fInfoType=" + s);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfoShort(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(" short value=" + n2);
        }
        return n2;
    }

    public synchronized String SQLGetInfoString(int n, short s) throws SQLException {
        return this.SQLGetInfoString(n, s, JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH);
    }

    public synchronized String SQLGetInfoString(int n, short s, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info string (SQLGetInfo), hDbc=" + n + ", fInfoType=" + s + ", len=" + n2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n2];
        this.getInfoString(n, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        String string = new String(byArray2, 0);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(string.trim());
        }
        return string.trim();
    }

    public synchronized int SQLGetStmtOption(int n, short s) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get statement option (SQLGetStmtOption), hStmt=" + n + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        n2 = this.getStmtOption(n, s, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public synchronized void SQLGetTypeInfo(int n, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get type info (SQLGetTypeInfo), hStmt=" + n + ", fSqlType=" + s);
        }
        byte[] byArray = new byte[1];
        this.getTypeInfo(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized boolean SQLMoreResults(int n) throws SQLException, SQLWarning {
        boolean bl = true;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get more results (SQLMoreResults), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        this.moreResults(n, byArray);
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("More results: " + bl);
        }
        return bl;
    }

    public synchronized String SQLNativeSql(int n, String string) throws SQLException {
        byte[] byArray = new byte[1];
        int n2 = JdbcOdbcLimits.DEFAULT_NATIVE_SQL_LENGTH;
        if (string.length() * 4 > n2 && (n2 = string.length() * 4) > 32768) {
            n2 = 32768;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Convert native SQL (SQLNativeSql), hDbc=" + n + ", nativeLen=" + n2 + ", SQL=" + string);
        }
        byte[] byArray2 = new byte[n2];
        this.nativeSql(n, string, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        String string2 = new String(byArray2, 0);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Native SQL=" + string2.trim());
        }
        return string2.trim();
    }

    public synchronized int SQLNumParams(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of parameter markers (SQLNumParams), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        n2 = this.numParams(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public synchronized int SQLNumResultCols(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of result columns (SQLNumResultCols), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        n2 = this.numResultCols(n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public synchronized int SQLParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get parameter number (SQLParamData), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        n2 = this.paramData(n, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n2 = -1;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter needing data=" + n2);
        }
        return n2;
    }

    public synchronized void SQLPrepare(int n, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Preparing (SQLPrepare), hStmt=" + n + ", szSqlStr=" + string);
        }
        byte[] byArray = new byte[1];
        this.prepare(n, string, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLPutData(int n, byte[] byArray, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Putting data (SQLPutData), hStmt=" + n + ", len=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.putData(n, byArray, n2, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public synchronized void SQLPrimaryKeys(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Primary keys (SQLPrimaryKeys), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = new byte[1];
        this.primaryKeys(n, string, string == null, string2, string2 == null, string3, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLProcedures(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Procedures (SQLProcedures), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3);
        }
        byte[] byArray = new byte[1];
        this.procedures(n, string, string == null, string2, string2 == null, string3, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLProcedureColumns(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Procedure columns (SQLProcedureColumns), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        this.procedureColumns(n, string, string == null, string2, string2 == null, string3, string3 == null, string4, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized int SQLRowCount(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of affected rows (SQLRowCount), hStmt=" + n);
        }
        byte[] byArray = new byte[1];
        n2 = this.rowCount(n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public synchronized void SQLSetConnectOption(int n, short s, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting connection option (SQLSetConnectOption), hDbc=" + n + ", fOption=" + s + ", vParam=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setConnectOption(n, s, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public synchronized void SQLSetConnectOption(int n, short s, String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting connection option string (SQLSetConnectOption), hDbc=" + n + ", fOption=" + s + ", vParam=" + string);
        }
        byte[] byArray = new byte[1];
        this.setConnectOptionString(n, s, string, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public synchronized void SQLSetCursorName(int n, String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting cursor name (SQLSetCursorName), hStmt=" + n + ", szCursor=" + string);
        }
        byte[] byArray = new byte[1];
        this.setCursorName(n, string, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLSetStmtOption(int n, short s, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting statement option (SQLSetStmtOption), hStmt=" + n + ", fOption=" + s + ", vParam=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setStmtOption(n, s, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLSpecialColumns(int n, short s, String string, String string2, String string3, int n2, boolean bl) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Special columns (SQLSpecialColumns), hStmt=" + n + ", fColType=" + s + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", fScope=" + n2 + ", fNullable=" + bl);
        }
        byte[] byArray = new byte[1];
        this.specialColumns(n, s, string, string == null, string2, string2 == null, string3, string3 == null, n2, bl, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLStatistics(int n, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Statistics (SQLStatistics), hStmt=" + n + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", unique=" + bl + ", approximate=" + bl2);
        }
        byte[] byArray = new byte[1];
        this.statistics(n, string, string == null, string2, string2 == null, string3, string3 == null, bl, bl2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLTables(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Tables (SQLTables), hStmt=" + n + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", types=" + string4);
        }
        byte[] byArray = new byte[1];
        this.tables(n, string, string == null, string2, string2 == null, string3, string3 == null, string4, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLTablePrivileges(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Tables (SQLTables), hStmt=" + n + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = new byte[1];
        this.tablePrivileges(n, string, string == null, string2, string2 == null, string3, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public synchronized void SQLTransact(int n, int n2, short s) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Transaction (SQLTransact), hEnv=" + n + ", hDbc=" + n2 + ", fType=" + s);
        }
        byte[] byArray = new byte[1];
        this.transact(n, n2, s, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public native int bufferToInt(byte[] var1);

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
        SQLWarning sQLWarning = jdbcOdbcSQLWarning;
        if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation dataTruncation = new DataTruncation(-1, false, true, 0, 0);
            sQLWarning = dataTruncation;
        }
        return sQLWarning;
    }

    protected native int allocConnect(int var1, byte[] var2);

    protected native int allocEnv(byte[] var1);

    protected native int allocStmt(int var1, byte[] var2);

    protected native void cancel(int var1, byte[] var2);

    protected native void bindColDefault(int var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    protected native void bindInParameterAtExec(int var1, int var2, int var3, int var4, byte[] var5, byte[] var6, byte[] var7);

    protected native void bindInParameterBinary(int var1, int var2, int var3, byte[] var4, int var5, byte[] var6, byte[] var7, byte[] var8);

    protected native void bindInParameterDate(int var1, int var2, int var3, int var4, int var5, byte[] var6, byte[] var7);

    protected native void bindInParameterDouble(int var1, int var2, int var3, int var4, double var5, byte[] var7, byte[] var8);

    protected native void bindInParameterFloat(int var1, int var2, int var3, int var4, float var5, byte[] var6, byte[] var7);

    protected native void bindInParameterInteger(int var1, int var2, int var3, int var4, byte[] var5, byte[] var6);

    protected native void bindInParameterNull(int var1, int var2, int var3, byte[] var4, byte[] var5);

    protected native void bindInParameterString(int var1, int var2, int var3, String var4, int var5, int var6, byte[] var7, byte[] var8);

    protected native void bindInParameterTime(int var1, int var2, int var3, int var4, int var5, byte[] var6, byte[] var7);

    protected native void bindInParameterTimestamp(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, byte[] var11);

    protected native void bindOutParameterString(int var1, int var2, int var3, int var4, byte[] var5, byte[] var6, byte[] var7);

    protected native void browseConnect(int var1, String var2, byte[] var3, byte[] var4);

    protected native int colAttributes(int var1, int var2, int var3, byte[] var4);

    protected native void colAttributesString(int var1, int var2, int var3, byte[] var4, byte[] var5);

    protected native void columns(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, String var8, boolean var9, byte[] var10);

    protected native void columnPrivileges(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, String var8, boolean var9, byte[] var10);

    protected native int describeParam(int var1, int var2, int var3, byte[] var4);

    protected native void disconnect(int var1, byte[] var2);

    protected native void driverConnect(int var1, String var2, byte[] var3);

    protected native int error(int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);

    protected native void execDirect(int var1, String var2, byte[] var3);

    protected native void execute(int var1, byte[] var2);

    protected native void fetch(int var1, byte[] var2);

    protected native void foreignKeys(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, String var8, boolean var9, String var10, boolean var11, String var12, boolean var13, byte[] var14);

    protected native void freeConnect(int var1, byte[] var2);

    protected native void freeEnv(int var1, byte[] var2);

    protected native void freeStmt(int var1, int var2, byte[] var3);

    protected native int getConnectOption(int var1, short var2, byte[] var3);

    protected native void getConnectOptionString(int var1, short var2, byte[] var3, byte[] var4);

    protected native void getCursorName(int var1, byte[] var2, byte[] var3);

    protected native int getStmtOption(int var1, short var2, byte[] var3);

    protected native int getDataBinary(int var1, int var2, int var3, byte[] var4, int var5, byte[] var6);

    protected native double getDataDouble(int var1, int var2, byte[] var3);

    protected native float getDataFloat(int var1, int var2, byte[] var3);

    protected native int getDataInteger(int var1, int var2, byte[] var3);

    protected native int getDataString(int var1, int var2, byte[] var3, byte[] var4);

    protected native void getDataStringDate(int var1, int var2, byte[] var3, byte[] var4);

    protected native void getDataStringTime(int var1, int var2, byte[] var3, byte[] var4);

    protected native void getDataStringTimestamp(int var1, int var2, byte[] var3, byte[] var4);

    protected native int getInfo(int var1, short var2, byte[] var3);

    protected native int getInfoShort(int var1, short var2, byte[] var3);

    protected native void getInfoString(int var1, short var2, byte[] var3, byte[] var4);

    protected native void getTypeInfo(int var1, short var2, byte[] var3);

    protected native void moreResults(int var1, byte[] var2);

    protected native void nativeSql(int var1, String var2, byte[] var3, byte[] var4);

    protected native int numParams(int var1, byte[] var2);

    protected native int numResultCols(int var1, byte[] var2);

    protected native int paramData(int var1, byte[] var2);

    protected native void prepare(int var1, String var2, byte[] var3);

    protected native void primaryKeys(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, byte[] var8);

    protected native void procedures(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, byte[] var8);

    protected native void procedureColumns(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, String var8, boolean var9, byte[] var10);

    protected native void putData(int var1, byte[] var2, int var3, byte[] var4);

    protected native int rowCount(int var1, byte[] var2);

    protected native void setConnectOption(int var1, short var2, int var3, byte[] var4);

    protected native void setConnectOptionString(int var1, short var2, String var3, byte[] var4);

    protected native void setCursorName(int var1, String var2, byte[] var3);

    protected native void setStmtOption(int var1, short var2, int var3, byte[] var4);

    protected native void specialColumns(int var1, short var2, String var3, boolean var4, String var5, boolean var6, String var7, boolean var8, int var9, boolean var10, byte[] var11);

    protected native void statistics(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, boolean var8, boolean var9, byte[] var10);

    protected native void tables(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, String var8, boolean var9, byte[] var10);

    protected native void tablePrivileges(int var1, String var2, boolean var3, String var4, boolean var5, String var6, boolean var7, byte[] var8);

    protected native void transact(int var1, int var2, short var3, byte[] var4);

    SQLException createSQLException(int n, int n2, int n3) {
        String string;
        Object object;
        boolean bl = false;
        Object object2 = null;
        Object object3 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("ERROR - Generating SQLException...");
        }
        while (!bl) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH];
            int n4 = this.error(n, n2, n3, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl = true;
                continue;
            }
            object = null;
            string = new String(byArray3, 0);
            String string2 = new String(byArray2, 0);
            object = new SQLException(string.trim(), string2.trim(), n4);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLException)object3).setNextException((SQLException)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General error";
            string = "S1000";
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("ERROR - " + string + " " + (String)object);
            }
            object2 = new SQLException((String)object, string);
        }
        return object2;
    }

    SQLWarning createSQLWarning(int n, int n2, int n3) {
        String string;
        Object object;
        boolean bl = false;
        Object object2 = null;
        Object object3 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("WARNING - Generating SQLWarning...");
        }
        while (!bl) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[JdbcOdbcLimits.DEFAULT_BUFFER_LENGTH];
            int n4 = this.error(n, n2, n3, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl = true;
                continue;
            }
            object = null;
            string = new String(byArray3, 0);
            String string2 = new String(byArray2, 0);
            object = new JdbcOdbcSQLWarning(string.trim(), string2.trim(), n4);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLWarning)object3).setNextWarning((SQLWarning)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General warning";
            string = "S1000";
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("WARNING - " + string + " " + (String)object);
            }
            object2 = new JdbcOdbcSQLWarning((String)object, string);
        }
        return object2;
    }

    void throwGenericSQLException() throws SQLException {
        String string = "General error";
        String string2 = "S1000";
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("ERROR - " + string2 + " " + string);
        }
        throw new SQLException(string, string2);
    }

    void standardError(short s, int n, int n2, int n3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("RETCODE = " + s);
        }
        switch (s) {
            case -1: {
                throw this.createSQLException(n, n2, n3);
            }
            case 1: {
                throw this.createSQLWarning(n, n2, n3);
            }
            case -2: {
                String string = "Invalid handle";
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
            case 100: {
                String string = "No data found";
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
        }
        this.throwGenericSQLException();
    }
}

