/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.server.UID;
import java.util.Vector;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.LiveRef;

class ConnectionOutputStream
extends MarshalOutputStream {
    private boolean resultStream = false;
    private Vector objList;
    private UID ackID = new UID();

    ConnectionOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    ConnectionOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        super(outputStream);
        this.resultStream = bl;
    }

    void writeID() throws IOException {
        this.ackID.write(this);
    }

    boolean isResultStream() {
        return this.resultStream;
    }

    void saveRef(LiveRef liveRef) {
        if (this.resultStream) {
            if (this.objList == null) {
                this.objList = new Vector();
            }
            this.objList.addElement(liveRef);
        }
    }

    void done(Connection connection) {
        if (this.objList != null && !this.objList.isEmpty()) {
            new DGCAckHandler(connection.getChannel(), this.ackID, this.objList);
        }
    }
}

