program AccountClientDII;

{$APPTYPE CONSOLE}

{
  This Console CORBA Client uses Dynamic Invocation Interface (DII) to
  connect to the Server thereby using 'late binding'.
  In order to run this client, follow these steps:
  1. Export a CORBA IDL file using 'Export' button on AccountServer Type Library Form.
     Save it as AccountServer.IDL
  2. Start an Interface Repository (IR) by typing IREP TEST on command prompt.
  3. Copy StdVCL.IDL from ($DELPHI)\Imports\IDL directory to current directory.
  4. Import Account.IDL into the Interface Repository by typing
      IDL2IR AccountServer.IDL -ir TEST
  5. Run the AccountServer.Exe
  6. Run this Client
}

uses
  SysUtils,
  CorbaObj;
// Notice it does not use any _TLB, stub or skeleton units

var
  Account: TAny;
begin
  CorbaInitialize;
  try
    Account := ORB.Bind('IDL:Account:1.0');
    WriteLn(Format('The balance on the account is $%2f',[Account.Balance]));
  except
    on E:Exception do WriteLn(E.Message);
  end;
end.
