unit ConjoinHost;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, DockForm;

type
  TConjoinDockHost = class(TForm)
    procedure FormUnDock(Sender: TObject; Client: TControl;
      var Allow: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDockDrop(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer);
  private
    FUndockingForm: TDockableForm;
    procedure DoFloat(AControl: TControl);
  public
    procedure UpdateCaption;
  end;

var
  ConjoinDockHost: TConjoinDockHost;

implementation

{$R *.DFM}

//uses DockForm;

procedure TConjoinDockHost.FormUnDock(Sender: TObject; Client: TControl;
  var Allow: Boolean);
begin
  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  if Client is TDockableForm then
  begin
    TDockableForm(Client).DockSite := True;
    FUndockingForm := TDockableForm(Client);
  end;
  if (DockClientCount = 2) then
    PostMessage(Self.Handle, WM_CLOSE, 0, 0);
  UpdateCaption;
  FUnDockingForm := nil;
end;

procedure TConjoinDockHost.DoFloat(AControl: TControl);
var
  ARect: TRect;
begin
  ARect.TopLeft := AControl.ClientToScreen(Point(0, 0));
  ARect.BottomRight := AControl.ClientToScreen(Point(AControl.UndockWidth,
                       AControl.UndockHeight));
  AControl.ManualFloat(ARect);
end;

procedure TConjoinDockHost.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if DockClientCount = 1 then
  begin
    DoFloat(DockClients[0]);
    Action := caFree;
  end else
    Action := caHide;
end;

procedure TConjoinDockHost.UpdateCaption;
var
  I: Integer;
begin
  Caption := '';
  for I := 0 to DockClientCount-1 do
    if DockClients[I].Visible and (DockClients[I] <> FUnDockingForm) then
      Caption := Caption + TDockableForm(DockClients[I]).Caption + ' ';
end;

procedure TConjoinDockHost.FormDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  UpdateCaption;
end;

end.

