program DockEx;

uses
  Forms,
  Graphics,
  SysUtils,
  Main in 'Main.pas' {MainForm},
  ToolDockHost in 'ToolDockHost.pas' {ToolForm},
  DockForm in 'DockForm.pas' {DockableForm},
  ConjoinHost in 'ConjoinHost.pas' {ConjoinDockHost},
  TabHost in 'TabHost.pas' {TabDockHost};

{$R *.RES}

const
  Colors: array[0..3] of TColor = (clWhite, clBlue, clGreen, clRed);
  ColStr: array[0..3] of string = ('White', 'Blue', 'Green', 'Red');

procedure CreateDockableWindows;
var
  DockWindow: TDockableForm;
  I: Integer;
begin
  for I := 0 to High(DockWindows) do
  begin
    Application.CreateForm(TDockableForm, DockWindow);
    DockWindow.Caption := ColStr[I];
    DockWindows[I] := DockWindow;
    DockWindows[I].Color := Colors[I];
  end;
end;

begin
  Application.Initialize;
  Application.CreateForm(TMainForm, MainForm);
  CreateDockableWindows;
  Application.Run;
end.
