unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ActnList, ToolWin, ExtCtrls;

type
  TMainForm = class(TForm)
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    ToolBar2: TToolBar;
    MenuToolBar: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton18: TToolButton;
    ToolButton19: TToolButton;
    ToolButton12: TToolButton;
    ToolButton20: TToolButton;
    ToolButton21: TToolButton;
    ToolButton22: TToolButton;
    PopupMenu1: TPopupMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    View1: TMenuItem;
    ToolBar11: TMenuItem;
    ToolBar21: TMenuItem;
    ActionList1: TActionList;
    N1: TMenuItem;
    DockWindow11: TMenuItem;
    DockWindow21: TMenuItem;
    DockWindow31: TMenuItem;
    DockWindow41: TMenuItem;
    ViewToolBar1: TAction;
    ViewToolBar2: TAction;
    DockPanel1: TPanel;
    DockPanel2: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure CoolBar1DockOver(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure CoolBar1DockDrop(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer);
    procedure ViewToolBar1Execute(Sender: TObject);
    procedure ViewToolBar2Execute(Sender: TObject);
    procedure DockWindow11Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

uses ToolDockHost, DockForm, TabHost, ConjoinHost;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ToolBar1.FloatingDockSiteClass := TToolForm;
  ToolBar2.FloatingDockSiteClass := TToolForm;
end;

procedure TMainForm.CoolBar1DockOver(Sender: TObject; Source: TDragDockObject;
  X, Y: Integer; State: TDragState; var Accept: Boolean);
var
  ARect: TRect;
begin
  Accept := (Source.Control is TToolForm);
  if Accept then
  begin
    ARect.TopLeft := CoolBar1.ClientToScreen(CoolBar1.ClientRect.TopLeft);
    ARect.BottomRight := CoolBar1.ClientToScreen(CoolBar1.ClientRect.BottomRight);
    Source.DockRect := ARect;
  end;
end;

procedure TMainForm.CoolBar1DockDrop(Sender: TObject; Source: TDragDockObject;
  X, Y: Integer);
begin
  if Source.Control is TToolForm then
  with Source.Control as TToolForm do
  begin
    TToolBar(Controls[0]).DragMode := dmAutomatic;
    Controls[0].ManualDock(CoolBar1, nil, alNone);
    Close;
  end;
end;

procedure TMainForm.ViewToolBar1Execute(Sender: TObject);
begin
  ToolBar11.Checked := not ToolBar11.Checked;
  if ToolBar1.Floating  then
    TToolDockForm(ToolBar1.HostDockSite).Visible := ToolBar11.Checked
  else
    ToolBar1.Visible := ToolBar11.Checked;
end;

procedure TMainForm.ViewToolBar2Execute(Sender: TObject);
begin
  ToolBar21.Checked := not ToolBar21.Checked;
  if ToolBar2.Floating then
    TToolDockForm(ToolBar2.HostDockSite).Visible := ToolBar21.Checked
  else
    ToolBar2.Visible := ToolBar21.Checked;
end;

procedure TMainForm.DockWindow11Click(Sender: TObject);
var
  DockWindow: TDockableForm;
begin
  DockWindow := DockWindows[(Sender as TComponent).Tag];
  //if DockWindow is TabDocked, it is docked to the PageControl
  //on TTabDockHost
  if DockWindow.HostDockSite is TPageControl then
    TTabDockHost(DockWindow.HostDockSite.Owner).Show
  else
    if (DockWindow.HostDockSite is TConjoinDockHost)
    and not DockWindow.HostDockSite.Visible then
      TConjoinDockHost(DockWindow.HostDockSite).Show
    else
      DockWindow.Show;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
