unit ServerDM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComServ, ComObj, VCLCom, StdVcl, BdeProv, DataBkr, Server_TLB,
  DBTables, Provider, Db, DBClient, BDE;

type
  TProjectData = class(TDataModule, IProjectData)
    Project: TTable;
    Employee: TQuery;
    EmpProj: TQuery;
    ProjectProvider: TProvider;
    UpdateQuery: TQuery;
    Database: TDatabase;
    procedure ProjectProviderUpdateError(DataSet: TClientDataSet;
      E: EUpdateError; UpdateKind: TUpdateKind;
      var Response: TResolverResponse);
  private
    { Private declarations }
  public
    { Public declarations }
  protected
    function Get_ProjectProvider: IProvider; safecall;
    function Get_EmpProjProvider: IProvider; safecall;
    function Get_Employee: IProvider; safecall;
    function Get_EmpProj: IProvider; safecall;
  end;

var
  ProjectData: TProjectData;

implementation

{$R *.DFM}


function TProjectData.Get_ProjectProvider: IProvider;
begin
  Result := ProjectProvider.Provider;
end;

function TProjectData.Get_EmpProjProvider: IProvider;
begin
  Result := EmpProjProvider.Provider;
end;

function TProjectData.Get_Employee: IProvider;
begin
  Result := Employee.Provider;
end;

procedure TProjectData.ProjectProviderUpdateError(DataSet: TClientDataSet;
  E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
const
  ExpError = 'violation of FOREIGN KEY constraint "INTEG_41" on table "EMPLOYEE_PROJECT"';
  DeleteQuery = 'delete from EMPLOYEE_PROJECT where PROJ_ID = :ProjID';
begin
  if (UpdateKind = ukDelete) and
     (E.ErrorCode = DBIERR_UNKNOWNSQL) and
     (Pos(ExpError,E.Context) > 0) then
  begin
    UpdateQuery.SQL.Text := DeleteQuery;
    UpdateQuery.Params[0].AsString := DataSet.FieldByName('PROJ_ID').AsString;
    UpdateQuery.ExecSQL;
    Response := rrApply;
  end;
end;

function TProjectData.Get_EmpProj: IProvider;
begin
  Result := EmpProj.Provider;
end;

initialization
  TComponentFactory.Create(ComServer, TProjectData,
    Class_ProjectData, ciMultiInstance);
end.
