// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DISQLite3Api.pas' rev: 6.00

#ifndef DISQLite3ApiHPP
#define DISQLite3ApiHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <DISystemCompat.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Disqlite3api
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ESQLite3;
class PASCALIMPLEMENTATION ESQLite3 : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
private:
	int FErrorCode;
	AnsiString FErrorMessage;
	
public:
	__fastcall ESQLite3(const int AErrorCode, const AnsiString AErrorMessage)/* overload */;
	__fastcall ESQLite3(const int AErrorCode)/* overload */;
	__fastcall ESQLite3(const AnsiString AErrorMessage)/* overload */;
	__property int ErrorCode = {read=FErrorCode, nodefault};
	__property AnsiString ErrorMessage = {read=FErrorMessage};
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ESQLite3(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ESQLite3(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ESQLite3(int Ident, const System::TVarRec * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ESQLite3(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ESQLite3(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ESQLite3(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ESQLite3(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ESQLite3(void) { }
	#pragma option pop
	
};


typedef TDIJulianDate TDIJulianDate;

typedef void *sqlite3;

typedef sqlite3 *sqlite3_ptr;

typedef void *TDISQLite3DatabaseHandle;

typedef sqlite3 *PDISQLite3DatabaseHandle;

typedef int __fastcall (*TSQLite3_Callback)(void * UserData, int ColumnCount, Disystemcompat::PPUtf8CharArray ColumnValues, Disystemcompat::PPUtf8CharArray ColumnNames);

struct sqlite3_io_methods;
typedef sqlite3_io_methods *sqlite3_io_methods_ptr;

#pragma pack(push, 1)
struct sqlite3_file
{
	sqlite3_io_methods *pMethods;
} ;
#pragma pack(pop)

typedef sqlite3_file *sqlite3_file_ptr;

#pragma pack(push, 1)
struct sqlite3_io_methods
{
	int iVersion;
	int __fastcall (*xClose)(sqlite3_file_ptr ID);
	int __fastcall (*xRead)(sqlite3_file_ptr ID, void * pBuf, int iAmt, __int64 iOfst);
	int __fastcall (*xWrite)(sqlite3_file_ptr ID, const void * pBuf, int iAmt, __int64 iOfst);
	int __fastcall (*xTruncate)(sqlite3_file_ptr ID, __int64 Size);
	int __fastcall (*xSync)(sqlite3_file_ptr ID, int Flags);
	int __fastcall (*xFileSize)(sqlite3_file_ptr ID, System::PInt64 pSize);
	int __fastcall (*xLock)(sqlite3_file_ptr ID, int lockType);
	int __fastcall (*xUnlock)(sqlite3_file_ptr ID, int lockType);
	int __fastcall (*xCheckReservedLock)(sqlite3_file_ptr ID, System::PInteger pResOut);
	int __fastcall (*xFileControl)(sqlite3_file_ptr ID, int op, void * pArg);
	int __fastcall (*xLockState)(sqlite3_file_ptr ID);
	int __fastcall (*xSectorSize)(sqlite3_file_ptr ID);
	int __fastcall (*xDeviceCharacteristics)(sqlite3_file_ptr ID);
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct sqlite3_mutex
{
	
} ;
#pragma pack(pop)

typedef sqlite3_mutex *sqlite3_mutex_ptr;

struct sqlite3_vfs;
typedef sqlite3_vfs *sqlite3_vfs_ptr;

#pragma pack(push, 1)
struct sqlite3_vfs
{
	int iVersion;
	int szOsFile;
	int mxPathname;
	sqlite3_vfs *pNext;
	char *zName;
	void *pAppData;
	int __fastcall (*xOpen)(sqlite3_vfs_ptr pVfs, const char * zName, sqlite3_file_ptr pFile, int Flags, System::PInteger pOutFlags);
	int __fastcall (*xDelete)(sqlite3_vfs_ptr pVfs, const char * zName, int syncDir);
	int __fastcall (*xAccess)(sqlite3_vfs_ptr pVfs, const char * zName, int Flags, System::PInteger pResOut);
	int __fastcall (*xFullPathname)(sqlite3_vfs_ptr pVfs, const char * zName, int nOut, char * zOut);
	void * __fastcall (*xDlOpen)(sqlite3_vfs_ptr pVfs, const char * zFilename);
	void __fastcall (*xDlError)(sqlite3_vfs_ptr pVfs, int nByte, char * zErrMsg);
	void * __fastcall (*xDlSym)(sqlite3_vfs_ptr pVfs, void * PHandle, const char * zSymbol);
	void __fastcall (*xDlClose)(sqlite3_vfs_ptr pVfs, void * PHandle);
	int __fastcall (*xRandomness)(sqlite3_vfs_ptr pVfs, int nByte, char * zOut);
	int __fastcall (*xSleep)(sqlite3_vfs_ptr pVfs, int microseconds);
	int __fastcall (*xCurrentTime)(sqlite3_vfs_ptr pVfs, System::PDouble pTimeOut);
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct sqlite3_mem_methods
{
	void * __fastcall (*xMalloc)(int nByte);
	void __fastcall (*xFree)(void * pPrior);
	void * __fastcall (*xRealloc)(void * pPrior, int nByte);
	int __fastcall (*xSize)(void * pPrior);
	int __fastcall (*xRoundup)(int n);
	int __fastcall (*xInit)(void * pAppData);
	void __fastcall (*xShutdown)(void * pAppData);
	void *pAppData;
} ;
#pragma pack(pop)

typedef sqlite3_mem_methods *sqlite3_mem_methods_ptr;

typedef int __fastcall (*TSQLite3_Busy_Callback)(void * p, int i);

typedef int __fastcall (*TSQLite_Authorizer_Callback)(void * UserData, int Arg2, char * Arg3, char * Arg4, char * Arg5, char * Arg6);

typedef void __fastcall (*TSQLite_Trace_Callback)(void * UserData, const char * SQL);

typedef void __fastcall (*TSQLite_Profile_Callback)(void * UserData, const char * SQL, __int64 elapseTime);

typedef int __fastcall (*TSQLite3_Progress_Callback)(void * UserData);

typedef void *sqlite3_stmt;

typedef sqlite3_stmt *sqlite3_stmt_ptr;

typedef void *TDISQLite3StatementHandle;

typedef sqlite3_stmt *PDISQLite3StatementHandle;

typedef void *sqlite3_value;

typedef sqlite3_value *sqlite3_value_ptr;

typedef void *sqlite3_context;

typedef sqlite3_context *sqlite3_context_ptr;

typedef void __fastcall (*TSQLite_Destructor)(void * p);

typedef void __fastcall (*TSQLite_Bind_Destructor)(void * p);

typedef void __fastcall (*TSQLite_Func_Callback)(sqlite3_context pCtx, int nArgs, System::PPointerArray Args);

typedef TSQLite_Func_Callback *PSQLite_Func_Callback;

typedef void __fastcall (*TSQLite_Result_Destructor)(void * p);

typedef void __fastcall (*TSQLite_Step_Callback)(sqlite3_context pCtx, int nArgs, System::PPointerArray Args);

typedef void __fastcall (*TSQLite_Final_Callback)(sqlite3_context pCtx);

typedef void __fastcall (*TSQLite3_Memory_Alarm_Callback)(void * pArg, __int64 used, int n);

typedef void __fastcall (*TSQLite_AuxData_Destructor)(void * p);

typedef int __fastcall (*TSQLite_Collation_Callback)(void * UserData, int l1, const void * s1, int l2, const void * s2);

typedef void __fastcall (*TSQLite_Collation_Destructor)(void * p);

typedef void __fastcall (*TSQLite_Collation_Needed_Callback)(void * UserData, sqlite3 DB, int eTextRep, char * Name);

typedef void __fastcall (*TSQLite_Collation_Needed16_Callback)(void * UserData, sqlite3 DB, int eTextRep, WideChar * Name);

typedef int __fastcall (*TSQLite_Commit_Callback)(void * pArg);

typedef void __fastcall (*TSQLite3_Rollback_Callback)(void * pArg);

typedef void __fastcall (*TSQLite3_Update_Callback)(void * pArg, int Operation, sqlite3 DB, char * TableName, __int64 RowID);

struct Tsqlite3_vtab;
typedef Tsqlite3_vtab *Psqlite3_vtab;

typedef Psqlite3_vtab *PPsqlite3_vtab;

struct TSQLite3_index_info;
typedef TSQLite3_index_info *Psqlite3_index_info;

#pragma pack(push, 1)
struct Tsqlite3_vtab_cursor
{
	Tsqlite3_vtab *pVTab;
} ;
#pragma pack(pop)

typedef Tsqlite3_vtab_cursor *Psqlite3_vtab_cursor;

typedef Psqlite3_vtab_cursor *PPsqlite3_vtab_cursor;

#pragma pack(push, 1)
struct Tsqlite3_module
{
	int iVersion;
	int __fastcall (*xCreate)(sqlite3 DB, void * paux, int argc, const Disystemcompat::PPUtf8CharArray argv, PPsqlite3_vtab pVTab, Disystemcompat::PPUtf8Char pzErr);
	int __fastcall (*xConnect)(sqlite3 DB, void * paux, int argc, const Disystemcompat::PPUtf8CharArray argv, PPsqlite3_vtab pVTab, Disystemcompat::PPUtf8Char pzErr);
	int __fastcall (*xBestIndex)(Psqlite3_vtab pVTab, Psqlite3_index_info Info);
	int __fastcall (*xDisconnect)(Psqlite3_vtab pVTab);
	int __fastcall (*xDestroy)(Psqlite3_vtab pVTab);
	int __fastcall (*xOpen)(Psqlite3_vtab pVTab, PPsqlite3_vtab_cursor ppCursor);
	int __fastcall (*xClose)(Psqlite3_vtab_cursor pCursor);
	int __fastcall (*xFilter)(Psqlite3_vtab_cursor pCursor, int idxNum, const char * idxStr, int argc, System::PPointerArray argv);
	int __fastcall (*xNext)(Psqlite3_vtab_cursor pCursor);
	int __fastcall (*xEof)(Psqlite3_vtab_cursor pCursor);
	int __fastcall (*xColumn)(Psqlite3_vtab_cursor pCursor, sqlite3_context pCtx, int i);
	int __fastcall (*xRowID)(Psqlite3_vtab_cursor pCursor, System::PInt64 pRowID);
	int __fastcall (*xUpdate)(Psqlite3_vtab pVTab, int argc, System::PPointerArray argv, System::PInt64 pRowID);
	int __fastcall (*xBegin)(Psqlite3_vtab pVTab);
	int __fastcall (*xSync)(Psqlite3_vtab pVTab);
	int __fastcall (*xCommit)(Psqlite3_vtab pVTab);
	int __fastcall (*xRollback)(Psqlite3_vtab pVTab);
	int __fastcall (*xFindFunction)(Psqlite3_vtab pVTab, int nArg, const char * zName, PSQLite_Func_Callback pxFunc, System::PPointerArray ppArg);
	int __fastcall (*xRename)(Psqlite3_vtab pVTab, const char * zNew);
} ;
#pragma pack(pop)

typedef Tsqlite3_module *Psqlite3_module;

#pragma pack(push, 1)
struct Tsqlite3_vtab
{
	Tsqlite3_module *pModule;
	int nRef;
	char *zErrMsg;
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct Tsqlite3_index_constraint
{
	int iColumn;
	Byte op;
	Byte usable;
	Word Dummy;
	int iTermOffset;
} ;
#pragma pack(pop)

typedef Tsqlite3_index_constraint Tsqlite3_index_constraint_array[178956970];

typedef Tsqlite3_index_constraint *Psqlite3_index_constraint_array;

#pragma pack(push, 1)
struct Tsqlite3_index_orderby
{
	int iColumn;
	Byte Desc;
} ;
#pragma pack(pop)

typedef Tsqlite3_index_orderby Tsqlite3_index_orderby_array[429496729];

typedef Tsqlite3_index_orderby *Psqlite3_index_orderby_array;

#pragma pack(push, 1)
struct Tsqlite3_index_constraint_usage
{
	int argvIndex;
	Byte omit;
} ;
#pragma pack(pop)

typedef Tsqlite3_index_constraint_usage Tsqlite3_index_constraint_usage_array[429496729];

typedef Tsqlite3_index_constraint_usage *Psqlite3_index_constraint_usage_array;

#pragma pack(push, 1)
struct TSQLite3_index_info
{
	int nConstraint;
	Tsqlite3_index_constraint *aConstraint;
	int nOrderBy;
	Tsqlite3_index_orderby *aOrderBy;
	Tsqlite3_index_constraint_usage *aConstraintUsage;
	int idxNum;
	char *idxStr;
	int needToFreeIdxStr;
	int orderByConsumed;
	double estimatedCost;
} ;
#pragma pack(pop)

typedef void __fastcall (*TSQLite_Module_Destructor)(void * p);

typedef void *sqlite3_blob;

typedef sqlite3_blob *sqlite3_blob_ptr;

typedef void *TDISQLite3BlobHandle;

typedef sqlite3_blob *PDISQLite3BlobHandle;

#pragma pack(push, 1)
struct sqlite3_mutex_methods
{
	int __fastcall (*xMutexInit)(void);
	int __fastcall (*xMutexEnd)(void);
	sqlite3_mutex_ptr __fastcall (*xMutexAlloc)(int ID);
	void __fastcall (*xMutexFree)(sqlite3_mutex_ptr p);
	void __fastcall (*xMutexEnter)(sqlite3_mutex_ptr p);
	int __fastcall (*xMutexTry)(sqlite3_mutex_ptr p);
	void __fastcall (*xMutexLeave)(sqlite3_mutex_ptr p);
	int __fastcall (*xMutexHeld)(sqlite3_mutex_ptr p);
	int __fastcall (*xMutexNotheld)(sqlite3_mutex_ptr p);
} ;
#pragma pack(pop)

typedef sqlite3_mutex_methods *sqlite3_mutex_methods_ptr;

#pragma pack(push, 1)
struct sqlite3_pcache
{
	
} ;
#pragma pack(pop)

typedef sqlite3_pcache *sqlite3_pcache_ptr;

#pragma pack(push, 1)
struct sqlite3_pcache_methods
{
	void *pArg;
	int __fastcall (*xInit)(void * pArg);
	void __fastcall (*xShutdown)(void * pArg);
	sqlite3_pcache_ptr __fastcall (*xCreate)(int szPage, int bPurgable);
	void __fastcall (*xCachesize)(sqlite3_pcache_ptr p, int nCacheSize);
	int __fastcall (*xPagecount)(sqlite3_pcache_ptr p);
	void * __fastcall (*xFetch)(sqlite3_pcache_ptr p, unsigned Key, unsigned createFlag);
	void __fastcall (*xUnpin)(sqlite3_pcache_ptr p, void * pPg, int discard);
	void __fastcall (*xRekey)(sqlite3_pcache_ptr p, void * pPg, unsigned oldKey, unsigned newKey);
	void __fastcall (*xTruncate)(sqlite3_pcache_ptr p, unsigned iLimit);
	void __fastcall (*xDestroy)(sqlite3_pcache_ptr p);
} ;
#pragma pack(pop)

typedef sqlite3_pcache_methods *sqlite3_pcache_methods_ptr;

struct Tsqlite3_tokenizer;
typedef Tsqlite3_tokenizer *Psqlite3_tokenizer;

typedef Psqlite3_tokenizer *PPsqlite3_tokenizer;

#pragma pack(push, 1)
struct Tsqlite3_tokenizer_cursor
{
	Tsqlite3_tokenizer *pTokenizer;
} ;
#pragma pack(pop)

typedef Tsqlite3_tokenizer_cursor *Psqlite3_tokenizer_cursor;

typedef Psqlite3_tokenizer_cursor *PPsqlite3_tokenizer_cursor;

#pragma pack(push, 1)
struct Tsqlite3_tokenizer_module
{
	int iVersion;
	int __fastcall (*xCreate)(int argc, const Disystemcompat::PPUtf8CharArray argv, PPsqlite3_tokenizer ppTokenizer);
	int __fastcall (*xDestroy)(Psqlite3_tokenizer pTokenizer);
	int __fastcall (*xOpen)(Psqlite3_tokenizer pTokenizer, const char * pInput, int nBytes, PPsqlite3_tokenizer_cursor ppCursor);
	int __fastcall (*xClose)(Psqlite3_tokenizer_cursor pCursor);
	int __fastcall (*xNext)(Psqlite3_tokenizer_cursor pCursor, const Disystemcompat::PPUtf8Char ppToken, System::PInteger pnBytes, System::PInteger piStartOffset, System::PInteger piEndOffset, System::PInteger piPosition);
} ;
#pragma pack(pop)

typedef Tsqlite3_tokenizer_module *Psqlite3_tokenizer_module;

#pragma pack(push, 1)
struct Tsqlite3_tokenizer
{
	Tsqlite3_tokenizer_module *pModule;
} ;
#pragma pack(pop)

struct LookasideSlot;
typedef LookasideSlot *LookasideSlot_ptr;

#pragma pack(push, 1)
struct LookasideSlot
{
	LookasideSlot *pNext;
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct Lookaside
{
	Word sz;
	Byte bEnabled;
	Byte bMalloced;
	int nOut;
	int mxOut;
	LookasideSlot *pFree;
	void *pStart;
	void *pEnd;
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct DISQLite3Api__2
{
	int iDb;
	int newTnum;
	Byte Busy;
	Byte _filler_1;
	Word _filler_2;
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct DISQLite3Api__3
{
	
	union
	{
		struct 
		{
			double notUsed1;
			
		};
		struct 
		{
			int isInterrupted;
			
		};
		
	};
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct sqlite3_int
{
	void *pVfs;
	int nDb;
	void *ADb;
	int Flags;
	int OpenFlags;
	int ErrCode;
	int errMask;
	Byte autoCommit;
	Byte temp_store;
	Byte mallocFailed;
	Byte dfltLockMode;
	Byte dfltJournalMode;
	Byte nextAutovac;
	Word _filer;
	int nextPagesize;
	int nTable;
	void *pDfltColl;
	__int64 lastRowid;
	__int64 priorNewRowid;
	int Magic;
	int nChange;
	int nTotalChange;
	sqlite3_mutex *mutex;
	int aLimit[10];
	DISQLite3Api__2 sqlite3InitInfo;
	int nExtension;
	void *aExtension;
	void *pVdbe;
	int activeVdbeCnt;
	int writeVdbeCnt;
	Lookaside Lookaside;
	TSQLite_Trace_Callback xTrace;
	void *pTraceArg;
	TSQLite_Profile_Callback xProfile;
	void *pProfileArg;
	void *pCommitArg;
	TSQLite_Commit_Callback xCommitCallback;
	void *pRollbackArg;
	TSQLite3_Rollback_Callback xRollbackCallback;
	void *pUpdateArg;
	TSQLite3_Update_Callback xUpdateCallback;
	TSQLite_Collation_Needed_Callback xCollNeeded;
	TSQLite_Collation_Needed16_Callback xCollNeeded16;
	void *pCollNeededArg;
	void *pErr;
	char *zErrMsg;
	WideChar *zErrMsg16;
	DISQLite3Api__3 u1;
	TSQLite_Authorizer_Callback xAuth;
	void *pAuthArg;
	TSQLite3_Progress_Callback xProgress;
	void *pProgressArg;
	int nProgressOps;
} ;
#pragma pack(pop)

typedef sqlite3_int *sqlite3_int_ptr;

#pragma option push -b-
enum TDISQLite3Affinity { afInteger, afText, afNone, afReal, afNumeric };
#pragma option pop

#pragma option push -b-
enum TDISQLite3DatabaseType { dtMain, dtTemp, dtAttached };
#pragma option pop

#pragma option push -b-
enum TDISQLite3Encoding { encUnknown, encUtf8, encUtf16, encUtf16le, encUtf16be };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------
#pragma error Unsupported symbol type (23, DISQLite3Api)
extern PACKAGE System::ResourceString _RSQLite3Error;
#define Disqlite3api_RSQLite3Error System::LoadResourceString(&Disqlite3api::_RSQLite3Error)
extern PACKAGE System::ResourceString _RSQLite3ErrorMsg;
#define Disqlite3api_RSQLite3ErrorMsg System::LoadResourceString(&Disqlite3api::_RSQLite3ErrorMsg)
static const char SQLITE3_IDENTIFIER_QUOTE_CHAR = '\x22';
static const char SQLITE3_STRING_QUOTE_CHAR = '\x27';
static const Shortint SQLITE_OK = 0x0;
static const Shortint SQLITE_ERROR = 0x1;
static const Shortint SQLITE_INTERNAL = 0x2;
static const Shortint SQLITE_PERM = 0x3;
static const Shortint SQLITE_ABORT = 0x4;
static const Shortint SQLITE_BUSY = 0x5;
static const Shortint SQLITE_LOCKED = 0x6;
static const Shortint SQLITE_NOMEM = 0x7;
static const Shortint SQLITE_READONLY = 0x8;
static const Shortint SQLITE_INTERRUPT = 0x9;
static const Shortint SQLITE_IOERR = 0xa;
static const Shortint SQLITE_CORRUPT = 0xb;
static const Shortint SQLITE_NOTFOUND = 0xc;
static const Shortint SQLITE_FULL = 0xd;
static const Shortint SQLITE_CANTOPEN = 0xe;
static const Shortint SQLITE_PROTOCOL = 0xf;
static const Shortint SQLITE_EMPTY = 0x10;
static const Shortint SQLITE_SCHEMA = 0x11;
static const Shortint SQLITE_TOOBIG = 0x12;
static const Shortint SQLITE_CONSTRAINT = 0x13;
static const Shortint SQLITE_MISMATCH = 0x14;
static const Shortint SQLITE_MISUSE = 0x15;
static const Shortint SQLITE_NOLFS = 0x16;
static const Shortint SQLITE_AUTH = 0x17;
static const Shortint SQLITE_FORMAT = 0x18;
static const Shortint SQLITE_RANGE = 0x19;
static const Shortint SQLITE_NOTADB = 0x1a;
static const Shortint SQLITE_ROW = 0x64;
static const Shortint SQLITE_DONE = 0x65;
static const Word SQLITE_IOERR_READ = 0x10a;
static const Word SQLITE_IOERR_SHORT_READ = 0x20a;
static const Word SQLITE_IOERR_WRITE = 0x30a;
static const Word SQLITE_IOERR_FSYNC = 0x40a;
static const Word SQLITE_IOERR_DIR_FSYNC = 0x50a;
static const Word SQLITE_IOERR_TRUNCATE = 0x60a;
static const Word SQLITE_IOERR_FSTAT = 0x70a;
static const Word SQLITE_IOERR_UNLOCK = 0x80a;
static const Word SQLITE_IOERR_RDLOCK = 0x90a;
static const Word SQLITE_IOERR_DELETE = 0xa0a;
static const Word SQLITE_IOERR_BLOCKED = 0xb0a;
static const Word SQLITE_IOERR_NOMEM = 0xc0a;
static const Word SQLITE_IOERR_CHECKRESERVEDLOCK = 0xe0a;
static const Word SQLITE_IOERR_LOCK = 0xf0a;
static const Word SQLITE_IOERR_CLOSE = 0x100a;
static const Word SQLITE_IOERR_DIR_CLOSE = 0x110a;
static const Shortint SQLITE_OPEN_READONLY = 0x1;
static const Shortint SQLITE_OPEN_READWRITE = 0x2;
static const Shortint SQLITE_OPEN_CREATE = 0x4;
static const Shortint SQLITE_OPEN_DELETEONCLOSE = 0x8;
static const Shortint SQLITE_OPEN_EXCLUSIVE = 0x10;
static const Word SQLITE_OPEN_MAIN_DB = 0x100;
static const Word SQLITE_OPEN_TEMP_DB = 0x200;
static const Word SQLITE_OPEN_TRANSIENT_DB = 0x400;
static const Word SQLITE_OPEN_MAIN_JOURNAL = 0x800;
static const Word SQLITE_OPEN_TEMP_JOURNAL = 0x1000;
static const Word SQLITE_OPEN_SUBJOURNAL = 0x2000;
static const Word SQLITE_OPEN_MASTER_JOURNAL = 0x4000;
static const Word SQLITE_OPEN_NOMUTEX = 0x8000;
static const int SQLITE_OPEN_FULLMUTEX = 0x10000;
static const Shortint SQLITE_IOCAP_ATOMIC = 0x1;
static const Shortint SQLITE_IOCAP_ATOMIC512 = 0x2;
static const Shortint SQLITE_IOCAP_ATOMIC1K = 0x4;
static const Shortint SQLITE_IOCAP_ATOMIC2K = 0x8;
static const Shortint SQLITE_IOCAP_ATOMIC4K = 0x10;
static const Shortint SQLITE_IOCAP_ATOMIC8K = 0x20;
static const Shortint SQLITE_IOCAP_ATOMIC16K = 0x40;
static const Byte SQLITE_IOCAP_ATOMIC32K = 0x80;
static const Word SQLITE_IOCAP_ATOMIC64K = 0x100;
static const Word SQLITE_IOCAP_SAFE_APPEND = 0x200;
static const Word SQLITE_IOCAP_SEQUENTIAL = 0x400;
static const Shortint SQLITE_LOCK_NONE = 0x0;
static const Shortint SQLITE_LOCK_SHARED = 0x1;
static const Shortint SQLITE_LOCK_RESERVED = 0x2;
static const Shortint SQLITE_LOCK_PENDING = 0x3;
static const Shortint SQLITE_LOCK_EXCLUSIVE = 0x4;
static const Shortint SQLITE_SYNC_NORMAL = 0x2;
static const Shortint SQLITE_SYNC_FULL = 0x3;
static const Shortint SQLITE_SYNC_DATAONLY = 0x10;
static const Shortint SQLITE_FCNTL_LOCKSTATE = 0x1;
static const Shortint SQLITE_GET_LOCKPROXYFILE = 0x2;
static const Shortint SQLITE_SET_LOCKPROXYFILE = 0x3;
static const Shortint SQLITE_LAST_ERRNO = 0x4;
static const Shortint SQLITE_ACCESS_EXISTS = 0x0;
static const Shortint SQLITE_ACCESS_READWRITE = 0x1;
static const Shortint SQLITE_ACCESS_READ = 0x2;
static const Shortint SQLITE_CONFIG_SINGLETHREAD = 0x1;
static const Shortint SQLITE_CONFIG_MULTITHREAD = 0x2;
static const Shortint SQLITE_CONFIG_SERIALIZED = 0x3;
static const Shortint SQLITE_CONFIG_MALLOC = 0x4;
static const Shortint SQLITE_CONFIG_GETMALLOC = 0x5;
static const Shortint SQLITE_CONFIG_SCRATCH = 0x6;
static const Shortint SQLITE_CONFIG_PAGECACHE = 0x7;
static const Shortint SQLITE_CONFIG_HEAP = 0x8;
static const Shortint SQLITE_CONFIG_MEMSTATUS = 0x9;
static const Shortint SQLITE_CONFIG_MUTEX = 0xa;
static const Shortint SQLITE_CONFIG_GETMUTEX = 0xb;
static const Shortint SQLITE_CONFIG_LOOKASIDE = 0xd;
static const Shortint SQLITE_CONFIG_PCACHE = 0xe;
static const Shortint SQLITE_CONFIG_GETPCACHE = 0xf;
static const Word SQLITE_DBCONFIG_LOOKASIDE = 0x3e9;
static const Shortint SQLITE_COPY = 0x0;
static const Shortint SQLITE_CREATE_INDEX = 0x1;
static const Shortint SQLITE_CREATE_TABLE = 0x2;
static const Shortint SQLITE_CREATE_TEMP_INDEX = 0x3;
static const Shortint SQLITE_CREATE_TEMP_TABLE = 0x4;
static const Shortint SQLITE_CREATE_TEMP_TRIGGER = 0x5;
static const Shortint SQLITE_CREATE_TEMP_VIEW = 0x6;
static const Shortint SQLITE_CREATE_TRIGGER = 0x7;
static const Shortint SQLITE_CREATE_VIEW = 0x8;
static const Shortint SQLITE_DELETE = 0x9;
static const Shortint SQLITE_DROP_INDEX = 0xa;
static const Shortint SQLITE_DROP_TABLE = 0xb;
static const Shortint SQLITE_DROP_TEMP_INDEX = 0xc;
static const Shortint SQLITE_DROP_TEMP_TABLE = 0xd;
static const Shortint SQLITE_DROP_TEMP_TRIGGER = 0xe;
static const Shortint SQLITE_DROP_TEMP_VIEW = 0xf;
static const Shortint SQLITE_DROP_TRIGGER = 0x10;
static const Shortint SQLITE_DROP_VIEW = 0x11;
static const Shortint SQLITE_INSERT = 0x12;
static const Shortint SQLITE_PRAGMA = 0x13;
static const Shortint SQLITE_READ = 0x14;
static const Shortint SQLITE_SELECT = 0x15;
static const Shortint SQLITE_TRANSACTION = 0x16;
static const Shortint SQLITE_UPDATE = 0x17;
static const Shortint SQLITE_ATTACH = 0x18;
static const Shortint SQLITE_DETACH = 0x19;
static const Shortint SQLITE_ALTER_TABLE = 0x1a;
static const Shortint SQLITE_REINDEX = 0x1b;
static const Shortint SQLITE_ANALYZE = 0x1c;
static const Shortint SQLITE_CREATE_VTABLE = 0x1d;
static const Shortint SQLITE_DROP_VTABLE = 0x1e;
static const Shortint SQLITE_FUNCTION = 0x1f;
static const Shortint SQLITE_SAVEPOINT = 0x20;
static const Shortint SQLITE_DENY = 0x1;
static const Shortint SQLITE_IGNORE = 0x2;
static const Shortint SQLITE_LIMIT_LENGTH = 0x0;
static const Shortint SQLITE_LIMIT_SQL_LENGTH = 0x1;
static const Shortint SQLITE_LIMIT_COLUMN = 0x2;
static const Shortint SQLITE_LIMIT_EXPR_DEPTH = 0x3;
static const Shortint SQLITE_LIMIT_COMPOUND_SELECT = 0x4;
static const Shortint SQLITE_LIMIT_VDBE_OP = 0x5;
static const Shortint SQLITE_LIMIT_FUNCTION_ARG = 0x6;
static const Shortint SQLITE_LIMIT_ATTACHED = 0x7;
static const Shortint SQLITE_LIMIT_LIKE_PATTERN_LENGTH = 0x8;
static const Shortint SQLITE_LIMIT_VARIABLE_NUMBER = 0x9;
static const Shortint SQLITE_INTEGER = 0x1;
static const Shortint SQLITE_FLOAT = 0x2;
static const Shortint SQLITE_TEXT = 0x3;
static const Shortint SQLITE_BLOB = 0x4;
static const Shortint SQLITE_NULL = 0x5;
static const Shortint SQLITE3_TEXT = 0x3;
static const Shortint SQLITE_UTF8 = 0x1;
static const Shortint SQLITE_UTF16LE = 0x2;
static const Shortint SQLITE_UTF16BE = 0x3;
static const Shortint SQLITE_UTF16 = 0x4;
static const Shortint SQLITE_ANY = 0x5;
static const Shortint SQLITE_UTF16_ALIGNED = 0x8;
extern PACKAGE TSQLite_Destructor SQLITE_STATIC;
extern PACKAGE TSQLite_Destructor SQLITE_TRANSIENT;
extern PACKAGE char *sqlite3_temp_directory;
static const Shortint SQLITE_INDEX_CONSTRAINT_EQ = 0x2;
static const Shortint SQLITE_INDEX_CONSTRAINT_GT = 0x4;
static const Shortint SQLITE_INDEX_CONSTRAINT_LE = 0x8;
static const Shortint SQLITE_INDEX_CONSTRAINT_LT = 0x10;
static const Shortint SQLITE_INDEX_CONSTRAINT_GE = 0x20;
static const Shortint SQLITE_INDEX_CONSTRAINT_MATCH = 0x40;
static const Shortint SQLITE_MUTEX_FAST = 0x0;
static const Shortint SQLITE_MUTEX_RECURSIVE = 0x1;
static const Shortint SQLITE_MUTEX_STATIC_MASTER = 0x2;
static const Shortint SQLITE_MUTEX_STATIC_MEM = 0x3;
static const Shortint SQLITE_MUTEX_STATIC_MEM2 = 0x4;
static const Shortint SQLITE_MUTEX_STATIC_PRNG = 0x5;
static const Shortint SQLITE_MUTEX_STATIC_LRU = 0x6;
static const Shortint SQLITE_MUTEX_STATIC_LRU2 = 0x7;
static const Shortint SQLITE_STATUS_MEMORY_USED = 0x0;
static const Shortint SQLITE_STATUS_PAGECACHE_USED = 0x1;
static const Shortint SQLITE_STATUS_PAGECACHE_OVERFLOW = 0x2;
static const Shortint SQLITE_STATUS_SCRATCH_USED = 0x3;
static const Shortint SQLITE_STATUS_SCRATCH_OVERFLOW = 0x4;
static const Shortint SQLITE_STATUS_MALLOC_SIZE = 0x5;
static const Shortint SQLITE_STATUS_PARSER_STACK = 0x6;
static const Shortint SQLITE_STATUS_PAGECACHE_SIZE = 0x7;
static const Shortint SQLITE_STATUS_SCRATCH_SIZE = 0x8;
static const Shortint SQLITE_DBSTATUS_LOOKASIDE_USED = 0x0;
static const Shortint SQLITE_STMTSTATUS_FULLSCAN_STEP = 0x1;
static const Shortint SQLITE_STMTSTATUS_SORT = 0x2;
static const Shortint SQLITE_N_LIMIT = 0x9;
#define SQLITE_MASTER_QUOTED "\"sqlite_master\""
#define SQLITE_TEMP_MASTER_QUOTED "\"sqlite_temp_master\""
static const WideChar WC_REPLACEMENT_CHARACTER = WideChar(0xfffd);
extern PACKAGE TDIJulianDate __fastcall DateToJulianDate(const System::TDateTime ADate);
extern PACKAGE TDIJulianDate __fastcall DateTimeToJulianDate(const System::TDateTime ADateTime);
extern PACKAGE TDIJulianDate __fastcall FileTimeToJulianDate(const _FILETIME &AFileTime);
extern PACKAGE AnsiString __fastcall FloatToSqliteStr(const Extended AValue, const char ADecimalSeparator = '\x2e', const int APrecision = 0xf);
extern PACKAGE AnsiString __fastcall FloatToSqlStr(const Extended AValue, const char ADecimalSeparator = '\x2e', int APrecision = 0xf, const int ADecimals = 0x270f);
extern PACKAGE TDIJulianDate __fastcall HmsToJulianDate(const int AHour, const int AMinute, const int ASecond);
extern PACKAGE System::TDateTime __fastcall JulianDateToDate(const TDIJulianDate AJulianDate);
extern PACKAGE System::TDateTime __fastcall JulianDateToDateTime(const TDIJulianDate AJulianDate);
extern PACKAGE _FILETIME __fastcall JulianDateToFileTime(const TDIJulianDate AJulianDate);
extern PACKAGE void __fastcall JulianDateToHms(const TDIJulianDate AJulianDate, /* out */ int &AHour, /* out */ int &AMinute, /* out */ int &ASecond);
extern PACKAGE System::TDateTime __fastcall JulianDateToTime(const TDIJulianDate AJulianDate);
extern PACKAGE void __fastcall JulianDateToYmd(const TDIJulianDate AJulianDate, /* out */ int &AYear, /* out */ int &AMonth, /* out */ int &ADay);
extern PACKAGE Extended __fastcall Power10(int Power);
extern PACKAGE AnsiString __fastcall QuotedStr(const AnsiString s, const char Quote = '\x22');
extern PACKAGE WideString __fastcall QuotedStr16(const WideString s, const WideChar Quote = WideChar(0x22));
extern PACKAGE int __fastcall SqlBufToFloat(char * p, unsigned l, /* out */ Extended &n, const char ADecimalSeparator = '\x2e');
extern PACKAGE int __fastcall SqlStrToFloat(const AnsiString s, /* out */ Extended &n, const char ADecimalSeparator = '\x2e');
extern PACKAGE Extended __fastcall SqlBufToFloatDef(const char * p, const unsigned l, const Extended ADefault, const char ADecimalSeparator = '\x2e');
extern PACKAGE Extended __fastcall SqlStrToFloatDef(const AnsiString s, const Extended ADefault, const char ADecimalSeparator = '\x2e');
extern PACKAGE int __fastcall SqlBufToFloat16(WideChar * p, unsigned l, /* out */ Extended &n, const WideChar ADecimalSeparator = WideChar(0x2e));
extern PACKAGE int __fastcall SqlStrToFloat16(const WideString s, /* out */ Extended &n, const WideChar ADecimalSeparator = WideChar(0x2e));
extern PACKAGE Extended __fastcall SqlBufToFloatDef16(const WideChar * p, const unsigned l, const Extended ADefault, const WideChar ADecimalSeparator = WideChar(0x2e));
extern PACKAGE Extended __fastcall SqlStrToFloatDef16(const WideString s, const Extended ADefault, const WideChar ADecimalSeparator = WideChar(0x2e));
extern PACKAGE unsigned __fastcall StrLen16(const WideChar * Str);
extern PACKAGE TDIJulianDate __fastcall TimeToJulianDate(const System::TDateTime ATime);
extern PACKAGE TDIJulianDate __fastcall YmdToJulianDate(int AYear, int AMonth, const int ADay);
extern PACKAGE void __fastcall sqlite3_Destroy_AnsiString(void * p);
extern PACKAGE void __fastcall sqlite3_Destroy_Mem(void * p);
extern PACKAGE void __fastcall sqlite3_Destroy_WideString(void * p);
extern PACKAGE TDISQLite3Affinity __fastcall sqlite3_affinity(const AnsiString ADeclaration);
extern PACKAGE TDISQLite3Affinity __fastcall sqlite3_affinity16(const WideString ADeclaration);
extern PACKAGE int __fastcall sqlite3_bind_params(const sqlite3_stmt pStmt, const System::TVarRec * Params, const int Params_Size);
extern PACKAGE int __fastcall sqlite3_bind_str(const sqlite3_stmt pStmt, const int ParamIdx, AnsiString Data);
extern PACKAGE int __fastcall sqlite3_bind_str16(const sqlite3_stmt pStmt, const int ParamIdx, WideString Data);
extern PACKAGE int __fastcall sqlite3_bind_variant(const sqlite3_stmt pStmt, const int ParamIdx, const Variant &Data);
extern PACKAGE int __fastcall sqlite3_bind_VarRec(const sqlite3_stmt pStmt, const int ParamIdx, const System::TVarRec &Data);
extern PACKAGE AnsiString __fastcall sqlite3_database_master(const AnsiString ADatabaseName = "");
extern PACKAGE WideString __fastcall sqlite3_database_master16(const WideString ADatabaseName = L"");
extern PACKAGE TDISQLite3DatabaseType __fastcall sqlite3_database_type(const AnsiString ADatabaseName);
extern PACKAGE TDISQLite3DatabaseType __fastcall sqlite3_database_type16(const WideString ADatabaseName);
extern PACKAGE void __fastcall sqlite3_exec_fast(const sqlite3 DB, const AnsiString SQL);
extern PACKAGE void __fastcall sqlite3_exec_fast16(const sqlite3 DB, const WideString SQL);
extern PACKAGE bool __fastcall sqlite3_has_data(const sqlite3 ADb, const AnsiString ATableOrViewName);
extern PACKAGE bool __fastcall sqlite3_has_data16(const sqlite3 ADb, const WideString ATableOrViewName);
extern PACKAGE void __fastcall sqlite3_raise_exception(const int AErrorCode)/* overload */;
extern PACKAGE int __fastcall sqlite3_check(const int AErrorCode)/* overload */;
extern PACKAGE int __fastcall sqlite3_check_stmt(const int AErrorCode, const sqlite3_stmt AStmt);
extern PACKAGE void __fastcall sqlite3_raise_exception(const int AErrorCode, const sqlite3 ADb)/* overload */;
extern PACKAGE void __fastcall sqlite3_raise_exception_stmt(const int AErrorCode, const sqlite3_stmt AStmt);
extern PACKAGE TDISQLite3Encoding __fastcall sqlite3_resolve_encoding(const char * p, const unsigned l);
extern PACKAGE TDISQLite3Encoding __fastcall sqlite3_resolve_encoding16(const WideChar * p, const unsigned l);
extern PACKAGE int __fastcall sqlite3_check(const int AErrorCode, const sqlite3 ADb)/* overload */;
extern PACKAGE AnsiString __fastcall sqlite3_column_str(const sqlite3_stmt pStmt, const int iCol);
extern PACKAGE WideString __fastcall sqlite3_column_str16(const sqlite3_stmt pStmt, const int iCol);
extern PACKAGE WideString __fastcall sqlite3_decode_utf8(char * p, unsigned l)/* overload */;
extern PACKAGE WideString __fastcall sqlite3_decode_utf8(const AnsiString AValue)/* overload */;
extern PACKAGE AnsiString __fastcall sqlite3_encode_utf8(WideChar * p, unsigned l)/* overload */;
extern PACKAGE AnsiString __fastcall sqlite3_encode_utf8(const WideString AValue)/* overload */;
extern PACKAGE unsigned __fastcall sqlite3_read_utf8(const void * p, const unsigned l, /* out */ unsigned &o);
extern PACKAGE void __fastcall sqlite3_result_str(const void * Context, AnsiString Data);
extern PACKAGE void __fastcall sqlite3_result_str16(const void * Context, WideString Data);
extern PACKAGE AnsiString __fastcall sqlite3_value_str(void * Value);
extern PACKAGE WideString __fastcall sqlite3_value_str16(void * Value);
extern PACKAGE unsigned __fastcall sqlite3_write_utf8(unsigned c, const void * p);
extern PACKAGE int __fastcall sqlite3Fts2RegisterTokenizer(const sqlite3 ADb, const AnsiString AName, const Psqlite3_tokenizer_module ATokenizerModule);
extern PACKAGE int __fastcall sqlite3Fts3RegisterTokenizer(const sqlite3 ADb, const AnsiString AName, const Psqlite3_tokenizer_module ATokenizerModule);
extern PACKAGE int __fastcall strcmp(char * s1, char * s2);
extern PACKAGE unsigned __fastcall StrLen(const char * s);
extern PACKAGE int __fastcall sqlite3Fts1Init(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3Fts2Init(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3Fts3Init(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3RtreeInit(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_get_table(sqlite3 DB, const char * zSql, Disystemcompat::PPPUtf8CharArray pazResult, System::PInteger pnRow, System::PInteger pnColumn, Disystemcompat::PPUtf8Char pzErrMsg);
extern PACKAGE void __fastcall sqlite3_free_table(Disystemcompat::PPUtf8CharArray resultp);
extern PACKAGE int __fastcall sqlite3_prepare(sqlite3 DB, const char * zSql, int nByte, sqlite3_stmt_ptr ppStmt, const Disystemcompat::PPUtf8Char pzTail);
extern PACKAGE int __fastcall sqlite3_prepare_v2(sqlite3 DB, const char * zSql, int nByte, sqlite3_stmt_ptr ppStmt, const Disystemcompat::PPUtf8Char pzTail);
extern PACKAGE int __fastcall sqlite3_prepare16(sqlite3 DB, const WideChar * zSql, int nByte, sqlite3_stmt_ptr ppStmt, const System::PPWideChar pzTail);
extern PACKAGE int __fastcall sqlite3_prepare16_v2(sqlite3 DB, const WideChar * zSql, int nBytes, sqlite3_stmt_ptr ppStmt, const System::PPWideChar pzTail);
extern PACKAGE int __fastcall sqlite3_complete(const char * SQL);
extern PACKAGE int __fastcall sqlite3_complete16(const WideChar * SQL);
extern PACKAGE char * __fastcall sqlite3_libversion(void);
extern PACKAGE int __fastcall sqlite3_libversion_number(void);
extern PACKAGE int __fastcall sqlite3_threadsafe(void);
extern PACKAGE int __fastcall sqlite3_initialize(void);
extern PACKAGE int __fastcall sqlite3_shutdown(void);
extern PACKAGE int __cdecl sqlite3_config(int op);
extern PACKAGE sqlite3_mutex_ptr __fastcall sqlite3_db_mutex(sqlite3_ptr DB);
extern PACKAGE int __cdecl sqlite3_db_config(sqlite3 DB, int op);
extern PACKAGE __int64 __fastcall sqlite3_last_insert_rowid(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_changes(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_total_changes(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_close(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_busy_handler(sqlite3 DB, TSQLite3_Busy_Callback Callback, void * UserData);
extern PACKAGE void __fastcall sqlite3_progress_handler(sqlite3 DB, int n, TSQLite3_Progress_Callback Callback, void * UserData);
extern PACKAGE int __fastcall sqlite3_busy_timeout(sqlite3 DB, int ms);
extern PACKAGE void __fastcall sqlite3_interrupt(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_create_function(sqlite3 DB, char * zFunctionName, int nArg, int eTextRep, void * UserData, TSQLite_Func_Callback xFunc, TSQLite_Step_Callback xStep, TSQLite_Final_Callback xFinal);
extern PACKAGE int __fastcall sqlite3_create_function16(sqlite3 DB, WideChar * zFunctionName, int nArg, int eTextRep, void * UserData, TSQLite_Func_Callback xFunc, TSQLite_Step_Callback xStep, TSQLite_Final_Callback xFinal);
extern PACKAGE int __fastcall sqlite3_overload_function(sqlite3 DB, const char * zFuncName, int nArg);
extern PACKAGE void * __fastcall sqlite3_trace(sqlite3 DB, TSQLite_Trace_Callback Callback, void * UserData);
extern PACKAGE void * __fastcall sqlite3_profile(sqlite3 DB, TSQLite_Profile_Callback Callback, void * UserData);
extern PACKAGE void * __fastcall sqlite3_commit_hook(sqlite3 DB, TSQLite_Commit_Callback Callback, void * pArg);
extern PACKAGE void * __fastcall sqlite3_update_hook(sqlite3 DB, TSQLite3_Update_Callback xCallback, void * Part);
extern PACKAGE void * __fastcall sqlite3_rollback_hook(sqlite3 DB, TSQLite3_Rollback_Callback Callback, void * pArg);
extern PACKAGE char * __fastcall sqlite3_errmsg(sqlite3 DB);
extern PACKAGE WideChar * __fastcall sqlite3_errmsg16(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_errcode(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_extended_errcode(sqlite3 DB);
extern PACKAGE int __fastcall sqlite3_limit(sqlite3 DB, int ID, int newVal);
extern PACKAGE int __fastcall sqlite3_open(char * FileName, sqlite3_ptr ppDB);
extern PACKAGE int __fastcall sqlite3_open_v2(const char * FileName, sqlite3_ptr ppDB, int Flags, const char * zVfs);
extern PACKAGE int __fastcall sqlite3_open16(WideChar * FileName, sqlite3_ptr ppDB);
extern PACKAGE int __fastcall sqlite3_create_collation(sqlite3 DB, const char * zName, int eTextRep, void * UserData, TSQLite_Collation_Callback xCompare);
extern PACKAGE int __fastcall sqlite3_create_collation_v2(sqlite3 DB, const char * zName, int eTextRep, void * UserData, TSQLite_Collation_Callback xCompare, TSQLite_Collation_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_create_collation16(sqlite3 DB, const WideChar * zName, int eTextRep, void * UserData, TSQLite_Collation_Callback xCompare);
extern PACKAGE int __fastcall sqlite3_collation_needed(sqlite3 DB, void * UserData, TSQLite_Collation_Needed_Callback Callback);
extern PACKAGE int __fastcall sqlite3_collation_needed16(sqlite3 DB, void * UserData, TSQLite_Collation_Needed16_Callback Callback);
extern PACKAGE int __fastcall sqlite3_global_recover(void);
extern PACKAGE int __fastcall sqlite3_get_autocommit(sqlite3 DB);
extern PACKAGE void __fastcall sqlite3_thread_cleanup(void);
extern PACKAGE int __fastcall sqlite3_table_column_metadata(sqlite3 DB, const char * zDbName, const char * zTableName, const char * zColumnName, const Disystemcompat::PPUtf8Char pzDataType, const Disystemcompat::PPUtf8Char pzCollSeq, System::PInteger pNotNull, System::PInteger pPrimaryKey, System::PInteger pAutoInc);
extern PACKAGE int __fastcall sqlite3_sleep(int ms);
extern PACKAGE int __fastcall sqlite3_extended_result_codes(sqlite3 DB, int onoff);
extern PACKAGE int __fastcall sqlite3_file_control(sqlite3_ptr DB, const char * zDbName, int op, void * pArg);
extern PACKAGE int __fastcall sqlite3_create_module(sqlite3 DB, const char * zName, const Psqlite3_module Module, void * UserData);
extern PACKAGE int __fastcall sqlite3_create_module_v2(sqlite3 DB, const char * zName, const Psqlite3_module Module, void * UserData, TSQLite_Module_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_declare_vtab(sqlite3 DB, const char * zCreateTable);
extern PACKAGE int __fastcall sqlite3_key(sqlite3 DB, const char * PKey, int nKey);
extern PACKAGE int __fastcall sqlite3_rekey(sqlite3 DB, const char * PKey, int nKey);
extern PACKAGE int __fastcall sqlite3_exec(sqlite3 DB, const char * SQL, TSQLite3_Callback Callback, void * UserData, Disystemcompat::PPUtf8Char ErrMsg);
extern PACKAGE int __fastcall sqlite3_set_authorizer(sqlite3 DB, TSQLite_Authorizer_Callback Callback, void * UserData);
extern PACKAGE int __fastcall sqlite3_blob_open(sqlite3 DB, const char * zDb, const char * zTable, const char * zColumn, __int64 iRow, int Flags, sqlite3_blob_ptr ppBlob);
extern PACKAGE int __fastcall sqlite3_blob_close(sqlite3_blob pBlob);
extern PACKAGE int __fastcall sqlite3_blob_read(sqlite3_blob pBlob, void * z, int n, int iOffset);
extern PACKAGE int __fastcall sqlite3_blob_write(sqlite3_blob pBlob, const void * z, int n, int iOffset);
extern PACKAGE int __fastcall sqlite3_blob_bytes(sqlite3_blob pBlob);
extern PACKAGE int __fastcall sqlite3_enable_shared_cache(int Value);
extern PACKAGE sqlite3_mutex_ptr __fastcall sqlite3_mutex_alloc(int iType);
extern PACKAGE void __fastcall sqlite3_mutex_free(sqlite3_mutex_ptr p);
extern PACKAGE void __fastcall sqlite3_mutex_enter(sqlite3_mutex_ptr p);
extern PACKAGE int __fastcall sqlite3_mutex_try(sqlite3_mutex_ptr p);
extern PACKAGE void __fastcall sqlite3_mutex_leave(sqlite3_mutex_ptr p);
extern PACKAGE int __fastcall sqlite3_expired(sqlite3_ptr pStmt);
extern PACKAGE int __fastcall sqlite3_finalize(sqlite3_stmt pStmt);
extern PACKAGE int __fastcall sqlite3_reset(sqlite3_stmt pStmt);
extern PACKAGE int __fastcall sqlite3_clear_bindings(sqlite3_stmt pStmt);
extern PACKAGE void * __fastcall sqlite3_value_blob(void * Value);
extern PACKAGE int __fastcall sqlite3_value_bytes(void * Value);
extern PACKAGE int __fastcall sqlite3_value_bytes16(void * Value);
extern PACKAGE double __fastcall sqlite3_value_double(void * Value);
extern PACKAGE int __fastcall sqlite3_value_int(void * Value);
extern PACKAGE __int64 __fastcall sqlite3_value_int64(void * Value);
extern PACKAGE char * __fastcall sqlite3_value_text(void * Value);
extern PACKAGE WideChar * __fastcall sqlite3_value_text16(void * Value);
extern PACKAGE WideChar * __fastcall sqlite3_value_text16be(void * Value);
extern PACKAGE WideChar * __fastcall sqlite3_value_text16le(void * Value);
extern PACKAGE int __fastcall sqlite3_value_type(void * Value);
extern PACKAGE void __fastcall sqlite3_result_blob(sqlite3_context pCtx, const void * Data, int nData, TSQLite_Result_Destructor xDestroy);
extern PACKAGE void __fastcall sqlite3_result_double(sqlite3_context pCtx, const double Data);
extern PACKAGE void __fastcall sqlite3_result_error(sqlite3_context pCtx, const char * Data, int nData);
extern PACKAGE void __fastcall sqlite3_result_error16(sqlite3_context pCtx, const WideChar * Data, int nData);
extern PACKAGE void __fastcall sqlite3_result_int(sqlite3_context pCtx, const int Data);
extern PACKAGE void __fastcall sqlite3_result_int64(sqlite3_context pCtx, const __int64 Data);
extern PACKAGE void __fastcall sqlite3_result_null(void * Context);
extern PACKAGE void __fastcall sqlite3_result_text(sqlite3_context pCtx, const char * Data, int nData, TSQLite_Result_Destructor xDestroy);
extern PACKAGE void __fastcall sqlite3_result_text16(sqlite3_context pCtx, const WideChar * Data, int nData, TSQLite_Result_Destructor xDestroy);
extern PACKAGE void __fastcall sqlite3_result_text16be(sqlite3_context pCtx, const WideChar * Data, int nData, TSQLite_Result_Destructor xDestroy);
extern PACKAGE void __fastcall sqlite3_result_text16le(sqlite3_context pCtx, const WideChar * Data, int nData, TSQLite_Result_Destructor xDestroy);
extern PACKAGE void __fastcall sqlite3_result_value(void * pCtx, void * pValue);
extern PACKAGE void __fastcall sqlite3_result_zeroblob(sqlite3_context pCtx, int n);
extern PACKAGE void __fastcall sqlite3_result_error_code(void * Context, int ErrCode);
extern PACKAGE void __fastcall sqlite3_result_error_toobig(void * Context);
extern PACKAGE void __fastcall sqlite3_result_error_nomem(void * Context);
extern PACKAGE int __fastcall sqlite3_step(sqlite3_stmt pStmt);
extern PACKAGE void * __fastcall sqlite3_user_data(sqlite3_context pCtx);
extern PACKAGE sqlite3 __fastcall sqlite3_context_db_handle(sqlite3_context pCtx);
extern PACKAGE void * __fastcall sqlite3_aggregate_context(sqlite3_context pCtx, int nBytes);
extern PACKAGE void * __fastcall sqlite3_get_auxdata(sqlite3_context pCtx, int nArg);
extern PACKAGE void __fastcall sqlite3_set_auxdata(sqlite3_context pCtx, int nArg, void * paux, TSQLite_AuxData_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_aggregate_count(sqlite3_context pCtx);
extern PACKAGE int __fastcall sqlite3_column_count(sqlite3_stmt pStmt);
extern PACKAGE int __fastcall sqlite3_data_count(sqlite3_stmt pStmt);
extern PACKAGE void * __fastcall sqlite3_column_blob(sqlite3_stmt pStmt, int iCol);
extern PACKAGE int __fastcall sqlite3_column_bytes(sqlite3_stmt pStmt, int iCol);
extern PACKAGE int __fastcall sqlite3_column_bytes16(sqlite3_stmt pStmt, int iCol);
extern PACKAGE double __fastcall sqlite3_column_double(sqlite3_stmt pStmt, int iCol);
extern PACKAGE int __fastcall sqlite3_column_int(sqlite3_stmt pStmt, int iCol);
extern PACKAGE __int64 __fastcall sqlite3_column_int64(sqlite3_stmt pStmt, int iCol);
extern PACKAGE char * __fastcall sqlite3_column_text(sqlite3_stmt pStmt, int iCol);
extern PACKAGE sqlite3_value __fastcall sqlite3_column_value(sqlite3_stmt pStmt, int iCol);
extern PACKAGE WideChar * __fastcall sqlite3_column_text16(sqlite3_stmt pStmt, int iCol);
extern PACKAGE int __fastcall sqlite3_column_type(sqlite3_stmt pStmt, int iCol);
extern PACKAGE char * __fastcall sqlite3_column_name(sqlite3_stmt pStmt, int n);
extern PACKAGE WideChar * __fastcall sqlite3_column_name16(sqlite3_stmt pStmt, int n);
extern PACKAGE char * __fastcall sqlite3_column_decltype(sqlite3_stmt pStmt, int n);
extern PACKAGE WideChar * __fastcall sqlite3_column_decltype16(sqlite3_stmt pStmt, int n);
extern PACKAGE char * __fastcall sqlite3_column_database_name(sqlite3_stmt pStmt, int n);
extern PACKAGE WideChar * __fastcall sqlite3_column_database_name16(sqlite3_stmt pStmt, int n);
extern PACKAGE char * __fastcall sqlite3_column_table_name(sqlite3_stmt pStmt, int n);
extern PACKAGE WideChar * __fastcall sqlite3_column_table_name16(sqlite3_stmt pStmt, int n);
extern PACKAGE char * __fastcall sqlite3_column_origin_name(sqlite3_stmt pStmt, int n);
extern PACKAGE WideChar * __fastcall sqlite3_column_origin_name16(sqlite3_stmt pStmt, int n);
extern PACKAGE int __fastcall sqlite3_bind_blob(sqlite3_stmt pStmt, int ParamIdx, const void * Data, int nData, TSQLite_Bind_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_bind_double(sqlite3_stmt pStmt, int ParamIdx, double Data);
extern PACKAGE int __fastcall sqlite3_bind_int(sqlite3_stmt pStmt, int ParamIdx, int Data);
extern PACKAGE int __fastcall sqlite3_bind_int64(sqlite3_stmt pStmt, int ParamIdx, __int64 Data);
extern PACKAGE int __fastcall sqlite3_bind_null(sqlite3_stmt pStmt, int ParamIdx);
extern PACKAGE int __fastcall sqlite3_bind_text(sqlite3_stmt pStmt, int ParamIdx, const char * Data, int nData, TSQLite_Bind_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_bind_text16(sqlite3_stmt pStmt, int ParamIdx, const WideChar * Data, int nData, TSQLite_Bind_Destructor xDestroy);
extern PACKAGE int __fastcall sqlite3_bind_value(sqlite3_stmt pStmt, int ParamIdx, const sqlite3_value_ptr pValue);
extern PACKAGE int __fastcall sqlite3_bind_zeroblob(sqlite3_stmt pStmt, int ParamIdx, int nData);
extern PACKAGE int __fastcall sqlite3_bind_parameter_count(sqlite3_stmt pStmt);
extern PACKAGE char * __fastcall sqlite3_bind_parameter_name(sqlite3_stmt pStmt, int n);
extern PACKAGE int __fastcall sqlite3_bind_parameter_index(sqlite3_stmt pStmt, const char * zName);
extern PACKAGE int __fastcall sqlite3_transfer_bindings(sqlite3_stmt pFromStmt, sqlite3_stmt pToStmt);
extern PACKAGE sqlite3 __fastcall sqlite3_db_handle(sqlite3_stmt pStmt);
extern PACKAGE sqlite3_stmt __fastcall sqlite3_next_stmt(sqlite3 pDb, sqlite3_stmt pStmt);
extern PACKAGE int __fastcall sqlite3_stmt_status(sqlite3_stmt Stmt, int op, int resetFlg);
extern PACKAGE char * __fastcall sqlite3_sql(sqlite3_stmt pStmt);
extern PACKAGE int __fastcall sqlite3_value_numeric_type(void * Value);
extern PACKAGE void __fastcall sqlite3_randomness(int n, void * p);
extern PACKAGE char * __cdecl sqlite3_mprintf(char * zFormat);
extern PACKAGE char * __cdecl sqlite3_snprintf(int BufSize, char * zBuf, char * zFormat);
extern PACKAGE void __fastcall sqlite3_soft_heap_limit(int n);
extern PACKAGE int __fastcall sqlite3_release_memory(int n);
extern PACKAGE __int64 __fastcall sqlite3_memory_used(void);
extern PACKAGE __int64 __fastcall sqlite3_memory_highwater(int resetFlag);
extern PACKAGE int __fastcall sqlite3_memory_alarm(TSQLite3_Memory_Alarm_Callback xCallback, void * pArg, __int64 iThreshold);
extern PACKAGE void * __fastcall sqlite3_malloc(int nByte);
extern PACKAGE void __fastcall sqlite3_free(void * p);
extern PACKAGE void * __fastcall sqlite3_realloc(void * POld, int nByte);
extern PACKAGE int __fastcall sqlite3_status(int op, System::PInteger pCurrent, System::PInteger pHighwater, int resetFlag);
extern PACKAGE int __fastcall sqlite3_db_status(sqlite3 DB, int op, System::PInteger pCurrent, System::PInteger pHighwater, int resetFlag);
extern PACKAGE sqlite3_vfs_ptr __fastcall sqlite3_vfs_find(const char * zVfsName);
extern PACKAGE int __fastcall sqlite3_vfs_register(sqlite3_vfs_ptr pVfs, int makeDflt);
extern PACKAGE int __fastcall sqlite3_vfs_unregister(sqlite3_vfs_ptr pVfs);
extern PACKAGE int __fastcall sqlite3_os_init(void);
extern PACKAGE int __fastcall sqlite3_os_end(void);

}	/* namespace Disqlite3api */
using namespace Disqlite3api;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// DISQLite3Api
