{ DISQLite3 example project showing how to and create a new table and fill it
  with some sample data.

  You can use the Show_Table project to display the table's data.

  Visit the DISQLite3 Internet site for latest information and updates:

    http://www.yunqa.de/delphi/

  Copyright (c) 2005-2009 Ralf Junker, The Delphi Inspiration <delphi@yunqa.de>

------------------------------------------------------------------------------ }

program DISQLite3_Create_Table;

{$I DI.inc}
{$I DISQLite3.inc}

{$APPTYPE CONSOLE}

uses
  {$IFDEF FastMM}FastMM4, {$ENDIF}SysUtils, DISQLite3Api,
  DISQLite3_Demos_Common in '..\DISQLite3_Common_Units\DISQLite3_Demos_Common.pas';

procedure InsertData;
begin
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Salvador'', ''Dali'', 1904, 1989);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Samuel Finley Breese'', ''Morse'', 1791, 1872);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Sergei'', ''Rachmaninoff'', 1873, 1943);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Alexandre'', ''Dumas'', 1802, 1870);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Franz'', ''Schubert'', 1797, 1828);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Leonardo'', ''da Vinci'', 1452, 1519);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Aldous Leonard'', ''Huxley'', 1894, 1963);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Claude'', ''Monet'', 1840, 1926);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Albert'', ''Einstein'', 1879, 1955);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Johannes'', ''Gutenberg'', 1400, 1468);');
  Write('.');
  sqlite3_exec_fast(DB, 'INSERT INTO People VALUES (''Jane'', ''Austen'', 1775, 1817);');
  Write('.');
end;

//------------------------------------------------------------------------------

begin
  WriteLn('SQLite Version ', sqlite3_libversion);

  { Disable FPU exceptions. No need to restore, setting is process specific. }
  Set8087CW($133F);

  try
    { Initialize the DISQLite3 library prior to using any other DISQLite3
    functionality. See also sqlite3_shutdown() below.}
    sqlite3_initialize;
    try
      Open_Demo_Database;
      try

        { Creating new tables is as simple as executing a single SQL statment. }
        Write('Creating table ...');
        { Execute an SQL statement to create the table if it does not yet exist. }
        sqlite3_exec_fast(DB,
          'CREATE TABLE IF NOT EXISTS People (' + CRLF +
          '  FirstName TEXT,' + CRLF +
          '  LastName TEXT,' + CRLF +
          '  YearOfBirth INTEGER,' + CRLF +
          '  YearOfDeath INTEGER);');
        WriteLn(' Done');

        { Insert some sample data - first without transaction. Each record is
          inserted and committed individually. This is rather slow compared to
          using transactions (see below). }
        Write('Inserting data without transaction ');
        InsertData;
        WriteLn(' OK');

        { Insert some sample data - now with transaction. Multiple records are
          inserted and not yet commited until the transaction is finally ended.
          This single transaction is very fast compared to multiple individual
          transactions. It is even faster than other database engines. }
        Write('Inserting data with transaction ');
        sqlite3_exec_fast(DB, 'BEGIN TRANSACTION;'); Write('.');
        try
          InsertData;
          sqlite3_exec_fast(DB, 'COMMIT TRANSACTION;'); Write('.');
          WriteLn(' OK');
        except
          { We get here only if there was a problem. If so, we write out the
            error message and rollback the transaction to restore the previous
            state of the database. }
          on e: Exception do
            begin
              WriteLn;
              WriteLn('An error occurred:');
              WriteLn(e.Message);
              Write('Rolling back transaction ...');
              sqlite3_exec_fast(DB, 'ROLLBACK TRANSACTION;');
              WriteLn(' OK');
            end;
        end;

      finally
        Close_Demo_Database;
      end;

    finally
      { Deallocate any resources that were allocated by
        sqlite3_initialize() above. }
      sqlite3_shutdown;
    end;

  except
    on e: Exception do
      WriteLn(e.Message);
  end;

  WriteLn;
  WriteLn('Done - Press ENTER to Exit');
  ReadLn;
end.

