{ DISQLite3 incremental blob demo. Using the incremental blob API, DISQLite3
  can conveniently handle large blobs with no strains to memory.

  Visit the DISQLite3 Internet site for latest information and updates:

    http://www.yunqa.de/delphi/

  Copyright (c) 2006-2009 Ralf Junker, The Delphi Inspiration <delphi@yunqa.de>

------------------------------------------------------------------------------ }

unit DISQLite3_Incremental_Blob_fAdd;

{$I DI.inc}
{$I DISQLite3.inc}

interface

uses
  Classes, Controls, Forms, StdCtrls;

type
  TfrmIncrementalBlobAdd = class(TForm)
    edtName: TEdit;
    edtComment: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    btnCancel: TButton;
    btnOK: TButton;
    edtBlobFileName: TEdit;
    btnSelectFile: TButton;
    lblBlobFileName: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnSelectFileClick(Sender: TObject);
    procedure edtBlobFileNameChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmIncrementalBlobAdd: TfrmIncrementalBlobAdd;

implementation

uses
  SysUtils, Dialogs,
  DISQLite3_Incremental_Blob_fMain;

{$R *.dfm}

procedure TfrmIncrementalBlobAdd.FormCreate(Sender: TObject);
begin
  Caption := APP_TITLE + ' - Add';
  btnOK.Enabled := False;
end;

//------------------------------------------------------------------------------

procedure TfrmIncrementalBlobAdd.btnSelectFileClick(Sender: TObject);
var
  OpenDlg: TOpenDialog;
begin
  OpenDlg := TOpenDialog.Create(nil);
  try
    OpenDlg.FileName := edtBlobFileName.Text;
    if OpenDlg.Execute then
      begin
        edtBlobFileName.Text := OpenDlg.FileName;
      end;
  finally
    OpenDlg.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmIncrementalBlobAdd.edtBlobFileNameChange(Sender: TObject);
var
  b: Boolean;
  FN: String;
begin
  FN := edtBlobFileName.Text;
  b := (FN <> '') and FileExists(FN);
  btnOK.Enabled := b;
  if b and (edtName.Text = '') then
    edtName.Text := ExtractFileName(FN);
end;

end.

