{ DISQLite3 incremental blob demo. Using the incremental blob API, DISQLite3
  can conveniently handle large blobs with no strains to memory.
  
  Visit the DISQLite3 Internet site for latest information and updates:

    http://www.yunqa.de/delphi/

  Copyright (c) 2006-2009 Ralf Junker, The Delphi Inspiration <delphi@yunqa.de>

------------------------------------------------------------------------------ }

unit DISQLite3_Incremental_Blob_fEdit;

{$I DI.inc}
{$I DISQLite3.inc}

interface

uses
  Classes, Controls, Forms, StdCtrls;

type
  TfrmIncrementalBlobEdit = class(TForm)
    edtName: TEdit;
    edtComment: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    btnCancel: TButton;
    btnOK: TButton;
    gbxBlobContents: TGroupBox;
    rbBlobNoChange: TRadioButton;
    rbBlobDelete: TRadioButton;
    rbBlobReplace: TRadioButton;
    edtBlobFileName: TEdit;
    btnSelectFile: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnSelectFileClick(Sender: TObject);
    procedure BlobChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmIncrementalBlobEdit: TfrmIncrementalBlobEdit;

implementation

uses
  SysUtils, Dialogs,
  DISQLite3_Incremental_Blob_fMain;

{$R *.dfm}

procedure TfrmIncrementalBlobEdit.FormCreate(Sender: TObject);
begin
  Caption := APP_TITLE + ' - Edit';
end;

//------------------------------------------------------------------------------

procedure TfrmIncrementalBlobEdit.btnSelectFileClick(Sender: TObject);
var
  OpenDlg: TOpenDialog;
begin
  OpenDlg := TOpenDialog.Create(nil);
  try
    OpenDlg.FileName := edtBlobFileName.Text;
    if OpenDlg.Execute then
      begin
        edtBlobFileName.Text := OpenDlg.FileName;
        rbBlobReplace.Checked := True;
      end;
  finally
    OpenDlg.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmIncrementalBlobEdit.BlobChange(Sender: TObject);
var
  FN: String;
begin
  FN := edtBlobFileName.Text;
  btnOK.Enabled :=
    rbBlobNoChange.Checked or
    rbBlobDelete.Checked or
    ((FN <> '') and FileExists(FN));
end;

end.

