{ DISQLite3 example project showing how to profile SQL execution times using
  the build-in sqlite3_profile function.

  !!! Important: This project requires the full version of DISQLite3 since
  !!!            it uses some functions not available in DISQLite Personal.

  Visit the DISQLite3 Internet site for latest information and updates:

    http://www.yunqa.de/delphi/

  Copyright (c) 2005-2009 Ralf Junker, The Delphi Inspiration <delphi@yunqa.de>

------------------------------------------------------------------------------ }

program DISQLite3_Profile;

{$I DI.inc}
{$I DISQLite3.inc}

{$IFDEF DISQLite3_Personal}
!!! This project requires functionality unavailable in DISQLite3 Personal. !!!
!!! To compile, download DISQLite3 Pro from www.yunqa.de/delphi/           !!!
{$ENDIF DISQLite3_Personal}

{$APPTYPE CONSOLE}

uses
  {$IFDEF FastMM}FastMM4, {$ENDIF}DISystemCompat, SysUtils, DISQLite3Api,
  DISQLite3_Demos_Common in '..\DISQLite3_Common_Units\DISQLite3_Demos_Common.pas';

//------------------------------------------------------------------------------

{ This function that is invoked at the conclusion of each SQL statement that is
  run and includes information on how long that statement ran. }
procedure Profile_Callback(
  UserData: Pointer;
  const Sql8: PUtf8Char;
  elapseTime: Int64);
begin
  WriteLn;
  WriteLn('Elapsed Time: ', elapseTime / 1000000000: 0: 4, ' seconds for SQL statement:');
  WriteLn(SQL8);
end;

//------------------------------------------------------------------------------

var
  Stmt: TDISQLite3StatementHandle;
begin
  { Disable FPU exceptions. No need to restore, setting is process specific. }
  Set8087CW($133F);

  try
    { Initialize the DISQLite3 library prior to using any other DISQLite3
      functionality. See also sqlite3_shutdown() below.}
    sqlite3_initialize;
    try
      Open_Demo_Database;
      try
        { Register a profile callback function. The sqlite3_profile function is
          not available with the DISQLite3 Personal edition! Instead, compile this
          example project with the DISQLite3 Standard edition available from the
          DISQLite3 Internet site. }
        sqlite3_profile(DB, Profile_Callback, nil); // Compile Error? Read first comment above!

        { Prepare an SQL statment to select duplicate entries. If the table is not
          indexed, this query can take a while to execute!

          An index can speed up this query considerably:

            CREATE INDEX i ON RandomTable (RandomInt); }
        sqlite3_check(sqlite3_prepare(
          DB,
          'SELECT RandomInt, COUNT() FROM RandomTable GROUP BY RandomInt HAVING COUNT() > 1;',
          -1, // Length of SQL statement, pass -1 to autodetect
          @Stmt, // Variable which takes the prepared SQL statement
          nil), // Variable to store beginning of next SQL statement or nil if not needed.
          DB);

        if Assigned(Stmt) then
          try
            WritePreparedStatement(DB, Stmt);
          finally
            sqlite3_finalize(Stmt);
          end;

      finally
        Close_Demo_Database;
      end;

    finally
      { Deallocate any resources that were allocated by
        sqlite3_initialize() above. }
      sqlite3_shutdown;
    end;

  except
    on e: Exception do
      WriteLn(e.Message);
  end;

  WriteLn;
  WriteLn('Done - Press ENTER to Exit');
  ReadLn;
end.

