{ Visit the DISQLite3 Internet site for latest information and updates:

    http://www.yunqa.de/delphi/

  Copyright (c) 2005-2009 Ralf Junker, The Delphi Inspiration <delphi@yunqa.de>

------------------------------------------------------------------------------ }

unit DISQLite3_World_ClientDataSet_Form;

{$I DI.inc}

interface

uses
  Classes, DB, Grids, DBGrids, StdCtrls, DBCtrls, Mask, Controls, ExtCtrls,
  ComCtrls, Provider, DBClient, ActnList, ToolWin,
  DISQLite3Database, DISQLite3DataSet,
  DISQLite3_World_Common;

type
  TfrmWorld = class(TfrmWorld_Common)
    DbGrid: TDBGrid;
    Splitter: TSplitter;
    ClientDataSet: TClientDataSet;
    DataSetProvider: TDataSetProvider;
    ToolBar: TToolBar;
    btnUpdate: TToolButton;
    btnCancel: TToolButton;
    ActionList: TActionList;
    actApplyUpdates: TAction;
    actCancelUpdates: TAction;
    btnPasteFlag: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnPasteFlagClick(Sender: TObject);
    procedure actUpdates_Update(Sender: TObject);
    procedure actCancelUpdatesExecute(Sender: TObject);
    procedure actApplyUpdatesExecute(Sender: TObject);
    procedure ClientDataSet_Modified(DataSet: TDataSet);
    procedure DISQLite3UniDirQueryInitFieldDef(
      const AColumn: TDISQLite3Column; const AFieldDef: TFieldDef);
  end;

var
  frmWorld: TfrmWorld;

implementation

uses
  SysUtils
  { Compile MidasLib into the application if supported by Delphi version.
    This removes all dependencies against midas.dll and turns projects into
    fully standalone applications. }
  {$IFDEF COMPILER_6_UP}, MidasLib{$ENDIF};

{$R *.dfm}

procedure TfrmWorld.FormCreate(Sender: TObject);
begin
  inherited;
  ClientDataSet.Open;
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.btnPasteFlagClick(Sender: TObject);
begin
  imgFlag.PasteFromClipboard;
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.actUpdates_Update(Sender: TObject);
begin
  (Sender as TAction).Enabled := ClientDataSet.ChangeCount > 0;
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.actCancelUpdatesExecute(Sender: TObject);
begin
  ClientDataSet.CancelUpdates;
  StatusBar.SimpleText := '';
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.actApplyUpdatesExecute(Sender: TObject);
var
  i: Integer;
begin
  i := ClientDataSet.ApplyUpdates(-1);
  if i > 0 then
    StatusBar.SimpleText := IntToStr(i) + ' Error(s) during update'
  else
    StatusBar.SimpleText := 'Update(s) OK';
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.ClientDataSet_Modified(DataSet: TDataSet);
begin
  if ClientDataSet.ChangeCount = 0 then
    StatusBar.SimpleText := ''
  else
    StatusBar.SimpleText := IntToStr(ClientDataSet.ChangeCount) + ' Update(s) pending';
end;

//------------------------------------------------------------------------------

procedure TfrmWorld.DISQLite3UniDirQueryInitFieldDef(
  const AColumn: TDISQLite3Column; const AFieldDef: TFieldDef);
begin
  inherited;
  {$IFNDEF COMPILER_5_UP}
  { TClientDataSet in D4 does not support WideStrings. }
  if AFieldDef.DataType = ftWideString then
    begin
      AFieldDef.DataType := ftString;
      AFieldDef.Size := 64;
    end;
  {$ENDIF !COMPILER_5_UP}
end;

end.
 
