{-------------------------------------------------------------------------------
 
 Copyright (c) 1999-2009 Ralf Junker, The Delphi Inspiration
 Internet: http://www.yunqa.de/delphi/
 E-Mail:   delphi@yunqa.de

-------------------------------------------------------------------------------}

unit DISQLite3Reg;

{$I DI.inc}
{$I DISQLite3.inc}

interface

procedure Register;

implementation

uses
  SysUtils, Classes, Dialogs, Db,
  {$IFDEF COMPILER_6_UP}DesignIntf, DesignEditors, {$ELSE }DsgnIntf, {$ENDIF}
  DISQLite3Api, DISQLite3Database, DISQLite3DataSet;

type
  TDISQLite3DatabasePropertyEditor = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    procedure SetValue(const Value: string); override;
  end;

function TDISQLite3DatabasePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  if GetComponent(0) is TDISQLite3Database then
    Result := [paDialog];
end;

procedure TDISQLite3DatabasePropertyEditor.SetValue(const Value: string);
var
  c: TPersistent;
begin
  c := GetComponent(0);
  if c is TDISQLite3Database then
    with c as TDISQLite3Database do
      if Connected then Connected := False;
  SetStrValue(Value);
end;

procedure TDISQLite3DatabasePropertyEditor.Edit;
var
  c: TPersistent;
begin
  c := GetComponent(0);
  if c is TDISQLite3Database then
    with TOpenDialog.Create(nil) do
      try
        Filter := 'Any File (*.*)|*.*|DISQLite3 Database (*.db;*.db3)|*.db;*.db3';
        InitialDir := ExtractFilePath((c as TDISQLite3Database).DatabaseName);
        if Execute then
          (c as TDISQLite3Database).DatabaseName := FileName;
      finally
        Free;
      end
  else
    inherited;
end;

procedure Register;
begin
  RegisterComponents('Delphi Inspiration', [
    TDISQLite3Database,
    TDISQLite3DataSetImporter,
      TDISQLite3UniDirQuery]);

  RegisterPropertyEditor(TypeInfo(WideString), TDISQLite3Database, 'DatabaseName', TDISQLite3DatabasePropertyEditor);

  RegisterFields([TDISQLite3MemoField]);

  {$IFNDEF COMPILER_5_UP}
  RegisterFields([TDISQLite3WideStringField]);
  {$ENDIF !COMPILER_5_UP}

  {$IFNDEF COMPILER_10_UP}
  RegisterFields([
    TDISQLite3BlobField,
      TDISQLite3WideStringField]);
  {$ENDIF !COMPILER_10_UP}
end;

end.

