var Dialog = (function() {
	var id,
	layout,
	title,
	content,
	closeTrigger,
	l = function(selector) {
		return layout.find(selector);
	},
	$tip = $('<span></span>').appendTo(document.body);
	$tip.css({
		position: 'absolute',
		top: '0',
		padding: '5px 10px',
		'border-top': '2px solid #67080f',
		color: '#fff',
		opacity: 0,
		"line-height": "20px",
		'z-index': 99999,
		'background-color': '#9d0c18'
	});

	return {
		init: function() {
			id = 'fitDialog',
			layout = $('#' + id),
			title = layout.find('.title'),
			content = layout.find('.content'),
			closeTrigger = layout.find('.pur5_mask_close'),
			confirmBtn = layout.find('.confirmBtn'),
			obj = layout.find('.obj');
		},
		tip: function(messageText, delaySeconds) {
			if (!messageText) return false;
			delaySeconds = (delaySeconds || 500);
			var move = 30;

			$tip.stop().css({
				opacity: 0
			}).text(messageText);

			if ($tip.width() > 300) {
				$tip.css({
					width: 300
				});
			} else {
				$tip.css({
					width: 'auto'
				});
			}

			setTimeout(function() {
				var top = ($(window).height() - $tip.outerHeight()) / 2,
					left = ($(window).width() - $tip.outerWidth()) / 2;
				$tip.css({
					top: top + move / 2,
					left: left,
					display: 'block',
					opacity: 0
				});
				$tip.animate({
					top: top - move / 2,
					opacity: 1
				}, function() {
					setTimeout(function() {
						var top = $tip.offset().top;
						$tip.animate({
							top: top - move,
							opacity: 0
						}, function() {
							$tip.hide();
							//$tip.remove();
						});
					}, delaySeconds);
				});
			});
			return $tip;
		},
		box: function(arg) {
			var self = this;
			var show = function() {
				self.hide();
				l('.title').html(arg.title);
				var content = l('.content');
				$('.inputTr').toggle( !! arg.prompt);

				arg = $.extend({
					style: {},
					action: function() {},
					closeBtnVisible: true
				}, arg);

				content.html('' + arg.content).css($.extend({
					height: 'auto',
					width: 'auto',
					overflow: 'hidden',
					border: 'none'
				}, arg.style));

				l('.pur5_mask_close').toggle(arg.closeBtnVisible);

				var buttonArr = [],
					buttonIndex = 0;
				$.each(arg.button, function(buttonText, buttonFunc) {
					if (!buttonFunc) return;
					buttonArr.push(
						'<span class="buttonNo">buttonText</span>'
						.replace(/buttonNo/g, buttonIndex == 0 ? 'button3' : 'button2')
						.replace(/buttonText/g, buttonText));
					buttonIndex++;
				});

				l('.buttons').html(buttonArr.join('')).pur5UI()
					.parents('tr').toggle( !! buttonArr.length);

				setTimeout(function() {
					pur5.Pages.alert(layout[0], function() {
						arg.action(content, layout);
						l('.buttons span').filter('.button2, .button3').click(function() {
							var button = $(this),
								buttonText = button.text(),
								result;

							result = arg.button[buttonText](content, self);
							if (result !== false) self.hide();
						});
					});
				});
			}

			if (arg.content && js_type(arg.content) == 'Object' && arg.content.url === true) {
				$.ajax($.extend({
					show: function(content) {
						$.extend(arg, {
							content: content
						});
						show();
					}
				}, arg.content));
			} else {
				show();
			}
		},
		prompt: function(arg, callback) {
			this.box($.extend(true, {
				title: '请输入',
				content: '内容',
				prompt: true,
				button: {
					'确 定': function() {},
					'取 消': function() {}
				},
				cb: function(buttonIndex, value) {
					callback && callback(value, buttonIndex);
				}
			}, arg));
		},
		alert: function(arg) {
			this.box($.extend(true, {
				title: '提示',
				content: '内容',
				button: {
					'确 定': function() {}
				},
				cb: function(buttonIndex) {
					try {
						return arg.button[buttonIndex - 1].action();
					} catch (e) {}
				}
			}, arg));
		},
		confirm: function(arg, callback) {
			this.box($.extend(true, {
				title: '请确认',
				buttton: {
					'确 定': function() {},
					'取 消': function() {}
				},
				content: '内容',
				cb: function(buttonIndex) {
					callback && callback(buttonIndex);
				}
			}, arg));
		},
		normalAlert: function(title, content) {
			this.alert({
				title: title || undefined,
				content: content || undefined,
				style: {
					width: 280,
					height: 30
				}
			});
		},
		normalConfirm: function(title, content, cb) {
			this.confirm({
				title: title || undefined,
				content: content || undefined,
				button: {
					'确 定': cb
				},
				style: {
					width: 280,
					height: 30
				}
			});
		},
		superIframe: function(Arg) {
			var Arg = $.extend({
				title: '提示',
				style: {
					width: 400,
					height: 300
				},
				src: 'about:blank;',
				action: function() {},
				parentAction: function() {}
			}, Arg);

			Dialog.alert({
				title: Arg.title,
				content: parseData2Template('<iframe frameborder="0" style="visibility:"\
							application="yes" width="$width" height="$height"\
							src="about:blank"></iframe>', {
								width: Arg.style.width,
								height: Arg.style.height
							}),
				action: function($content) {
					$content.find('iframe').load(function() {
						var Win = this.contentWindow,
							Doc = Win.document,
							$doc = $(Doc),
							Iframe = $doc.find('iframe');

						Arg.parentAction($doc, Win, $content, layout);

						Iframe.load(function() {
							var Win = this.contentWindow,
								Doc = Win.document,
								$doc = $(Doc);

							Arg.action($doc, Win, $content, layout);
						}).attr('src', Arg.src);

					}).attr('src', 'file:///' + pur5.Cfg.startPath + 'iframe.html');
				},
				button: Arg.button
			});
		},
		hide: function() {
			try {
				closeTrigger.click();
				$('.pur5_mask_show_bg, .pur5_mask_show, .pur5_mask_show_iframe').hide();
			} catch (e) {}
		}
	}
})();
Dialog.init();