var Progress = (function(){
	var	id,
		layout,
		title,
		progress,
		content,
		closeTrigger,
		l = function(selector){
			return layout.find(selector);
		},
		maxValue,
		currentValue;
		
	return {
		init: function(){
			id = 'progress',
			layout = $('#' + id),
			title = layout.find('.title'),
			content = layout.find('.content'),
			progress = layout.find('.progress'),
			closeTrigger = layout.find('.pur5_mask_close');
		},
		show: function(titleText, contentText, max_value){
			maxValue = max_value;
			currentValue = 1;
			title.html(titleText + '&nbsp;');
			content.html(contentText);
			pur5.Pages.alert(layout[0]);
		},
		hide: function(){
			try{
				closeTrigger.click();
			}catch(e){}
		},
		val: function(total, bytes, contentText){
			if(!total) total = maxValue;
			if(!bytes){
				bytes = currentValue++;
			}
			
			var value = parseInt(bytes / total * 100) + '%';
			//progress.text(value);
			title.html(title.html().replace(/\d+%$/,'') + value);
			content.html(contentText);			
		}
	}
})();
Progress.init();