﻿var SnapConfig = (function(){
	var	configPath = 'model/snapConfig/config.pur5',
		Config = (new Function('return ' + Fso.read(configPath))() || {
			hideUIWhenSnap: false
		});

	return {
		isHideUIWhenSnap: function(){
			return Config.hideUIWhenSnap;
		},
		saveConfig: function(){
			Fso.write(configPath, $.stringify(Config));
		},
		init: function(){
			var self = this;
			$('#hidePur5WhenSnap').click(function(){//截图时是否隐藏软件
				Config.hideUIWhenSnap = this.checked;
				self.saveConfig();
			});
			
			$('#hidePur5WhenSnap').attr('checked', Config.hideUIWhenSnap);
			
			$('#menuSNAPCONFIG').click(function(){
				 pur5.Pages.layoutTo('layoutSnapConfig');
				 self.refresh();
			});
		},
		refresh: function(){
			var self = this,
				Data = Snap.getData();
				
			$('#snapList')
				.empty()
				.append(parseData2Template('<div class="snapPicItem" style="background-image:url($filePath)"\
				fileName="$filePath"><span>删除</span></div>', Data))
				.find('.snapPicItem')
				.css({
					opacity: 0.85
				})
				.mouseover(function(){
					var self = $(this);
					self.css({
						opacity: 1
					})
					.siblings().css({
						opacity: 0.85
					})
				})
				.click(function(){
					var self = $(this);
					window.open(self.attr('fileName'));
				})
				.find('>span')
				.click(function(e){
					if(!confirm('确定要删除这张截图吗？')){
						return false;
					}
					
					Snap.del($(this).parent('.snapPicItem').index());
					self.refresh();
				});
			
			$('.snapCount').text(Data.length);
			$('#snapList').scrollTop(Data.length * 100);
		}
	};
})();

$(function(){
	SnapConfig.init();
});