﻿var TaobaoOffline = (function(){
	var windowId = '' + new Date().getTime(),
		Ds = new ActiveXObject('dsCookieGetter.ds'),
		loginUrl = 'https://login.taobao.com/member/login.jhtml',
		triggerBtn = $('#menuLXTG'),
		layout = $('#layoutTaobaoOffline'),
		loginBtn = layout.find('.loginBtn'),
		submitBtn = layout.find('.submitBtn'),
		offlineFeeBtn = layout.find('.offlineFeeBtn'),
		offlineEndTime = layout.find('.offlineEndTime'),
		list = layout.find('.list'),
		
		shopNumber = '',
		source = 'taobao'
		cookies = '';
	
	return {
		init: function(){
			var self = this;
			offlineFeeBtn.click(function(){
				var endTime = offlineEndTime.text();
					endStr = endTime.split(/[^\d]/);
					nowStr = new Date().toJson().split(/[^\d]/)
					endTime = new Date(endStr[0], endStr[1], endStr[2]),
					nowTime = new Date(nowStr[0], nowStr[1], nowStr[2]),
					diffDay = Math.round((endTime.getTime() - nowTime.getTime())/(1000*60*60*24));

				if(diffDay > 10){
					if(confirm('离线托管还有['+diffDay+']天到期，是否确认续费？')) OfflineFee.show(source);
				}else{
					OfflineFee.show(source);
				}
			});
			
			triggerBtn.unbind('click').attr('onclick', '').click(function(){
				pur5.Pages.topMenuEvent(triggerBtn);
				self.layout();
			});
			
			loginBtn.click(function(){
				Ds.Link(loginUrl + '?' + windowId, windowId);
			});
			
			submitBtn.click(function(){
				if(!self.getCookies()) return false;
				self.submit();
			});
		},
		layout: function(){
			var self = this;

			if(!pur5.Cfg.pur5PassWordKey) {
				TradingPass.show(function(){
					pur5.Pages.setPur5PW2(true, function() {
						pur5.Pages.layoutTo(layout.attr('id'));
						self.getList();
					});
				});
			} else {
				pur5.Pages.layoutTo(layout.attr('id'));
				self.getList();
			}
		},
		stop: function(offlineId){
			var self = this;
			$.ajax({
				url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
				type: 'get',
				cache: false,
				data: {
					token: pur5.Cfg.token,
					lv: 't3',
					//ww: qq,
					id: offlineId,
					source: source
				},
				success: function(Result){
					if(Result == '1') {
						list.find('td.offline_' + offlineId).parent().remove();
						self.getList();
					} else {
						alert('取消托管失败：' + Result);
					}
				},
				error: function(jqXhr){
					alert('取消托管错误：' + jqXhr.responseText);
				}
			});
		},
		getList: function(){
			this.getStatus();
			var self = this;
			list.children().remove();
			$.ajax({
				url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
				cache: false,
				dataType: 'json',
				data: {
					token: pur5.Cfg.token,
					lv: 't2',
					source: source
				},
				success: function(OfflineList){
					list.hide();					
					var tmp = '<tr><td class="offline_Id">Number</td><td>startTime</td><td class="bluefont">states</td><td><a href="#" class="cancelOffline" value="Id" title="停止对店铺Number的离线托管">停止</a></td></tr>';
					$.each(OfflineList, function(index, offlineRow){
						list.append(
							tmp
								.replace(/Number/g, decodeURIComponent(offlineRow[0]))
								.replace(/startTime/g, offlineRow[1])
								.replace(/endTime/g, offlineRow[4])
								
								.replace(/states/g, offlineRow[3])
								.replace(/description/g, offlineRow[3])
								.replace(/Id/g, offlineRow[5])
						);
						if(/停止/.test(offlineRow[3])){
							list.find('tr').eq(index).find('.cancelOffline').hide();
						}
					});
					list.show();
					
					list.find('a.cancelOffline').click(function(){
						if(!confirm($(this).attr('title') + '？')) return false;
						self.stop($(this).attr('value'));
					});

				},
				error: function(jqXhr, textStatus){
					ajaxError('读取淘宝离线托管列表', jqXhr, textStatus);
				}
			});
		},
		getStatus: function(){
			$.ajax({
				url: pur5.Cfg.GBHOSTSOFT + 'offline/offlinePay.asp',
				dataType: 'json',
				data: {
					action: 'status',
					source: source,
					token: pur5.Cfg.token
				},
				success: function(Result){
					offlineEndTime.text(Result.values.endTime);
				},
				error: function(jqXhr, textStatus){
					ajaxError('读取淘宝离线托管截止时间', jqXhr, textStatus);
				}
			});
		},
		getCookies: function(){
			Ds.CloseWindow(windowId);
			cookies = Ds.GetCookie(windowId);
			
			if(cookies) cookies = cookies.replace(/[\n\r]+/gm, '');
			if(!cookies || cookies.search("token") <= 0) {
				alert('请先点击"登录淘宝"按钮登录后再开始托管！');
				return false;
			}
			
			if(cookies.indexOf('_nk_=') != -1) {
				shopNumber = unescape(cookies.split('_nk_=')[1].split(';')[0].replace(/%5C/g, '%'));
			} else if(cookies.indexOf('nick=') != -1) {
				shopNumber = unescape(cookies.split('nick=')[1].split(';')[0].replace(/%5C/g, '%'));
			}
			if(!shopNumber){
				alert('请先点击"登录淘宝"按钮登录后再开始托管！');
				//alert('获取旺旺号为空');
				return false;
			}
			return true;
		},
		submit: function(){
			var self = this;

			$.ajax({//托管
				url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
				type: 'post',
				cache: false,
				data: {
					token: pur5.Cfg.token,
					lv: 't1',
					ww: shopNumber.$$$(),
					cookie: cookies.$$$(),
					source: source
				},
				success: function(Result){
					if(Result != '1'){
						alert('提交淘宝离线托管失败：\n' + Result);
						return false;
					}
					self.getList();
				},
				error: function(jqXhr, textStatus){
					ajaxError('提交淘宝离线托管', jqXhr, textStatus);
				}
			});
		}
	}
})();

$(function(){
	TaobaoOffline.init();
});