﻿var WarnSetting = (function(){
	var	triggerBtn,
		filePath = 'controls/warnsetting.pur5',
		Warn = {},
		isLayouted;
	
	return {
		init: function(){
			var self = this;
			triggerBtn = $('#menuQJSZ');
			if(!triggerBtn.length) return false;
			
			filePath = filePath.replace(/type/, pur5.Pages.Version.type);
			$('#WarnSetting .warnSettingBtn').css({
				opacity: 0.5
			}).mouseover(function(){
				$(this).css({
					opacity: 1
				});
			}).mouseout(function(){
				$(this).css({
					opacity: 0.5
				});
			}).attr('title', '配置')
			.click(function(){
				alert($(this).parent().attr('className'));
				return false;
			});
			
			$('#WarnSetting').bind('selectstart', false);
			$('table.warntable').each(function(){
				$(this).find('tr:gt(0)').each(function(){
					$(this).find('td:gt(0)')
					.each(function(){
						var self = $(this);
						self
						.addClass(self.parents('tr').find('td:first').attr('className') + '_' + $('#settingWarnTitle td:eq('+(self.index())+')').attr('className'))
						.addClass($('#settingWarnTitle td:eq('+(self.index())+')').attr('className'))
						.css({
							textAlign: 'center'
						})
						.mouseover(function(){
//							var self = $(this);
//							$('#GlobalSetting .actived').removeClass('actived');
//							self.parent().addClass('actived');
//							$('#settingWarnTitle td:nth-child('+(self.index()+1)+'), table.warmtable td:nth-child('+(self.index()+1)+')').addClass('actived');
						});
					})
					.css({
						opacity: 0.5
					})
					.click(function(){
						$(this).toggleClass('right');
						self.save();
					});
				});
			});
			$('#settingWarnTitle').find('td[className]')
			.click(function(){
				var title = $(this);
				$('table.warntable tr td:nth-child('+(title.index()+1)+')').toggleClass('right', !title.attr('right'));
				title.attr('right', !title.attr('right'));
				self.save();
			});
			
			$('table.warntable tr:gt(0) td:first-child').click(function(){
				$(this).siblings().toggleClass('right', !$(this).attr('selectedall'));
				$(this).attr('selectedall', !$(this).attr('selectedall'));
				self.save();
			});
			
			triggerBtn.click(function(){
				//if(!isLayouted){
					$('table.warntable tr:gt(0) td').not(':nth-child(1)').removeClass('right');
					self.load();
					isLayouted = true;
				//}
				pur5.Pages.layoutTo('layoutWarnSetting');
				pur5.Pages.topMenuEvent($(this));
			});
		},
		load: function(){//读取设置
			var preSetting = Fso.read(filePath);
			Warn = $.parseJSON(preSetting) || Warn;
			$.each(Warn, function(warnName, warnValue){
				$('table.warntable .' + warnName).toggleClass('right', warnValue);
			})
		},
		save: function(){//保存设置
			Warn = {};
			$('#WarnSetting table.warntable td.right').map(function(){
				Warn[$(this).attr('className').match(/(\w+?_\w+)/)[1]] = true;
			}).get();
			Fso.write(filePath, $.stringify(Warn));
		}
	}
})();
$(function(){
	WarnSetting.init();
});