var	Ui = (function(){
	var Ax = Dwd.loadAx('UI组件', 'TrayControl.FSTray'),
		isTrayShow = false,
		isMax = false,
		Data = {
			maxlog: '../log/maxlog.pur5'
		},
		HtaControl = (function(){
			var Ax = $('<object style="display:none;" classid="CLSID:8AC2C463-17EE-4AF8-9C45-449FB915B506"></object>').appendTo(document.body)[0];
			
			return {
				setPosition: function(Arg){
					Ax.SetWindowPos(Arg.left, Arg.top, Arg.width, Arg.height, 0);
				},
				show: function(){
					Ax.Show(1);
				},
				hide: function(){
					Ax.Show(0);
				}
			}
		})();
	if(!Ax) return false;
	
	var videos = (function(){//显示器
		var result = [];
		
		try{
			var swbemlocator = new ActiveXObject("wbemscripting.swbemlocator"),
				wmiservice = swbemlocator.ConnectServer('.');
			
			var items = new Enumerator(wmiservice.ExecQuery('Select * from Win32_DesktopMonitor',false,48)),
				item,
				lastVideo;	
			while(!items.atEnd()){
				var item = items.item();
				if(!item.ScreenWidth || !item.ScreenHeight){
					items.moveNext();
					continue;
				}

				result.push({
					left: item.ScreenLeft,
					top: item.ScreenTop,
					width: item.ScreenWidth,
					height: item.ScreenHeight 
				});
				items.moveNext();
			}
			swbemlocator = wmiservice = null;
			CollectGarbage();
		}catch(e){}
		
		if(result.length == 0){
			result = [{
				left: screen.availLeft,
				top: screen.availTop,
				width: screen.availWidth,
				height: screen.availHeight
			}];			
		}
				
		return result;
	})(),
	getScreen = function(){
		var screenIndex = 0,
			windowScreenLeft = window.screenLeft;
			try{
				windowScreenLeft = event.screenX;
			}catch(e){}
		var left = 0;
		$.each(videos, function(index, video){
			if(windowScreenLeft >= video.width && videos[index+1]){
				screenIndex = index + 1;
				left += video.width;
			}
		});
		if(screenIndex == 0){
			videos[screenIndex].height = screen.availHeight;
			videos[screenIndex].width = screen.availWidth;
		}
		return $.extend(videos[screenIndex],{
			left: left
		});
	};
	
	return {
		getScreen: getScreen,
		setTrayTitle: function(title){
			Ax.setName2('商为开店软件', title);
		},
		HtaControl: HtaControl,
		show: function(){
			HtaControl.show();
			this.hideTray();
		},
		hide: function(){
			Ax.show(0);
		},
		mini: function(){
			var miniObj = $('#winMinimizeActive');
			if(!miniObj.length){
				miniObj = $('<object id="winMinimizeActive" type="application/x-oleobject" classid="clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11"\
							style="display:none;"><param name="Command" value="MINIMIZE"></object>').appendTo(document.body);
			}
			try{
				miniObj[0].Click();
			}catch(e){}
		},
		loginSuccess: function(){
			if(Fso.read(Data.maxlog) == '1'){
				this.forceMax();
			}
		},
		max: function(force){
			var vScreen = getScreen();
			var maxLayout = $('#main'),
				maxSize = maxLayout.attr('size');
			if(maxSize){
				Fso.del(Data.maxlog);
				maxSize = maxSize.split(',');
				this.resizeTo(parseInt(maxSize[0])+2, parseInt(maxSize[1])+2);
				$('#main').css({
					'border-width': 1,
					width: maxSize[0],
					height: maxSize[1]
				});
				this.setDragArea(0, 0, maxSize[0], 34);
				maxLayout.removeAttr('size');			
			}else{
				var width = vScreen.width,
					height = vScreen.height;
				this.resizeTo(width, height);
				$('#main')
				.attr('size', (maxLayout.width()) + ',' + (maxLayout.height()))
				.css({
					'border-width': 0,
					width: width,
					height: height
				});
				this.setDragArea(false);
				Fso.write(Data.maxlog, '1');
			}
			isMax = !isMax;
			
			Dwd.maxStatusChange(isMax);
		},
		forceMax: function(){
			if(!isMax){
				this.max();
			}
		},
		miniToTray: function(){
			this.showTray();
			this.hide();
		},
		showTray: function(msg){
			if(!msg && isTrayShow) return false;
			Ax.SetTipAndImage2(msg, 'images/1.ico');
			isTrayShow = true;
		},
		hideTray: function(){
			Ax.Clear();
			isTrayShow = false;
		},
		frameTo: function(url, queryString){
			if(!/^http:\/\//.test(url)) url = User.makeFullPath(url);
			
			if(!/\?/.test(url)) url += '?';
			url += '&_=' + Dwd.startTime;
			url += '&token=' + User.getToken();
			if(queryString){
				url += '&' + queryString;
			}
			
			var F = $('#frame iframe').css({
				visibility: 'hidden'
			});			
			if(!F.length){
				var iframe = document.createElement('iframe');
				iframe.application = 'yes';
				iframe.frameborder = '0';
				$('#frame').append(iframe);
				F = $('#frame iframe');
				F.load(function(){
					F.css({
						visibility: 'visible'
					});
				});
			}
			F[0].contentWindow.document.location.href=(url);
		},
		getPosition: function(width, height, flag){
			width = parseInt(width),
			height = parseInt(height);
			
			var Screen = getScreen(),
				center = (Screen.width - width)/2 + Screen.left,
				middle = (Screen.height - height)/2,
				right = (Screen.width - width) + Screen.left,
				bottom = Screen.height - height,
				left = Screen.left,
				top = 0,
				positionHash = {
					'1': [left, top],
					'2': [center, top],
					'3': [right, top],
					'4': [left, middle],
					'5': [center, middle],
					'6': [right, middle],
					'7': [left, bottom],
					'8': [center, bottom],
					'9': [right, bottom],
					'10': [left, bottom + height],
					'11': [center, bottom + height],
					'12': [right, bottom + height]					
				},
				
				position = positionHash[flag || 9];
				
			return {
				left: position[0],
				top: position[1],
				position: positionHash
			};
		},
		pop: function(arg){
			var arg = $.extend(true, {
				messageHash: Dwd.startTime,
				tag: '',
				title: false,
				content: '内容',
				position: 9,
				width: 200,
				height: 150,
				arg: {
					token: User.getToken()
				}
			}, arg);
			$.extend(arg, this.getPosition(arg.width, arg.height, arg.position));
			
			Fso.writeUtf8(Dwd.startPath + 'pop-temp.html', Fso.readUtf8(top.Dwd.startPath + 'pop.html').replace(/swkd3p44op_name/, 'swkd3p44op_' + arg.tag))
			Fso.write('../log/pop.pur5', $.stringify(arg));
			Fso.exec('"'+Dwd.startPath + 'host32.exe" "' + Dwd.startPath + 'pop-temp.html?messageHash=' + arg.messageHash+'"');
		},
		openIE: function(url){
			var iePath = (Fso.getSystemFolder(42) || 'C:\\Program Files') + '\\Internet Explorer\\IEXPLORE.EXE';
			top.Fso.exec('"' + iePath + '" "' + (url || '') + '"');
		},
		layoutTo: function(layout){
			var $layout = $(layout);
			$layout.show().siblings().hide();
			this.resizeTo($layout.outerWidth(), $layout.outerHeight());
			this.setDragArea(0, 0, 1000, 34);
		},
		resizeTo: function(width, height, isNotCenter){
			var vScreen = getScreen();
			try{
				resizeTo(width, height);
				if(!isNotCenter) moveTo((vScreen.width - width) / 2 + vScreen.left, (vScreen.height - height) / 2);			
			}catch(e){}
		},
		setDragArea: function(left, top, width, height){//设置拖动区域
			if(left === false){
				Ax.SetMoveRegion(0, 0, 0, 0);
			}else{
				Ax.SetMoveRegion(left, top, width, height);
			}
			Ax.EnableMove(1);
		},		
		clearPop: function(){
			Ax.ClearMessage();
		},
		play: function(wavPath){
			Ax.PlayWav(wavPath);
		}
	}
})();