var FileBrowser = (function(){
	var Ax;
	try{
		Ax = new ActiveXObject("FileBrowser.FBrowser");
	}catch(e){
		alert('FileBrowser创建失败');
		return false;
	}
	
	return {
		getFileName: function(path){
			return path.match(/[\\\/]([^\\\/]+?(\.\w+)?)$/)[1];
		},
		getFileExtName: function(path){
			return path.match(/\.(\w+)$/)[1];
		},
		getAllFiles: function(path){
			return Ax.GetAllFiles(path);
		},
		getTempFolder: function(){
			return Ax.GetTempFolder();
		},
		getAppDataFolder: function(){
			return Ax.GetAppDataFolder();
		}
	}
})();