var Model = (function(){
	var loadedModels = [],
		typeReg = /<div[\s\S]+?class="(\w+)"/,
		typeHash = {
			layout_content_in: '.layout_content',
			pur5_mask_show: '#pur5LayoutMain'
		};

	return {
		load: function(modelName, container){
			if($.inArray(modelName, loadedModels) > -1) return false;
			
			var modelContent = Fso.readUtf8('model/' + modelName + '/html.html')
								.replace(/id="/, 'modelpath="$modelPath" id="')
								.replace(/src="script\/main\.js"/, 'src="$modelPathscript/main.js"')
								.replace(/href="style\/css\.css"/, 'href="$modelPathstyle/css.css"')
								.replace(/\$modelPath/gi,'model/' + modelName + '/'),
				contentId = modelContent.match(/id="([^"]+)"/);

			(container || $(typeHash[modelContent.match(typeReg)[1]])).append(modelContent);
			if(contentId && contentId[1]) $('#'+contentId[1]).pur5UI();

			loadedModels.push(modelName);
		},
		loads: function(modelNameArr, container){
			var index = 0, modelName;
			while(modelName = modelNameArr[index++]){
				this.load(modelName, container);
			}
		}
	};
})();