$.ajaxSetup({
	crossDomain: false,
	timeout: 10000
});

window.onerror = function(){
	if(arguments[0].match(/已释放/)) return true;
}

var Dwd = (function(){
	return {
		startTime: new Date().getTime(),
		startPath: decodeURI(document.location.href.replace(/\/[^\/]+$/,'/').replace('file:///', '')),
		version: '',
		host: '',
		init: function(){
			var self = this;
			var container = $('.container');
			
			Ui.setTrayTitle('第五代');
			if($('#titletr').is(":visible")){
				Ui.setDragArea(0, 0, 2290, parseInt($('#titletr').height()));
			}
			setTimeout(function(){
				$('#window_btn')
				.find('.return_btn,.max_btn').click(function(){
					Ui.max();
				}).end()
				.find('.mini_btn').click(function(){
					Ui.mini();
				}).end()
				.find('.mini_totray').click(function(){
					Ui.miniToTray();
				}).end()
				.find('.close_btn').click(function(){
					//Dwd.close();
					window.close();
				});
				
				$('.form-icon').dblclick(Dwd.close);
				
				$('#max_dbl_area').dblclick(function(){
					$('#window_btn').find('.max_btn').click();
				});
				
				$('.splash_close_btn').click(function(){
					window.close();
				});
				
				self.version = (function(){
					try{
						return Fso.read('version.pur5').match(/version=([^#]+)#/)[1];
					}catch(e){
						return '';
					}	
				}())
				$('.version').html(Dwd.version);
				
				$('#main').bind("resize", function(){
					$('.main').height($(window).height() - 139);
				});
				
				$('.shopChange-btn').click(function(){
					Shop.change(function(){
						try{
							var refreshShopInfo = $('#frame iframe').get(0).contentWindow.refreshShopInfo;
							if(refreshShopInfo){
								refreshShopInfo();
							}else{
								$('#frame iframe').get(0).contentWindow.location.reload();
							}
						}catch(e){}
					});
				});				
			}, 10);
		},
		maxStatusChange: function(isMax){
			if(isMax){
				$('.return_btn').parent().show();
				$('.max_btn').parent().hide();
			}else{
				$('.return_btn').parent().hide();
				$('.max_btn').parent().show();
			}
		},
		setShopId: function(shopId){
			this.shopId = shopId;
		},
		makeFullPath: function(path){
			return str_replace('http://{1}/{2}', this.host, path);
		},
		interface: function(name, url, data, cb){
			superAjax({
				url: this.makeFullPath('interface/' + url),
				type: 'post',
				dataType: 'json',
				data: $.extend({}, data, {
					token: User.getToken()
				}),
				success: function(result, textStatus, jqXhr){
					if(result){
						result.message?cb(false, name + '出错：' + result.message, result):cb(result);
					}else{
						cb(false, ajaxError(name, jqXhr, textStatus));
					}
				},
				error: function(jqXhr, textStatus){
					cb(false, ajaxError(name, jqXhr, textStatus), false);
				}
			});
		},
		loadAx: function(axName, axRegString){
			try{
				return new ActiveXObject(axRegString);
			}catch(e){
				alert(axName + ' 加载失败');
				return false;
			}
		},
		close: function(){
			window.close();
		},
		alert: function(layout, noAnimate){
			var noAnimate = true;
			var $doc = $(document);
			$('#fitDialog_shadow').css({
				opacity: 0.1
			}).show().focus();
			$('#fitDialog-shadow-cover').css({
				opacity: 0.4
			}).show();
			
			if(noAnimate){
				layout.css({
					'margin-top': 0-layout.height()/2-1,
					'margin-left': 0-layout.outerWidth()/2,
					display: ''
				});
			}else{
				layout.css({
					'margin-top': 0,
					'margin-left': 0-layout.outerWidth()/2,
					display: ''
				}).animate({
					'margin-top': 0-layout.height()/2-1
				}, 'fast');
			}
		},
		loginSuccess: function(){
			Notice.init();
			Tb.Api.setData({
				redirectHost: this.host
			});
			Ui.setTrayTitle('商为开店软件');
			Ui.layoutTo('#main');
			$('#main').trigger('resize');
			Ui.setDragArea(0, 0, 1000, 34);
			$('#menu li:first').click();
			Ui.loginSuccess();
		},
		startTbDesigner: function(){
			var hasInstallPur5Designer = Fso.read(Fso.getAppDataFolder('AppData') + '\\pur5Desion.ini'),
				installPath;
				
			try{
				installPath = hasInstallPur5Designer.match(/installDir=(.+)/)[1].replace(/\s+$/,'');
			}catch(e){}
			
			if(installPath && Fso.fileExists(installPath)){
				Fso.exec(installPath);
			}else{
				Dialog.alert({
					content: joinWithTag(['您需要安装新版淘宝自动装修软件，并在安装后手动启动一次，然后才能从这里启动它。',
						'下载地址：<a href="http://www.diwudai.com/url.asp?tag=softdown13" class="redfont" target="_blank">http://www.diwudai.com/url.asp?tag=softdown13</a>'
					], '', '<br />')
				});
			}			
		}	
	}
})();

$(function(){
	setTimeout(function(){
		$.include('scripts/', [
			'inc/function.js',
			'inc/jquery.stringify.js',
			'inc/dwd.ui.js',
			'inc/message.js'
		], function(){
			Dwd.init();
		});
	},0);
});