/**
 @description 第五代自动充值软件 V3.0
 @requires base.js
 @author by (www.pur5.com)
 @version 3.0
 @revisions
  Date          Description
  2011-03-14    创建
*/



/**
 * 全局命名空间
 */
var pur5 = {};

/**
 * 全局配置项
 */
pur5.Cfg = {
	startPath: decodeURI(document.location.href.replace(/\/[^\/]+$/, '/').replace('file:///', '')),
	version: '', //客户端软件版本号
	sBeginText: 'BEGINPUR5IP',
	startTime: Number(new Date()),
	sEndText: 'ENDPUR5IP',
	menu: null, //页面主菜单
	err: {}, //错误跟踪对象标记集合，成员使用mark1、mark2等标记
	CheckSvrStartTime: 0, //登录前选择服务器检查用的用于比较时间的临时变量
	GBHOST: '', //平台登录后所连接的服务器ip
	loginedHostName: '',
	GBHOSTSOFT: '', //平台登录后所连接的服务器项目目录
	GBTIMEOUT: 10000, //平台登录超时
	LoginFsoFileOld: 'controls/Pur5.pur5', //平台登录前选择"保存密码"后，信息所保存在的文件
	token: '', //平台登录后的token
	GBCode: '', //平台登录后的GBCode                            
	GBPUR5LOG: false, //平台登录状态
	pur5Uid: '', //平台uid
	pur5PassWord: '', //平台登录密码
	pur5PassWordKey: '', //平台交易密码输入正确后得到的key每次监控时带上
	userType: '', //平台用户类型
	selSerInterval: null, //平台登录前选择服务器倒计时
	Ds: null, //系统淘宝抓单方式对接控件
	DsAPI: null, //系统淘宝API方式对接控件
	FSTray: null, //系统FSTray控件
	pur5Ax: null //系统Fso文件操作控件
};

//$.fn.extend({
//	toggleFieldset: function(){
//		$(this).find('.toggleBtn').click(function(){
//			var content = $(this).parents('legend').next();
//			if(content.is(':visible')){
//				content.hide();
//			}else{
//				content.show();
//			}
//		}).css({
//			cursor: 'pointer'
//		})
//	}
//});
//

/**
 * "工具级"方法的统一命名空间。本命名空间下的成员名称以"小驼峰写法"命名，如：lowerCamelCase
 */
var pur5Tools = {
	//脚本模板引擎精简版
	tpl: function(str, data) {
		var fn = !/\W/.test(str) ? this.cache[str] = this.cache[str] || tmpl(document.getElementById(str).innerHTML) : new Function("obj",
			"var p=[];with(obj){p.push('" + str.replace(/[\r\t\n]/g, " ")
			.split("<%").join("\t")
			.replace(/((^|%>)[^\t]*)'/g, "$1\r")
			.replace(/\t=(.*?)%>/g, "',$1,'")
			.split("\t").join("');")
			.split("%>").join("p.push('")
			.split("\r").join("\\'") + "');}return p.join('');");
		return data ? fn(data) : fn;
	},
	rightShield: function(event) {
		var e = event || window.event,
			et = e.srcElement || e.target;
		if (document.selection.createRange().text.length && et.tagName != 'A') {
			return true;
		}
		if (et.tagName != 'INPUT' && et.tagName != 'TEXTAREA') {
			return false;
		}
	},
	isIE6: function() {
		return navigator.userAgent.indexOf("MSIE 6") > 0;
	}
};


var UI = (function() {
	try {
		var Ft = new ActiveXObject("TrayControl.FSTray"),
			isTrayShow = false;
	} catch (e) {
		alert('UI组件创建失败，请重新注册');
		return false;
	}

	$(window).bind('unload', function() {
		Ft.Clear();
		//Ft.ClearMessage();
		Ft = null;
		CollectGarbage();
	});

	var HtaControl = (function(){
		var Ax;
		$(function(){
			Ax = $('<object style="display:none;" classid="CLSID:8AC2C463-17EE-4AF8-9C45-449FB915B506"></object>').appendTo(document.body)[0];
		});
		
		return {
			setPosition: function(Arg){
				Ax.SetWindowPos(Arg.left, Arg.top, Arg.width, Arg.height, 0);
			},
			show: function(){
				Ax.Show(1);
			},
			hide: function(){
				Ax.Show(0);
			}
		}
	})(),
	videos = (function(){//显示器
		var result = [];
		
		try{
			var swbemlocator = new ActiveXObject("wbemscripting.swbemlocator"),
				wmiservice = swbemlocator.ConnectServer('.');
			
			var items = new Enumerator(wmiservice.ExecQuery('Select * from Win32_DesktopMonitor',false,48)),
				item,
				lastVideo;	
			while(!items.atEnd()){
				var item = items.item();
				if(!item.ScreenWidth || !item.ScreenHeight){
					items.moveNext();
					continue;
				}

				result.push({
					left: item.ScreenLeft,
					top: item.ScreenTop,
					width: item.ScreenWidth,
					height: item.ScreenHeight 
				});
				items.moveNext();
			}
			swbemlocator = wmiservice = null;
			CollectGarbage();
		}catch(e){}
		
		if(result.length == 0){
			result = [{
				left: screen.availLeft,
				top: screen.availTop,
				width: screen.availWidth,
				height: screen.availHeight
			}];			
		}
				
		return result;
	})(),
	getScreen = function(){
		var screenIndex = 0,
			windowScreenLeft = window.screenLeft;
			try{
				windowScreenLeft = event.screenX;
			}catch(e){}
		var left = 0;
		$.each(videos, function(index, video){
			if(windowScreenLeft >= video.width && videos[index+1]){
				screenIndex = index + 1;
				left += video.width;
			}
		});
		if(screenIndex == 0){
			videos[screenIndex].height = screen.availHeight;
			videos[screenIndex].width = screen.availWidth;
		}
		return $.extend(videos[screenIndex],{
			left: left
		});
	};

	return {
		mini: function() { //最小化
			var miniObj = $('#winMinimizeActive');
			if (!miniObj.length) {
				miniObj = $('<object id="winMinimizeActive" type="application/x-oleobject" classid="clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11" style="display:none;"><param name="Command" value="MINIMIZE"></object>').appendTo(document.body);
			}
			try {
				miniObj[0].Click();
			} catch (e) {}
		},
		miniToTray: function() { //最小化到托盘
			this.showTray();
			this.hide();
		},
		hideTray: function() { //隐藏托盘
			Ft.Clear();
			isTrayShow = false;
		},
		showTray: function(msg) { //显示托盘 msg = false
			if (!msg && isTrayShow) return false;

			Ft.SetTipAndImage2(msg, 'images/1.ico');
			isTrayShow = true;
		},
		hide: function() { //隐藏主界面
			HtaControl.hide();
		},
		show: function() { //显示主界面
			HtaControl.show();
			this.hideTray();
		},
		changeIcon: function(iconPath) { //改变托盘图标
			Ft.ChangeIcon(iconPath);
		},
		chageIconAnimate: function(config) {
			var Config = {
				Icons: [
					'images/1.ico',
					'images/2.ico']
			};
			$.extend(Config, config);

			var n = 0,
				index = 0;

			var U = this,
				isTrayShowBefore = isTraySSho

				UI.showTray(); //显示托盘 以使图标变换可见
			(function() {
				if (n > 10) {
					UI.changeIcon('images/1.ico');
					if (!isTrayShowBefore) U.hideTray();
					return false;
				}
				UI.changeIcon(Config.Icons[index++]);
				if (index >= Config.Icons.length) index = 0;
				n++;
				setTimeout(arguments.callee, 400);
			})();
		},
		getPosition: function(width, height, flag){
			width = parseInt(width),
			height = parseInt(height);
			
			var Screen = getScreen(),
				center = (Screen.width - width)/2 + Screen.left,
				middle = (Screen.height - height)/2,
				right = (Screen.width - width) + Screen.left,
				bottom = Screen.height - height,
				left = Screen.left,
				top = 0,
				positionHash = {
					'1': [left, top],
					'2': [center, top],
					'3': [right, top],
					'4': [left, middle],
					'5': [center, middle],
					'6': [right, middle],
					'7': [left, bottom],
					'8': [center, bottom],
					'9': [right, bottom],
					'10': [left, bottom + height],
					'11': [center, bottom + height],
					'12': [right, bottom + height]					
				},
				
				position = positionHash[flag || 5];
				
			return {
				left: position[0],
				top: position[1],
				position: positionHash
			};
		},
		popup: function(arg, ignoreSetting){
			MsgBox.insert(arg.content.replace(/<[^>]+>/g,''));

			var popStatus = Fso.read(pur5.Cfg.sysPopFile);
			if (!ignoreSetting && popStatus != '1') {
				return false;
			}

			Message.pop(arg);
		},
		openIE: function(url){
			var iePath = (Fso.getSystemFolder(42) || 'C:\\Program Files') + '\\Internet Explorer\\IEXPLORE.EXE';
			top.Fso.exec('"' + iePath + '" "' + (url || '') + '"');
		},
		setTrayTitle: function(str) { //设置鼠标指向托盘时的提示文字
			Ft.setName2('第五代', str);
		},
		pop: function(msg, ignoreSetting) { //桌面右下角弹出消息
			if (!msg || /^\s*<[\S\s]+>\s*$/.test(msg)) { //抓到HTML代码
				return false;
			}

			if (/^\s*<script>[\S\s]+?<\/script>\s*$/.test(msg)) { //收到超时或其它需要执行脚本的消息消息
				return false; //直接返回
			}

			if (typeof(MsgBox) != 'undefined') {
				MsgBox.insert(msg);
			}

			var popStatus = Fso.read(pur5.Cfg.sysPopFile);
			if (!ignoreSetting && popStatus != '1') {
				return false;
			}

			var isTrayShowBefore = isTrayShow;
			this.showTray(msg);
			if (!isTrayShowBefore) this.hideTray();
		},
		popFlash: function(flashPath, haveTo) {
			var self = this;
			$.ajax({
				url: flashPath,
				_: pur5.Cfg.CheckSvrStartTime,
				success: function(data) {
					if (!data.match(/<\!\-\-diwudai\.com\-\->/)) return false;
					self.pop(flashPath, haveTo);
				}
			});
		},
		clearPop: function() { //清除桌面右下角的弹出消息
			Ft.ClearMessage();
		},
		play: function(wavPath) { //播放wav音频
			//			var popStatus = pur5.Pages.getFso(pur5.Cfg.sysPopFile);
			//			if(popStatus != '1'){
			//				return false;
			//			}
			Ft.PlayWav(wavPath);
		},
		movable: function() { //界面可拖动
			Ft.EnableMove(1);
		},
		immovable: function() { //界面不可拖动
			Ft.EnableMove(0);
		},
		setMoveRegion: function(left, top, width, height) { //设计拖动区域
			Ft.SetMoveRegion(left, top, width, height);
			this.movable();
		},
		ContextMenu: [
			'官方网站',
			'在线帮助',
			'-',
			'退出'],
		setContextMenu: function(MenuArr) {

		},
		triggerContextMneu: function(menuText) {
			this.Method[menuText]();
		}
	}
})();


/**
 * "页面类级"的控件、组件统一命名空间。本命名空间下的成员名称以"大驼峰写法"命名，如：UpperCamelCase
 */
pur5.Class = {};


/**
 * "页面层级"的函数、方法统一命名空间。本命名空间下的成员名称以"小驼峰写法"命名，如：lowerCamelCase
 */
pur5.Pages = {};


/**
 * 扩展字符串去首尾空格方法
 */
String.prototype.trim = function() {
	var text = this.replace(/^\s+/, '');
	//将尾部单独处理，避开正则表达式处理尾部长空格的性能bug
	for (var i = text.length - 1; i >= 0; i--) {
		if (/\S/.test(text.charAt(i))) {
			text = text.substring(0, i + 1);
			break;
		}
	}
	return text;
}


/**
 * 扩展获取字符串指定范围的方法
 * @param {String} sStart 范围开始关键字
 * @param {String} sEnd 范围结束关键字
 * @param {Boolean} bIncludeSpliter 是否包括开始与结束关键字
 */
String.prototype.between = function(sStart, sEnd, bIncludeSpliter) {
	if (this.indexOf(sStart) == -1 || this.indexOf(sStart) == -1) {
		return '';
	}
	return this != '' ? this.replace(/[\n\r]+/gm, '').replace(new RegExp('.*(' + sStart + ')(.*?)(' + sEnd + ').*'), bIncludeSpliter ? '$1$2$3' : '$2') : '';
}


/**
 * 扩展带逗号字符串的格式化方法
 */
String.prototype.formatComma = function() {
	return this.replace(/，/gi, ',').replace(/\s/gi, '').replace(/\,\,/gi, '').replace(/^\,|\,$/gi, '');
}


/**
 * 扩展字符串的格式化方法，把html代码里的表单元素组成键值对返回hash对象
 */
String.prototype.getUrlHash = function() {
	var str = this.replace(/[\r\n]/g, ''),
		aItems = [],
		aTemp = [],
		oHash = {};
	aItems = str.match(/<\s*input[^>]*?>|<\s*textarea[^>]*?>.*?<\/\s*textarea\s*>|<\s*select[^>]*?>.*?<\/\s*select\s*>/gi);

	for (var i = 0, l = aItems.length; i < l; i++) {
		aTemp[0] = aItems[i].replace(/<.*name\s*=\s*('|"|\b)\s*(.*?)\s*\1.*>/i, '$2');
		if (aTemp[0] == aItems[i]) continue;
		if (/<\s*input/i.test(aItems[i]) && (/type\s*=\s*('|"|\b)(text)\1/i.test(aItems[i]) || /type\s*=\s*('|"|\b)(hidden)\1/i.test(aItems[i]))) {
			aTemp[1] = aItems[i].replace(/<.*value\s*=\s*('|"|\b)(.*?)\1.*>/i, '$2');
		} else {
			if (/<\s*textarea/i.test(aItems[i])) {
				aTemp[1] = aItems[i].replace(/<\s*textarea.*?>(.*?)<\/\s*textarea\s*>/i, '$1');
			} else if (/<\s*select/i.test(aItems[i])) {
				if (!/selected\s*/i.test(aItems[i])) {
					aTemp[1] = aItems[i].replace(/.*?<\s*option.*?value\s*=\s*('|"|\b)\s*(.*?)\s*\1.*>/i, '$2');
				} else {
					if (/<\s*option[^>]*?selected[^>]*?value/i.test(aItems[i])) {
						aTemp[1] = aItems[i].replace(/.*<\s*option[^>]*?selected[^>]*?value\s*=\s*('|"|\b)\s*(.*?)\s*\1.*>/i, '$2');
					} else if (/<\s*option[^>]*?value[^>]*?selected/i.test(aItems[i])) {
						aTemp[1] = aItems[i].replace(/.*<\s*option[^>]*?value\s*=\s*('|"|\b)\s*(.*?)\s*\1[^>]*?selected.*>/i, '$2');
					}
				}
			}
		}
		oHash[aTemp[0]] = aTemp[1] == aItems[i] ? '' : aTemp[1];
	}

	return oHash;
};


/**
 * 扩展获取字符串左半部分方法
 * @param {Number} nLen 获取长度
 */
String.prototype.left = function(nLen) {
	if (isNaN(nLen) || nLen == null) {
		nLen = this.length;
	} else {
		if (parseInt(nLen) < 0 || parseInt(nLen) > this.length) {
			nLen = this.length;
		}
	}
	return this.substr(0, nLen);
}


/**
 * 扩展获取字符串右半部分方法
 * @param {Number} nLen 获取长度
 */
String.prototype.right = function(nLen) {
	if (isNaN(nLen) || nLen == null) {
		nLen = this.length;
	} else {
		if (parseInt(nLen) < 0 || parseInt(nLen) > this.length) {
			nLen = this.length;
		}
	}
	return this.substring(this.length - nLen, this.length);
}


/**
 * 扩展字符串的编码转换方法
 */
String.prototype.$$ = function() {
	var str = this;
	str = str.replace(/.|\n/g, function(sHex) {
		window.EnCodeStr = '';
		window.sHex = sHex;
		window.execScript('window.EnCodeStr=Asc(window.sHex)', 'vbscript');
		if ((window.EnCodeStr >= 65 && window.EnCodeStr <= 90) || (window.EnCodeStr <= 122 && window.EnCodeStr >= 97) || (window.EnCodeStr <= 57 && window.EnCodeStr >= 48)) return sHex;
		if (window.EnCodeStr <= 127 && window.EnCodeStr >= 0) return escape(sHex);
		window.execScript('window.EnCodeStr=Hex(Asc(window.sHex))', 'vbscript');
		return window.EnCodeStr.replace(/../g, '%$&');
	});
	return str.replace(/\+/g, '%2B').replace('"', '%22').replace("'", '%27').replace('/', '%2F');
}


/**
 * 扩展字符串的Url格式化方法
 */
String.prototype.exEnUrl = function() {
	var x = this,
		y = '',
		z = '';
	x = x.split(/\&/);
	for (var i = 0; i < x.length; i++) {
		if (x[i].search("=") >= 0) {
			z = x[i].split("=");
			y = y + z[0] + "=" + z[1].$$() + "&";
		} else {
			y = y + x[i].$$() + "&";
		}
	}
	y = y.substring(0, y.length - 1);
	return y;
}


/**
 * 扩展字符串的encodeURIComponent格式化方法
 */
String.prototype.$$$ = function() {
	return encodeURIComponent(this);
}


/**
 * 扩展数组的push方法，只往数组最后追加一个之前数组没有的项
 * @param {Object} oItem 需要追加的项
 * @param {Object} nIndex 用作比较的二维数组索引号，非必填
 */
Array.prototype.$push = function(oItem, nIndex) {
	for (var i = 0, l = this.length; i < l; i++) {
		if (typeof(nIndex) != 'undefined') {
			if (this[i][nIndex] == oItem[nIndex]) return this;
		} else {
			if (this[i] == oItem) return this;
		}
	}
	return this.push(oItem);
}


/**
 * 主菜单类
 * @param {Object} oCfg 配置项
 */
pur5.Class.Menu = function(oCfg) {
	this.content = $('#' + oCfg.contentId);
	this.lis1 = $('#' + oCfg.contentId + ' > li');
	this.as1 = $('#' + oCfg.contentId + ' > li > a');
	this.lis2 = $('#' + oCfg.contentId + ' > li > ul > li');
	this.as2 = $('#' + oCfg.contentId + ' > li > ul > li > a');
	this.init();
}

pur5.Class.Menu.prototype = {
	/**
	 * 设置菜单某个级别的所有链接
	 * @param {Number} nLevel 级别
	 */
	setAllAs: function(nLevel) {
		var as = this['as' + nLevel];
		for (var i = 0, l = as.length; i < l; i++) {
			$(as[i]).removeClass('menulink_now');
		}
	},
	/**
	 * 设置顶级菜单事件
	 */
	eventLis1: function() {
		var lis1 = this.lis1,
			firstUl = {}, iframe = {}, that = this;
		for (var i = 0, l = lis1.length; i < l; i++) {
			$(lis1[i]).mouseover(function() {
				firstUl = $(this).find('ul:eq(0)'),
				iframe = $(this).find('iframe:eq(0)');
				if (firstUl && firstUl[0] && iframe) {
					firstUl.show(),
					iframe.css('height', firstUl[0].offsetHeight + 'px');
					iframe.show();
				}
			});
			$(lis1[i]).mouseout(function() {
				firstUl = $(this).find('ul:eq(0)'),
				iframe = $(this).find('iframe:eq(0)');
				if (firstUl && iframe) firstUl.hide(), iframe.hide();
			});

			if (!lis1[i].getElementsByTagName('ul')[0]) {
				$(lis1[i]).click(function() {
					that.setAllAs(1);
					$(this.getElementsByTagName('a')[0]).addClass('menulink_now');
				});
			}
		}
	},
	/**
	 * 设置子级菜单事件
	 * @param {Number} nLevel 级别
	 */
	eventLisClild: function(nLevel) {
		var as = this['as' + nLevel],
			that = this;
		for (var i = 0, l = as.length; i < l; i++) {
			$(as[i]).click(function() {
				if (this.className.indexOf('menulink') == -1) {
					if (!this.getAttribute('noRefTo')) {
						that.setAllAs(1);
						that.setAllAs(2);
						$(this.parentNode.parentNode.parentNode.firstChild).addClass('menulink_now');
						$(this).addClass('menulink_now');
					}
				}
			});
		}
	},
	init: function() {
		this.eventLis1();
		this.eventLisClild(2);
	}
}


/**
 * 调整窗口大小并移动到屏幕中央
 * @param {Number} nWidth 宽度
 * @param {Number} nHeight 高度
 * @param {Boolean} isNotMiddle 不需要设置到中央，true为不需要设置
 */
pur5.Pages.winResize = function(nWidth, nHeight, isNotMiddle) {
	try {
		resizeTo(nWidth, nHeight);
		if (!isNotMiddle) moveTo((screen.availWidth - nWidth) / 2, (screen.availHeight - nHeight) / 2);
	} catch (e) {
		//alert('系统不支持窗口尺寸调整！');
	}
}


/**
 * 获取硬件mac信息
 * @param {Boolean} bNeedTips 出错时是否弹出提示，默认不提示
 */
pur5.Pages.mac = function(bNeedTips) {
	try {
		var arr = pur5.Cfg.pur5Ax.Mac.replace(/-/g, ':').toUpperCase().split(':');
		for (var i = 0, l = arr.length; i < l; i++) {
			if (arr[i].length == 1) arr[i] = '0' + arr[i];
		}
		return arr.join(':');
	} catch (e) {
		if (bNeedTips) alert('无法获取您的硬件地址！');
		return '';
	}
}


/**
 * 精确获取小数点后n位
 * @param {Number} nNum 目标小数
 * @param {Number} nHowmany 需要精确到的小数点位数
 */
pur5.Pages.numberRound = function(nNum, nHowmany) {
	return /[\d]+/g.test(nHowmany) ? Math.round(nNum * Math.pow(10, nHowmany)) / Math.pow(10, nHowmany) : Math.round(nNum);
}


/**
 * 控制页面主显示区所有的"layout_content"隐藏
 */
pur5.Pages.hideLayoutContent = function() {
	$('.layout_content > .layout_content_in').hide();
}


/**
 * 页面主显示区切换函数
 * @param {String} sUrl URL地址
 */
pur5.Pages.iframeTo = function(sUrl, absolutely) {
	if (!/\?/.test(sUrl)) {
		sUrl += '?_=' + new Date().getTime();
	}

	if (!/token=/.test(sUrl)) {
		sUrl += '&token=' + (pur5.Cfg.token || '');
	}

	if (!/version=/.test(sUrl)) {
		sUrl += '&version=' + (pur5.Cfg.version);
	}

	pur5.Pages.hideLayoutContent();

	var iframeContent = $('#iframeContent')[0],
		oldIframe = iframeContent.firstChild,
		oldIframeWindow = oldIframe.contentWindow;
	iframeContent.style.display = 'inline';

	if (oldIframe) {
		try {
			oldIframe.src = 'about:blank';
			oldIframeWindow.document.write('');
			oldIframeWindow.document.clear();
			oldIframeWindow.close();
			iframeContent.removeChild(oldIframe);

			var iframe = document.createElement('iframe');
			//if(/^rechargeForShengPay\.asp/.test(sUrl)){
			iframe.application = 'yes';
			//}

			if (/(pay|searchtrade|orders|ordersCAgent|orderall)\.asp/.test(sUrl)) {
				//$(iframe).load(pur5.Pages.payFrameLoaded);
			}
			if (/profile\.asp/.test(sUrl)) {
				$(iframe).load(function() {
					pur5.Pages.profileOnLoad();
				});
			}
			$(iframe).load(function() {
				var Win = this.contentWindow,
					$Doc = $(Win.document);

				(function() { //更新token 20110810 xz
					var tokenReg = /token=(\w{32})/,
						token;
					if (tokenReg.test(Win.location.href)) {
						token = Win.location.href.match(tokenReg)[1];
						pur5.Cfg.token = token;
					}
				})();

				(function() { //忘记密码
					var UserLoginCheckGetPass = $Doc.find('#UserLoginCheckGetPass');
					if (!UserLoginCheckGetPass.length) return false;

					UserLoginCheckGetPass.click(function() {
						pur5.Pages.signOut();
						pur5.Pages.getCode();
						window.showModalDialog(pur5.Cfg.GBHOSTSOFT + 'forget/forget.asp', '', 'dialogWidth=400px;dialogHeight=300px');
					});
				})();

				(function() {
					try {
						var js = $Doc.find('#execjSOnClient').val();
						eval(js);
					} catch (e) {}
				})();
			});

			iframeContent.appendChild(iframe);
			iframe.src = ((/^http:/.test(sUrl) || absolutely) ? '' : pur5.Cfg.GBHOSTSOFT) + sUrl;
			iframe.frameborder = '0';
			iframe.className = 'iframegg';
			pur5.Pages.iframeCallBack(iframe.src);
			pur5.Pages.iframeReload();

			CollectGarbage();
			setTimeout(CollectGarbage, 25);
		} catch (e) {}
	}

	iframeContent = oldIframe = oldIframeWindow = iframe = null;
	return false;
}

/**
 * 页面主显示区iframe重加载
 */
pur5.Pages.iframeReload = function() {
	var iframeContent = $('#iframeContent')[0],
		oldIframe = iframeContent.firstChild,
		oldIframeWindow = oldIframe.contentWindow,
		oldIframeSrc = oldIframe.src,
		loadFn = function() {
			var oldIframeSrc = $('#iframeContent')[0].firstChild.src,
				newSrc = $('#iframeContent')[0].firstChild.contentWindow.location;
			if (newSrc != oldIframeSrc) {
				try {
					var iframe = document.createElement('iframe');
					iframe.src = newSrc;
					iframe.frameborder = '0';
					iframe.className = 'iframegg';
					iframeContent.appendChild(iframe);
					pur5.Pages.iframeCallBack(iframe.src);

					this.src = 'about:blank';
					oldIframeWindow.document.write('');
					oldIframeWindow.document.clear();
					//oldIframeWindow.close();
					CollectGarbage();
					setTimeout(CollectGarbage, 25);
					iframeContent.removeChild(this);

					$(iframe).load(loadFn);
				} catch (e) {}
			}
		};
	///暂时不启用
	///$(oldIframe).load(loadFn);
}


/**
 * 页面主显示区iframe加载之后回调
 * @param {String} sUrl URL地址
 */
pur5.Pages.iframeCallBack = function(sUrl) {
	var htaSwapId = execHtaCallBack = '';

	htaSwapId = sUrl.indexOf('htaSwapId') == -1 ? '' : sUrl.replace(/.*?\?.*?htaSwapId=(.*?)(&|$).*/i, '$1');
	execHtaCallBack = sUrl.indexOf('execHtaCallBack') == -1 ? '' : sUrl.replace(/.*?\?.*?execHtaCallBack=(.*?)(&|$).*/i, '$1');

	if (htaSwapId) {
		try {
			pur5.Pages.layoutTo(htaSwapId);
		} catch (e) {}
	}
	if (execHtaCallBack) {
		try {
			eval(execHtaCallBack)();
		} catch (e) {}
	}
}


/**
 * 页面主显示区切换函数
 * @param {String} sId 需要切换显示的class="layout_content_in"的div的id
 * @param {Function} fCallBack 显示完毕后运行回调函数
 */
pur5.Pages.layoutTo = function(sId, fCallBack) {
	pur5.Pages.hideLayoutContent();
	$('#' + sId).show();
	if (fCallBack) fCallBack();
}


/**
 * 页面主显示区手工控制显示
 * @param {String} sArg 顶部下拉菜单对应的id
 * @param {Number} nDelayTime 延迟显示时间
 */
pur5.Pages.layoutShow = function(sArg, nDelayTime) {
	if (!nDelayTime && !isNaN(nDelayTime)) {
		$('#' + sArg).click();
	} else {
		setTimeout(function() {
			$('#' + sArg).click();
		}, nDelayTime);
	}
}


/**
 * 时间格式转换函数
 * @param {String} sPattern 格式化的格式
 * @param {Date} dDate 时间
 */
pur5.Pages.getTime = function(sPattern, dDate) {
	var dateArr = (dDate || new Date()).toJson().split(/\s/),
		dateObj = {
			'0': dateArr.join(' '),
			'1': dateArr[0],
			'2': dateArr[1]
		};

	return dateObj[sPattern || '0'];
}

/**
 * 保存日志
 * @param {String} sType 日志类型 paipai/taobao
 * @param {String} sId sType所对应的用户id
 * @param {String} sMsg 日志信息
 */
pur5.Pages.saveLog = function(sType, sId, sMsg) { //保存日志
	var date = pur5.Pages.getTime('1', new Date()),
		hostName = $('#loginHost').text(),
		fileName = '../log/' + [date, hostName, pur5.Cfg.pur5Uid, sType, sId].join('-') + '.txt';

	pur5.Pages.appendFile(fileName, sMsg);
	//	var MaxLength = 10240,//10M
	//		date = pur5.Pages.getTime('1', new Date()),
	//		hostName = $('#loginHost').text(),
	//		folderPath = '../log/' + [date, hostName, pur5.Cfg.pur5Uid, sType, sId].join('-'),
	//		Folder,
	//		File,
	//		filePath,
	//		lastFile,
	//		lastFileName;
	//		
	//	(function(){//创建文件夹
	//		var folderArr = folderPath.split(/\//),
	//			folder;
	//		for(var i = 2; i <= folderArr.length; i++){
	//			folder = folderArr.slice(0,i).join('/');
	//			try{
	//				Folder = pur5.Cfg.Fso.GetFolder(folder);
	//			}catch(e){
	//				if(e.description == '路径未找到'){
	//					pur5.Cfg.Fso.CreateFolder(folder);
	//					Folder = pur5.Cfg.Fso.GetFolder(folder);
	//				}
	//			}
	//		}
	//	})();
	//		
	//	var fileList = new Enumerator(Folder.Files),
	//		fileListArr = [];
	//	for (; !fileList.atEnd(); fileList.moveNext()){ 
	//		fileListArr.push(fileList.item().Name);
	//	}
	//	fileListArr.sort();
	//	if(fileListArr.length === 0){
	//		fileName = '1.txt';
	//	}else{
	//		fileName = fileListArr[fileListArr.length - 1];
	//		lastFile =  pur5.Cfg.Fso.GetFile(Folder + '/' + fileName);
	//		var lastFileSize = Math.round(lastFile.size / 1024);
	//		if(lastFileSize > MaxLength){
	//			fileName = ''+(new Number(fileName.match(/^(\d+)/)[1]) + 1) + '.txt';
	//		}
	//	}
	//	
	//	filePath = Folder + '/' + fileName;
	//	
	//	try{
	//		pur5.Cfg.Fso.GetFile(filePath);
	//	}catch(e){
	//		if(e.description == '文件未找到'){
	//			pur5.Cfg.Fso.CreateTextFile(filePath);
	//		}
	//	}
	//	
	//	File = pur5.Cfg.Fso.OpenTextFile(filePath, 8);
	//	File.WriteLine(sMsg);
	//	File.Close();　
}


/**
 * 写FSO
 * @param {String} sFile 文件路径与文件名
 * @param {String} sMsg 登录日志信息
 * @param {Number} nType 写模式，0或空为不追加换行符；1为追加换行符。非必填项
 */
pur5.Pages.setFso = function(sFile, sMsg, nType) {
	try {
		pur5.Cfg.pur5Ax.Open(sFile, 0);
		if (sMsg != '') {
			if (!nType) {
				pur5.Cfg.pur5Ax.Write(sMsg);
			} else {
				pur5.Cfg.pur5Ax.WriteLine(sMsg);
			}
		}
		pur5.Cfg.pur5Ax.Close();
		if (sMsg == '') pur5.Cfg.pur5Ax.Delete(sFile);
	} catch (e) {}
}


/**
 * 读FSO
 * @param {String} sFile 文件路径与文件名
 * @param {Number} nType 读模式，0或空为不带换行符；1为带换行符。非必填项
 */
pur5.Pages.getFso = function(sFile, nType) {
	var s = '';
	try {
		pur5.Cfg.pur5Ax.Open(sFile, 1);
		if (!nType) {
			s = pur5.Cfg.pur5Ax.Read();
		} else {
			s = pur5.Cfg.pur5Ax.ReadLine();
		}
		pur5.Cfg.pur5Ax.Close();
	} catch (e) {}
	return s;
}


/**
 * 追加文件
 * @param {String} sFile 文件路径与文件名
 * @param {String} sMsg 文件内容
 */
pur5.Pages.appendFile = function(sFile, sMsg) {
	try {
		pur5.Cfg.pur5Ax.Open(sFile, 0);
		pur5.Cfg.pur5Ax.AppendLine(sMsg);
		pur5.Cfg.pur5Ax.Close();
	} catch (e) {}
}


/**
 * 统一浮出层提示
 * @param {Object} oDom 必选。需要提示的dom元素
 * @param {String} sMsg 必选。提示内容
 * @param {String} sHideEvent 可选。隐藏提示的事件名，默认或缺省为'blur'
 * @param {Function} fCallBack 可选。出来提示的同时运行的回调
 */
pur5.Pages.tips = function(oDom, sMsg, sHideEvent, fCallBack) {
	var doc = document,
		pur5Tips = doc.createElement('div');
	pur5Tips.className = 'pur5_pages_tips';
	pur5Tips.innerHTML = '<span></span><iframe frameborder="0"></iframe>';
	doc.body.appendChild(pur5Tips);
	var innerSpan = pur5Tips.getElementsByTagName('span')[0],
		innerIframe = pur5Tips.getElementsByTagName('iframe')[0],
		oOffset = $(oDom).offset(),
		oWidth = oDom.offsetWidth,
		oHeight = oDom.offsetHeight,
		oTop = oOffset.top,
		oLeft = oOffset.left;
	innerSpan.innerHTML = sMsg;
	pur5Tips.style.display = 'block';
	pur5Tips.style.top = oTop + oHeight + 1 + 'px';
	pur5Tips.style.left = oLeft + 'px';
	pur5Tips.style.width = innerIframe.style.width = innerSpan.offsetWidth + 'px';
	pur5Tips.style.height = innerIframe.style.height = innerSpan.offsetHeight + 'px';
	$(oDom)[sHideEvent || 'blur'](function() {
		innerSpan.innerHTML = '';
		pur5Tips.style.display = 'none';
	})
	if (fCallBack) fCallBack(pur5Tips);
}


/**
 * 统一弹出层提示
 * @param {Object} oDom 必选。弹出层容器
 * @param {Function} fCallBack 可选。出来提示的同时运行的回调
 */
pur5.Pages.alert = function(oDom, fCallBack) {
	var doc = document,
		pur5MaskShow = doc.createElement('div'),
		showIframe = doc.createElement('iframe'),
		ctrls = $(oDom).find('.pur5_mask_close'),
		bodyH = doc.documentElement.clientHeight || doc.body.clientHeight,
		scrollHeight = doc.documentElement.scrollHeight || doc.body.scrollHeight,
		scrollTop = doc.documentElement.scrollTop || doc.body.scrollTop;
	pur5MaskShow.className = 'pur5_mask_show_bg';
	pur5MaskShow.style.height = scrollHeight + 'px';
	pur5MaskShow.style.display = showIframe.style.display = 'block';
	showIframe.className = 'pur5_mask_show_iframe';
	doc.body.appendChild(pur5MaskShow);
	doc.body.appendChild(showIframe);
	doc.documentElement.style.overflow = 'hidden';
	oDom.style.display = 'block';
	oDom.style.top = scrollTop + bodyH / 2 - oDom.offsetHeight / 2 + 'px';
	//showIframe.style.width = oDom.offsetWidth + 'px';
	//showIframe.style.height = oDom.offsetHeight + 'px';

	oDom.style.marginLeft = showIframe.style.marginLeft = -oDom.offsetWidth / 2 + 'px';

	for (var i = 0, l = ctrls.length; i < l; i++) {
		$(ctrls[i]).unbind('click');
		$(ctrls[i]).click(function() {
			$('.pur5_mask_show_bg, .pur5_mask_show, .pur5_mask_show_iframe').hide();
			doc.body.removeChild(pur5MaskShow);
			doc.body.removeChild(showIframe);
			doc.documentElement.style.overflow = '';
			oDom.style.top = '50%';
			oDom.style.display = 'none';
		});
	}
	//修正背景
	$(showIframe).css({
		
	});
	if (fCallBack) fCallBack();
}


/**
 * 设置状态栏平台余额和未买家未确认收货的金额
 */

pur5.Pages.profileOnLoad = function() {};
pur5.Pages.setUserMoney = function() {

	var oldfreezenMoneyContainer = $('#statusBarUserMoney2').attr('title', '未确认收货的金额'),
		floatFreezenMoneyContainer = $('<div><a href="#">淘宝：<span class="taobaoFreezenMoney">0.000</span></a><br/><a href="#">拍拍：<span class="paipaiFreezenMoney">0.000</span></a></div>').appendTo(document.body);

	floatFreezenMoneyContainer.mouseleave(function() {
		$(this).hide();
		return false;
	})
		.css({
		display: 'none',
		position: 'absolute',
		'background-color': '#f2f2f2',
		top: 535,
		padding: 5,
		border: '1px solid #666'
	})
		.find('a').css({
		color: '#333',
		height: '21px',
		'line-height': '21px',
		'text-decoration': 'none',
		cursor: 'default'
	})
		.find('span').addClass('redfont');

	oldfreezenMoneyContainer.mouseover(function() {
		floatFreezenMoneyContainer.css({
			left: oldfreezenMoneyContainer.offset().left
		}).show();
	});


	var fn = function() {
		var statusBarUserMoney = $('#statusBarUserMoney'),
			statusBarUserMoney2 = $('#statusBarUserMoney2'),
			Btn_RefreshUserMoney = $('#Btn_RefreshUserMoney'),
			statusBarUserMoneyLoading = $('#statusBarUserMoneyLoading'),
			statusBarUserMoneyLoading2 = $('#statusBarUserMoneyLoading2'),
			Tip1 = '第五代加款需要确认付款后才能由未确认资金转为正常可使用资金。';
		//Tip1 = 'http://www.pur5.com/flashpolo.html';

		statusBarUserMoney[0].style.visibility = 'hidden', statusBarUserMoneyLoading[0].style.visibility = 'visible';
		statusBarUserMoney2[0].style.visibility = 'hidden', statusBarUserMoneyLoading2[0].style.visibility = 'visible';
		$.get(pur5.Cfg.GBHOSTSOFT + 'GetM/returnM.asp', {
			token: pur5.Cfg.token,
			t1: pur5.Cfg.pur5Uid,
			version: '20121124'
		}, function(Money) {
			var lastMoney = 10,
				tip = [];

			Money.freezenMoneySum = Money.moneyTaobao + Money.moneyPaipai;
			if (Money.freezenMoneySum > 0) {
				tip.push((function() {
					var msg = '您的账户有' + Money.freezenMoneySum.toFixed(2) + '元冻结资金，';
					if (Money.moneyTaobao > 0) msg += '淘宝冻结金额' + Money.moneyTaobao.toFixed(2) + '元(<a title="去淘宝确认加款卡收货" href="#" onclick="javascript:Message.send(function(){UI.openIE(\'http://trade.taobao.com/trade/itemlist/list_bought_items.htm\')});">淘宝解冻</a>)，';
					 if (Money.moneyPaipai > 0) msg += '拍拍冻结金额' + Money.moneyPaipai.toFixed(2) + '元(<a title="去拍拍确认加款卡收货" href="#" onclick="javascript:Message.send(function(){UI.openIE(\'http://my.paipai.com/cgi-bin/trade_deal_list/boughtentry?isBuyLink=01\')});">拍拍解冻</a>)，';
					msg += '去相应网站确认收货，方可解冻。';

					return msg;
				})());
			}

			if (Money.money < lastMoney) {
				tip.push('您的账户余额已小于' + lastMoney + '元，为保证订单正常交易，请及时加款(<a title="" href="#" onclick="javascript:Message.send(function(){pur5.Pages.topMenuEvent($(\'#menuCZJK\'));UI.show();});">加款通道</a>)。');
			}

			tip.length && UI.popup({
				title: '余额提醒',
				tag: 'freezenMoney',
				height: 160,
				width: 250,
				position: 12,
				content: '<p>' + tip.join('<br />') + '</p>',
				arg: {
					showTime: 1000 * 60 * 2
				}
			});

			floatFreezenMoneyContainer.find('.taobaoFreezenMoney').text(Money.moneyTaobao.toFixed(2));
			floatFreezenMoneyContainer.find('.paipaiFreezenMoney').text(Money.moneyPaipai.toFixed(2));
			statusBarUserMoney.html(Money.money.toFixed(3));
			statusBarUserMoney2.html(Money.freezenMoneySum.toFixed(2));
		}, 'json');
		statusBarUserMoney[0].style.visibility = 'visible', statusBarUserMoneyLoading[0].style.visibility = 'hidden';
		statusBarUserMoney2[0].style.visibility = 'visible', statusBarUserMoneyLoading2[0].style.visibility = 'hidden';

		statusBarUserMoney.unbind('click')
			.click(function() {
			fn();
		});
		statusBarUserMoney2.unbind('click')
			.click(function() {
			fn();
		});

		Btn_RefreshUserMoney.unbind('click')
			.click(function() {
			fn();
		});
	};
	pur5.Pages.profileOnLoad = fn;
	fn();
	pur5.Cfg.sysUserMoneyInterval = setInterval(fn, pur5.Cfg.sysUserMoneyIntervalTime);
}


/**
 * 获取pur5.Cfg.GBCode
 */
pur5.Pages.getCode = function() {
	$.get(pur5.Cfg.GBHOSTSOFT + 'getCode.asp?' + (new Date()).getTime() + Math.random(), null, function(data) {
		pur5.Cfg.GBCode = data;
	})
}


/**
 * 设置主界面tab切换
 */
pur5.Pages.setIndexTab = function() {
	var indexTabArea = $('#indexTabArea'),
		indexNoticeCtrl = $('#indexNoticeCtrl'),
		indexNoticeMore = $('#indexNoticeMore'),
		indexPolicyCtrl = $('#indexPolicyCtrl'),
		indexNoticeList = $('#indexNoticeList'),
		indexPolicyMore = $('#indexPolicyMore'),
		indexPolicyList = $('#indexPolicyList');
	indexNoticeCtrl.click(function() {
		indexTabArea[0].className = 'index_tab_area';
		indexNoticeMore.show(),
		indexPolicyMore.hide(),
		indexNoticeList.show(),
		indexPolicyList.hide();
	});
	indexPolicyCtrl.click(function() {
		indexTabArea[0].className = 'index_tab_area2';
		indexNoticeMore.hide(),
		indexPolicyMore.show(),
		indexNoticeList.hide(),
		indexPolicyList.show();
	});
}


/**
 * 初始化"最小化到托盘"和"拖拽窗口"控件
 */
pur5.Pages.createTray = function() {
	try {
		pur5.Cfg.FSTray = new ActiveXObject("TrayControl.FSTray");
	} catch (e) {
		alert('FSTray组件创建失败，请重新注册！');
	}
	try {
		pur5.Cfg.pur5Ax = new ActiveXObject("pur5Util.pur5UtilAx.1");
	} catch (e) {
		alert('pur5UtilAx组件创建失败，请重新注册！');
	}
	try {
		//pur5.Cfg.Ds = new ActiveXObject('dsCookieGetter.ds');
	} catch (e) {
		alert('Ds组件创建失败，请重新注册！');
	}
}


/**
 * 设置主界面"气泡提示"
 */
pur5.Pages.setSysPop = function() {
	var menuQPTS = $('#menuQPTS'),
		menuQPTSParent = menuQPTS[0].parentNode,
		fnStart = function() {
			var popStatus = Fso.read(pur5.Cfg.sysPopFile);

			if (!popStatus) return;
			if (pur5.Cfg.sysPopInterval) clearInterval(pur5.Cfg.sysPopInterval);
			pur5.Cfg.sysPopInterval = setInterval(function() {
				$.get(pur5.Cfg.GBHOSTSOFT + 'pop.asp?token=' + pur5.Cfg.token, null, function(a) {
					if (a == '' || /^\s*<script>[\S\s]*<\/script>\s*$/.test(a)) return;
					//UI.pop(a);
					UI.popup({
						title: '消息提醒',
						tag: 'pop',
						content: a
					});
				});
			}, pur5.Cfg.sysPopIntervalTime);
			pur5.Cfg.sysPopSwitch = true;
		};
	if (!/(12|32|39)/.test(pur5.Cfg.userType)) {
		menuQPTSParent.style.display = 'none';
	} else {
		fnStart();
		menuQPTSParent.style.display = '';
		menuQPTS.unbind('click');
		menuQPTS.click(function() {
			if (!pur5.Cfg.sysPopSwitch) {
				Fso.write(pur5.Cfg.sysPopFile, '1');
				fnStart();
				alert('气泡提示功能已打开！');
			} else {
				clearInterval(pur5.Cfg.sysPopInterval);
				UI.hideTray();
				pur5.Cfg.sysPopSwitch = false;
				Fso.del(pur5.Cfg.sysPopFile);
				alert('气泡提示功能已关闭！');
			}
		});
	}
}


/**
 * 设置状态栏的"运行时长"
 */
pur5.Pages.statusBarRunTime = function() {
	var statusBarUserRunTime = $('#statusBarUserRunTime'),
		h = m = s = 0;
	pur5.Cfg.sysRunTimeInterval = setInterval(function() {
		if (s < 59) {
			s++;
		} else {
			s = 0;
			m++;
			if (m > 59) {
				m = 0;
				h++;
			}
		}
		statusBarUserRunTime.html((h < 10 ? '0' + h : h) + '时' + (m < 10 ? '0' + m : m) + '分' + (s < 10 ? '0' + s : s) + '秒');
	}, pur5.Cfg.sysRunTimeIntervalTime);
}


/**
 * 设置主界面菜单顶部链接事件
 * @param {Object} oDom 需要设置样式的dom元素
 */
pur5.Pages.topMenuEvent = function(oDom) {
	var content = $('#pur5TopMenuClick'),
		classN = 'menulink_now',
		imgs = content[0].getElementsByTagName('img'),
		pur5TopMenu = $('#pur5TopMenu'),
		menuLs = pur5TopMenu[0].getElementsByTagName('li');
	for (var i = 0, l = menuLs.length; i < l; i++) {
		$(menuLs[i].getElementsByTagName('a')[0]).removeClass(classN);
	}
	if (!oDom) return;
	oDom[0].click();
	$(oDom[0].parentNode.parentNode.parentNode.getElementsByTagName('a')[0]).addClass(classN);
	$(oDom[0]).addClass(classN);
}


/**
 * 设置主界面"供货状态"
 */
pur5.Pages.setIndexStatus = function(action) {
	if (/notice|all/.test(action)) {
		Pur5.get({
			action: 'getNotices',
			type: pur5.Pages.Version.type,
			subType: pur5.Pages.Version.subType || ''
		}, function(notices) {
			if (!notices) return false;
			var template = '<li iid="$id"><a href="#"><span class="times">$times</span>$title</a></li>',
				result = [];

			$.each(notices, function(id, note) {
				result.push(
				template.replace(/\$(\w+)/g, function(a, fieldName) {
					return note[fieldName];
				}));
			});
			$('#indexNoticeList').empty();
			setTimeout(function() {
				$('#indexNoticeList').html(result.join(''))
					.find('li a').click(function() {
					var note = $(this).parent();
					Dialog.alert({
						title: '<b>' + (pur5.Pages.Version.subType || '') + '公告' + '</b>',
						content: '<iframe width="450" height="330" scrolling="no" frameborder="0" src="' + Pur5.makeFullPath('notice/NoticeShow.asp?id=' + note.attr('iid') + '&token=' + Pur5.getToken()) + '"></iframe>'
					});
					return false;
				});
			}, 300);
		});
	}

	if (/status|all/.test(action)) {
		if (pur5.Pages.Version.type == 'fuzhuang') {
			Pur5.get({
				action: 'getMaterialLeftTop'
			}, function(msg) {
				$('#indexStatus').empty();
				setTimeout(function() {
					$('#tradeTitle').text(msg.title);
					$('#indexStatus').html(msg.html);
					return false;

					$('#indexStatus').html('<div class="marquee"><ul><li>' + msg.html + '</li></ul></div>')
						.find('.marquee')
						.each(function() {
						var self = $(this);
						self.parents('ul').attr('dis', self.parents('ul').css('display'))
							.css({
							'display': 'block',
							'visibility': 'hidden'
						});

						self.css({
							'overflow': 'hidden',
							'height': self.height() + 'px'
						})

						if (self.height() > self.parents('div').height()) {
							try {
								self.kxbdSuperMarquee({
									isMarquee: true,
									isEqual: false,
									scrollDelay: 100,
									direction: 'up'
								})
							} catch (e) {}
						}

						self.parents('ul')
							.css({
							'display': self.parents('ul').attr('dis'),
							'visibility': 'visible'
						});
					});

				}, 3e2);
			});
			/*			Pur5.get({
				action: 'getMaterialTrades',
				subType: pur5.Pages.Version.subType || ''
			}, function(trades){
				if(!trades) return false;
				var template = '$userid - $id - $times',
					result = [];
					
				$.each(trades, function(id, note){
					result.push(
						template.replace(/\$(\w+)/g, function(a, fieldName){
							return note[fieldName];
						})
					);
				});
				$('#indexStatus').empty();
				setTimeout(function(){
					$('#indexStatus').html('<div class="marquee"><ul><li>' + result.join('</li><li>') + '</li></ul></div>')
					.find('.marquee')
					.each(function(){
						var self = $(this);
						self.parents('ul').attr('dis', self.parents('ul').css('display'))
						.css({
							'display': 'block',
							'visibility': 'hidden'
						});
						
						self.css({
							'overflow': 'hidden',
							'height': self.height() + 'px'
						})
						
						if(self.height() > self.parents('div').height()){
							try{
								self.kxbdSuperMarquee({
									isMarquee: true,
									isEqual: false,
									scrollDelay: 100,
									direction:'up'
								})
							}catch(e){}
						}
						
						self.parents('ul')
						.css({
							'display': self.parents('ul').attr('dis'),
							'visibility': 'visible'
						});
					});					
				}, 300);
			});
*/
		} else {
			var indexStatus = $('#indexStatus');
			$.get(pur5.Cfg.GBHOSTSOFT + 'notice/NoticeForDefault.asp', {
				token: pur5.Cfg.token,
				type: pur5.Pages.Version.type,
				subType: pur5.Pages.Version.subType
			}, function(data) {
				if (data == '') return;
				try {
					var data = $.parseJSON(data),
						arrSupply = data.supplyStatus,
						Status = {
							'0': 'nor',
							'1': 'err',
							'2': 'nowd'
						},
						StatusArr = [];

					arrSupply.sort(function(a, b) { //按状态排序：正常-维护-不稳定
						return (a[1] < b[1]) ? 1 : -1;
					});

					for (var i = arrSupply.length; i--;) {
						StatusArr.push(
							'<li class="' + (Status[arrSupply[i][1]] || Status['2']) + '">' + arrSupply[i][0] + '</li>');
					}

					indexStatus.html('');
					setTimeout(function() {
						indexStatus.html(StatusArr.join(''));
					}, 300);
				} catch (e) {
					//alert('NoticeForDefault.asp返回的数据不合法');
				}
			});
		}
	}
}


/**
 * 注销登录
 */
pur5.Pages.signOut = function(cb) {
	if (!pur5.Cfg.token) return false;

	Fso.del(pur5.Cfg.LoginFsoFile);
	pur5.Pages.logout();
}

pur5.Pages.logout = function(cb) {
	if (!pur5.Cfg.token) return;
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'logout.asp',
		data: {
			token: pur5.Cfg.token
		},
		type: 'post',
		async: false,
		timeout: 3000,
		complete: function() {
			pur5.Cfg.token = null;
			if (cb) {
				cb();
			} else {
				history.go(0);
			}
		}
	});
}


$(function() {
	$('#loginBody .softVersion').after('&nbsp-&nbsp<span class="loginHost"></span>');
	pur5.Cfg.LoginFsoFile = '../log/dwd' + (/^chongzhi|fuzhuang$/.test(pur5.Pages.Version.type) ?
		'' : pur5.Pages.Version.type) + '.pur5';

	$('#rememberPass').click(function() {
		if (this.checked && !confirm('为了您的资金安全，请不要在公共电脑上记住密码。\n-----------------------\n您确定要记住密码吗？')) {
			this.checked = false;
		}
	});

	window.onbeforeunload = function() {
		pur5.Pages.logout();
	};

	pur5.Pages.switchToYJBD = function() {
		pur5.Pages.iframeTo('bindhard.asp');
	};

	(function() { //拍拍状态栏整理：去掉淘宝监控状态
		if (pur5.Pages.Version.type == 'paipai') {
			$('#statusBarMonitorTB').parent().parent().next().andSelf().remove();
			$('#statusBarUserType').parents('table').css({
				width: 'auto'
			});
		}
	})();

	(function() { //状态栏整理：保险箱
		$('#statusBarUserRunTime').parent()[0].childNodes(0).data = '运行：';

		var bandHTML = ' <span class="redfont" style\
			="text-decoration:underline;cursor:pointer;" id="autoMoneyFreezenSwitch" title="资金保险箱，点击设置">保险箱</span>';
		$('#statusBarUserMoney').after(bandHTML);

		$('#statusBarUserMoney').parents('td').css({
			'text-align': 'left',
			width: 165
		}).siblings().css({
			'text-align': 'center'
		});

		$('#statusBarUserMoney2').parents('td').css({
			'text-align': 'left'
		});
		$('#autoMoneyFreezenSwitch').click(function() {
			Dialog.superIframe({
				title: '资金保险箱',
				src: Pur5.makeFullPath('checkband.asp'),
				style: {
					width: 600,
					height: 430
				},
				button: {
					'确 定': 0
				}
			});
		});
	})();

	(function() { //新版登录控件
		$('[name=passID1]').parent().html('<object tabindex="2" id="Pur5EditAx"\
			classid="CLSID:B5BA7BDA-71B1-484A-A39D-C461252DA227" width="100%" height="21" style="width:240px;border:1px solid #ccc;"></object>');

		var Pur5EditAx = $('#Pur5EditAx')[0];
		Pur5EditAx.attachEvent('onenter', function(base64Pic) {
			$('#btnSysLogin').click();
		});

		$('[name=userID1]').css({
			height: 21
		}).keydown(function(e) {
			if (e.keyCode == 9) {
				Pur5EditAx.Focus();
				return false;
			}
		});

		$('[name=userID1]').css({
			'text-align': 'left'
		});
	})();

	(function(){
		$('#rememberPass').parents('td').next().after('<td>&nbsp;<a href="#;" class="yellowfont" style="text-decoration:underline;" onclick="window.showModalDialog(pur5.Cfg.GBHOSTSOFT + \'UserRegSerialNumber.asp\',\'\',\'dialogWidth=550px;dialogHeight=230px\');pur5.Pages.getCode();">激活码开户</a></td>');

		$('#menuXSRJ').parent().after('<li><a href="#;" hidefocus="true" id="menuJHM" onclick="pur5.Pages.iframeTo(\'UserSerialNumberList.asp?type=\'+pur5.Pages.Version.type+\'&token=\'+pur5.Cfg.token)">激活码</a></li>');

		 $('#menuCZJK').parent().after('<li><a href="#;" hidefocus="true" id="menuZJTX" onclick="pur5.Pages.iframeTo(\'paytx.asp?token=\'+pur5.Cfg.token)">资金提现</a></li>');
	})();

	try {
		pur5.Pages.Version.longName = pur5.Pages.Version.longName.replace('2012', '2013');
	} catch (e) {}

	$.include('scripts/', [
		'inc/fso.js'], function() {
		pur5.Cfg.version = (function() {
			try {
				return Fso.read('version.pur5').match(/version=([^#]+)#/)[1];
			} catch (e) {
				return '';
			}
		})();
		$('.softVersion').text(pur5.Cfg.version);
	});
	pur5.Pages.winResize(445, 291);

	$('.versionName').text(pur5.Pages.Version.name);
	$('.versionLongName').text(pur5.Pages.Version.longName);
	$('.softLogo').attr('title', pur5.Pages.Version.longName);

	try {
		//初始化"最小化到托盘"和"拖拽窗口"控件
		pur5.Pages.createTray();
		//登录窗口顶部拖拽类实例化
		UI.setMoveRegion(30, 0, 385, 28);
	} catch (e) {
		//alert('FSTray组件注册失败，请重新注册！');
		return false;
	}

	//屏蔽右键
	$(document.body).bind('contextmenu', pur5Tools.rightShield);

	$.include('scripts/', [
		'inc/module.js',
		'inc/fso.js',
		'inc/jquery.pur5.md5.js',
		'inc/jquery.stringify.js',
		'inc/function.js',
		'inc/pur5.encode.js',
		'inc/pur5.js',
		'inc/fitWindow.js',
		'inc/hra.js',
		'inc/miniBrowser.js',
		'inc/realyIEVersion.js',
		'inc/fileBrowser.js',
		'inc/snap.js',
		'inc/express.js',
		'taobao/taobao.user.js',
		'inc/message.js'], function() {
			Fso.del(pur5.Cfg.LoginFsoFileOld);
			Tb.User.appRoot = pur5.Cfg.startPath;
			pur5.Pages.selectServers();
			Model.loads(['sysClose']);
	});
});

pur5.Pages.windowOpenPur5Agreement = function() {
	try {
		window.open('../agreement/代理供货平台用户协议.html', '_blank', 'left=200,top=100,height=600,width=900,status=no,toolbar=no,menubar=no,location=no,scrollbars=yes,resizable=yes');
		return false;
	} catch (e) {
		return true;
	}
}

$.extend(pur5.Pages, {
	getServerVersion: function(cb) {
		var servers = Fso.read('version.pur5').match(/(http[^#]+)/g),
			index = 0;
		(function() {
			if (!servers[index]) {
				cb();
				return false;
			}
			var fn = arguments.callee,
				ajax = $.ajax({
					url: servers[index++] + '/version.asp',
					type: 'get',
					dataType: 'text',
					timeout: 5000,
					success: function(info) {
						var version = '',
							reg = /version=([\d\.]+)/;
						try {
							version = info.match(reg)[1];
						} catch (e) {}

						if (version) {
							cb(version);
							return false;
						} else {
							fn();
						}
					},
					error: function(jqXhr, textStatus) {
						ajax.abort();
						fn();
					}
				});
		})();
	}
});

pur5.Pages.selectServers = function() {
	window.clearInterval(pur5.Cfg.selSerInterval);
	pur5.Cfg.CheckServersTime = new Date().getTime();
	pur5.Pages.selectServersSuccess({
		'服务器1': '116.246.3.58',
		'服务器2': '112.65.249.180',
		'服务器3': '222.73.4.229:508',
		'服务器4': '116.246.3.58',
		'服务器5': '222.73.182.158',
		'服务器6': '117.135.131.115',
		'服务器7': '114.80.94.220',
		'服务器8': '116.246.3.58',
		'服务器9': '116.246.3.58'
	});
}

/**
 * 登录前选择服务器失败
 */
pur5.Pages.selectServersFail = function() {
	alert('网络链接错误，请确定本机已连接网络，且网速流畅。');
}


/**
 * 登录前选择服务器成功
 * @param {String} aData 请求返回的数据
 */
pur5.Pages.selectServersSuccess = function(aData) {

	(function() { //本地调试数据
		var debugInfo = Fso.read('debug.pur5');
		if (!debugInfo) return false;

		$.each(getFields({
			name: 1,
			ip: 2
		}, debugInfo, /ip:([^:]+):(\S+)/g), function(index, elem) {
			aData[elem.name] = elem.ip;
		});
	})();

	serverID.innerHTML = '';
	var i = 0,
		_html = '';
	for (name in aData) {
		_html += " <span style='display:block; float:left; width:130px; height:30px; cursor:hand;font-color:blue;text-decoration:underline;' onclick='clearInterval(pur5.Cfg.selSerInterval);document.all.usingSpan.innerText=this.innerText;pur5.Cfg.GBHOST=\"" + aData[name] + "\";$(\"#loginHost\").text($(this).find(\"span:first\").text());pur5.Cfg.loginedHostName=$(\"#loginHost\").text();pur5.Pages.refreshHostName();'> <span style='display:block; float:left; width:60px; height:100%;'>" + name + "</span><span id=time" + i + " style='display:block; width:60px; height:17px; float:left; border:1px solid #ccc; background:#fff;'>连接..</span><img width='0' id=img" + i + " height='0' onload='pur5.Pages.loadImgok(this, " + "\"" + aData[name] + "\",\"" + name + "\")' src='http://" + aData[name] + "/images/regbg2.gif?" + (new Date()).getTime() + Math.random() + "' style='float:left;' /></span>";
		if ((i + 1) % 3 == 0) _html += '<br />';
		i++;
	}
	pur5.Cfg.CheckSvrStartTime = new Date().getTime();
	serverID.innerHTML = _html;
}


/**
 * 登录前选择服务器时刷新服务器列表
 */
pur5.Pages.selectServersResets = function() {
	pur5.Cfg.GBHOST = '';
	document.all.usingSpan.innerText = '重试中...';
	serverID.innerHTML = '';
	document.all.GG0.innerHTML = '';
	pur5.Pages.selectServers();
}

pur5.Pages.refreshHostName = function(){
	$('#loginHost, .loginHost').text(pur5.Cfg.loginedHostName);
};

/**
 * 登录前选择服务器列表的图片加载完成
 * @param {Object} oDom 当前dom元素
 * @param {String} sIp ip
 * @param {String} sIpname ipname
 */
pur5.Pages.hasServerRetured = false;
pur5.Pages.loadImgok = function(oDom, sIp, sIpname) {
	var ip = sIp,
		ipname = sIpname,
		oDomPre = oDom.previousSibling,
		loginBody = $('#loginBody')[0];
	if (!pur5.Pages.hasServerRetured) {
		pur5.Pages.hasServerRetured = true;
	}

	if (pur5.Cfg.GBHOST == '' && loginBody.style.display != 'none') {
		pur5.Cfg.GBHOST = ip;
		var timeText = 3;
		$('#loginHost, .loginHost').text(ipname);
		pur5.Cfg.selSerInterval = setInterval(function() {
			document.all.usingSpan.innerText = ' ' + timeText--;
			if (timeText < 0) {
				document.all.usingSpan.innerText = ipname;
				clearInterval(pur5.Cfg.selSerInterval);
				if (loginBody.style.display != 'none') pur5.Pages.loginFillForm();
			}
		}, 1000);
	}
	var t = new Date();

	t = pur5.Pages.numberRound(((t.getTime() - pur5.Cfg.CheckSvrStartTime) / 1000), 2);

	var t2 = 100 * t + 10;
	if (t2 > 200) t2 = 200;

	if (t <= 1) {
		oDomPre.innerHTML = "<img src='images/zhuangtaai1.gif' align=absmiddle>" + (t < 0.5 ? "" : "<img src='images/zhuangtaai1.gif' align=absmiddle>");
	} else {
		if (t <= 2) {
			oDomPre.innerHTML = "<img src='images/zhuangtaai2.gif' align=absmiddle><img src='images/zhuangtaai2.gif' align=absmiddle><img src='images/zhuangtaai2.gif' align=absmiddle>" + (t < 1.7 ? "" : "<img src='images/zhuangtaai2.gif' align=absmiddle>");
		} else {
			oDomPre.innerHTML = "<img src='images/zhuangtaai4.gif' align=absmiddle><img src='images/zhuangtaai4.gif' align=absmiddle><img src='images/zhuangtaai4.gif' align=absmiddle><img src='images/zhuangtaai4.gif' align=absmiddle><img src='images/zhuangtaai4.gif' align=absmiddle>" + (t < 3 ? "" : "<img src='images/zhuangtaai4.gif' align=absmiddle>");
		}
	}
}


/**
 * 登录前选择服务器完成后进入输入帐号密码界面
 */
pur5.Pages.loginFillFormed = false;
pur5.Pages.loginFillForm = function() {
	if (pur5.Pages.loginFillFormed) return false;
	pur5.Pages.loginFillFormed = true;

	if (!pur5.Cfg.GBHOST) return;

	pur5.Cfg.GBHOSTSOFT = 'http://' + pur5.Cfg.GBHOST + '/pages/';

	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'getCode.asp?q=' + (new Date()).getTime() + Math.random(),
		type: 'GET',
		cache: false,
		success: function(data) {
			pur5.Cfg.GBCode = data;
			pur5.Pages.winResize(445, 282);
			$(logintable).css({
				height: 202
			});
			loginBody.style.background = 'url(images/' + pur5.Pages.Version.loginBg + ')';
			tablemain.style.display = 'none';
			logintable.style.display = '';

			$('#btnSysLogin')
				.mouseup(function() {
				pur5.Pages.login(this);
			});

			try {
				var LoginInfo = new Function('return ' + Fso.read(pur5.Cfg.LoginFsoFile))();
				if (LoginInfo.userName && LoginInfo.pwdEncode && LoginInfo.time) {
					$('#rememberPass').attr('checked', true);
					document.all.userID1.value = LoginInfo.userName;
					setTimeout(function() {
						try {
							$('#Pur5EditAx')[0].transform = true;
							$('#Pur5EditAx')[0].time = LoginInfo.time;
							$('#Pur5EditAx')[0].input = LoginInfo.pwdEncode;
						} catch (e) {
							alert('记住的密码已经过期，请重新输入！');
							$('#rememberPass').attr('checked', false);
							Fso.del(pur5.Cfg.LoginFsoFile);
						}
					}, 100);
				} else {
					throw new Error();
				}
			} catch (e) {
				$('#rememberPass').attr('checked', false);
				Fso.del(pur5.Cfg.LoginFsoFile);
			}
		},
		error: function() {
			alert('服务器连接失败，请刷新重试！');
		}
	});
}

/**
 * 平台登录
 * @param {Object} oDom 被点击dom对象
 * @param {Number} nRem 已经记过密码
 */

pur5.Pages.login = function(oDom, nRem) {
	if (oDom.getAttribute('disa') != 'disa') {
		oDom.setAttribute('disa', 'disa');

		if ($('#pur5Agreement').length && !$('#pur5Agreement').is(':checked')) {
			alert('请仔细阅读第五代相关协议');
			oDom.removeAttribute('disa');
			return false;
		}

		var Pur5EditAx = $('#Pur5EditAx')[0];
		Pur5EditAx.url = Pur5.makeFullPath('getCodeNew.asp?' + new Date().getTime());
		Pur5EditAx.Refresh();

		var Info = {
			pass: encodeURIComponent(Pur5EditAx.output),
			username: document.all.userID1.value,
			loginType: pur5.Pages.Version.type,
			version: pur5.Cfg.version,
			h: encodeURIComponent(Pur5EditAx.H1(0)),
			time: Pur5EditAx.time
		};

		if (Info.username == '' || Info.pass == '') {
			alert("请填写用户名以及密码！");
			oDom.removeAttribute('disa');
			return;
		}

		$.ajax({
			url: pur5.Cfg.GBHOSTSOFT + (pur5.Pages.Version.loginPath || 'login_do.asp?') + $.param({
				username: Info.username,
				loginType: Info.loginType,
				version: Info.version,
				time: Info.time
			}),
			type: 'post',
			dataType: 'json',
			cache: false,
			data: {
				pass: Info.pass,
				h: Info.h				
			},
			success: function(result) {
				if (!result || !result.user_login_response) {
					this.error();
					return;
				}

				result = result.user_login_response;

				try {
					if (result.fun) {
						result.fun = result.fun.replace(/^function\(\)\{|\}$/g, '');
						pur5.Pages.Version.startFunction = new Function(result.fun);
					}
				} catch (e) {}

				if (result.uid && result.token) {
					$.extend(pur5.Cfg, {
						token: result.token,
						GBPUR5LOG: true,
						pur5Uid: result.uid,
						//pur5PassWord: pass,
						userType: result.status,
						userTypeName: result.softname
					});

					if ($('#rememberPass').is(':checked')) {
						Fso.write(pur5.Cfg.LoginFsoFile, $.stringify({
							userName: Info.username,
							pwdEncode: Pur5EditAx.O1,
							time: Info.time
						}));
					} else {
						Fso.del(pur5.Cfg.LoginFsoFile);
					}

					pur5.Pages.loginSuccess();
				} else {
					pur5.Cfg.GBPUR5LOG = false;
					if (result.msg) {
						alert("登录失败:\n" + result.msg);
					}
					if (result.fun) {
						pur5.Pages.Version.startFunction();
					}
					oDom.removeAttribute('disa');
					return false;
				}
			},
			error: function(jqXhr, textStatus) {
				oDom.removeAttribute('disa');
				alert("服务器未返回数据或服务器出错，请重试！");
			}
		});
	}
}

/**
 * 平台登录成功后运行
 */
pur5.Pages.loginSuccess = function() {

	//平台登录进主界面后的回调
	pur5.Pages.loginSuccessCallBack();

	//进入主界面后窗体初始化设置
	pur5.Pages.sysWinSet();

	if (pur5.Pages.Version.type != 'meterial') {
		//设置左侧"供货状态"
		pur5.Pages.setIndexStatus('all');

		//设置状态栏"平台余额"
		pur5.Pages.setUserMoney();

		//主界面左侧"最新公告"和"官方政策"tab切换
		pur5.Pages.setIndexTab();

		//状态栏的"运行时长"
		pur5.Pages.statusBarRunTime();

		//设置主界面"气泡提示"
		pur5.Pages.setSysPop();
	}

	$.include('scripts/', [
		'inc/fso.js'], function() {
		$('.taobaoDesign').click(function() {
			var hasInstallPur5Designer = Fso.read(Fso.getAppDataFolder('AppData') + '\\Pur5Designer\\Pur5Designer.ini'),
				installPath;

			try {
				installPath = hasInstallPur5Designer.match(/installDir=(.+)/)[1].replace(/\s+$/, '');
			} catch (e) {}
			
			if(!installPath) {
				try {
					hasInstallPur5Designer = Fso.read(Fso.getAppDataFolder('AppData') + '\\pur5Desion.ini'),
					installPath = hasInstallPur5Designer.match(/installDir=(.+)/)[1].replace(/\s+$/, '');
				} catch(e) { }
			}

			if (installPath && Fso.fileExists(installPath)) {
				Fso.exec(installPath);
			} else {
				Dialog.alert({
					content: joinWithTag(['您需要安装新版淘宝自动装修软件，并在安装后手动启动一次，然后才能从这里启动它。',
						'下载地址：<a href="http://diwudai.com/url.asp?tag=softdown13" class="redfont" target="_blank">http://diwudai.com/url.asp?tag=softdown13</a>'], '', '<br />')
				});
			}
		});
	});

	FitWindow.open('第五代活动公告', 'http://www.diwudai.com/tab/index-' + pur5.Pages.Version.type + '.html?' + pur5.Cfg.startTime);
}

/*
 */
pur5.Pages.refreshBandStatus = function() {
	$.ajax({
		url: Pur5.makeFullPath('other/CheckbandMoney.asp')
	});
}

/**
 * 进入主界面后窗体初始化设置
 */
pur5.Pages.sysWinSet = function() {
	(function($) { //Hide Menu By UserType
		var Hash = {
			'10': { //终端版
				'menu': 'menuLXTG, menuPPLXTG, menuXSGL, menuGHSJ',
				'toolbar': 'menuXSRJ',
				'other': function() {
					//var statuBar = $('#statusBarUserType').parents('table').removeAttr('width');
					//$('#statusBarMonitorTB').parent().parent().prev().andSelf().remove();
					//$('#statusBarMonitorPP').parent().parent().prev().andSelf().remove();
				}
			}
		},
		type = Hash[pur5.Cfg.userType];
		if (!type) return false;

		$('#pur5TopMenuClick').css('margin', '0 3').removeAttr('width');

		$.each(type.menu.split(/, ?/), function(index, name) {
			try {
				$('#' + name).parent().remove();
			} catch (e) {}
		});

		$.each(type.toolbar.split(/, ?/), function(index, name) {
			try {
				$('#pur5TopMenuClick img[onclick*=' + name + ']').parent().remove();
			} catch (e) {}
		});

		type.other && type.other();
	}(jQuery));

	pur5.Pages.winResize(0, 0);
	var trayContent = $('#trayContent'),
		trayCtrl = $('#trayCtrl');

	if (pur5.Cfg.FSTray) {
		UI.setTrayTitle(pur5.Cfg.pur5Uid + ' - ' + pur5.Pages.Version.longName);
		trayContent.show();
	}

	trayCtrl.click(function() {
		UI.miniToTray();
	});

	$('#minimize').click(function() {
		UI.mini();
	});

	//顶部主菜单生成
	pur5.Cfg.menu = new pur5.Class.Menu({
		contentId: 'pur5TopMenu'
	});

	//系统全局长运行定时器
	pur5.Pages.runSysInterval();

	//根据选择的对接方式加载taobao_js文件
	pur5.Pages.taobaoJsLoad();

	//设置状态栏"用户编号"
	$('#statusBarUserNo').html(pur5.Cfg.pur5Uid);

	//设置状态栏"用户类型"
	$('#statusBarUserType').html(function() {
		return (pur5.Cfg.userTypeName || ({
			9: '代理',
			10: '终端',
			12: '供货',
			21: '实体代理',
			22: '实体终端',
			32: '',
			39: ''
		}[pur5.Cfg.userType]) + '版');
	});

	Model.loads([
		'orderWarn',
		'warnSetting',
		'msgBox',
		'snapConfig',
		'tradingPass',
		'dialog',
		'progress']);

	if (/(chongzhi|paipai)/.test(pur5.Pages.Version.type)) {
		Model.loads([
			'ppTradingPass',
			'ppMonitor',
			'ppOffline',
			'offlineFee']);

		if (pur5.Pages.Version.type === 'chongzhi') {
			Model.loads([
				'tbApiMonitor',
				'tbApiOffline',
				'taobaoManage'
			/*,
				'taobaoPurchase'*/
			]);
		}
	} else {
		if (/(fuzhuang)/.test(pur5.Pages.Version.type)) {
			Model.loads([
				'materialMenu']);
		}
	}

	$('#loginBody').hide();
	$('#pur5LayoutMain').show();

	pur5.Pages.winResize(844, 595);
	UI.setMoveRegion(30, 0, 744, 28);

	pur5.Pages.Version.startFunction(); //调用当前版本自己的预置函数
}

/**
 * 系统全局长运行定时器
 */
pur5.Pages.runSysInterval = function() {
	pur5.Cfg.sysInterval = setInterval(function() {
		//设置左侧"供货状态"
		pur5.Pages.setIndexStatus('all');
	}, pur5.Cfg.sysIntervalTime);
}