//-------------------------------------------------------------------------------system.js.Start
/**
 * 全局配置项
 */
pur5.Cfg.sysInterval = null;                      //系统定时器
pur5.Cfg.sysIntervalTime = 900000;                //系统定时器时长，15分钟
pur5.Cfg.sysPopSwitch = false;                    //气泡提示开关
pur5.Cfg.sysPopFile = 'controls/pop.pur5',        //气泡提示历史开关状态保存文件
pur5.Cfg.sysPopInterval = null;                   //系统气泡提示定时器
pur5.Cfg.sysPopIntervalTime = 300000;             //系统气泡提示定时器时长
pur5.Cfg.sysRunTimeInterval = null;               //系统状态栏"运行时间"定时器
pur5.Cfg.sysRunTimeIntervalTime = 1000;           //系统状态栏"运行时间"定时器时长
pur5.Cfg.sysUserMoneyInterval = null;             //系统状态栏"平台余额"定时器
pur5.Cfg.sysUserMoneyIntervalTime = 2400000;      //系统状态栏"平台余额"定时器时长，40分钟


/**
 * 平台登录进主界面后的回调，可在这里对之前客户端的pur5.js里的方法统一进行重写覆盖
 */
pur5.Pages.loginSuccessCallBack = function() {
	//UI.pop('中秋节9.10-9.12销售软件额外返点40%\n详情查看公告', 1);
}


/**
 * 设置平台交易密码临时变量
 * @param {Boolean} bFirstTime 是否第一次调用
 * @param {Function} fCallBack 回调
 */
pur5.Pages.setPur5PW2 = function(bFirstTime, fCallBack) {
	var Pur5EditAx = $('#tradePass')[0];
	Pur5EditAx.url = Pur5.makeFullPath('getCodeNew.asp?' + new Date().getTime());
	Pur5EditAx.Refresh();
	
	var Info = {
		pass: encodeURIComponent(Pur5EditAx.output),
		h: encodeURIComponent(Pur5EditAx.H1(0))
	};
	
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'CheckP.asp',
		type: 'POST',
		cache: false,
		data: {
			lv: 't1',
			token: pur5.Cfg.token,
			ls: Info.pass,
			h: Info.h
		},
		success: function(data) {
			try {
				var arr = $.parseJSON(data);
				if(!arr[2]) {
					pur5.Cfg.pur5PassWordKey = arr[0];		//用于之后监控时使用的key
					if(fCallBack) fCallBack();
					TradingPass.hide();
				} else if(arr[2] == 'error') {
					alert(arr[1]);
					Pur5EditAx.Focus();
				} else if(arr[2] == 'url') {
					pur5.Pages.iframeTo(arr[1]);
					TradingPass.hide();
				}
			} catch(e) { alert('登录状态失效，请关闭软件重新登录！'); }
		},
		error: function() { alert('设置平台交易密码失败，请重试！'); }
	});
}

/**
 * 向服务器提交错误信息
 * @param {Object} data 需要提交的数据
 */
pur5.Pages.reportErrorToServer = function(data){
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'softerror/softerror.asp',
		type: 'POST',
		cache: false,
		data: data,
		success: function(a) {},
		error: function() {
			pur5.Pages.setTBRecord("提交失败信息未成功！");
		}
	});
}


/**
 * 根据选择的对接方式加载taobao_js文件
 */
pur5.Pages.taobaoJsLoad = function() {
	var selVal = $('#selTBDJType').val();
	//$('#taobaoScriptFile')[0].src = 'scripts/' + selVal.replace('_', '.');
}
//-------------------------------------------------------------------------------system.js.End