//-------------------------------------------------------------------------------taobao.js.Start
/**
 * 设置交易全局配置项
 */
pur5.Cfg.TBJKDsSession = '';                                 //登录taobao监控弹窗控件获取到的session
pur5.Cfg.TBJKDsUrl = '';                                     //登录taobao监控弹窗控件获取到的请求“待发货列表页”url
pur5.Cfg.TBJKDsBlkUrl = '';                                  //登录taobao监控弹窗控件获取到的请求"待付款列表页"url
pur5.Cfg.GBTAOBAOLOG = false;                                //taobao登录状态，登录后为true
pur5.Cfg.taobaoUid = '';                                     //登录taobao后的uid
pur5.Cfg.GBstopTaobao = true;                                //是否暂停taobao监控，系统一开始未登录taobao前是true
pur5.Cfg.ReadTBOrdersInterval = null;                        //"淘宝监控"筛选符合发货条件的订单定时器
pur5.Cfg.ReadTBOrdersIntervalTime = 25000;                   //"淘宝监控"筛选符合发货条件的订单定时器时长
pur5.Cfg.TBOrders = [];                                      //"淘宝监控"等待发货的列表
pur5.Cfg.TBBlkOrders = [];                                   //"淘宝监控"黑名单列表
pur5.Cfg.TBPreBlkFinish = true;                              //"淘宝监控"关闭上一个黑名单操作是否完成标记
pur5.Cfg.TBPreSendFinish = true;                             //"淘宝监控"发货时上一个商品是否发送完毕标记
pur5.Cfg.TBSendOrdersInterval = null;                        //"淘宝监控"发货和关闭交易定时器
pur5.Cfg.TBSendOrdersIntervalTime = 4000;                    //"淘宝监控"发货和关闭交易定时器时长
pur5.Cfg.TBOrdersPage = 1;                                   //监控"淘宝"订单页的当前页码数
pur5.Cfg.TBBlkOrdersPage = 1;                                //监控"淘宝"待发货页的当前页码数
pur5.Cfg.TBMaxPages = 15;                                    //"淘宝监控"的最大页码数
pur5.Cfg.TBReDeliverInterval = null;                         //"淘宝监控"重新检查遗漏的未发货商品定时器
pur5.Cfg.TBReDeliverIntervalTime = 240000;                   //"淘宝监控"重新检查遗漏的未发货商品定时器时长
pur5.Cfg.TBRecordMax = 4000;                                 //"淘宝监控"记录文字最大长度
pur5.Cfg.TBOfflineMax = 1;                                   //taobao离线托管最大用户数
pur5.Cfg.TBJKWinId = '';                                     //taobao控件获取cookie前弹出窗口的id
pur5.Cfg.TBBlkListNameFile = 'controls/TBBlkN.pur5';         //taobao买家姓名黑名单本地FSO存储文件
pur5.Cfg.TBBlkListProFile = 'controls/TBBlkP.pur5';          //taobao商品名称黑名单本地FSO存储文件



/**
 * 设置"淘宝监控"的实时记录显示
 * @param {String} sMsg 登录日志信息
 */
pur5.Pages.setTBRecord = function(sMsg) {
	var layoutTBJKRecord = $('#layoutTBJKRecord')[0],
		p = document.createElement('p');
	try { p.innerHTML = sMsg; layoutTBJKRecord.insertBefore(p, layoutTBJKRecord.firstChild); } catch(e) {}
}


/**
 * 清除"淘宝监控"的实时记录显示
 */
pur5.Pages.clearTBRecord = function() {
	var layoutTBJKRecord = $('#layoutTBJKRecord');
	layoutTBJKRecord.html('');
}


/**
 * 淘宝监控时session超时重新设置交易密码
 */
pur5.Pages.tbInputAgainPur5PW2 = function() {
	if($('#inputTradingPass')[0].style.display != 'none') return;

	alert('session超时，请重新输入交易密码！');
	clearInterval(pur5.Cfg.ReadTBOrdersInterval);
	clearInterval(pur5.Cfg.TBSendOrdersInterval);
	pur5.Cfg.GBstopTaobao = true;
	
	TradingPass.show(function(){
		pur5.Pages.setPur5PW2(false, function() {
			pur5.Cfg.GBstopTaobao = false;
			pur5.Pages.runTBOrdersInterval();
			pur5.Pages.runTBSendOrdersInterval();
		});
	});
}


/**
 * 切换到"淘宝监控"事件
 */
pur5.Pages.switchToTBJK = function() {
	$('#layoutTBJKUserNo').html(pur5.Cfg.pur5Uid);
	if(!pur5.Cfg.pur5PassWordKey) {
	
	TradingPass.show(function(){
		pur5.Pages.setPur5PW2(true, function() {
			pur5.Pages.layoutTo('layoutTbJk');
		});
	});
	} else {
		pur5.Pages.layoutTo('layoutTbJk');
	}
}


/**
 * 切换到"离线托管"事件
 */
pur5.Pages.switchToLXTG = function() {
	var offlineTBUser = $('#offlineTBUser'),
		offlineTBLastTime = $('#offlineTBLastTime'),
		offlineTBResult = $('#offlineTBResult'),
		tds = offlineTBResult.find('td'),
		startText = '正在监控',
		stopText = '停止监控',
		fnInit = function() {
			$.ajax({
				url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
				type: 'get',
				cache: false,
				data: {
					token: pur5.Cfg.token,
					lv: 't2',
					source: 'taobao'
				},
				success: function(data){
					try {
						var arr = $.parseJSON(data), html = '';
						if(arr.length == 0) { alert('离线托管未开启，或已关闭，请重新启用'); return; }
						for(var i = 0, l = arr.length; i < l; i++) {
							html += '<tr><td>' + pur5.Cfg.pur5Uid + '</td><td>' + decodeURIComponent(arr[i][0]) + '</td><td>' + arr[i][1].replace(/\s+/g, '<br />') + '</td><td class="'
							+ (arr[i][2] == '0' ? ('bluefont">' + startText) : ('redfont">' + stopText))
							+ '</td><td>' + arr[i][3] + '</td></tr>';
						}
						offlineTBResult.html(html);
						offlineTBUser.html(decodeURI(arr[0][0]));//20100530 xz
						offlineTBLastTime.html(arr[0][1]);
						
						var state = arr[0][2];
						if(state == 1)
							state = 0;
						else
							state = 1;
						$('input[name="offlineTBIsStart"]').eq(state).attr('checked', false).siblings().attr('checked', true);
					} catch(e) {
						alert('返回数据格式不对！');
					}
				},
				error: function(jqXhr, textStatus){
					alert('托管状态获取失败');
				}
			});
		};

	if(!pur5.Cfg.pur5PassWordKey) {//修改 增加交易密码输入 20110530 xz
		TradingPass.show(function(){
			pur5.Pages.setPur5PW2(true, function() {
				pur5.Pages.layoutTo('layoutTbTg');
				fnInit();
			});
		});
	} else {
		pur5.Pages.layoutTo('layoutTbTg');
		fnInit();
	}
}


/**
 * 设置"淘宝"启用买家黑名单的关联控制
 * @param {String} target 目标字符串
 * @param {Boolean} bConditions 判断条件
 */
pur5.Pages.getTaobaoBlacklist = function(sTarget, bConditions) {
	var arrResult = [];
	if(bConditions) {
		arrResult = sTarget.formatComma().split(',');
	}
	return arrResult;
}


/**
 * "淘宝"发货定时器与关闭黑名单交易定时器运行函数
 */
pur5.Pages.runTBSendOrdersInterval = function() {
	clearInterval(pur5.Cfg.TBSendOrdersInterval);
	pur5.Cfg.TBSendOrdersInterval = setInterval(function() {
		var arr = pur5.Cfg.TBOrders.shift(), arrBlk = pur5.Cfg.TBBlkOrders.shift();
		if(arr && pur5.Cfg.TBPreSendFinish) pur5.Pages.prepareForTBDeliver(arr[0], arr[1], arr[2], arr[3]);
		if(arrBlk && pur5.Cfg.TBPreBlkFinish) pur5.Pages.closeTBTransaction(arrBlk[0]);
	}, pur5.Cfg.TBSendOrdersIntervalTime);
}


/**
 * 淘宝"发货列表页"order_list_new.htm自动发货前的检查准备
 * @param {Number} nTborder 淘宝订单号
 * @param {String} sStr 当前用户信息字符串值
 * @param {Number} nSn 商家编码
 */
pur5.Pages.prepareForTBDeliver = function(nTborder, sStr, nSn) {
	var spt1 = String.fromCharCode(11),
		spt2 = String.fromCharCode(12),
		step2 = function(a) {
			if(a == '') {
				pur5.Pages.setTBRecord(nTborder + '：在别处已发货！');
				pur5.Cfg.TBPreSendFinish = true;
				return;
			} else if(a == 'ErrorKey') {
				pur5.Pages.setTBRecord('请重新登陆：ErrorKey');
				pur5.Cfg.TBPreSendFinish = true;
				return;
			} else if(a == 'SessionLost') {
				pur5.Pages.setTBRecord('请重新登陆：SessionLost');
				pur5.Pages.tbInputAgainPur5PW2();
				return;
			} else if(a == nTborder) {
				pur5.Cfg.err.mark1 = false;
			} else {
				pur5.Pages.setTBRecord('未保存成功');
				
				///临时增加的，将出现"未保存成功"文字时存trading表的str和ajax返回的数据a存起来，方便将来从用户那拿过来分析
				if(!pur5.Cfg.err.mark1) {
					$.ajax({
						url: pur5.Cfg.GBHOSTSOFT + 'softerror/softerror.asp',
						type: 'POST',
						cache: false,
						data: {lv: 't1', page: 'hta'.$$$(), message: '[' + pur5.Cfg.GBHOST + ']' + '出现"未保存成功"文字时存trading表的str和ajax返回的数据a'.$$$(), content: 'str:\n' + sStr.replace(new RegExp(spt1, 'g'), '\r').replace(new RegExp(spt2, 'g'), '\n').$$$() + '\na:\n' + a, q: (new Date()).getTime() + Math.random()},
						success: function(a) {
							pur5.Pages.setTBRecord("提交失败信息成功！");
							pur5.Cfg.TBPreSendFinish = true;
						},
						error: function() {
							pur5.Pages.setTBRecord("提交失败信息未成功！");
							pur5.Cfg.TBPreSendFinish = true;
						}
					});
					pur5.Cfg.err.mark1 = true;
				}
				
				pur5.Cfg.TBPreSendFinish = true;
				return;
			}
			
			pur5.Pages.setTBRecord('保存成功');
			pur5.Pages.tbDeliver(nTborder);
		};

	pur5.Cfg.TBPreSendFinish = false;
	
	pur5.Pages.setTBRecord('编码:' + nSn);
	pur5.Pages.setTBRecord('正在保存' + nTborder);
	//先将该条记录存到服务器trading表中，再开始发货
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'taobao.asp',
		type: 'POST',
		cache: false,
		data: {tborderid: nTborder, token: pur5.Cfg.token, str: sStr.replace(new RegExp(spt1, 'g'), '\r').replace(new RegExp(spt2, 'g'), '\n').$$$(), lv: 't1', ls: pur5.Cfg.pur5PassWordKey, q: (new Date()).getTime() + Math.random()},
		success: step2,
		error: function() {
			pur5.Cfg.TBPreSendFinish = true;
			pur5.Pages.setTBRecord('尝试连接服务器trading表！');
		}
	});
}


/**
 * 淘宝发货
 * @param {String} sStr 当前用户信息字符串值
 * @param {Number} nTborder 淘宝订单号
 */
pur5.Pages.tbDeliver = function(nTborder) {
	pur5.Pages.setTBRecord('准备发货');
	
	var _key = 'sdkjfkadjflajdlpur5.comsdfsdfsdfs',
		_lv = 't1',
		_tid = nTborder + '',
		_ls = pur5.Cfg.TBJKDsSession + '',
		_lrnd = Math.random() + '';
		
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'offline/taobaoApiDuiJie.asp',
		type: 'POST',
		cache: false,
		data: {
			key: _key,
			lu: pur5.Cfg.pur5Uid,
			lv: _lv,
			tid: _tid,
			lrnd: _lrnd,
			token: pur5.Cfg.token,
			ls: _ls,
			dataType: 'json',
			sign: md5(_lv.toLowerCase() + _ls.toLowerCase() + _tid.toLowerCase() + _lrnd.toLowerCase() + _key)
		},
		success: function(data) {
			var url = '';
			
			try {
				data = $.parseJSON(data);
				url = data[0];
			} catch(e) {
				pur5.Pages.setTBRecord('发货请求的url数据不合法');
				pur5.Cfg.TBPreSendFinish = true;
			}

			if(url) {
				pur5.Pages.setTBRecord('发货中');
				$.ajax({
					url: url,
					type: 'POST',
					cache: false,
					//dataType: 'json',
					success: function(data) {
						try {
							data = $.parseJSON(data.replace(/[\r\n]/gm, ''));
						} catch(e) {
							pur5.Pages.setTBRecord('发货时返回的数据不合法');
							pur5.Cfg.TBPreSendFinish = true;
							return;
						}
						
						if(
							data &&
							data.logistics_dummy_send_response &&
							data.logistics_dummy_send_response.shipping &&
							typeof(data.logistics_dummy_send_response.shipping.is_success) != 'undefined'
						) {
							pur5.Pages.setTBRecord("发货成功，发货已返回信息");
							pur5.Pages.tbProDetail(nTborder);
						} else {
							if(
								data &&
								data.error_response &&
								typeof(data.error_response.sub_msg) != 'undefined'
							) {
								pur5.Pages.setTBRecord(data.error_response.sub_msg);
							} else {
								pur5.Pages.setTBRecord('session超时，发货失败');
							}
							pur5.Cfg.TBPreSendFinish = true;
						}
					},
					error: function(a) {
						pur5.Pages.setTBRecord('发货失败：' + a.responseText);
						pur5.Cfg.TBPreSendFinish = true;
					}
				});
			} else {
				pur5.Pages.setTBRecord('发货请求的url为空');
				pur5.Cfg.TBPreSendFinish = true;
			}
		},
		error: function(a) {
			pur5.Pages.setTBRecord('获取发货url请求出错：' + a.responseText);
			pur5.Cfg.TBPreSendFinish = true;
		}
	});
}


/**
 * 淘宝自动发货完成后获取订单信息
 * @param {String} sOrderId 订单编号
 * @param {Boolean} bIsFromTrad 是否从复查trading表那边过来的，缺省时为否
 */
pur5.Pages.tbProDetail = function(sOrderId, bIsFromTrad) {
	if(!sOrderId) { if(!bIsFromTrad) { pur5.Cfg.TBPreSendFinish = true; } return; }
	pur5.Pages.setTBRecord('准备提交订单');
	
	var _key = 'sdkjfkadjflajdlpur5.comsdfsdfsdfs',
		_lv = 't2',
		_tid = sOrderId + '',
		_ls = pur5.Cfg.TBJKDsSession + '',
		_lrnd = Math.random() + '';
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'offline/taobaoApiDuiJie.asp',
		type: 'POST',
		cache: false,
		data: {
			key: _key,
			lu: pur5.Cfg.pur5Uid,
			lv: _lv,
			tid: _tid,
			lrnd: _lrnd,
			token: pur5.Cfg.token,
			ls: _ls,
			dataType: 'json',
			sign: md5(_lv.toLowerCase() + _ls.toLowerCase() + _tid.toLowerCase() + _lrnd.toLowerCase() + _key)
		},
		success: function(data) {		
			var url = '';
			
			try {
				data = $.parseJSON(data);
				url = data[0];
			} catch(e) {
				pur5.Pages.setTBRecord('获取订单详情请求的url数据不合法');
				pur5.Cfg.TBPreSendFinish = true;
			}

			if(url) {
				$.ajax({
					url: url,
					type: 'POST',
					cache: false,
					//dataType: 'json',
					success: function(data) {
						try {
							data = $.parseJSON(data.replace(/[\r\n]/gm, ''));
						} catch(e) {
							pur5.Pages.setTBRecord('获取订单详情时返回的数据不合法');
							pur5.Cfg.TBPreSendFinish = true;
							return;
						}
						
						var str = '',
							spt1 = String.fromCharCode(11),
							spt2 = String.fromCharCode(12),
							statusHash = {
								st1: ['WAIT_BUYER_CONFIRM_GOODS', '卖家已发货'],
								st2: ['TRADE_FINISHED', '交易成功']
							},
							_status = '',
							_trade = '';
							
						if(
							data &&
							data.trade_fullinfo_get_response &&
							typeof(data.trade_fullinfo_get_response.trade) != 'undefined'
						) {
							_trade = data.trade_fullinfo_get_response.trade;
						}
						
						if(!_trade) {
							pur5.Pages.setTBRecord('获取订单详情时返回的数据不完整');
							pur5.Cfg.TBPreSendFinish = true;
							return;
						}
						
						if(_trade.status == statusHash.st1[0]) {
							_status = statusHash.st1[1];
						} else if(_trade.status == statusHash.st2[0]) {
							_status = statusHash.st2[1];
						} else {
							if(!bIsFromTrad) { pur5.Pages.setTBRecord("订单状态不匹配"); pur5.Cfg.TBPreSendFinish = true; }
							return;
						}
						
						_trade.receiver_address = _trade.receiver_address.replace(/[\s\u3000]+/g, ' ');
						str = [
							'平台账号' + spt1 + pur5.Cfg.pur5Uid + spt2,
							'商家编码' + spt1 + _trade.orders.order[0].outer_iid + spt2,
							'淘宝订单号' + spt1 + _trade.tid + spt2,
							'淘宝序号' + spt1 + '' + spt2,
							'淘宝状态' + spt1 + _status + spt2,
							'旺旺' + spt1 + pur5.Cfg.taobaoUid + spt2,
							'昵称' + spt1 + _trade.buyer_nick + spt2,
							'姓名' + spt1 + _trade.receiver_name + spt2,
							'地区' + spt1 + '' + spt2,
							'电话' + spt1 + '' + spt2,
							'宝贝名称' + spt1 + _trade.title + spt2,
							'单价' + spt1 + _trade.price + spt2,
							'数量' + spt1 + _trade.num + spt2,
							'优惠' + spt1 + (_trade.orders.order[0].discount_fee == 0 ? '—' : _trade.orders.order[0].discount_fee) + spt2,
							'商品总价' + spt1 + _trade.total_fee + spt2,
							'运费' + spt1 + _trade.post_fee + spt2,
							'实收款' + spt1 + _trade.payment + spt2,
							'支付宝单号' + spt1 + _trade.alipay_no + spt2,
							'成交时间' + spt1 + _trade.created + spt2,
							'付款时间' + spt1 + _trade.pay_time + spt2,
							'收货地址' + spt1 + _trade.receiver_address + spt2,
							'收货方式' + spt1 + (_trade.shipping_type == 'virtual' ? '虚拟物品' : '非虚拟物品') + spt2,
							'附加信息' + spt1 + _trade.receiver_address + spt2
						].join('');
						
						pur5.Pages.tbSendToServer(str);
					},
					error: function(a) {
						pur5.Pages.setTBRecord('发货失败：' + a.responseText);
						pur5.Cfg.TBPreSendFinish = true;
					}
				});
			} else {
				pur5.Pages.setTBRecord('发货请求的url为空');
				pur5.Cfg.TBPreSendFinish = true;
			}
		},
		error: function(a) {
			pur5.Pages.setTBRecord('获取订单详情url请求出错：' + a.responseText);
			pur5.Cfg.TBPreSendFinish = true;
		}
	});
}


/**
 * 淘宝自动发货完成后获取订单信息发送到pur5服务器保存
 * @param {String} sStr 上一步拼接起来的用户成交订单信息
 * @param {Boolean} bIsFromTrad 是否从复查trading表那边过来的，缺省时为否
 */
pur5.Pages.tbSendToServer = function(sStr, bIsFromTrad) {
	var spt1 = String.fromCharCode(11),
		spt2 = String.fromCharCode(12);
	if(sStr.between('平台账号' + spt1, spt2) != pur5.Cfg.pur5Uid) { pur5.Pages.setTBRecord("平台账号不匹配"); if(!bIsFromTrad) { pur5.Cfg.TBPreSendFinish = true; } return; }
	if(sStr.between('旺旺' + spt1, spt2) != pur5.Cfg.taobaoUid) { pur5.Pages.setTBRecord("旺旺不匹配"); if(!bIsFromTrad) { pur5.Cfg.TBPreSendFinish = true; } return; }
	
	pur5.Pages.setTBRecord("准备发送");

	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'taobao.asp',
		type: 'POST',
		cache: false,
		data: {token: pur5.Cfg.token, Text: sStr.replace(new RegExp(spt1, 'g'), '\r').replace(new RegExp(spt2, 'g'), '\n').$$$(), lv: 't2', ls: pur5.Cfg.pur5PassWordKey, q: (new Date()).getTime() + Math.random()},
		success: function(a) {
			pur5.Pages.setTBRecord("检查网络");
			if(a == '' || a == 'ErrorKey') { pur5.Cfg.TBPreSendFinish = true; return; }
			if(a == 'SessionLost') { pur5.Pages.tbInputAgainPur5PW2(); pur5.Cfg.TBPreSendFinish = true; return; }
			if(!bIsFromTrad) { pur5.Cfg.TBPreSendFinish = true; }
			
			pur5.Pages.setTBRecord("提交完毕！");
			pur5.Cfg.err.mark3 = false;
		},
		error: function() {
			if(!bIsFromTrad) { pur5.Cfg.TBPreSendFinish = true; }
			pur5.Pages.setTBRecord('网络错误。正在重试！');
			
			///临时增加的，将taobao已发了货但结果里没有该条记录的情况下，post到服务器的参数先存起来，方便将来从用户那拿过来分析
			if(!pur5.Cfg.err.mark3) {
				$.ajax({
					url: pur5.Cfg.GBHOSTSOFT + 'softerror/softerror.asp',
					type: 'POST',
					cache: false,
					data: {lv: 't1', page: 'hta'.$$$(), message: '[' + pur5.Cfg.GBHOST + ']' + 'taobao已发了货但结果里没有该条记录'.$$$(), content: (pur5.Cfg.token + '\n' + sStr.replace(new RegExp(spt1, 'g'), '\r').replace(new RegExp(spt2, 'g'), '\n')).$$$(), q: (new Date()).getTime() + Math.random()},
					success: function(a) {
						pur5.Pages.setTBRecord("提交失败信息成功！");
					},
					error: function() {
						pur5.Pages.setTBRecord("提交失败信息未成功！");
					}
				});
				pur5.Cfg.err.mark3 = true;
			}
		}
	});
}


/**
 * 关闭淘宝"等待买家付款列表"页中黑名单里存在的交易
 * @param {String} sOrderId 该条交易的淘宝订单号
 */
pur5.Pages.closeTBTransaction = function(sOrderId) {
	if(!sOrderId) { pur5.Cfg.TBPreBlkFinish = true; return; }
	
	pur5.Cfg.TBPreBlkFinish = false;		
	pur5.Pages.setTBRecord('正在关闭订单：' + sOrderId);
	
	//这里关闭交易
	var _key = 'sdkjfkadjflajdlpur5.com',
		_lv = 't0',
		_tid = sOrderId + '',
		_ls = pur5.Cfg.TBJKDsSession + '',
		_lrnd = Math.random() + '';
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'offline/taobaoApiDuiJie.asp',
		type: 'POST',
		cache: false,
		data: {
			key: _key,
			lu: pur5.Cfg.pur5Uid,
			lv: _lv,
			tid: _tid,
			lrnd: _lrnd,
			token: pur5.Cfg.token,
			ls: _ls,
			dataType: 'json',
			sign: md5(_lv.toLowerCase() + _ls.toLowerCase() + _tid.toLowerCase() + _lrnd.toLowerCase() + _key),
			closeReason: 'other close reason'
		},
		success: function(data) {
			var url = '';
			
			try {
				data = $.parseJSON(data);
				url = data[0];
			} catch(e) {
				pur5.Pages.setTBRecord('获取关闭订单：' + sOrderId + '的请求url数据不合法');
				pur5.Cfg.TBPreBlkFinish = true;
			}

			if(url) {
				$.ajax({
					url: url,
					type: 'POST',
					cache: false,
					//dataType: 'json',
					success: function(data) {
						
						try {
							data = $.parseJSON(data.replace(/[\r\n]/gm, ''));
						} catch(e) {
							pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '时返回的数据不合法');
							pur5.Cfg.TBPreBlkFinish = true;
							return;
						}
						
						var _trade = '';
						
						if(
							data &&
							data.trade_close_response &&
							typeof(data.trade_close_response.trade) != 'undefined'
						) {
							_trade = data.trade_close_response.trade;
						}
						
						if(_trade && _trade.tid == sOrderId) {
							pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '成功！');
							pur5.Cfg.TBPreBlkFinish = true;
						} else {
							pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '失败！');
							pur5.Cfg.TBPreBlkFinish = true;
						}
					},
					error: function(a) {
						pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '失败：' + a.responseText);
						pur5.Cfg.TBPreBlkFinish = true;
					}
				});
			} else {
				pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '请求的url为空');
				pur5.Cfg.TBPreBlkFinish = true;
			}
		},
		error: function(a) {
			pur5.Pages.setTBRecord('关闭订单：' + sOrderId + '请求出错：' + a.responseText);
			pur5.Cfg.TBPreBlkFinish = true;
		}
	});
}


/**
 * "淘宝监控"定时器调用函数
 */
pur5.Pages.doingReadTBOrders = function() {
	if(!pur5.Cfg.GBPUR5LOG || !pur5.Cfg.GBTAOBAOLOG || pur5.Cfg.GBstopTaobao) return;
	
	//定时清空监控记录
	var layoutTBJKRecord = $('#layoutTBJKRecord');
	if(layoutTBJKRecord[0].innerHTML.length >= pur5.Cfg.TBRecordMax) {
		layoutTBJKRecord[0].innerHTML = '';
	}
		
	var	tbAutoCloseOrder  = $('#tbAutoCloseOrder'),
		tbAutoCloseAll = $('#tbAutoCloseAll'),
		tbBlackListIDON = $('#tbBlackListIDON'),
		tbBlackListID = $('#tbBlackListID'),
		tbAutoCloseOrder = $('#tbAutoCloseOrder'),
		tbAutoCloseOrderTitle = $('#tbAutoCloseOrderTitle'),
		blackListID = tbBlackListID[0],
		blackListIDON = tbBlackListIDON[0],
		autoCloseOrderTitle = tbAutoCloseOrderTitle[0],
		autoCloseOrder = tbAutoCloseOrder[0],
		autoCloseAll = tbAutoCloseAll[0],
		tbBkUsersList = pur5.Pages.getTaobaoBlacklist(blackListID.value, blackListIDON.checked && blackListID.value != ''),
		tbBkGoodsList = pur5.Pages.getTaobaoBlacklist(autoCloseOrderTitle.value, autoCloseOrder.checked && autoCloseOrderTitle.value != '' && !autoCloseAll.checked);
	
	//获取“等待发货列表”数据
	//window.open(pur5.Cfg.TBJKDsUrl);
	$.ajax({
		url: pur5.Cfg.TBJKDsUrl,
		type: 'POST',
		cache: false,
		success: function(data) {
			data = $.parseJSON(data.replace(/[\r\n]/gm, ''));
			var _trades_sold_get_response = data.trades_sold_get_response;
			if(!data || !_trades_sold_get_response) { pur5.Pages.setTBRecord('请求待发货列表页数据为空!'); return; }
			if(_trades_sold_get_response.total_results == '0') {
				pur5.Pages.setTBRecord('当前没有需要发货的宝贝 ' + pur5.Pages.getTime('2'));
				return;
			} else {
				var a = _trades_sold_get_response.trades.trade,
					//商家编码
					sn,
					//订单编号
					orderId = 0,
					//买家帐号名
					buyerName = '',
					//商品名称
					goodsName = '',
					//购买某商品数量
					howMany = 0,
					//其他字段剩余字段拼接的字符串
					str = '',
					isInBlack = false;
				for(var i = 0, l = a.length; i < l; i++) {
					isInBlack = false;
					sn = a[i].orders.order[0].outer_iid.trim();
					
					if((!isNaN(sn) && sn != '') || sn.left(8).toUpperCase() == 'PUR5.COM') {
						if(!isNaN(sn)){
							if(sn >= 10 && sn <= 20){
							} else {
								continue;
							}
						}
						
						orderId = a[i].tid,
						buyerName = a[i].buyer_nick,
						goodsName = a[i].orders.order[0].title,
						howMany = a[i].num;
						
						//淘宝买家姓名黑名单过滤
						if(blackListIDON.checked && tbBkUsersList.length > 0) {
							for(var j = 0, jL = tbBkUsersList.length; j < jL; j++) {
								if(buyerName == tbBkUsersList[j]) {
									isInBlack = true;
									break;
								}
							}
							
							if(isInBlack) continue;
						}
						
						//商品数量与商品关键字黑名单过滤
						if(autoCloseOrder.checked && howMany > 1) {
							if(autoCloseAll.checked) {
								continue;
							} else {
								if(tbBkGoodsList.length > 0) {
									for(j = 0, jL = tbBkGoodsList.length; j < jL; j++) {
										if(goodsName.indexOf(tbBkGoodsList[j]) > 0) {
											isInBlack = true;
											break;
										}
									}
									
									if(isInBlack) continue;
								}
							}
						}
			
						str += '平台账号' + String.fromCharCode(11) + pur5.Cfg.pur5Uid + String.fromCharCode(12)
										+ '淘宝订单号' + String.fromCharCode(11) + orderId + String.fromCharCode(12);
						
						//将符合发货条件的订单统一放到pur5.Cfg.TBOrders里
						if(pur5.Cfg.TBOrders.length > 50) pur5.Cfg.TBOrders = pur5.Cfg.TBOrders.slice(0, 50);
						pur5.Cfg.TBOrders.$push([orderId, str, sn], 0);
					}
				}
				if(!pur5.Cfg.TBOrders.length) pur5.Pages.setTBRecord('当前没有符合发货条件的宝贝 ' + pur5.Pages.getTime('2'));
			}
		},
		error: function(a) {
			pur5.Pages.setTBRecord('尝试重新获取"等待发货列表"数据：' + a.responseText);
		}
	});
	
	
	//只有启用"姓名黑名单"、"最大数量产品关键字限制黑名单"、"最大数量全部限制黑名单"功能中的一个，才往下运行
	if((tbBlackListIDON[0].checked && tbBlackListID.val() != '') || (tbAutoCloseOrder[0].checked && (tbAutoCloseOrderTitle.val() != '' || tbAutoCloseAll[0].checked))) {
		//获取"等待付款列表"数据
		//window.open(pur5.Cfg.TBJKDsBlkUrl);
		$.ajax({
			url: pur5.Cfg.TBJKDsBlkUrl,
			type: 'POST',
			cache: false,
			success: function(data) {
				data = $.parseJSON(data.replace(/[\r\n]/gm, ''));
				var _trades_sold_get_response = data.trades_sold_get_response;
				if(!data || !_trades_sold_get_response) { pur5.Pages.setTBRecord('请求等待付款列表数据为空!'); return; }
				if(_trades_sold_get_response.total_results == '0') {
					pur5.Pages.setTBRecord('当前没有需要关闭交易的宝贝');
					return;
				} else {
					var a = _trades_sold_get_response.trades.trade,
						//商家编码
						sn,
						//订单编号
						orderId = 0,
						//买家帐号名
						buyerName = '',
						//商品名称
						goodsName = '',
						//购买某商品数量
						howMany = 0;
					
					if(!a.length) { pur5.Cfg.TBPreBlkFinish = true; return; }
				
					for(var i = 0, l = a.length; i < l; i++) {
						sn = a[i].orders.order[0].outer_iid.trim(),
						orderId = a[i].tid,
						buyerName = a[i].buyer_nick,
						goodsName = a[i].title,
						howMany = a[i].num;
						
						if((!isNaN(sn) && sn != '') || sn.left(8).toUpperCase() == 'PUR5.COM') {
							if(!isNaN(sn)){
								if(sn >= 10 && sn <= 20){
								} else {
									continue;
								}
							}
							
							//淘宝买家姓名黑名单过滤
							if(blackListIDON.checked && tbBkUsersList.length) {
								for(var j = 0, jL = tbBkUsersList.length; j < jL; j++) {
									if(buyerName == tbBkUsersList[j]) {
										if(pur5.Cfg.TBBlkOrders.length > 50) pur5.Cfg.TBBlkOrders = pur5.Cfg.TBBlkOrders.slice(0, 50);
										pur5.Cfg.TBBlkOrders.$push([orderId], 0);
										break;
									}
								}
							}
							
							//商品数量与商品关键字黑名单过滤
							if(autoCloseOrder.checked && howMany > 1) {
								if(autoCloseAll.checked) {
									if(pur5.Cfg.TBBlkOrders.length > 50) pur5.Cfg.TBBlkOrders = pur5.Cfg.TBBlkOrders.slice(0, 50);
									pur5.Cfg.TBBlkOrders.$push([orderId], 0);
								} else {
									if(tbBkGoodsList.length) {
										for(var k = 0, kL = tbBkGoodsList.length; k < kL; k++) {
											if(goodsName.indexOf(tbBkGoodsList[k]) > 0) {
												if(pur5.Cfg.TBBlkOrders.length > 50) pur5.Cfg.TBBlkOrders = pur5.Cfg.TBBlkOrders.slice(0, 50);
												pur5.Cfg.TBBlkOrders.$push([orderId], 0);
												break;
											}
										}
									}
								}
							}
							
						}
					}
				}
			},
			error: function(a) {
				pur5.Pages.setTBRecord('尝试重新获取"等待付款列表"数据：' + a.responseText);
			}
		});
	}
}


/**
 * 定时检查淘宝之前已存服务器的trading表，将表里存在的"已成功发货，但因网络问题或软件退出导致发货记录还没来得及提交到pur5服务器"的订单，重新提交到pur5服务器
 */
pur5.Pages.tbReDeliverInterval = function() {
	if(!pur5.Cfg.GBPUR5LOG || !pur5.Cfg.GBTAOBAOLOG) return;
	
	$.ajax({
		url: pur5.Cfg.GBHOSTSOFT + 'taobao.asp',
		type: 'get',
		cache: false,
		data: {
			token: pur5.Cfg.token,
			lv: 't3',
			ls: pur5.Cfg.pur5PassWordKey
		},
		success: function(a){
			if(a == '' || a == 'ErrorKey') return;
			if(a == 'SessionLost') { pur5.Pages.tbInputAgainPur5PW2(); return; }
			
			var aa = [], str = '', tborder = '', spt1 = String.fromCharCode(11), spt2 = String.fromCharCode(12);
			a = a.replace(/\r/g, spt1).replace(/\n/g, spt2);
			aa = a.split("|||").slice(0, Math.floor(pur5.Cfg.TBReDeliverIntervalTime / pur5.Cfg.TBSendOrdersIntervalTime / 2));
			
			if(aa.length == 1) return;
			pur5.Pages.setTBRecord('正在复查是否有漏单......');
			//重新走流程提交发货和把记录返回pur5服务器并清除trading表中该条记录
			for(var i = 0, l = aa.length; i < l; i++) {
				(function(j) {
					setTimeout(function() {
						str = aa[j];
						if(str) {
							tborder = str.between('淘宝订单号' + spt1, spt2);
							if(!tborder) return;
	
							pur5.Pages.tbProDetail(tborder, true);
						}
					}, j * pur5.Cfg.TBSendOrdersIntervalTime / 2);
				})(i);
			}
		},
		error: function(a){
			pur5.Pages.setTBRecord('复查漏单尝试中：' + a.responseText);
		}
	});
}


/**
 * "淘宝"筛选符合发货条件的订单定时器运行函数
 */
pur5.Pages.runTBOrdersInterval = function() {
	clearInterval(pur5.Cfg.ReadTBOrdersInterval);
	clearInterval(pur5.Cfg.TBReDeliverInterval);
	pur5.Cfg.ReadTBOrdersInterval = setInterval(pur5.Pages.doingReadTBOrders, pur5.Cfg.ReadTBOrdersIntervalTime);
	pur5.Cfg.TBReDeliverInterval = setInterval(pur5.Pages.tbReDeliverInterval, pur5.Cfg.TBReDeliverIntervalTime);
	return;
}


/**
 * 主显示区"淘宝监控"的初始化设置
 */
$(function() {
	var layoutTBJKButton = $('#layoutTBJKButton'),
		//layoutTBJKInputUser = $('#layoutTBJKInputUser'),
		//layoutTBJKInputPass = $('#layoutTBJKInputPass'),
		layoutTBJKInfoText = $('#layoutTBJKInfoText'),
		layoutTBJKInputStart = $('#layoutTBJKInputStart'),
		layoutTBJKInputTime = $('#layoutTBJKInputTime'),
		layoutTBJKInputSuspend = $('#layoutTBJKInputSuspend'),
		layoutTBJKInputStop = $('#layoutTBJKInputStop'),
		layoutTBJKRecord = $('#layoutTBJKRecord'),
		layoutTBJKLoginBefore = $('#layoutTBJKLoginBefore'),
		layoutTBJKLoginAfter = $('#layoutTBJKLoginAfter'),
		layoutTBJKTextUser = $('#layoutTBJKTextUser'),
		statusBarMonitorTB = $('#statusBarMonitorTB'),
		layoutTBJKRecordClear = $('#layoutTBJKRecordClear'),
		tbAutoCloseOrder = $('#tbAutoCloseOrder'),
		tbBlackListIDON = $('#tbBlackListIDON'),
		tbBlackListID = $('#tbBlackListID'),
		tbAutoCloseAll = $('#tbAutoCloseAll'),
		tbAutoCloseOrderTitle = $('#tbAutoCloseOrderTitle'),
		startClick = function() {
			pur5.Pages.setTBRecord('正在登录淘宝...');
			layoutTBJKInputSuspend[0].disabled = false;

			if(pur5.Cfg.TBJKDsSession && pur5.Cfg.TBJKDsUrl) {
				pur5.Cfg.GBTAOBAOLOG = true;
				pur5.Cfg.GBstopTaobao = false;
				layoutTBJKRecord.html('');
				pur5.Pages.setTBRecord('登录淘宝成功,' + pur5.Cfg.taobaoUid);
				layoutTBJKLoginBefore.hide();
				layoutTBJKLoginAfter.show();
				layoutTBJKInputStart.hide();
				layoutTBJKInputStop.show();
				layoutTBJKTextUser.html(pur5.Cfg.taobaoUid);
				layoutTBJKInfoText.html('正在监控');
				statusBarMonitorTB.html('正在监控');
				pur5.Pages.doingReadTBOrders();
				pur5.Cfg.ReadTBOrdersIntervalTime = layoutTBJKInputTime.val() * 1000;
				pur5.Pages.tbReDeliverInterval();					//登录完毕后也先查一下trading表
				pur5.Pages.runTBOrdersInterval();
				pur5.Pages.runTBSendOrdersInterval();
			} else {
				pur5.Pages.setTBRecord('登录失败！！获取API的session或url不对。');
				pur5.Cfg.GBTAOBAOLOG = false;
			}
		};
	
	tbBlackListIDON[0].checked =
	tbAutoCloseOrder[0].checked =
	tbAutoCloseAll[0].checked =
	layoutTBJKInputSuspend[0].checked = false;

	try {
		if(!pur5.Cfg.DsAPI) pur5.Cfg.DsAPI = new ActiveXObject("toplogin.tl");
	} catch(e) { alert('对接API组件注册失败，请重新注册！'); }
	
	try {
		if(!pur5.Cfg.Ds) pur5.Cfg.Ds = new ActiveXObject('dsCookieGetter.ds');
		pur5.Cfg.Ds.AddFilter(".taobao.com");
	} catch(e) { alert('对接组件注册失败，请重新注册！'); }

	layoutTBJKButton.click(function() {
		pur5.Cfg.DsAPI.Go2('http://container.open.taobao.com/container?appkey=12184223&t=' + Math.random() + '&dataType=json&actionType=1&serverHttp='+ pur5.Cfg.GBHOSTSOFT, 'PUR5[授权成功]', pur5.Cfg.GBHOSTSOFT);
		try {
			var arr = $.parseJSON(pur5.Cfg.DsAPI.getHTML());
			pur5.Cfg.TBJKDsSession = arr[0];
			pur5.Cfg.TBJKDsUrl = arr[1];
			pur5.Cfg.TBJKDsBlkUrl = arr[2];
			pur5.Cfg.taobaoUid = arr[3];
		} catch(e) {
			alert('弹窗登录返回数据不合法');
		}
	});
	
	layoutTBJKInputStart.click(startClick);
	
	layoutTBJKRecordClear.click(pur5.Pages.clearTBRecord);
	
	if(tbAutoCloseOrder[0].checked) tbAutoCloseAll[0].disabled = false;
	
	tbBlackListIDON.click(function() {
		tbBlackListID[0].disabled = this.checked ? false : true;
	});
	
	tbAutoCloseOrder.click(function() {
		tbAutoCloseAll[0].disabled = tbAutoCloseOrderTitle[0].disabled = this.checked ? false : true;
	});
	
	layoutTBJKInputTime.blur(function() {
		var val = this.value;
		if(isNaN(val)) val = 25;
		if(val < 15) {
			val = 15;
		} else if(val > 120) {
			val = 120;
		}
		this.value = val;
		pur5.Cfg.ReadTBOrdersIntervalTime = val * 1000;
		pur5.Pages.runTBOrdersInterval();
		pur5.Pages.runTBSendOrdersInterval();
	});
	layoutTBJKInputSuspend.click(function() {
		if(this.checked && pur5.Cfg.ReadTBOrdersInterval && pur5.Cfg.GBTAOBAOLOG && !pur5.Cfg.GBstopTaobao) {
			if(confirm('注意：淘宝已发货的订单将无法暂停！是否继续？')) {
				clearInterval(pur5.Cfg.ReadTBOrdersInterval);
				clearInterval(pur5.Cfg.TBSendOrdersInterval);
				pur5.Cfg.GBstopTaobao = true;
				layoutTBJKInfoText.html('暂停监控');
				statusBarMonitorTB.html('暂停监控');
			} else {
				this.checked = false;
			}
		} else {
			pur5.Cfg.GBstopTaobao = false;
			pur5.Pages.runTBOrdersInterval();
			pur5.Pages.runTBSendOrdersInterval();
			layoutTBJKInfoText.html('正在监控');
			statusBarMonitorTB.html('正在监控');
		}
	});
	layoutTBJKInputStop.click(function() {
		if(confirm('是否退出淘宝？')) {
			var ds1 = pur5.Cfg.Ds;
			pur5.Cfg.TBJKDsSession = '';
			pur5.Cfg.TBJKDsUrl = '';
			pur5.Cfg.TBJKDsBlkUrl = '';
			layoutTBJKTextUser.html('未登录');
			pur5.Cfg.GBTAOBAOLOG = false;
			pur5.Cfg.GBstopTaobao = true;
			pur5.Pages.setTBRecord('退出淘宝');
			layoutTBJKInfoText.html('未监控');
			statusBarMonitorTB.html('未监控');
			layoutTBJKInputSuspend[0].checked = false;
			layoutTBJKInputSuspend[0].disabled = true;
			pur5.Cfg.taobaoUid = '';
			layoutTBJKLoginBefore.show();
			layoutTBJKLoginAfter.hide();
			layoutTBJKInputStart.show();
			clearInterval(pur5.Cfg.ReadTBOrdersInterval);
			clearInterval(pur5.Cfg.TBSendOrdersInterval);
			clearInterval(pur5.Cfg.TBReDeliverInterval);
			$(this).hide();
		}
	});
	
	try {
		tbBlackListID.val(pur5.Pages.getFso(pur5.Cfg.TBBlkListNameFile));
		tbAutoCloseOrderTitle.val(pur5.Pages.getFso(pur5.Cfg.TBBlkListProFile));
	} catch(e) {}
});


/**
 * taobao离线托管的初始化设置
 */
$(function() {
	var offlineTBLastTime = $('#offlineTBLastTime'),
		offlineTBJKButton = $('#offlineTBJKButton'),
		//offlineTBWW = $('#offlineTBWW'),
		//offlineTBWWP = $('#offlineTBWWP'),
		offlineTBStop = $('#offlineTBStop'),
		offlineTBSubmit = $('#offlineTBSubmit'),
		offlineTBResult = $('#offlineTBResult'),
		tds = offlineTBResult.find('td'),
		startText = '正在监控',
		stopText = '停止监控',
		successText = '登录成功';
	
	offlineTBJKButton.click(function() {
		if(pur5.Cfg.TBJKWinId) pur5.Cfg.Ds.CloseWindow(pur5.Cfg.TBJKWinId);
		pur5.Cfg.TBJKWinId = (new Date()).getTime() + Math.random() + '';
		pur5.Cfg.Ds.Link('https://login.taobao.com/member/login.jhtml?' + (new Date()).getTime() + Math.random(), pur5.Cfg.TBJKWinId);
	});
	
	offlineTBSubmit.click(function() {
		//var user = offlineTBWW.val().toLocaleLowerCase(),
		var user = '',
			//pass = offlineTBWWP.val().left(16),
			trs = offlineTBResult.find('tr'),
			needStop = false,
			inTable = false,
			ds1 = pur5.Cfg.Ds,
			//poststr = "from=tb&TPL_username=" + user.$$() + "&TPL_password=" + pass.$$() + "&isww=1&actionForStable=enable_post_user_action&action=Authenticator&TPL_redirect_url=&event_submit_do_login=anything",
			cookies = '';
		if(pur5.Cfg.TBJKWinId) ds1.CloseWindow(pur5.Cfg.TBJKWinId);
		cookies = ds1.GetCookie(pur5.Cfg.TBJKWinId);
		
		if(cookies) cookies = cookies.replace(/[\n\r]+/gm, '');
		if(!cookies || cookies.search("token") <= 0) { alert('请先点击"登录淘宝"按钮登录后再点确定按钮！'); return; }
		
		if(cookies.indexOf('_nk_=') != -1) {
			user = unescape(cookies.split('_nk_=')[1].split(';')[0].replace(/%5C/g, '%'));
		} else if(cookies.indexOf('nick=') != -1) {
			user = unescape(cookies.split('nick=')[1].split(';')[0].replace(/%5C/g, '%'));
		}
		if(user == '') alert('获取旺旺号为空');
			
		if(offlineTBStop[0].checked) {
			//if(user == '') { alert('请输入旺旺账号'); return; }
			//if(pass == '') { alert('请输入旺旺密码'); return; }
			//cookies = ds1.httpCookiePost("http://login.taobao.com/member/login.jhtml", "", 0, poststr, '', '');
			//将cookie清除
			//ds1.httpCookiePost('http://login.taobao.com/member/logout.jhtml?', cookies, 1, '', '', '');
			//ds1.SetCookie('.taobao.com');
			
			for(var i = 0, l = trs.length; i < l; i++) {
				var tds = trs[i].getElementsByTagName('td');
				if(tds[3].innerHTML == startText) {
					needStop = true;
					break;
				}				
			}
			if(needStop) {
				if(cookies.search('cookie1') >= 0 && cookies.search('cookie2') >= 0 && cookies.search('uc1=lltime') >= 0) {
					$.ajax({
						url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
						type: 'get',
						cache: false,
						data: {
							token: pur5.Cfg.token,
							lv: 't3', ww: user,
							source: 'taobao'
						},
						success: function(data){
							if(data == '1') {
								//offlineTBWWP.val('');
								tds[3].innerHTML = stopText;
								tds[3].className = 'redfont';
								tds[4].innerHTML = successText;
							} else {
								tds[4].innerHTML = data;
							}
						}
					});
				} else {
					alert('请先点击"登录淘宝"按钮登录后再点确定按钮！')
				}
			} else { alert('该旺旺账号未起用离线托管'); }
			needStop = false;
		} else {
			//if(user == '') { alert('请输入旺旺账号'); return; }
			//if(pass == '') { alert('请输入旺旺密码'); return; }
			//cookies = ds1.httpCookiePost("http://login.taobao.com/member/login.jhtml", "", 0, poststr, '', '');
			
			var loginTime = pur5.Pages.getTime(), trIndex = 0;
			if(cookies.search('cookie1') >= 0 && cookies.search('cookie2') >= 0 && cookies.search('uc1=lltime') >= 0) {
				for(var i = 0, l = trs.length; i < l; i++) {
					var tds = trs[i].getElementsByTagName('td');
					if(tds[1].innerHTML == user) {
						inTable = true;
						trIndex = i;
						break;
					}
				}
				
				$.ajax({
					url: pur5.Cfg.GBHOSTSOFT + 'offline/offline.asp',
					type: 'post',
					cache: false,
					data: {
						token: pur5.Cfg.token,
						lv: 't1',
						ww: user.$$$(),
						cookie: cookies.$$$(),
						source: 'taobao'
					},
					success: function(data){
						if(data != '1') { alert(data); return; }
						var tds = trs[trIndex].getElementsByTagName('td');
						if(inTable) {
							if(tds[3].innerHTML == stopText) {
								tds[2].innerHTML = loginTime.replace(/\s+/g, '<br />');
								tds[3].innerHTML = startText;
								tds[3].className = 'bluefont';
								tds[4].innerHTML = successText;
							} else {
								alert('该旺旺已经在离线托管中！');
							}
						} else {
							if(pur5.Cfg.TBOfflineMax == 1) {
								tds[0].innerHTML = pur5.Cfg.pur5Uid;
								tds[1].innerHTML = user;
								tds[2].innerHTML = loginTime.replace(/\s+/g, '<br />');
								tds[3].innerHTML = startText;
								tds[3].className = 'bluefont';
								tds[4].innerHTML = successText;
															
								$('#offlineTBUser').html(user);//20100530 xz
								$('#offlineTBLastTime').html(loginTime);
	
								return;
							}
							
							if(trs.length >= pur5.Cfg.TBOfflineMax) {
								offlineTBResult[0].deleteRow(pur5.Cfg.TBOfflineMax - 1);
							}
							
							if(tds[0].innerHTML == '') {
								tds[0].innerHTML = pur5.Cfg.pur5Uid;
								tds[1].innerHTML = user;
								tds[2].innerHTML = loginTime.replace(/\s+/g, '<br />');
								tds[3].innerHTML = startText, tds[3].className = 'bluefont';
								tds[4].innerHTML = successText;
							} else {
								var trNew = offlineTBResult[0].insertRow(0), trNewCells = trNew.cells;
								trNew.insertCell(0), trNewCells[0].innerHTML = pur5.Cfg.pur5Uid;
								trNew.insertCell(1), trNewCells[1].innerHTML = user;
								trNew.insertCell(2), trNewCells[2].innerHTML = loginTime.replace(/\s+/g, '<br />');
								trNew.insertCell(3), trNewCells[3].innerHTML = startText, trNew.cells[3].className = 'bluefont';
								trNew.insertCell(4), trNewCells[4].innerHTML = successText;
							}
						}
						
						offlineTBLastTime.html(loginTime);
						//offlineTBWWP.val('');
						inTable = false;
					},
					error: function(jqXhr, textStatus){
						alert('托管失败:' + textStatus);
					}
				});
			}else{
				alert('登录失败！！');
			}
		}
	});
})

//为解决淘宝API的bug（即：数据带回车符时，API本身存在问题），临时性增加的错误过滤
window.onerror = function() { return true; }
//-------------------------------------------------------------------------------taobao.js.End