/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

public abstract class AbstractBoard
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BOARD_COLOR = Color.decode("#F8EBB3");
    public static Color BORDER_COLOR = BOARD_COLOR.darker();
    public static Color COORDINATE_COLOR = Color.gray.brighter();
    public static float COORDINATE_FONT_SIZE = 9.0f;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(1.2), SizeUnit.in);
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels())};
    protected Point firstPoint = new Point();
    protected Point secondPoint = new Point();
    protected Color boardColor = BOARD_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Color coordinateColor = COORDINATE_COLOR;
    protected Boolean drawCoordinates = true;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(this.boardColor);
            g2d.fillRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
            g2d.setComposite(oldComposite);
        }
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.drawRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
        drawingObserver.stopTracking();
    }

    protected void drawCoordinates(Graphics2D g2d, int spacing) {
        if (!this.getDrawCoordinates()) {
            return;
        }
        Point p = new Point(this.firstPoint);
        g2d.setColor(this.coordinateColor);
        g2d.setFont(LABEL_FONT.deriveFont(COORDINATE_FONT_SIZE));
        int t = 1;
        while (p.y < this.secondPoint.y - spacing) {
            p.y += spacing;
            super.drawCenteredText(g2d, this.getCoordinateLabel(t++), p.x + 2, p.y, HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
        }
        p = new Point(this.firstPoint);
        t = 1;
        while (p.x < this.secondPoint.x - spacing) {
            p.x += spacing;
            super.drawCenteredText(g2d, this.getCoordinateLabel(t++), p.x, p.y - 2, HorizontalAlignment.CENTER, VerticalAlignment.TOP);
        }
    }

    private String getCoordinateLabel(int coordinate) {
        String result = "";
        while (coordinate > 0) {
            int digit = coordinate % 26;
            coordinate /= 26;
            if (digit == 0) {
                result = 'Z' + result;
                --coordinate;
                continue;
            }
            result = (char)(65 + digit - 1) + result;
        }
        return result;
    }

    @EditableProperty(name="Color")
    public Color getBoardColor() {
        return this.boardColor;
    }

    public void setBoardColor(Color boardColor) {
        this.boardColor = boardColor;
    }

    @EditableProperty(name="Coordinate Color")
    public Color getCoordinateColor() {
        return this.coordinateColor == null ? COORDINATE_COLOR : this.coordinateColor;
    }

    public void setCoordinateColor(Color coordinateColor) {
        this.coordinateColor = coordinateColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Draw Coordinates")
    public boolean getDrawCoordinates() {
        return this.drawCoordinates == null || this.drawCoordinates != false;
    }

    public void setDrawCoordinates(boolean drawCoordinates) {
        this.drawCoordinates = drawCoordinates;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.firstPoint.setLocation(Math.min(this.controlPoints[0].x, this.controlPoints[1].x), Math.min(this.controlPoints[0].y, this.controlPoints[1].y));
        this.secondPoint.setLocation(Math.max(this.controlPoints[0].x, this.controlPoints[1].x), Math.max(this.controlPoints[0].y, this.controlPoints[1].y));
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

