/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Trace Cut", category="Connectivity", author="Branislav Stojkovic", description="Designates the place where a trace on the vero board needs to be cut", instanceNamePrefix="Cut", stretchable=false, zOrder=3.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class TraceCut
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    public static Color FILL_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.red;
    public static Color SELECTION_COLOR = Color.blue;
    private Size size = SIZE;
    private Color fillColor = FILL_COLOR;
    private Color borderColor = BORDER_COLOR;
    protected Point point = new Point(0, 0);

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int size = this.getClosestOdd((int)this.size.convertToPixels());
        int dotDiameter = size - 6;
        g2d.setColor(this.fillColor);
        g2d.fillRect(this.point.x - size / 2, this.point.y - size / 2, size, size);
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.drawRect(this.point.x - size / 2, this.point.y - size / 2, size, size);
        g2d.fillOval(this.point.x - dotDiameter / 2, this.point.y - dotDiameter / 2, dotDiameter, dotDiameter);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int size = 16;
        int dotDiameter = size / 4 * 2;
        g2d.setColor(FILL_COLOR);
        g2d.fillRect((width - size) / 2, (height - size) / 2, size, size);
        g2d.setColor(BORDER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.drawRect((width - size) / 2, (height - size) / 2, size, size);
        g2d.fillOval((width - dotDiameter) / 2, (height - dotDiameter) / 2, dotDiameter, dotDiameter);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @EditableProperty
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty(name="Fill")
    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Deprecated
    public String getName() {
        return super.getName();
    }
}

