/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.misc.IconImageConverter;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Image", author="Branislav Stojkovic", category="Misc", description="User defined image", instanceNamePrefix="Img", zOrder=4.0, flexibleZOrder=true, stretchable=false, bomPolicy=BomPolicy.NEVER_SHOW)
public class Image
extends AbstractTransparentComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static String DEFAULT_TEXT = "Double click to edit text";
    private static ImageIcon ICON;
    private static byte DEFAULT_SCALE;
    private Point point = new Point(0, 0);
    @XStreamConverter(value=IconImageConverter.class)
    private ImageIcon image = ICON;
    private byte scale = (byte)50;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        double s = 1.0 * (double)this.scale / (double)DEFAULT_SCALE;
        Rectangle clip = g2d.getClip().getBounds();
        if (!clip.intersects(new Rectangle2D.Double(this.point.getX(), this.point.getY(), (double)this.image.getIconWidth() * s, (double)this.image.getIconHeight() * s))) {
            System.console().writer().print("escape");
            return;
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.scale(s, s);
        g2d.drawImage(this.image.getImage(), (int)((double)this.point.x / s), (int)((double)this.point.y / s), null);
        if (componentState == ComponentState.SELECTED) {
            g2d.setComposite(oldComposite);
            g2d.scale(1.0 / s, 1.0 / s);
            g2d.setColor(SELECTION_COLOR);
            g2d.drawRect(this.point.x, this.point.y, (int)((double)this.image.getIconWidth() * s), (int)((double)this.image.getIconHeight() * s));
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.drawImage(ICON.getImage(), this.point.x, this.point.y, null);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(defaultable=false)
    public ImageIcon getImage() {
        return this.image;
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    @EditableProperty(defaultable=false)
    public byte getScale() {
        return this.scale;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public String getName() {
        return super.getName();
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    static {
        DEFAULT_SCALE = (byte)50;
        String name = "image.png";
        URL imgURL = Image.class.getResource(name);
        if (imgURL != null) {
            ICON = new ImageIcon(imgURL, name);
        }
    }
}

