/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.components.AbstractSchematicLeadedSymbol;
import org.diylc.components.passive.Voltage;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Capacitor (schematic symbol)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="C", description="Capacitor schematic symbol with an optional polarity sign", zOrder=4.0)
public class CapacitorSymbol
extends AbstractSchematicLeadedSymbol<Capacitance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_LENGTH = new Size(Double.valueOf(0.05), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.15), SizeUnit.in);
    private Capacitance value = null;
    @Deprecated
    private Voltage voltage = Voltage._63V;
    private org.diylc.core.measures.Voltage voltageNew = null;
    private boolean polarized = false;

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Capacitance getValue() {
        return this.value;
    }

    public void setValue(Capacitance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @Deprecated
    public Voltage getVoltage() {
        return this.voltage;
    }

    @Deprecated
    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty(name="Voltage")
    public org.diylc.core.measures.Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(org.diylc.core.measures.Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    @EditableProperty
    public boolean getPolarized() {
        return this.polarized;
    }

    public void setPolarized(boolean polarized) {
        this.polarized = polarized;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR);
        g2d.drawLine(0, height / 2, 13, height / 2);
        g2d.drawLine(width - 13, height / 2, width, height / 2);
        g2d.setColor(COLOR);
        g2d.drawLine(14, height / 2 - 6, 14, height / 2 + 6);
        g2d.drawLine(width - 14, height / 2 - 6, width - 14, height / 2 + 6);
    }

    protected Size getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    protected Size getDefaultLength() {
        return DEFAULT_LENGTH;
    }

    protected Shape getBodyShape() {
        GeneralPath polyline = new GeneralPath();
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        polyline.moveTo(0.0f, 0.0f);
        polyline.lineTo(0.0, width);
        polyline.moveTo(length, 0.0);
        polyline.lineTo(length, width);
        return polyline;
    }

    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (this.polarized) {
            g2d.setColor(this.getBorderColor());
            int plusSize = this.getClosestOdd(this.getWidth().convertToPixels() / 4.0);
            int x = -plusSize;
            int y = plusSize;
            g2d.drawLine(x - plusSize / 2, y, x + plusSize / 2, y);
            g2d.drawLine(x, y - plusSize / 2, x, y + plusSize / 2);
        }
    }
}

