/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.components.AbstractSchematicLeadedSymbol;
import org.diylc.components.passive.Power;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.PowerUnit;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Resistor (schematic symbol)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="R", description="Resistor schematic symbol", zOrder=4.0)
public class ResistorSymbol
extends AbstractSchematicLeadedSymbol<Resistance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_LENGTH = new Size(Double.valueOf(0.3), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.08), SizeUnit.in);
    private Resistance value = null;
    @Deprecated
    private Power power = Power.HALF;
    private org.diylc.core.measures.Power powerNew = new org.diylc.core.measures.Power(Double.valueOf(0.5), PowerUnit.W);

    @EditableProperty
    public Resistance getValue() {
        return this.value;
    }

    public void setValue(Resistance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getPowerNew() == null ? "" : " " + this.getPowerNew().toString());
    }

    @Deprecated
    public Power getPower() {
        return this.power;
    }

    @Deprecated
    public void setPower(Power power) {
        this.power = power;
    }

    @EditableProperty(name="Power rating")
    public org.diylc.core.measures.Power getPowerNew() {
        if (this.powerNew == null) {
            this.powerNew = this.power.convertToNewFormat();
            this.power = null;
        }
        return this.powerNew;
    }

    public void setPowerNew(org.diylc.core.measures.Power powerNew) {
        this.powerNew = powerNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR);
        g2d.drawLine(0, height / 2, 4, height / 2);
        g2d.drawLine(width - 4, height / 2, width, height / 2);
        g2d.setColor(COLOR);
        g2d.drawPolyline(new int[]{4, 6, 10, 14, 18, 22, 26, 28}, new int[]{height / 2, height / 2 + 2, height / 2 - 2, height / 2 + 2, height / 2 - 2, height / 2 + 2, height / 2 - 2, height / 2}, 8);
    }

    protected Size getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    protected Size getDefaultLength() {
        return DEFAULT_LENGTH;
    }

    protected Shape getBodyShape() {
        GeneralPath polyline = new GeneralPath();
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        polyline.moveTo(0.0, width / 2.0);
        polyline.lineTo(length / 16.0, width);
        polyline.lineTo(3.0 * length / 16.0, 0.0);
        polyline.lineTo(5.0 * length / 16.0, width);
        polyline.lineTo(7.0 * length / 16.0, 0.0);
        polyline.lineTo(9.0 * length / 16.0, width);
        polyline.lineTo(11.0 * length / 16.0, 0.0);
        polyline.lineTo(13.0 * length / 16.0, width);
        polyline.lineTo(15.0 * length / 16.0, 0.0);
        polyline.lineTo(length, width / 2.0);
        return polyline;
    }
}

