/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.semiconductors.ICPointCount;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="IC Symbol", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="IC", description="IC symbol with 3 or 5 contacts", stretchable=false, zOrder=4.0)
public class ICSymbol
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color BODY_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.black;
    protected ICPointCount icPointCount = ICPointCount._5;
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected Color bodyColor = BODY_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Display display = Display.NAME;
    private transient Shape[] body;

    public ICSymbol() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        Shape[] body = this.getBody();
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(body[0]);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = this.borderColor;
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.draw(body[1]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2));
        g2d.draw(body[0]);
        g2d.setFont(LABEL_FONT);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR;
        }
        g2d.setColor(finalLabelColor);
        int x = (this.controlPoints[0].x + this.controlPoints[2].x) / 2;
        this.drawCenteredText(g2d, this.display == Display.VALUE ? this.getValue() : this.getName(), x, this.controlPoints[0].y + pinSpacing, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.drawCenteredText(g2d, "-", this.controlPoints[0].x + pinSpacing, this.controlPoints[0].y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.drawCenteredText(g2d, "+", this.controlPoints[1].x + pinSpacing, this.controlPoints[1].y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 3 * width / 32;
        Area area = new Area(new Polygon(new int[]{margin, margin, width - margin}, new int[]{margin, height - margin, height / 2}, 3));
        area.intersect(new Area(new Rectangle2D.Double(2 * margin, 0.0, width, height)));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.setFont(LABEL_FONT.deriveFont(8.0f));
        this.drawCenteredText(g2d, "-", 3 * margin, height / 3, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.drawCenteredText(g2d, "+", 3 * margin + 1, height * 2 / 3, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        g2d.draw(area);
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.icPointCount.getValue();
    }

    private void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        this.controlPoints[1].x = x;
        this.controlPoints[1].y = y + pinSpacing * 2;
        this.controlPoints[2].x = x + pinSpacing * 6;
        this.controlPoints[2].y = y + pinSpacing;
        this.controlPoints[3].x = x + pinSpacing * 3;
        this.controlPoints[3].y = y - pinSpacing;
        this.controlPoints[4].x = x + pinSpacing * 3;
        this.controlPoints[4].y = y + pinSpacing * 3;
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[2];
            int pinSpacing = (int)PIN_SPACING.convertToPixels();
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            Polygon triangle = new Polygon(new int[]{x + pinSpacing / 2, x + pinSpacing * 11 / 2, x + pinSpacing / 2}, new int[]{y - pinSpacing * 3 / 2, y + pinSpacing, y + pinSpacing * 7 / 2}, 3);
            this.body[0] = triangle;
            GeneralPath polyline = new GeneralPath();
            polyline.moveTo(this.controlPoints[0].x, this.controlPoints[0].y);
            polyline.lineTo(this.controlPoints[0].x + pinSpacing / 2, this.controlPoints[0].y);
            polyline.moveTo(this.controlPoints[1].x, this.controlPoints[1].y);
            polyline.lineTo(this.controlPoints[1].x + pinSpacing / 2, this.controlPoints[1].y);
            polyline.moveTo(this.controlPoints[2].x, this.controlPoints[2].y);
            polyline.lineTo(this.controlPoints[2].x - pinSpacing / 2, this.controlPoints[2].y);
            if (this.icPointCount == ICPointCount._5) {
                polyline.moveTo(this.controlPoints[3].x, this.controlPoints[3].y);
                polyline.lineTo(this.controlPoints[3].x, this.controlPoints[3].y + pinSpacing * 3 / 4);
                polyline.moveTo(this.controlPoints[4].x, this.controlPoints[4].y);
                polyline.lineTo(this.controlPoints[4].x, this.controlPoints[4].y - pinSpacing * 3 / 4);
            }
            this.body[1] = polyline;
        }
        return this.body;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty(name="Contacts")
    public ICPointCount getIcPointCount() {
        return this.icPointCount;
    }

    public void setIcPointCount(ICPointCount icPointCount) {
        this.icPointCount = icPointCount;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }
}

