/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import org.diylc.common.ObjectCache;
import org.diylc.components.tube.AbstractTubeSymbol;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Triode Symbol", author="Branislav Stojkovic", category="Tubes", instanceNamePrefix="V", description="Triode tube symbol", stretchable=false, zOrder=4.0)
public class TriodeSymbol
extends AbstractTubeSymbol {
    private static final long serialVersionUID = 1L;
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected boolean directlyHeated = false;

    public TriodeSymbol() {
        this.updateControlPoints();
    }

    @Override
    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[3];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int pinSpacing = (int)PIN_SPACING.convertToPixels();
            GeneralPath polyline = new GeneralPath();
            polyline.moveTo(x + pinSpacing * 5 / 4, y);
            polyline.lineTo(x + pinSpacing * 7 / 4, y);
            polyline.moveTo(x + pinSpacing * 9 / 4, y);
            polyline.lineTo(x + pinSpacing * 11 / 4, y);
            polyline.moveTo(x + pinSpacing * 13 / 4, y);
            polyline.lineTo(x + pinSpacing * 15 / 4, y);
            polyline.moveTo(x + pinSpacing * 17 / 4, y);
            polyline.lineTo(x + pinSpacing * 19 / 4, y);
            polyline.moveTo(x + pinSpacing * 3 / 2, y - pinSpacing);
            polyline.lineTo(x + pinSpacing * 9 / 2, y - pinSpacing);
            if (this.directlyHeated) {
                polyline.moveTo(this.controlPoints[2].x, this.controlPoints[2].y - pinSpacing);
                polyline.lineTo(this.controlPoints[2].x + pinSpacing, this.controlPoints[2].y - pinSpacing * 2);
                polyline.lineTo(this.controlPoints[4].x, this.controlPoints[4].y - pinSpacing);
            } else {
                polyline.moveTo(x + pinSpacing * 2, y + pinSpacing);
                polyline.lineTo(x + pinSpacing * 4, y + pinSpacing);
            }
            this.body[0] = polyline;
            polyline = new GeneralPath();
            polyline.moveTo(x, y);
            polyline.lineTo(x + pinSpacing, y);
            polyline.moveTo(this.controlPoints[1].x, this.controlPoints[1].y);
            polyline.lineTo(x + pinSpacing * 3, y - pinSpacing);
            if (this.directlyHeated) {
                polyline.moveTo(this.controlPoints[2].x, this.controlPoints[2].y);
                polyline.lineTo(this.controlPoints[2].x, this.controlPoints[2].y - pinSpacing);
                polyline.moveTo(this.controlPoints[4].x, this.controlPoints[4].y);
                polyline.lineTo(this.controlPoints[4].x, this.controlPoints[4].y - pinSpacing);
            } else {
                polyline.moveTo(this.controlPoints[2].x, this.controlPoints[2].y);
                polyline.lineTo(x + pinSpacing * 2, y + pinSpacing);
                if (this.showHeaters) {
                    polyline.moveTo(this.controlPoints[3].x, this.controlPoints[3].y);
                    polyline.lineTo(this.controlPoints[3].x, this.controlPoints[3].y - pinSpacing);
                    polyline.lineTo(this.controlPoints[3].x + pinSpacing / 2, this.controlPoints[3].y - 3 * pinSpacing / 2);
                    polyline.moveTo(this.controlPoints[4].x, this.controlPoints[4].y);
                    polyline.lineTo(this.controlPoints[4].x, this.controlPoints[4].y - pinSpacing);
                    polyline.lineTo(this.controlPoints[4].x - pinSpacing / 2, this.controlPoints[4].y - 3 * pinSpacing / 2);
                }
            }
            this.body[1] = polyline;
            this.body[2] = new Ellipse2D.Double(x + pinSpacing / 2, y - pinSpacing * 5 / 2, pinSpacing * 5, pinSpacing * 5);
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.drawLine(width / 4, height / 4, width * 3 / 4, height / 4);
        g2d.drawLine(width / 2, height / 4, width / 2, 0);
        g2d.drawLine(width / 4 + 2 * width / 32, height * 3 / 4, width * 3 / 4 - 4 * width / 32, height * 3 / 4);
        g2d.drawLine(width / 4 + 2 * width / 32, height * 3 / 4, width / 4 + 2 * width / 32, height - 1);
        g2d.drawOval(1, 1, width - 1 - 2 * width / 32, height - 1 - 2 * width / 32);
        g2d.drawLine(0, height / 2, width / 8, height / 2);
        g2d.setStroke(new BasicStroke(1.0f, 1, 2, 0.0f, new float[]{3.0f}, 6.0f));
        g2d.drawLine(width / 8, height / 2, width * 7 / 8, height / 2);
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    protected void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        this.controlPoints[1].x = x + pinSpacing * 3;
        this.controlPoints[1].y = y - pinSpacing * 3;
        this.controlPoints[2].x = x + pinSpacing * 2;
        this.controlPoints[2].y = y + pinSpacing * 3;
        this.controlPoints[3].x = x + pinSpacing * 3;
        this.controlPoints[3].y = y + pinSpacing * 3;
        this.controlPoints[4].x = x + pinSpacing * 4;
        this.controlPoints[4].y = y + pinSpacing * 3;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        if (this.directlyHeated) {
            return index != 3 ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
        }
        if (this.showHeaters) {
            return VisibilityPolicy.WHEN_SELECTED;
        }
        return index < 3 ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
    }

    public boolean isControlPointSticky(int index) {
        if (this.directlyHeated) {
            return index != 3;
        }
        if (this.showHeaters) {
            return true;
        }
        return index < 3;
    }

    @Override
    protected Point getTextLocation() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        return new Point(this.controlPoints[0].x + pinSpacing * 5, this.controlPoints[0].y + pinSpacing * 2);
    }

    @EditableProperty(name="Directly heated")
    public boolean getDirectlyHeated() {
        return this.directlyHeated;
    }

    public void setDirectlyHeated(boolean directlyHeated) {
        this.directlyHeated = directlyHeated;
        this.body = null;
    }
}

