/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.util.EnumSet;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.file.ProjectDrawingProvider;
import org.diylc.swing.plugins.file.TraceMaskDrawingProvider;

public class FileMenuPlugin
implements IPlugIn {
    private static final String FILE_TITLE = "File";
    private static final String TRACE_MASK_TITLE = "Trace Mask";
    private ProjectDrawingProvider drawingProvider;
    private TraceMaskDrawingProvider traceMaskDrawingProvider;
    private ISwingUI swingUI;

    public FileMenuPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
    }

    @Override
    public void connect(IPlugInPort iPlugInPort) {
        this.drawingProvider = new ProjectDrawingProvider(iPlugInPort, false, true);
        this.traceMaskDrawingProvider = new TraceMaskDrawingProvider(iPlugInPort);
        ActionFactory actionFactory = ActionFactory.getInstance();
        this.swingUI.injectMenuAction(actionFactory.createNewAction(iPlugInPort), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createOpenAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createSaveAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createSaveAsAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(null, FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPDFAction(this.drawingProvider, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPNGAction(this.drawingProvider, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createPrintAction(this.drawingProvider), FILE_TITLE);
        this.swingUI.injectSubmenu(TRACE_MASK_TITLE, IconLoader.TraceMask.getIcon(), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPDFAction(this.traceMaskDrawingProvider, this.swingUI), TRACE_MASK_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPNGAction(this.traceMaskDrawingProvider, this.swingUI), TRACE_MASK_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createPrintAction(this.traceMaskDrawingProvider), TRACE_MASK_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createBomAction(iPlugInPort), FILE_TITLE);
        this.swingUI.injectMenuAction(null, FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExitAction(iPlugInPort), FILE_TITLE);
    }

    @Override
    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    @Override
    public void processMessage(EventType eventType, Object ... objectArray) {
    }
}

