/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.layers;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.ISwingUI;

public class LayersMenuPlugin
implements IPlugIn {
    private static final String LOCK_LAYERS_TITLE = "Lock Layers";
    private IPlugInPort plugInPort;
    private Map<Layer, Action> lockActionMap = new HashMap<Layer, Action>();

    public LayersMenuPlugin(ISwingUI iSwingUI) {
        for (Layer layer : Layer.values()) {
            final int n = layer.getZOrder();
            AbstractAction abstractAction = new AbstractAction(layer.getTitle()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LayersMenuPlugin.this.plugInPort.setLayerLocked(n, (Boolean)this.getValue("SwingSelectedKey"));
                }
            };
            abstractAction.putValue("org.diylc.checkBoxMenuItem", true);
            this.lockActionMap.put(layer, abstractAction);
            iSwingUI.injectMenuAction(abstractAction, LOCK_LAYERS_TITLE);
        }
    }

    @Override
    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
    }

    @Override
    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.LAYER_STATE_CHANGED);
    }

    @Override
    public void processMessage(EventType eventType, Object ... objectArray) {
        if (eventType == EventType.LAYER_STATE_CHANGED) {
            Set set = (Set)objectArray[0];
            for (Layer layer : Layer.values()) {
                this.lockActionMap.get((Object)layer).putValue("SwingSelectedKey", set.contains(layer.getZOrder()));
            }
        }
    }

    static enum Layer {
        CHASSIS("Chassis", 1),
        BOARD("Board", 2),
        TRACE("Trace", 3),
        COMPONENT("Component", 4),
        TEXT("Text", 5);

        String title;
        int zOrder;

        private Layer(String string2, int n2) {
            this.title = string2;
            this.zOrder = n2;
        }

        public String getTitle() {
            return this.title;
        }

        public int getZOrder() {
            return this.zOrder;
        }
    }
}

