/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.IConfigListener;

public class ConfigurationManager {
    private static final Logger LOG = Logger.getLogger(ConfigurationManager.class);
    private static ConfigurationManager instance;
    private XStream xStream;
    private Map<String, Object> configuration;
    private Map<String, List<IConfigListener>> listeners = new HashMap<String, List<IConfigListener>>();

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    private ConfigurationManager() {
        this.xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.initializeConfiguration();
    }

    public void addConfigListener(String key, IConfigListener listener) {
        List<Object> listenerList;
        if (this.listeners.containsKey(key)) {
            listenerList = this.listeners.get(key);
        } else {
            listenerList = new ArrayList();
            this.listeners.put(key, listenerList);
        }
        listenerList.add(listener);
    }

    private void initializeConfiguration() {
        LOG.info((Object)"Initializing configuration");
        File configFile = new File("config.xml");
        try {
            FileInputStream in = new FileInputStream(configFile);
            this.configuration = (Map)this.xStream.fromXML((InputStream)in);
            in.close();
        }
        catch (Exception e) {
            this.configuration = new HashMap<String, Object>();
        }
    }

    public void saveConfigration() {
        LOG.info((Object)"Saving configuration");
        File configFile = new File("config.xml");
        try {
            FileOutputStream out = new FileOutputStream(configFile);
            this.xStream.toXML(this.configuration, (OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Could not save configuration: " + e.getMessage()));
        }
    }

    public boolean readBoolean(String key, boolean defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Boolean)this.configuration.get(key);
        }
        return defaultValue;
    }

    public String readString(String key, String defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (String)this.configuration.get(key);
        }
        return defaultValue;
    }

    public int readInt(String key, int defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Integer)this.configuration.get(key);
        }
        return defaultValue;
    }

    public float readFloat(String key, float defaultValue) {
        if (this.configuration.containsKey(key)) {
            return ((Float)this.configuration.get(key)).floatValue();
        }
        return defaultValue;
    }

    public double readDouble(String key, double defaultValue) {
        if (this.configuration.containsKey(key)) {
            return (Double)this.configuration.get(key);
        }
        return defaultValue;
    }

    public Object readObject(String key, Object defaultValue) {
        if (this.configuration.containsKey(key)) {
            return this.configuration.get(key);
        }
        return defaultValue;
    }

    public void writeValue(String key, Object value) {
        this.configuration.put(key, value);
        this.saveConfigration();
        if (this.listeners.containsKey(key)) {
            for (IConfigListener listener : this.listeners.get(key)) {
                listener.valueChanged(key, value);
            }
        }
    }
}

