/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.appframework.simplemq.IMessageListener;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.appframework.update.Version;
import org.diylc.appframework.update.VersionNumber;
import org.diylc.common.ComponentType;
import org.diylc.common.DrawOption;
import org.diylc.common.EventType;
import org.diylc.common.IComponentFiler;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.components.connectivity.SolderPad;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IDIYComponent;
import org.diylc.core.IView;
import org.diylc.core.Project;
import org.diylc.core.Template;
import org.diylc.core.Theme;
import org.diylc.core.measures.SizeUnit;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComparatorFactory;
import org.diylc.presenter.ComponentProcessor;
import org.diylc.presenter.DrawingManager;
import org.diylc.presenter.InstantiationManager;
import org.diylc.presenter.ProjectFileManager;

public class Presenter
implements IPlugInPort {
    private static final Logger LOG = Logger.getLogger(Presenter.class);
    public static VersionNumber CURRENT_VERSION = new VersionNumber(3, 0, 0);
    public static final String DEFAULTS_KEY_PREFIX = "default.";
    public static final List<IDIYComponent<?>> EMPTY_SELECTION;
    public static final int ICON_SIZE = 32;
    private Project currentProject;
    private Map<String, List<ComponentType>> componentTypes;
    private List<IPlugIn> plugIns;
    private List<IDIYComponent<?>> selectedComponents;
    private Map<IDIYComponent<?>, Set<Integer>> controlPointMap;
    private Set<IDIYComponent<?>> lockedComponents;
    private DrawingManager drawingManager;
    private ProjectFileManager projectFileManager;
    private InstantiationManager instantiationManager;
    private Rectangle selectionRect;
    private final IView view;
    private MessageDispatcher<EventType> messageDispatcher;
    private boolean dragInProgress = false;
    private Point previousDragPoint = null;
    private Project preDragProject = null;
    private int dragAction;
    private Point previousScaledPoint;

    public Presenter(IView iView) {
        this.view = iView;
        this.plugIns = new ArrayList<IPlugIn>();
        this.messageDispatcher = new MessageDispatcher(true);
        this.selectedComponents = new ArrayList();
        this.lockedComponents = new HashSet();
        this.currentProject = new Project();
        this.drawingManager = new DrawingManager(this.messageDispatcher);
        this.projectFileManager = new ProjectFileManager(this.messageDispatcher);
        this.instantiationManager = new InstantiationManager();
    }

    public void installPlugin(IPlugIn iPlugIn) {
        LOG.info((Object)String.format("installPlugin(%s)", iPlugIn.getClass().getSimpleName()));
        this.plugIns.add(iPlugIn);
        iPlugIn.connect(this);
        this.messageDispatcher.registerListener((IMessageListener)iPlugIn);
    }

    public void dispose() {
        for (IPlugIn iPlugIn : this.plugIns) {
            this.messageDispatcher.unregisterListener((IMessageListener)iPlugIn);
        }
    }

    @Override
    public Double[] getAvailableZoomLevels() {
        return new Double[]{0.25, 0.3333, 0.5, 0.6667, 0.75, 1.0, 1.25, 1.5, 2.0};
    }

    @Override
    public double getZoomLevel() {
        return this.drawingManager.getZoomLevel();
    }

    @Override
    public void setZoomLevel(double d) {
        LOG.info((Object)String.format("setZoomLevel(%s)", d));
        if (this.drawingManager.getZoomLevel() == d) {
            return;
        }
        this.drawingManager.setZoomLevel(d);
    }

    @Override
    public Cursor getCursorAt(Point point) {
        if (this.instantiationManager.getComponentTypeSlot() == null) {
            Point point2 = this.scalePoint(point);
            if (this.controlPointMap != null && !this.controlPointMap.isEmpty()) {
                return Cursor.getPredefinedCursor(12);
            }
            for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
                Area area;
                if (this.isComponentLocked(iDIYComponent) || (area = this.drawingManager.getComponentArea(iDIYComponent)) == null || !area.contains(point2)) continue;
                return Cursor.getPredefinedCursor(12);
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public Dimension getCanvasDimensions(boolean bl) {
        return this.drawingManager.getCanvasDimensions(this.currentProject, this.drawingManager.getZoomLevel(), bl);
    }

    @Override
    public Project getCurrentProject() {
        return this.currentProject;
    }

    @Override
    public void loadProject(Project project, boolean bl) {
        LOG.info((Object)String.format("loadProject(%s, %s)", project.getTitle(), bl));
        this.currentProject = project;
        this.drawingManager.clearComponentAreaMap();
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_LOADED, new Object[]{project, bl});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_STATE_CHANGED, new Object[]{this.currentProject.getLockedLayers()});
    }

    @Override
    public void createNewProject() {
        LOG.info((Object)"createNewFile()");
        try {
            Project project = new Project();
            this.instantiationManager.fillWithDefaultProperties(project, null);
            this.loadProject(project, true);
            this.projectFileManager.startNewFile();
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not create new file", (Throwable)exception);
            this.view.showMessage("Could not create a new file. Check the log for details.", "Error", 0);
        }
    }

    @Override
    public void loadProjectFromFile(String string) {
        LOG.info((Object)String.format("loadProjectFromFile(%s)", string));
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Project project = this.projectFileManager.deserializeProjectFromFile(string, arrayList);
            this.loadProject(project, true);
            this.projectFileManager.fireFileStatusChanged();
            if (!arrayList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("<html>File was opened, but there were some issues with it:<br><br>");
                for (String string2 : arrayList) {
                    stringBuilder.append(string2);
                    stringBuilder.append("<br>");
                }
                stringBuilder.append("</html");
                this.view.showMessage(stringBuilder.toString(), "Warning", 2);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not load file", (Throwable)exception);
            this.view.showMessage("Could not open file " + string + ". Check the log for details.", "Error", 0);
        }
    }

    @Override
    public boolean allowFileAction() {
        if (this.projectFileManager.isModified()) {
            int n = this.view.showConfirmDialog("There are unsaved changes. Would you like to save them?", "Warning", 1, 2);
            if (n == 0) {
                if (this.getCurrentFileName() == null) {
                    File file = this.view.promptFileSave();
                    if (file == null) {
                        return false;
                    }
                    this.saveProjectToFile(file.getAbsolutePath(), false);
                } else {
                    this.saveProjectToFile(this.getCurrentFileName(), false);
                }
            }
            return n != 2;
        }
        return true;
    }

    @Override
    public void saveProjectToFile(String string, boolean bl) {
        block2: {
            LOG.info((Object)String.format("saveProjectToFile(%s)", string));
            try {
                this.currentProject.setFileVersion(CURRENT_VERSION);
                this.projectFileManager.serializeProjectToFile(this.currentProject, string, bl);
            }
            catch (Exception exception) {
                LOG.error((Object)"Could not save file", (Throwable)exception);
                if (bl) break block2;
                this.view.showMessage("Could not save file " + string + ". Check the log for details.", "Error", 0);
            }
        }
    }

    @Override
    public String getCurrentFileName() {
        return this.projectFileManager.getCurrentFileName();
    }

    @Override
    public boolean isProjectModified() {
        return this.projectFileManager.isModified();
    }

    @Override
    public Map<String, List<ComponentType>> getComponentTypes() {
        if (this.componentTypes == null) {
            LOG.info((Object)"Loading component types.");
            this.componentTypes = new HashMap<String, List<ComponentType>>();
            Set set = null;
            try {
                set = Utils.getClasses((String)"org.diylc.components");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (Class clazz : set) {
                List<Object> list;
                if (Modifier.isAbstract(clazz.getModifiers()) || !IDIYComponent.class.isAssignableFrom(clazz)) continue;
                ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(clazz);
                if (this.componentTypes.containsKey(componentType.getCategory())) {
                    list = this.componentTypes.get(componentType.getCategory());
                } else {
                    list = new ArrayList();
                    this.componentTypes.put(componentType.getCategory(), list);
                }
                list.add(componentType);
            }
        }
        return this.componentTypes;
    }

    @Override
    public void draw(Graphics2D graphics2D, Set<DrawOption> set, IComponentFiler iComponentFiler) {
        IDIYComponent<?> iDIYComponent2;
        if (this.currentProject == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        for (IDIYComponent<?> iDIYComponent2 : this.currentProject.getComponents()) {
            if (this.findAllGroupedComponents(iDIYComponent2).size() <= 1) continue;
            hashSet.add(iDIYComponent2);
        }
        Object object = this.instantiationManager.getFirstControlPoint() != null && this.instantiationManager.getPotentialControlPoint() != null && this.instantiationManager.getFirstControlPoint().equals(this.instantiationManager.getPotentialControlPoint()) ? null : this.instantiationManager.getComponentSlot();
        iDIYComponent2 = this.drawingManager.drawProject(graphics2D, this.currentProject, set, iComponentFiler, this.selectionRect, this.selectedComponents, this.getLockedComponents(), hashSet, Arrays.asList(this.instantiationManager.getFirstControlPoint(), this.instantiationManager.getPotentialControlPoint()), (List<IDIYComponent<?>>)object, this.dragInProgress);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = iDIYComponent2.iterator();
        while (iterator.hasNext()) {
            IDIYComponent iDIYComponent3 = (IDIYComponent)iterator.next();
            arrayList.add(iDIYComponent3.getName());
        }
        Collections.sort(arrayList);
        if (!arrayList.isEmpty()) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.STATUS_MESSAGE_CHANGED, new Object[]{"<html><font color='red'>Failed to draw components: " + Utils.toCommaString(arrayList) + "</font></html>"});
        } else {
            this.messageDispatcher.dispatchMessage((Enum)EventType.STATUS_MESSAGE_CHANGED, new Object[]{""});
        }
    }

    public List<IDIYComponent<?>> findComponentsAtScaled(Point point) {
        List<IDIYComponent<?>> list = this.drawingManager.findComponentsAt(point, this.currentProject);
        Iterator<IDIYComponent<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.isComponentLocked(iterator.next())) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public List<IDIYComponent<?>> findComponentsAt(Point point) {
        Point point2 = this.scalePoint(point);
        List<IDIYComponent<?>> list = this.findComponentsAtScaled(point2);
        return list;
    }

    @Override
    public void mouseClicked(Point point, int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        LOG.debug((Object)String.format("mouseClicked(%s, %s, %s, %s, %s)", point, n, bl, bl2, bl3));
        Point point2 = this.scalePoint(point);
        if (n2 >= 2) {
            this.editSelection();
        } else if (this.instantiationManager.getComponentTypeSlot() != null) {
            if (n != 1) {
                this.instantiationManager.tryToRotateComponentSlot();
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                return;
            }
            ComponentType componentType = this.instantiationManager.getComponentTypeSlot();
            Template template = this.instantiationManager.getTemplate();
            Project project = this.currentProject.clone();
            switch (componentType.getCreationMethod()) {
                case SINGLE_CLICK: {
                    try {
                        if (this.isSnapToGrid()) {
                            CalcUtils.snapPointToGrid(point2, this.currentProject.getGridSpacing());
                        }
                        List<IDIYComponent<?>> list = this.instantiationManager.getComponentSlot();
                        ArrayList arrayList = new ArrayList();
                        for (IDIYComponent<?> iDIYComponent : list) {
                            this.addComponent(iDIYComponent, true);
                            arrayList.add(iDIYComponent);
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        this.updateSelection(arrayList);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)("Error instatiating component of type: " + componentType.getInstanceClass().getName()), (Throwable)exception);
                    }
                    if (componentType.isAutoEdit() && ConfigurationManager.getInstance().readBoolean("autoEdit", false)) {
                        this.editSelection();
                    }
                    if (ConfigurationManager.getInstance().readBoolean("continuousCreation", false)) {
                        this.setNewComponentTypeSlot(componentType, template);
                        break;
                    }
                    this.setNewComponentTypeSlot(null, null);
                    break;
                }
                case POINT_BY_POINT: {
                    if (this.isSnapToGrid()) {
                        CalcUtils.snapPointToGrid(point2, this.currentProject.getGridSpacing());
                    }
                    if (this.instantiationManager.getComponentSlot() == null) {
                        try {
                            this.instantiationManager.instatiatePointByPoint(point2, this.currentProject);
                        }
                        catch (Exception exception) {
                            this.view.showMessage("Could not create component. Check log for details.", "Error", 0);
                            LOG.error((Object)"Could not create component", (Throwable)exception);
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{componentType, this.instantiationManager.getFirstControlPoint()});
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        break;
                    }
                    List<IDIYComponent<?>> list = this.instantiationManager.getComponentSlot();
                    list.get(0).setControlPoint(point2, 1);
                    ArrayList arrayList = new ArrayList();
                    for (IDIYComponent<?> iDIYComponent : list) {
                        this.addComponent(iDIYComponent, true);
                        if (this.isComponentLocked(iDIYComponent)) continue;
                        arrayList.add(iDIYComponent);
                    }
                    this.updateSelection(arrayList);
                    this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                    if (componentType.isAutoEdit() && ConfigurationManager.getInstance().readBoolean("autoEdit", false)) {
                        this.editSelection();
                    }
                    if (ConfigurationManager.getInstance().readBoolean("continuousCreation", false)) {
                        this.setNewComponentTypeSlot(componentType, template);
                        break;
                    }
                    this.setNewComponentTypeSlot(null, null);
                    break;
                }
                default: {
                    LOG.error((Object)("Unknown creation method: " + (Object)((Object)componentType.getCreationMethod())));
                }
            }
            if (!project.equals(this.currentProject)) {
                this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Add " + componentType.getName()});
                this.projectFileManager.notifyFileChange();
            }
        } else {
            ArrayList arrayList = new ArrayList(this.selectedComponents);
            List<IDIYComponent<?>> list = this.findComponentsAtScaled(point2);
            if (list.isEmpty()) {
                if (!bl) {
                    arrayList.clear();
                }
            } else {
                IDIYComponent<?> iDIYComponent = list.get(0);
                if (bl) {
                    if (arrayList.contains(iDIYComponent)) {
                        arrayList.removeAll(this.findAllGroupedComponents(iDIYComponent));
                    } else {
                        arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
                    }
                } else {
                    arrayList.clear();
                    arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
                }
            }
            this.updateSelection(arrayList);
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        LOG.debug((Object)String.format("keyPressed(%s, %s, %s, %s)", n, bl, bl2, bl3));
        HashMap hashMap = new HashMap();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (iDIYComponent.getControlPointCount() <= 0) continue;
            for (n2 = 0; n2 < iDIYComponent.getControlPointCount(); ++n2) {
                hashSet.add(n2);
            }
            hashMap.put(iDIYComponent, hashSet);
        }
        if (hashMap.isEmpty()) {
            return false;
        }
        boolean bl4 = ConfigurationManager.getInstance().readBoolean("stickyPoints", true);
        if (bl) {
            boolean bl5 = bl4 = !bl4;
        }
        if (bl4) {
            this.includeStuckComponents(hashMap);
        }
        boolean bl6 = ConfigurationManager.getInstance().readBoolean("snapToGrid", true);
        if (bl2) {
            bl6 = !bl6;
        }
        int n3 = bl6 ? (int)this.currentProject.getGridSpacing().convertToPixels() : 1;
        n2 = 0;
        int n4 = 0;
        switch (n) {
            case 40: {
                n4 = n3;
                break;
            }
            case 37: {
                n2 = -n3;
                break;
            }
            case 38: {
                n4 = -n3;
                break;
            }
            case 39: {
                n2 = n3;
                break;
            }
            default: {
                return false;
            }
        }
        Project project = this.currentProject.clone();
        this.moveSelectedComponents(hashMap, n2, n4, bl6);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Move Selection"});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        return true;
    }

    @Override
    public void editSelection() {
        HashSet<PropertyWrapper> hashSet;
        boolean bl;
        List<PropertyWrapper> list = this.getMutualSelectionProperties();
        if (list != null && !list.isEmpty() && (bl = this.view.editProperties(list, hashSet = new HashSet<PropertyWrapper>()))) {
            try {
                this.applyPropertiesToSelection(list);
            }
            catch (Exception exception) {
                this.view.showMessage("Error occured while editing selection. Check the log for details.", "Error", 0);
                LOG.error((Object)"Error applying properties", (Throwable)exception);
            }
            for (PropertyWrapper propertyWrapper : hashSet) {
                if (propertyWrapper.getValue() == null) continue;
                this.setSelectionDefaultPropertyValue(propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }

    @Override
    public void mouseMoved(Point point, boolean bl, boolean bl2, boolean bl3) {
        HashMap hashMap = new HashMap();
        this.previousScaledPoint = this.scalePoint(point);
        if (this.instantiationManager.getComponentTypeSlot() != null) {
            if (this.isSnapToGrid()) {
                CalcUtils.snapPointToGrid(this.previousScaledPoint, this.currentProject.getGridSpacing());
            }
            boolean bl4 = false;
            switch (this.instantiationManager.getComponentTypeSlot().getCreationMethod()) {
                case POINT_BY_POINT: {
                    bl4 = this.instantiationManager.updatePointByPoint(this.previousScaledPoint);
                    break;
                }
                case SINGLE_CLICK: {
                    bl4 = this.instantiationManager.updateSingleClick(this.previousScaledPoint, this.isSnapToGrid(), this.currentProject.getGridSpacing());
                }
            }
            if (bl4) {
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
        } else {
            block6: for (int i = this.currentProject.getComponents().size() - 1; i >= 0; --i) {
                IDIYComponent<?> iDIYComponent = this.currentProject.getComponents().get(i);
                ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
                for (int j = 0; j < iDIYComponent.getControlPointCount(); ++j) {
                    Point point2 = iDIYComponent.getControlPoint(j);
                    if (!this.selectedComponents.contains(iDIYComponent) || !componentType.isStretchable() || this.findAllGroupedComponents(iDIYComponent).size() != 1) continue;
                    try {
                        if (!(this.previousScaledPoint.distance(point2) < (double)DrawingManager.CONTROL_POINT_SIZE)) continue;
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        if (componentType.isStretchable()) {
                            hashSet.add(j);
                        } else {
                            for (int k = 0; k < iDIYComponent.getControlPointCount(); ++k) {
                                hashSet.add(k);
                            }
                        }
                        hashMap.put(iDIYComponent, hashSet);
                        continue block6;
                    }
                    catch (Exception exception) {
                        LOG.warn((Object)("Error reading control point for component of type: " + iDIYComponent.getClass().getName()));
                    }
                }
            }
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.MOUSE_MOVED, new Object[]{this.previousScaledPoint});
        if (!((Object)hashMap).equals(this.controlPointMap)) {
            this.controlPointMap = hashMap;
            this.messageDispatcher.dispatchMessage((Enum)EventType.AVAILABLE_CTRL_POINTS_CHANGED, new Object[]{new HashMap(hashMap)});
        }
    }

    @Override
    public List<IDIYComponent<?>> getSelectedComponents() {
        return this.selectedComponents;
    }

    @Override
    public void selectAll() {
        LOG.info((Object)"selectAll()");
        ArrayList arrayList = new ArrayList(this.currentProject.getComponents());
        arrayList.removeAll(this.getLockedComponents());
        this.updateSelection(arrayList);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public VersionNumber getCurrentVersionNumber() {
        return CURRENT_VERSION;
    }

    @Override
    public void dragStarted(Point point, int n) {
        Point point2;
        LOG.debug((Object)String.format("dragStarted(%s, %s)", point, n));
        if (this.instantiationManager.getComponentTypeSlot() != null) {
            LOG.debug((Object)"Cannot start drag because a new component is being created.");
            this.mouseClicked(point, 1, n == 1, n == 0x40000000, n == 2, 1);
            return;
        }
        this.dragInProgress = true;
        this.dragAction = n;
        this.preDragProject = this.currentProject.clone();
        this.previousDragPoint = point2 = this.scalePoint(point);
        List<IDIYComponent<?>> list = this.findComponentsAtScaled(point2);
        if (!this.controlPointMap.isEmpty()) {
            this.updateSelection(new ArrayList(this.controlPointMap.keySet()));
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        } else if (list.isEmpty()) {
            this.updateSelection(EMPTY_SELECTION);
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        } else {
            IDIYComponent<?> iDIYComponent = list.get(0);
            if (!this.selectedComponents.contains(iDIYComponent)) {
                this.updateSelection(new ArrayList(this.findAllGroupedComponents(iDIYComponent)));
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
            for (IDIYComponent<?> iDIYComponent2 : this.selectedComponents) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                if (iDIYComponent2.getControlPointCount() <= 0) continue;
                for (int i = 0; i < iDIYComponent2.getControlPointCount(); ++i) {
                    hashSet.add(i);
                }
                this.controlPointMap.put(iDIYComponent2, hashSet);
            }
            boolean bl = ConfigurationManager.getInstance().readBoolean("stickyPoints", true);
            if (this.dragAction == 1) {
                boolean bl2 = bl = !bl;
            }
            if (bl) {
                this.includeStuckComponents(this.controlPointMap);
            }
        }
    }

    @Override
    public void dragActionChanged(int n) {
        LOG.debug((Object)("dragActionChanged(" + n + ")"));
        this.dragAction = n;
    }

    private void includeStuckComponents(Map<IDIYComponent<?>, Set<Integer>> map) {
        int n = map.size();
        LOG.trace((Object)"Expanding selected component map");
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                if (map.containsKey(iDIYComponent) && map.get(iDIYComponent).contains(i) || this.isComponentLocked(iDIYComponent) || !iDIYComponent.isControlPointSticky(i)) continue;
                boolean bl = false;
                block2: for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
                    if (bl) break;
                    for (Integer n2 : entry.getValue()) {
                        Point point;
                        Point point2 = iDIYComponent.getControlPoint(i);
                        if (!entry.getKey().isControlPointSticky(n2) || !(point2.distance(point = entry.getKey().getControlPoint(n2)) < (double)DrawingManager.CONTROL_POINT_SIZE)) continue;
                        bl = true;
                        continue block2;
                    }
                }
                if (!bl) continue;
                LOG.trace((Object)("Including component: " + iDIYComponent));
                HashSet hashSet = new HashSet();
                if (componentType.isStretchable()) {
                    hashSet.add(i);
                } else {
                    for (int j = 0; j < iDIYComponent.getControlPointCount(); ++j) {
                        hashSet.add(j);
                    }
                }
                if (map.containsKey(iDIYComponent)) {
                    map.get(iDIYComponent).addAll(hashSet);
                    continue;
                }
                map.put(iDIYComponent, hashSet);
            }
        }
        int n3 = map.size();
        if (n3 > n) {
            LOG.trace((Object)"Component count changed, trying one more time.");
            this.includeStuckComponents(map);
        } else {
            LOG.trace((Object)"Component count didn't change, done with expanding.");
        }
    }

    private boolean isSnapToGrid() {
        boolean bl = ConfigurationManager.getInstance().readBoolean("snapToGrid", true);
        if (this.dragAction == 0x40000000) {
            bl = !bl;
        }
        return bl;
    }

    @Override
    public boolean dragOver(Point point) {
        if (point == null) {
            return false;
        }
        Point point2 = this.scalePoint(point);
        if (!this.controlPointMap.isEmpty()) {
            int n = point2.x - this.previousDragPoint.x;
            int n2 = point2.y - this.previousDragPoint.y;
            Point point3 = this.moveSelectedComponents(this.controlPointMap, n, n2, this.isSnapToGrid());
            if (point3 == null) {
                return true;
            }
            this.previousDragPoint.translate(point3.x, point3.y);
        } else if (this.selectedComponents.isEmpty() && this.instantiationManager.getComponentTypeSlot() == null) {
            Rectangle rectangle = this.selectionRect == null ? null : new Rectangle(this.selectionRect);
            this.selectionRect = Utils.createRectangle((Point)point2, (Point)this.previousDragPoint);
            if (this.selectionRect.equals(rectangle)) {
                return true;
            }
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        return true;
    }

    private Point moveSelectedComponents(Map<IDIYComponent<?>, Set<Integer>> map, int n, int n2, boolean bl) {
        IDIYComponent<?> iDIYComponent;
        int n3 = 0;
        int n4 = 0;
        int n5 = (int)this.currentProject.getWidth().convertToPixels();
        int n6 = (int)this.currentProject.getHeight().convertToPixels();
        boolean bl2 = true;
        for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
            int n7;
            iDIYComponent = entry.getKey();
            Point[] pointArray = new Point[iDIYComponent.getControlPointCount()];
            for (n7 = 0; n7 < iDIYComponent.getControlPointCount(); ++n7) {
                pointArray[n7] = new Point(iDIYComponent.getControlPoint(n7));
                if (entry.getValue().contains(n7)) {
                    if (bl2) {
                        bl2 = false;
                        Point point = new Point((Point)pointArray[n7]);
                        point.translate(n, n2);
                        if (bl) {
                            CalcUtils.snapPointToGrid(point, this.currentProject.getGridSpacing());
                        }
                        n3 = point.x - iDIYComponent.getControlPoint((int)n7).x;
                        n4 = point.y - iDIYComponent.getControlPoint((int)n7).y;
                        if (n3 == 0 && n4 == 0) {
                            return null;
                        }
                    }
                    ((Point)pointArray[n7]).translate(n3, n4);
                    if (((Point)pointArray[n7]).x < 0 || ((Point)pointArray[n7]).y < 0 || ((Point)pointArray[n7]).x > n5 || ((Point)pointArray[n7]).y > n6) {
                        return null;
                    }
                }
                if (!iDIYComponent.canControlPointOverlap(n7)) continue;
                pointArray[n7] = null;
            }
            for (n7 = 0; n7 < pointArray.length - 1; ++n7) {
                for (int i = n7 + 1; i < pointArray.length; ++i) {
                    if (pointArray[n7] == null || pointArray[i] == null || !((Point)pointArray[n7]).equals(pointArray[i])) continue;
                    return null;
                }
            }
        }
        for (Map.Entry<IDIYComponent<?>, Set<Integer>> entry : map.entrySet()) {
            iDIYComponent = entry.getKey();
            this.drawingManager.invalidateComponent(iDIYComponent);
            for (Integer n8 : entry.getValue()) {
                Point point = new Point(iDIYComponent.getControlPoint(n8));
                point.translate(n3, n4);
                iDIYComponent.setControlPoint(point, n8);
            }
        }
        return new Point(n3, n4);
    }

    @Override
    public void dragEnded(Point point) {
        LOG.debug((Object)String.format("dragEnded(%s)", point));
        if (!this.dragInProgress) {
            return;
        }
        Point point2 = this.scalePoint(point);
        if (this.selectedComponents.isEmpty()) {
            if (point2 != null) {
                this.selectionRect = Utils.createRectangle((Point)point2, (Point)this.previousDragPoint);
            }
            ArrayList arrayList = new ArrayList();
            for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
                Area area;
                if (this.isComponentLocked(iDIYComponent) || (area = this.drawingManager.getComponentArea(iDIYComponent)) == null || this.selectionRect == null || !area.intersects(this.selectionRect)) continue;
                arrayList.addAll(this.findAllGroupedComponents(iDIYComponent));
            }
            this.selectionRect = null;
            this.updateSelection(arrayList);
        } else {
            this.updateSelection(this.selectedComponents);
        }
        if (!this.preDragProject.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{this.preDragProject, this.currentProject.clone(), "Drag"});
            this.projectFileManager.notifyFileChange();
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.dragInProgress = false;
    }

    @Override
    public void pasteComponents(List<IDIYComponent<?>> list) {
        LOG.info((Object)String.format("pasteComponents(%s)", list));
        this.instantiationManager.pasteComponents(list, this.previousScaledPoint, this.isSnapToGrid(), this.currentProject.getGridSpacing());
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{this.instantiationManager.getComponentTypeSlot(), this.instantiationManager.getFirstControlPoint()});
    }

    @Override
    public void deleteSelectedComponents() {
        LOG.info((Object)"deleteSelectedComponents()");
        if (this.selectedComponents.isEmpty()) {
            LOG.debug((Object)"Nothing to delete");
            return;
        }
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            this.drawingManager.invalidateComponent(iDIYComponent);
        }
        this.currentProject.getComponents().removeAll(this.selectedComponents);
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Delete"});
        this.projectFileManager.notifyFileChange();
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void setSelectionDefaultPropertyValue(String string, Object object) {
        LOG.info((Object)String.format("setSelectionDefaultPropertyValue(%s, %s)", string, object));
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            String string2 = iDIYComponent.getClass().getName();
            LOG.debug((Object)("Default property value set for " + string2 + ":" + string));
            ConfigurationManager.getInstance().writeValue(DEFAULTS_KEY_PREFIX + string2 + ":" + string, object);
        }
    }

    @Override
    public void setProjectDefaultPropertyValue(String string, Object object) {
        LOG.info((Object)String.format("setProjectDefaultPropertyValue(%s, %s)", string, object));
        LOG.debug((Object)("Default property value set for " + Project.class.getName() + ":" + string));
        ConfigurationManager.getInstance().writeValue(DEFAULTS_KEY_PREFIX + Project.class.getName() + ":" + string, object);
    }

    @Override
    public void setMetric(boolean bl) {
        ConfigurationManager.getInstance().writeValue("metric", (Object)bl);
    }

    @Override
    public void groupSelectedComponents() {
        LOG.info((Object)"groupSelectedComponents()");
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        this.currentProject.getGroups().add(new HashSet(this.selectedComponents));
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Group"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void ungroupSelectedComponents() {
        LOG.info((Object)"ungroupSelectedComponents()");
        Project project = this.currentProject.clone();
        this.ungroupComponents(this.selectedComponents);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Ungroup"});
            this.projectFileManager.notifyFileChange();
        }
    }

    @Override
    public void setLayerLocked(int n, boolean bl) {
        LOG.info((Object)String.format("setLayerLocked(%s, %s)", n, bl));
        if (bl) {
            this.currentProject.getLockedLayers().add(n);
        } else {
            this.currentProject.getLockedLayers().remove(n);
        }
        this.updateSelection(EMPTY_SELECTION);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        this.messageDispatcher.dispatchMessage((Enum)EventType.LAYER_STATE_CHANGED, new Object[]{this.currentProject.getLockedLayers()});
    }

    @Override
    public void sendSelectionToBack() {
        LOG.info((Object)"sendSelectionToBack()");
        Project project = this.currentProject.clone();
        block0: for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            int n = this.currentProject.getComponents().indexOf(iDIYComponent);
            if (n < 0) {
                LOG.warn((Object)("Component not found in the project: " + iDIYComponent.getName()));
                continue;
            }
            while (n > 0) {
                IDIYComponent<?> iDIYComponent2 = this.currentProject.getComponents().get(n - 1);
                ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                if (!componentType.isFlexibleZOrder() && componentType2.getZOrder() < componentType.getZOrder()) continue block0;
                Collections.swap(this.currentProject.getComponents(), n, n - 1);
                --n;
            }
        }
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Send to Back"});
            this.projectFileManager.notifyFileChange();
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    @Override
    public void bringSelectionToFront() {
        LOG.info((Object)"bringSelectionToFront()");
        Project project = this.currentProject.clone();
        block0: for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            int n = this.currentProject.getComponents().indexOf(iDIYComponent);
            if (n < 0) {
                LOG.warn((Object)("Component not found in the project: " + iDIYComponent.getName()));
                continue;
            }
            while (n < this.currentProject.getComponents().size() - 1) {
                IDIYComponent<?> iDIYComponent2 = this.currentProject.getComponents().get(n + 1);
                ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                if (!componentType.isFlexibleZOrder() && componentType2.getZOrder() > componentType.getZOrder()) continue block0;
                Collections.swap(this.currentProject.getComponents(), n, n + 1);
                ++n;
            }
        }
        if (!project.equals(this.currentProject)) {
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Bring to Front"});
            this.projectFileManager.notifyFileChange();
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
        }
    }

    @Override
    public void refresh() {
        LOG.info((Object)"refresh()");
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public Theme getSelectedTheme() {
        return this.drawingManager.getTheme();
    }

    @Override
    public void setSelectedTheme(Theme theme) {
        this.drawingManager.setTheme(theme);
    }

    @Override
    public void renumberSelectedComponents(final boolean bl) {
        LOG.info((Object)("renumberSelectedComponents(" + bl + ")"));
        if (this.getSelectedComponents().isEmpty()) {
            return;
        }
        Project project = this.currentProject.clone();
        ArrayList arrayList = new ArrayList(this.getSelectedComponents());
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                int n;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n = 0; n < iDIYComponent.getControlPointCount(); ++n) {
                    n2 = (int)((double)n2 + iDIYComponent.getControlPoint(n).getX());
                    n3 = (int)((double)n3 + iDIYComponent.getControlPoint(n).getY());
                }
                for (n = 0; n < iDIYComponent2.getControlPointCount(); ++n) {
                    n4 = (int)((double)n4 + iDIYComponent2.getControlPoint(n).getX());
                    n5 = (int)((double)n5 + iDIYComponent2.getControlPoint(n).getY());
                }
                n2 /= iDIYComponent.getControlPointCount();
                n3 /= iDIYComponent.getControlPointCount();
                n4 /= iDIYComponent2.getControlPointCount();
                n5 /= iDIYComponent2.getControlPointCount();
                if (bl) {
                    if (n3 < n5) {
                        return -1;
                    }
                    if (n3 > n5) {
                        return 1;
                    }
                    if (n2 < n4) {
                        return -1;
                    }
                    if (n2 > n4) {
                        return 1;
                    }
                } else {
                    if (n2 < n4) {
                        return -1;
                    }
                    if (n2 > n4) {
                        return 1;
                    }
                    if (n3 < n5) {
                        return -1;
                    }
                    if (n3 > n5) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        for (IDIYComponent iDIYComponent : arrayList) {
            iDIYComponent.setName("");
        }
        for (IDIYComponent iDIYComponent : arrayList) {
            iDIYComponent.setName(this.instantiationManager.createUniqueName(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()), this.currentProject));
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Renumber selection"});
        this.projectFileManager.notifyFileChange();
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public void updateSelection(List<IDIYComponent<?>> list) {
        this.selectedComponents = list;
        HashMap hashMap = new HashMap();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                hashSet.add(i);
            }
            hashMap.put(iDIYComponent, hashSet);
        }
        if (ConfigurationManager.getInstance().readBoolean("stickyPoints", true)) {
            this.includeStuckComponents(hashMap);
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.SELECTION_CHANGED, new Object[]{this.selectedComponents, hashMap.keySet()});
    }

    @Override
    public void expandSelection(ExpansionMode expansionMode) {
        LOG.info((Object)String.format("expandSelection(%s)", new Object[]{expansionMode}));
        ArrayList arrayList = new ArrayList(this.selectedComponents);
        HashSet<String> hashSet = new HashSet<String>();
        if (expansionMode == ExpansionMode.SAME_TYPE) {
            for (IDIYComponent<?> iDIYComponent : this.getSelectedComponents()) {
                hashSet.add(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getNamePrefix());
            }
        }
        for (IDIYComponent<?> iDIYComponent : this.getCurrentProject().getComponents()) {
            Area area = this.drawingManager.getComponentArea(iDIYComponent);
            if (arrayList.contains(iDIYComponent) || !iDIYComponent.isControlPointSticky(0) || area == null) continue;
            boolean bl = false;
            for (IDIYComponent<?> iDIYComponent2 : this.selectedComponents) {
                Area area2 = this.drawingManager.getComponentArea(iDIYComponent2);
                if (area2 == null) continue;
                Area area3 = new Area(area);
                area3.intersect(area2);
                if (area3.isEmpty()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            switch (expansionMode) {
                case ALL: 
                case IMMEDIATE: {
                    arrayList.add(iDIYComponent);
                    break;
                }
                case SAME_TYPE: {
                    if (!hashSet.contains(ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getNamePrefix())) break;
                    arrayList.add(iDIYComponent);
                }
            }
        }
        int n = this.getSelectedComponents().size();
        this.updateSelection(arrayList);
        if (arrayList.size() > n && expansionMode != ExpansionMode.IMMEDIATE) {
            this.expandSelection(expansionMode);
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    private void ungroupComponents(Collection<IDIYComponent<?>> collection) {
        Iterator<Set<IDIYComponent<?>>> iterator = this.currentProject.getGroups().iterator();
        while (iterator.hasNext()) {
            Set<IDIYComponent<IDIYComponent<?>>> set = iterator.next();
            set.removeAll(collection);
            if (!set.isEmpty()) continue;
            iterator.remove();
        }
    }

    private Set<IDIYComponent<?>> findAllGroupedComponents(IDIYComponent<?> iDIYComponent) {
        HashSet hashSet = new HashSet();
        hashSet.add(iDIYComponent);
        for (Set<IDIYComponent<?>> set : this.currentProject.getGroups()) {
            if (!set.contains(iDIYComponent)) continue;
            hashSet.addAll(set);
            break;
        }
        return hashSet;
    }

    @Override
    public Point2D calculateSelectionDimension() {
        if (this.selectedComponents.isEmpty()) {
            return null;
        }
        boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
        Area area = new Area();
        for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
            Area area2 = this.drawingManager.getComponentArea(iDIYComponent);
            if (area2 != null) {
                area.add(area2);
                continue;
            }
            LOG.warn((Object)("No area found for: " + iDIYComponent.getName()));
        }
        double d = area.getBounds2D().getWidth();
        double d2 = area.getBounds2D().getHeight();
        d /= 200.0;
        d2 /= 200.0;
        if (bl) {
            d *= SizeUnit.in.getFactor() / SizeUnit.cm.getFactor();
            d2 *= SizeUnit.in.getFactor() / SizeUnit.cm.getFactor();
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        return double_;
    }

    private void addComponent(IDIYComponent<?> iDIYComponent, boolean bl) {
        int n;
        for (n = this.currentProject.getComponents().size(); n > 0 && ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass()).getZOrder() < ComponentProcessor.getInstance().extractComponentTypeFrom(this.currentProject.getComponents().get(n - 1).getClass()).getZOrder(); --n) {
        }
        if (n < this.currentProject.getComponents().size()) {
            this.currentProject.getComponents().add(n, iDIYComponent);
        } else {
            this.currentProject.getComponents().add(iDIYComponent);
        }
        if (bl && ConfigurationManager.getInstance().readBoolean("autoCreatePads", false) && !(iDIYComponent instanceof SolderPad)) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(SolderPad.class);
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                if (!iDIYComponent.isControlPointSticky(i)) continue;
                try {
                    IDIYComponent<?> iDIYComponent2 = this.instantiationManager.instantiateComponent(componentType, null, iDIYComponent.getControlPoint(i), this.currentProject).get(0);
                    iDIYComponent2.setControlPoint(iDIYComponent.getControlPoint(i), 0);
                    this.addComponent(iDIYComponent2, false);
                    continue;
                }
                catch (Exception exception) {
                    LOG.warn((Object)"Could not auto-create solder pad", (Throwable)exception);
                }
            }
        }
    }

    @Override
    public List<PropertyWrapper> getMutualSelectionProperties() {
        try {
            return ComponentProcessor.getInstance().getMutualSelectionProperties(this.selectedComponents);
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not get mutual selection properties", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPropertiesToSelection(List<PropertyWrapper> list) {
        block7: {
            LOG.debug((Object)String.format("applyPropertiesToSelection(%s)", list));
            Project project = this.currentProject.clone();
            try {
                for (IDIYComponent<?> iDIYComponent : this.selectedComponents) {
                    this.drawingManager.invalidateComponent(iDIYComponent);
                    for (PropertyWrapper propertyWrapper : list) {
                        if (!propertyWrapper.isChanged()) continue;
                        propertyWrapper.writeTo(iDIYComponent);
                    }
                }
                if (project.equals(this.currentProject)) break block7;
            }
            catch (Exception exception) {
                block8: {
                    try {
                        LOG.error((Object)"Could not apply selection properties", (Throwable)exception);
                        this.view.showMessage("Could not apply changes to the selection. Check the log for details.", "Error", 0);
                        if (project.equals(this.currentProject)) break block8;
                    }
                    catch (Throwable throwable) {
                        if (!project.equals(this.currentProject)) {
                            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
                            this.projectFileManager.notifyFileChange();
                        }
                        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
                        throw throwable;
                    }
                    this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
                    this.projectFileManager.notifyFileChange();
                }
                this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Selection"});
            this.projectFileManager.notifyFileChange();
        }
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    @Override
    public List<PropertyWrapper> getProjectProperties() {
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(Project.class);
        try {
            for (PropertyWrapper propertyWrapper : list) {
                propertyWrapper.readFrom(this.currentProject);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not get project properties", (Throwable)exception);
            return null;
        }
        Collections.sort(list, ComparatorFactory.getInstance().getPropertyNameComparator());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPropertiesToProject(List<PropertyWrapper> list) {
        block6: {
            LOG.debug((Object)String.format("applyPropertiesToProject(%s)", list));
            Project project = this.currentProject.clone();
            try {
                for (PropertyWrapper propertyWrapper : list) {
                    propertyWrapper.writeTo(this.currentProject);
                }
                if (project.equals(this.currentProject)) break block6;
            }
            catch (Exception exception) {
                block7: {
                    try {
                        LOG.error((Object)"Could not apply project properties", (Throwable)exception);
                        this.view.showMessage("Could not apply changes to the project. Check the log for details.", "Error", 0);
                        if (project.equals(this.currentProject)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!project.equals(this.currentProject)) {
                            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
                            this.projectFileManager.notifyFileChange();
                        }
                        this.drawingManager.fireZoomChanged();
                        throw throwable;
                    }
                    this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
                    this.projectFileManager.notifyFileChange();
                }
                this.drawingManager.fireZoomChanged();
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.PROJECT_MODIFIED, new Object[]{project, this.currentProject.clone(), "Edit Project"});
            this.projectFileManager.notifyFileChange();
        }
        this.drawingManager.fireZoomChanged();
    }

    @Override
    public ComponentType getNewComponentTypeSlot() {
        return this.instantiationManager.getComponentTypeSlot();
    }

    @Override
    public void setNewComponentTypeSlot(ComponentType componentType, Template template) {
        LOG.info((Object)String.format("setNewComponentSlot(%s)", componentType == null ? null : componentType.getName()));
        try {
            this.instantiationManager.setComponentTypeSlot(componentType, template, this.currentProject);
            if (componentType != null) {
                this.updateSelection(EMPTY_SELECTION);
            }
            this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
            this.messageDispatcher.dispatchMessage((Enum)EventType.SLOT_CHANGED, new Object[]{this.instantiationManager.getComponentTypeSlot(), this.instantiationManager.getFirstControlPoint()});
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not set component type slot", (Throwable)exception);
            this.view.showMessage("Could not set component type slot. Check log for details.", "Error", 0);
        }
    }

    @Override
    public void saveSelectedComponentAsTemplate(String string) {
        int n;
        String string2;
        ArrayList<Object> arrayList;
        LOG.info((Object)String.format("saveSelectedComponentAsTemplate(%s)", string));
        if (this.selectedComponents.size() != 1) {
            throw new RuntimeException("Can only save a single component as a template at once.");
        }
        IDIYComponent<?> iDIYComponent = this.selectedComponents.iterator().next();
        ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("templates", null);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if ((arrayList = (ArrayList<Object>)hashMap.get(string2 = componentType.getCategory() + "." + componentType.getName())) == null) {
            arrayList = new ArrayList<Object>();
            hashMap.put(string2, arrayList);
        }
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(iDIYComponent.getClass());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (PropertyWrapper propertyWrapper : list) {
            if (propertyWrapper.getName().equalsIgnoreCase("name")) continue;
            try {
                propertyWrapper.readFrom(iDIYComponent);
                hashMap2.put(propertyWrapper.getName(), propertyWrapper.getValue());
            }
            catch (Exception exception) {}
        }
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < iDIYComponent.getControlPointCount(); ++n) {
            Point point = new Point(iDIYComponent.getControlPoint(n));
            arrayList2.add(point);
        }
        n = ((Point)arrayList2.iterator().next()).x;
        int n2 = ((Point)arrayList2.iterator().next()).y;
        Object object = arrayList2.iterator();
        while (object.hasNext()) {
            Point point = (Point)object.next();
            point.translate(-n, -n2);
        }
        object = new Template(string, hashMap2, arrayList2);
        boolean bl = false;
        for (Object object2 : arrayList) {
            if (!((Template)object2).getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            Object object2;
            int n3 = this.view.showConfirmDialog("Template with that name already exists. Overwrite?", "Save as Template", 0, 2);
            if (n3 != 0) {
                return;
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Template template = (Template)object2.next();
                if (!template.getName().equalsIgnoreCase(string)) continue;
                object2.remove();
            }
        }
        arrayList.add(object);
        ConfigurationManager.getInstance().writeValue("templates", hashMap);
    }

    @Override
    public List<Template> getTemplatesFor(String string, String string2) {
        Map map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
        if (map != null) {
            return (List)map.get(string + "." + string2);
        }
        return null;
    }

    @Override
    public void deleteTemplate(String string, String string2, String string3) {
        List list;
        Map map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
        if (map != null && (list = (List)map.get(string + "." + string2)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Template template = (Template)iterator.next();
                if (!template.getName().equalsIgnoreCase(string3)) continue;
                iterator.remove();
            }
        }
    }

    private Set<IDIYComponent<?>> getLockedComponents() {
        this.lockedComponents.clear();
        for (IDIYComponent<?> iDIYComponent : this.currentProject.getComponents()) {
            if (!this.isComponentLocked(iDIYComponent)) continue;
            this.lockedComponents.add(iDIYComponent);
        }
        return this.lockedComponents;
    }

    private boolean isComponentLocked(IDIYComponent<?> iDIYComponent) {
        ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
        return this.currentProject.getLockedLayers().contains((int)Math.round(componentType.getZOrder()));
    }

    private Point scalePoint(Point point) {
        return point == null ? null : new Point((int)((double)point.x / this.drawingManager.getZoomLevel()), (int)((double)point.y / this.drawingManager.getZoomLevel()));
    }

    static {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("update.xml"));
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            List list = (List)xStream.fromXML((InputStream)bufferedInputStream);
            bufferedInputStream.close();
            CURRENT_VERSION = ((Version)list.get(list.size() - 1)).getVersionNumber();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Could not find version number, using default", (Throwable)iOException);
        }
        EMPTY_SELECTION = Collections.emptyList();
    }
}

