/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.androlib.java.AndrolibJava;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.SmaliBuilder;
import brut.androlib.src.SmaliDecoder;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Androlib {
    private final AndrolibResources mAndRes = new AndrolibResources();
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private static final String SMALI_DIRNAME = "smali";
    private static final String APK_DIRNAME = "build/apk";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};
    private static final String VERSION = "1.3.2";

    public ResTable getResTable(ExtFile extFile) throws AndrolibException {
        return this.mAndRes.getResTable(extFile);
    }

    public void decodeSourcesRaw(ExtFile extFile, File file, boolean bl) throws AndrolibException {
        try {
            if (bl) {
                LOGGER.warning("Debug mode not available.");
            }
            Directory directory = extFile.getDirectory();
            LOGGER.info("Copying raw classes.dex file...");
            extFile.getDirectory().copyToDir(file, "classes.dex");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void decodeSourcesSmali(File file, File file2, boolean bl) throws AndrolibException {
        try {
            File file3 = new File(file2, SMALI_DIRNAME);
            OS.rmdir(file3);
            file3.mkdirs();
            LOGGER.info("Baksmaling...");
            SmaliDecoder.decode(file, file3, bl);
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public void decodeSourcesJava(ExtFile extFile, File file, boolean bl) throws AndrolibException {
        LOGGER.info("Decoding Java sources...");
        new AndrolibJava().decode(extFile, file);
    }

    public void decodeResourcesRaw(ExtFile extFile, File file) throws AndrolibException {
        try {
            Directory directory = extFile.getDirectory();
            LOGGER.info("Copying raw resources...");
            extFile.getDirectory().copyToDir(file, APK_RESOURCES_FILENAMES);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void decodeResourcesFull(ExtFile extFile, File file, ResTable resTable) throws AndrolibException {
        LOGGER.info("Decoding resources...");
        this.mAndRes.decode(resTable, extFile, file);
    }

    public void decodeRawFiles(ExtFile extFile, File file) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory directory = extFile.getDirectory();
            if (directory.containsDir("assets")) {
                directory.copyToDir(file, "assets");
            }
            if (directory.containsDir("lib")) {
                directory.copyToDir(file, "lib");
            }
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void writeMetaFile(File file, Map<String, Object> map) throws AndrolibException {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        try {
            yaml.dump(map, new FileWriter(new File(file, "apktool.yml")));
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    public Map<String, Object> readMetaFile(ExtFile extFile) throws AndrolibException {
        InputStream inputStream = null;
        try {
            inputStream = extFile.getDirectory().getFileInput("apktool.yml");
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(inputStream);
            return map;
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void build(File file, File file2, boolean bl, boolean bl2) throws AndrolibException {
        this.build(new ExtFile(file), file2, bl, bl2);
    }

    public void build(ExtFile extFile, File file, boolean bl, boolean bl2) throws AndrolibException {
        boolean bl3;
        Map<String, Object> map = this.readMetaFile(extFile);
        Object object = map.get("isFrameworkApk");
        boolean bl4 = bl3 = object == null ? false : (Boolean)object;
        if (file == null) {
            String string = (String)map.get("apkFileName");
            file = new File(extFile, "dist" + File.separator + (string == null ? "out.apk" : string));
        }
        new File(extFile, APK_DIRNAME).mkdirs();
        this.buildSources(extFile, bl, bl2);
        this.buildResources(extFile, bl, bl3, (Map)map.get("usesFramework"));
        this.buildLib(extFile, bl);
        this.buildApk(extFile, file, bl3);
    }

    public void buildSources(File file, boolean bl, boolean bl2) throws AndrolibException {
        if (!(this.buildSourcesRaw(file, bl, bl2) || this.buildSourcesSmali(file, bl, bl2) || this.buildSourcesJava(file, bl, bl2))) {
            LOGGER.warning("Could not find sources");
        }
    }

    public boolean buildSourcesRaw(File file, boolean bl, boolean bl2) throws AndrolibException {
        try {
            File file2 = new File(file, "classes.dex");
            if (!file2.exists()) {
                return false;
            }
            if (bl2) {
                LOGGER.warning("Debug mode not available.");
            }
            File file3 = new File(file, "build/apk/classes.dex");
            if (bl || this.isModified(file2, file3)) {
                LOGGER.info("Copying classes.dex file...");
                BrutIO.copyAndClose(new FileInputStream(file2), new FileOutputStream(file3));
            }
            return true;
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    public boolean buildSourcesSmali(File file, boolean bl, boolean bl2) throws AndrolibException {
        ExtFile extFile = new ExtFile(file, SMALI_DIRNAME);
        if (!extFile.exists()) {
            return false;
        }
        File file2 = new File(file, "build/apk/classes.dex");
        if (!bl) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (bl || this.isModified(extFile, file2)) {
            LOGGER.info("Smaling...");
            file2.delete();
            SmaliBuilder.build(extFile, file2, bl2);
        }
        return true;
    }

    public boolean buildSourcesJava(File file, boolean bl, boolean bl2) throws AndrolibException {
        File file2 = new File(file, "src");
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(file, "build/apk/classes.dex");
        if (!bl) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (bl || this.isModified(file2, file3)) {
            LOGGER.info("Building java sources...");
            file3.delete();
            new AndrolibJava().build(file2, file3);
        }
        return true;
    }

    public void buildResources(ExtFile extFile, boolean bl, boolean bl2, Map<String, Object> map) throws AndrolibException {
        if (!this.buildResourcesRaw(extFile, bl) && !this.buildResourcesFull(extFile, bl, bl2, map)) {
            LOGGER.warning("Could not find resources");
        }
    }

    public boolean buildResourcesRaw(ExtFile extFile, boolean bl) throws AndrolibException {
        try {
            if (!new File(extFile, "resources.arsc").exists()) {
                return false;
            }
            File file = new File(extFile, APK_DIRNAME);
            if (!bl) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (bl || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, extFile), this.newFiles(APK_RESOURCES_FILENAMES, file))) {
                LOGGER.info("Copying raw resources...");
                extFile.getDirectory().copyToDir(file, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public boolean buildResourcesFull(File file, boolean bl, boolean bl2, Map<String, Object> map) throws AndrolibException {
        try {
            if (!new File(file, "res").exists()) {
                return false;
            }
            if (!bl) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File file2 = new File(file, APK_DIRNAME);
            if (bl || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, file), this.newFiles(APK_RESOURCES_FILENAMES, file2))) {
                LOGGER.info("Building resources...");
                File file3 = File.createTempFile("APKTOOL", null);
                file3.delete();
                File file4 = new File(file, "9patch");
                if (!file4.exists()) {
                    file4 = null;
                }
                this.mAndRes.aaptPackage(file3, new File(file, "AndroidManifest.xml"), new File(file, "res"), file4, null, this.parseUsesFramework(map), false, bl2);
                Directory directory = new ExtFile(file3).getDirectory();
                directory.copyToDir(file2, directory.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
            }
            return true;
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void buildLib(File file, boolean bl) throws AndrolibException {
        File file2 = new File(file, "lib");
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file, "build/apk/lib");
        if (bl || this.isModified(file2, file3)) {
            LOGGER.info("Copying libs...");
            try {
                OS.rmdir(file3);
                OS.cpdir(file2, file3);
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
        }
    }

    public void buildApk(File file, File file2, boolean bl) throws AndrolibException {
        File file3;
        LOGGER.info("Building apk file...");
        if (file2.exists()) {
            file2.delete();
        } else {
            file3 = file2.getParentFile();
            if (file3 != null && !file3.exists()) {
                file3.mkdirs();
            }
        }
        file3 = new File(file, "assets");
        if (!file3.exists()) {
            file3 = null;
        }
        this.mAndRes.aaptPackage(file2, null, null, new File(file, APK_DIRNAME), file3, null, false, bl);
    }

    public void publicizeResources(File file) throws AndrolibException {
        this.mAndRes.publicizeResources(file);
    }

    public void installFramework(File file, String string) throws AndrolibException {
        this.mAndRes.installFramework(file, string);
    }

    public boolean isFrameworkApk(ResTable resTable) {
        for (ResPackage resPackage : resTable.listMainPackages()) {
            if (resPackage.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public static String getVersion() {
        return VERSION;
    }

    private File[] parseUsesFramework(Map<String, Object> map) throws AndrolibException {
        if (map == null) {
            return null;
        }
        List list = (List)map.get("ids");
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = (String)map.get("tag");
        File[] fileArray = new File[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            fileArray[n++] = this.mAndRes.getFrameworkApk(n2, string);
        }
        return fileArray;
    }

    private boolean isModified(File file, File file2) {
        if (!file2.exists()) {
            return true;
        }
        return BrutIO.recursiveModifiedTime(file) > BrutIO.recursiveModifiedTime(file2);
    }

    private boolean isModified(File[] fileArray, File[] fileArray2) {
        for (int i = 0; i < fileArray2.length; ++i) {
            if (fileArray2[i].exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(fileArray) > BrutIO.recursiveModifiedTime(fileArray2);
    }

    private File[] newFiles(String[] stringArray, File file) {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(file, stringArray[i]);
        }
        return fileArray;
    }
}

