/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Collections;
import java.util.List;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

public class AnnotationDirectoryItem
extends Item<AnnotationDirectoryItem> {
    private AnnotationSetItem classAnnotations;
    private FieldIdItem[] fieldAnnotationFields;
    private AnnotationSetItem[] fieldAnnotations;
    private MethodIdItem[] methodAnnotationMethods;
    private AnnotationSetItem[] methodAnnotations;
    private MethodIdItem[] parameterAnnotationMethods;
    private AnnotationSetRefList[] parameterAnnotations;
    private ClassDefItem parent = null;

    protected AnnotationDirectoryItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationDirectoryItem(DexFile dexFile, AnnotationSetItem annotationSetItem, FieldIdItem[] fieldIdItemArray, AnnotationSetItem[] annotationSetItemArray, MethodIdItem[] methodIdItemArray, AnnotationSetItem[] annotationSetItemArray2, MethodIdItem[] methodIdItemArray2, AnnotationSetRefList[] annotationSetRefListArray) {
        super(dexFile);
        this.classAnnotations = annotationSetItem;
        this.fieldAnnotationFields = fieldIdItemArray;
        this.fieldAnnotations = annotationSetItemArray;
        this.methodAnnotationMethods = methodIdItemArray;
        this.methodAnnotations = annotationSetItemArray2;
        this.parameterAnnotationMethods = methodIdItemArray2;
        this.parameterAnnotations = annotationSetRefListArray;
    }

    public static AnnotationDirectoryItem internAnnotationDirectoryItem(DexFile dexFile, AnnotationSetItem annotationSetItem, List<FieldAnnotation> list, List<MethodAnnotation> list2, List<ParameterAnnotation> list3) {
        int n;
        FieldIdItem[] fieldIdItemArray = null;
        AnnotationSetItem[] annotationSetItemArray = null;
        MethodIdItem[] methodIdItemArray = null;
        AnnotationSetItem[] annotationSetItemArray2 = null;
        MethodIdItem[] methodIdItemArray2 = null;
        AnnotationSetRefList[] annotationSetRefListArray = null;
        if (list != null && list.size() > 0) {
            fieldIdItemArray = new FieldIdItem[list.size()];
            annotationSetItemArray = new AnnotationSetItem[list.size()];
            Collections.sort(list);
            n = 0;
            for (FieldAnnotation comparable : list) {
                fieldIdItemArray[n] = comparable.field;
                annotationSetItemArray[n++] = comparable.annotationSet;
            }
        }
        if (list2 != null && list2.size() > 0) {
            methodIdItemArray = new MethodIdItem[list2.size()];
            annotationSetItemArray2 = new AnnotationSetItem[list2.size()];
            Collections.sort(list2);
            n = 0;
            for (MethodAnnotation methodAnnotation : list2) {
                methodIdItemArray[n] = methodAnnotation.method;
                annotationSetItemArray2[n++] = methodAnnotation.annotationSet;
            }
        }
        if (list3 != null && list3.size() > 0) {
            methodIdItemArray2 = new MethodIdItem[list3.size()];
            annotationSetRefListArray = new AnnotationSetRefList[list3.size()];
            Collections.sort(list3);
            n = 0;
            for (ParameterAnnotation parameterAnnotation : list3) {
                methodIdItemArray2[n] = parameterAnnotation.method;
                annotationSetRefListArray[n++] = parameterAnnotation.annotationSet;
            }
        }
        AnnotationDirectoryItem annotationDirectoryItem = new AnnotationDirectoryItem(dexFile, annotationSetItem, fieldIdItemArray, annotationSetItemArray, methodIdItemArray, annotationSetItemArray2, methodIdItemArray2, annotationSetRefListArray);
        return dexFile.AnnotationDirectoriesSection.intern(annotationDirectoryItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n;
        this.classAnnotations = (AnnotationSetItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, input.readInt());
        this.fieldAnnotationFields = new FieldIdItem[input.readInt()];
        this.fieldAnnotations = new AnnotationSetItem[this.fieldAnnotationFields.length];
        this.methodAnnotationMethods = new MethodIdItem[input.readInt()];
        this.methodAnnotations = new AnnotationSetItem[this.methodAnnotationMethods.length];
        this.parameterAnnotationMethods = new MethodIdItem[input.readInt()];
        this.parameterAnnotations = new AnnotationSetRefList[this.parameterAnnotationMethods.length];
        for (n = 0; n < this.fieldAnnotations.length; ++n) {
            try {
                this.fieldAnnotationFields[n] = this.dexFile.FieldIdsSection.getItemByIndex(input.readInt());
                this.fieldAnnotations[n] = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, input.readInt());
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error occured while reading FieldAnnotation at index " + n);
            }
        }
        for (n = 0; n < this.methodAnnotations.length; ++n) {
            try {
                this.methodAnnotationMethods[n] = this.dexFile.MethodIdsSection.getItemByIndex(input.readInt());
                this.methodAnnotations[n] = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, input.readInt());
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error occured while reading MethodAnnotation at index " + n);
            }
        }
        for (n = 0; n < this.parameterAnnotations.length; ++n) {
            try {
                this.parameterAnnotationMethods[n] = this.dexFile.MethodIdsSection.getItemByIndex(input.readInt());
                this.parameterAnnotations[n] = (AnnotationSetRefList)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_REF_LIST, input.readInt());
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error occured while reading ParameterAnnotation at index " + n);
            }
        }
    }

    @Override
    protected int placeItem(int n) {
        return n + 16 + ((this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length) + (this.methodAnnotations == null ? 0 : this.methodAnnotations.length) + (this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length)) * 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        int n;
        if (annotatedOutput.annotates()) {
            int n2;
            int n3;
            if (!this.isInternable() && this.parent != null) {
                annotatedOutput.annotate(0, this.parent.getClassType().getTypeDescriptor());
            }
            if (this.classAnnotations != null) {
                annotatedOutput.annotate(4, "class_annotations_off: 0x" + Integer.toHexString(this.classAnnotations.getOffset()));
            } else {
                annotatedOutput.annotate(4, "class_annotations_off:");
            }
            n = this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length;
            annotatedOutput.annotate(4, "annotated_fields_size: 0x" + Integer.toHexString(n) + " (" + n + ")");
            n = this.methodAnnotations == null ? 0 : this.methodAnnotations.length;
            annotatedOutput.annotate(4, "annotated_methods_size: 0x" + Integer.toHexString(n) + " (" + n + ")");
            n = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
            annotatedOutput.annotate(4, "annotated_parameters_size: 0x" + Integer.toHexString(n) + " (" + n + ")");
            if (this.fieldAnnotations != null) {
                n3 = 0;
                for (n2 = 0; n2 < this.fieldAnnotations.length; ++n2) {
                    annotatedOutput.annotate(0, "[" + n3++ + "] field_annotation");
                    annotatedOutput.indent();
                    annotatedOutput.annotate(4, "field: " + this.fieldAnnotationFields[n2].getFieldName().getStringValue() + ":" + this.fieldAnnotationFields[n2].getFieldType().getTypeDescriptor());
                    annotatedOutput.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.fieldAnnotations[n2].getOffset()));
                    annotatedOutput.deindent();
                }
            }
            if (this.methodAnnotations != null) {
                n3 = 0;
                for (n2 = 0; n2 < this.methodAnnotations.length; ++n2) {
                    annotatedOutput.annotate(0, "[" + n3++ + "] method_annotation");
                    annotatedOutput.indent();
                    annotatedOutput.annotate(4, "method: " + this.methodAnnotationMethods[n2].getMethodString());
                    annotatedOutput.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.methodAnnotations[n2].getOffset()));
                    annotatedOutput.deindent();
                }
            }
            if (this.parameterAnnotations != null) {
                n3 = 0;
                for (n2 = 0; n2 < this.parameterAnnotations.length; ++n2) {
                    annotatedOutput.annotate(0, "[" + n3++ + "] parameter_annotation");
                    annotatedOutput.indent();
                    annotatedOutput.annotate(4, "method: " + this.parameterAnnotationMethods[n2].getMethodString());
                    annotatedOutput.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.parameterAnnotations[n2].getOffset()));
                }
            }
        }
        annotatedOutput.writeInt(this.classAnnotations == null ? 0 : this.classAnnotations.getOffset());
        annotatedOutput.writeInt(this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length);
        annotatedOutput.writeInt(this.methodAnnotations == null ? 0 : this.methodAnnotations.length);
        annotatedOutput.writeInt(this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length);
        if (this.fieldAnnotations != null) {
            for (n = 0; n < this.fieldAnnotations.length; ++n) {
                annotatedOutput.writeInt(this.fieldAnnotationFields[n].getIndex());
                annotatedOutput.writeInt(this.fieldAnnotations[n].getOffset());
            }
        }
        if (this.methodAnnotations != null) {
            for (n = 0; n < this.methodAnnotations.length; ++n) {
                annotatedOutput.writeInt(this.methodAnnotationMethods[n].getIndex());
                annotatedOutput.writeInt(this.methodAnnotations[n].getOffset());
            }
        }
        if (this.parameterAnnotations != null) {
            for (n = 0; n < this.parameterAnnotations.length; ++n) {
                annotatedOutput.writeInt(this.parameterAnnotationMethods[n].getIndex());
                annotatedOutput.writeInt(this.parameterAnnotations[n].getOffset());
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.getClassType() + ")";
    }

    @Override
    public int compareTo(AnnotationDirectoryItem annotationDirectoryItem) {
        if (!this.isInternable()) {
            if (!annotationDirectoryItem.isInternable()) {
                return this.parent.compareTo(annotationDirectoryItem.parent);
            }
            return -1;
        }
        if (!annotationDirectoryItem.isInternable()) {
            return 1;
        }
        return this.classAnnotations.compareTo(annotationDirectoryItem.classAnnotations);
    }

    public AnnotationSetItem getClassAnnotations() {
        return this.classAnnotations;
    }

    public void iterateFieldAnnotations(FieldAnnotationIteratorDelegate fieldAnnotationIteratorDelegate) {
        for (int i = 0; i < this.fieldAnnotationFields.length; ++i) {
            try {
                fieldAnnotationIteratorDelegate.processFieldAnnotations(this.fieldAnnotationFields[i], this.fieldAnnotations[i]);
                continue;
            }
            catch (Exception exception) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(exception, "Error occured while processing field annotations for field: " + this.fieldAnnotationFields[i].getFieldString()));
            }
        }
    }

    public int getFieldAnnotationCount() {
        return this.fieldAnnotationFields.length;
    }

    public void iterateMethodAnnotations(MethodAnnotationIteratorDelegate methodAnnotationIteratorDelegate) {
        for (int i = 0; i < this.methodAnnotationMethods.length; ++i) {
            try {
                methodAnnotationIteratorDelegate.processMethodAnnotations(this.methodAnnotationMethods[i], this.methodAnnotations[i]);
                continue;
            }
            catch (Exception exception) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(exception, "Error occured while processing method annotations for method: " + this.methodAnnotationMethods[i].getMethodString()));
            }
        }
    }

    public int getMethodAnnotationCount() {
        return this.methodAnnotationMethods.length;
    }

    public void iterateParameterAnnotations(ParameterAnnotationIteratorDelegate parameterAnnotationIteratorDelegate) {
        for (int i = 0; i < this.parameterAnnotationMethods.length; ++i) {
            try {
                parameterAnnotationIteratorDelegate.processParameterAnnotations(this.parameterAnnotationMethods[i], this.parameterAnnotations[i]);
                continue;
            }
            catch (Exception exception) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(exception, "Error occured while processing parameter annotations for method: " + this.parameterAnnotationMethods[i].getMethodString()));
            }
        }
    }

    public int getParameterAnnotationCount() {
        return this.parameterAnnotationMethods.length;
    }

    private boolean isInternable() {
        return !(this.classAnnotations == null || this.fieldAnnotations != null && this.fieldAnnotations.length != 0 || this.methodAnnotations != null && this.methodAnnotations.length != 0 || this.parameterAnnotations != null && this.parameterAnnotations.length != 0);
    }

    protected void setParent(ClassDefItem classDefItem) {
        this.parent = classDefItem;
    }

    public int hashCode() {
        if (!this.isInternable()) {
            return super.hashCode();
        }
        return this.classAnnotations.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AnnotationDirectoryItem annotationDirectoryItem = (AnnotationDirectoryItem)object;
        return this.compareTo(annotationDirectoryItem) == 0;
    }

    public static class ParameterAnnotation
    implements Comparable<ParameterAnnotation> {
        public final MethodIdItem method;
        public final AnnotationSetRefList annotationSet;

        public ParameterAnnotation(MethodIdItem methodIdItem, AnnotationSetRefList annotationSetRefList) {
            this.method = methodIdItem;
            this.annotationSet = annotationSetRefList;
        }

        @Override
        public int compareTo(ParameterAnnotation parameterAnnotation) {
            return this.method.compareTo(parameterAnnotation.method);
        }
    }

    public static class MethodAnnotation
    implements Comparable<MethodAnnotation> {
        public final MethodIdItem method;
        public final AnnotationSetItem annotationSet;

        public MethodAnnotation(MethodIdItem methodIdItem, AnnotationSetItem annotationSetItem) {
            this.method = methodIdItem;
            this.annotationSet = annotationSetItem;
        }

        @Override
        public int compareTo(MethodAnnotation methodAnnotation) {
            return this.method.compareTo(methodAnnotation.method);
        }
    }

    public static class FieldAnnotation
    implements Comparable<FieldAnnotation> {
        public final FieldIdItem field;
        public final AnnotationSetItem annotationSet;

        public FieldAnnotation(FieldIdItem fieldIdItem, AnnotationSetItem annotationSetItem) {
            this.field = fieldIdItem;
            this.annotationSet = annotationSetItem;
        }

        @Override
        public int compareTo(FieldAnnotation fieldAnnotation) {
            return this.field.compareTo(fieldAnnotation.field);
        }
    }

    public static interface ParameterAnnotationIteratorDelegate {
        public void processParameterAnnotations(MethodIdItem var1, AnnotationSetRefList var2);
    }

    public static interface MethodAnnotationIteratorDelegate {
        public void processMethodAnnotations(MethodIdItem var1, AnnotationSetItem var2);
    }

    public static interface FieldAnnotationIteratorDelegate {
        public void processFieldAnnotations(FieldIdItem var1, AnnotationSetItem var2);
    }
}

