/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction3rc
extends InstructionWithReference
implements RegisterRangeInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private short startReg;

    public Instruction3rc(Opcode opcode, short s, int n, Item item) {
        super(opcode, item);
        if (s >= 256) {
            throw new RuntimeException("regCount must be less than 256");
        }
        if (s < 0) {
            throw new RuntimeException("regCount cannot be negative");
        }
        if (n >= 65536) {
            throw new RuntimeException("The beginning register of the range must be less than 65536");
        }
        if (n < 0) {
            throw new RuntimeException("The beginning register of the range cannot be negative");
        }
        this.regCount = (byte)s;
        this.startReg = (short)n;
        Instruction3rc.checkItem(opcode, item, s);
    }

    private Instruction3rc(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
        super(dexFile, opcode, byArray, n);
        this.regCount = (byte)NumberUtils.decodeUnsignedByte(byArray[n + 1]);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(byArray, n + 4);
        Instruction3rc.checkItem(opcode, this.getReferencedItem(), this.getRegCount());
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regCount);
        annotatedOutput.writeShort(this.getReferencedItem().getIndex());
        annotatedOutput.writeShort(this.startReg);
    }

    @Override
    public Format getFormat() {
        return Format.Format3rc;
    }

    @Override
    public short getRegCount() {
        return (short)(this.regCount & 0xFF);
    }

    @Override
    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    private static void checkItem(Opcode opcode, Item item, int n) {
        if (opcode == Opcode.FILLED_NEW_ARRAY_RANGE) {
            String string = ((TypeIdItem)item).getTypeDescriptor();
            if (string.charAt(0) != '[') {
                throw new RuntimeException("The type must be an array type");
            }
            if (string.charAt(1) == 'J' || string.charAt(1) == 'D') {
                throw new RuntimeException("The type cannot be an array of longs or doubles");
            }
        } else if (opcode.value >= Opcode.INVOKE_VIRTUAL_RANGE.value && opcode.value <= Opcode.INVOKE_INTERFACE_RANGE.value) {
            MethodIdItem methodIdItem = (MethodIdItem)item;
            int n2 = methodIdItem.getPrototype().getParameterRegisterCount();
            if (opcode != Opcode.INVOKE_STATIC_RANGE) {
                ++n2;
            }
            if (n2 != n) {
                throw new RuntimeException("regCount does not match the number of arguments of the method");
            }
        }
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction3rc(dexFile, opcode, byArray, n);
        }
    }
}

