/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class AnnotationEncodedSubValue
extends EncodedValue {
    private int hashCode = 0;
    public final TypeIdItem annotationType;
    public final StringIdItem[] names;
    public final EncodedValue[] values;

    public AnnotationEncodedSubValue(DexFile dexFile, Input input) {
        this.annotationType = dexFile.TypeIdsSection.getItemByIndex(input.readUnsignedLeb128());
        this.names = new StringIdItem[input.readUnsignedLeb128()];
        this.values = new EncodedValue[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = dexFile.StringIdsSection.getItemByIndex(input.readUnsignedLeb128());
            this.values[i] = EncodedValue.readEncodedValue(dexFile, input);
        }
    }

    public AnnotationEncodedSubValue(TypeIdItem typeIdItem, StringIdItem[] stringIdItemArray, EncodedValue[] encodedValueArray) {
        this.annotationType = typeIdItem;
        if (stringIdItemArray.length != encodedValueArray.length) {
            throw new RuntimeException("The names and values parameters must be the same length");
        }
        this.names = stringIdItemArray;
        this.values = encodedValueArray;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        annotatedOutput.annotate("annotation_type: " + this.annotationType.getTypeDescriptor());
        annotatedOutput.writeUnsignedLeb128(this.annotationType.getIndex());
        annotatedOutput.annotate("element_count: 0x" + Integer.toHexString(this.names.length) + " (" + this.names.length + ")");
        annotatedOutput.writeUnsignedLeb128(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            annotatedOutput.annotate(0, "[" + i + "] annotation_element");
            annotatedOutput.indent();
            annotatedOutput.annotate("element_name: " + this.names[i].getStringValue());
            annotatedOutput.writeUnsignedLeb128(this.names[i].getIndex());
            annotatedOutput.annotate(0, "element_value:");
            annotatedOutput.indent();
            this.values[i].writeValue(annotatedOutput);
            annotatedOutput.deindent();
            annotatedOutput.deindent();
        }
    }

    @Override
    public int placeValue(int n) {
        n += Leb128Utils.unsignedLeb128Size(this.annotationType.getIndex());
        n += Leb128Utils.unsignedLeb128Size(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            n += Leb128Utils.unsignedLeb128Size(this.names[i].getIndex());
            n = this.values[i].placeValue(n);
        }
        return n;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        AnnotationEncodedSubValue annotationEncodedSubValue = (AnnotationEncodedSubValue)encodedValue;
        int n = this.annotationType.compareTo(annotationEncodedSubValue.annotationType);
        if (n != 0) {
            return n;
        }
        n = this.names.length - annotationEncodedSubValue.names.length;
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.names.length; ++i) {
            n = this.names[i].compareTo(annotationEncodedSubValue.names[i]);
            if (n != 0) {
                return n;
            }
            n = this.values[i].compareTo(annotationEncodedSubValue.values[i]);
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_ANNOTATION;
    }

    private void calcHashCode() {
        this.hashCode = this.annotationType.hashCode();
        for (int i = 0; i < this.names.length; ++i) {
            this.hashCode = 31 * this.hashCode + this.names[i].hashCode();
            this.hashCode = 31 * this.hashCode + this.values[i].hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }
}

