/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class CharEncodedValue
extends EncodedValue {
    public final char value;

    protected CharEncodedValue(Input input, byte by) {
        this.value = (char)EncodedValueUtils.decodeUnsignedIntegralValue(input.readBytes(by + 1));
    }

    public CharEncodedValue(char c) {
        this.value = c;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeUnsignedIntegralValue(this.value);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_CHAR.name() + ",value_arg=" + (byArray.length - 1));
            char[] cArray = Character.toChars(this.value);
            assert (cArray.length > 0);
            annotatedOutput.annotate(byArray.length, "value: 0x" + Integer.toHexString(this.value) + " '" + cArray[0] + "'");
        }
        annotatedOutput.writeByte(ValueType.VALUE_CHAR.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value) + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        CharEncodedValue charEncodedValue = (CharEncodedValue)encodedValue;
        return this.value < charEncodedValue.value ? -1 : (this.value > charEncodedValue.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_CHAR;
    }

    public int hashCode() {
        return this.value;
    }
}

