/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class IntEncodedValue
extends EncodedValue {
    public final int value;

    protected IntEncodedValue(Input input, byte by) {
        this.value = (int)EncodedValueUtils.decodeSignedIntegralValue(input.readBytes(by + 1));
    }

    public IntEncodedValue(int n) {
        this.value = n;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeSignedIntegralValue(this.value);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_INT.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: 0x" + Integer.toHexString(this.value) + " (" + this.value + ")");
        }
        annotatedOutput.writeByte(ValueType.VALUE_INT.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + EncodedValueUtils.getRequiredBytesForSignedIntegralValue(this.value) + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        IntEncodedValue intEncodedValue = (IntEncodedValue)encodedValue;
        return this.value < intEncodedValue.value ? -1 : (this.value > intEncodedValue.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_INT;
    }

    public int hashCode() {
        return this.value;
    }
}

