/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class MethodIdItem
extends Item<MethodIdItem> {
    private int hashCode = 0;
    private TypeIdItem classType;
    private ProtoIdItem methodPrototype;
    private StringIdItem methodName;
    private String cachedMethodString = null;
    private String cachedVirtualMethodString = null;

    protected MethodIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private MethodIdItem(DexFile dexFile, TypeIdItem typeIdItem, ProtoIdItem protoIdItem, StringIdItem stringIdItem) {
        this(dexFile);
        this.classType = typeIdItem;
        this.methodPrototype = protoIdItem;
        this.methodName = stringIdItem;
    }

    public static MethodIdItem internMethodIdItem(DexFile dexFile, TypeIdItem typeIdItem, ProtoIdItem protoIdItem, StringIdItem stringIdItem) {
        MethodIdItem methodIdItem = new MethodIdItem(dexFile, typeIdItem, protoIdItem, stringIdItem);
        return dexFile.MethodIdsSection.intern(methodIdItem);
    }

    public static MethodIdItem lookupMethodIdItem(DexFile dexFile, TypeIdItem typeIdItem, ProtoIdItem protoIdItem, StringIdItem stringIdItem) {
        MethodIdItem methodIdItem = new MethodIdItem(dexFile, typeIdItem, protoIdItem, stringIdItem);
        return dexFile.MethodIdsSection.getInternedItem(methodIdItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(input.readShort());
        this.methodPrototype = this.dexFile.ProtoIdsSection.getItemByIndex(input.readShort());
        this.methodName = this.dexFile.StringIdsSection.getItemByIndex(input.readInt());
    }

    @Override
    protected int placeItem(int n) {
        return n + 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(2, "class_type: " + this.classType.getTypeDescriptor());
            annotatedOutput.annotate(2, "method_prototype: " + this.methodPrototype.getPrototypeString());
            annotatedOutput.annotate(4, "method_name: " + this.methodName.getStringValue());
        }
        annotatedOutput.writeShort(this.classType.getIndex());
        annotatedOutput.writeShort(this.methodPrototype.getIndex());
        annotatedOutput.writeInt(this.methodName.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_METHOD_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "method_id_item: " + this.getMethodString();
    }

    @Override
    public int compareTo(MethodIdItem methodIdItem) {
        int n = this.classType.compareTo(methodIdItem.classType);
        if (n != 0) {
            return n;
        }
        n = this.methodName.compareTo(methodIdItem.methodName);
        if (n != 0) {
            return n;
        }
        return this.methodPrototype.compareTo(methodIdItem.methodPrototype);
    }

    public String getMethodString() {
        if (this.cachedMethodString == null) {
            String string = this.classType.getTypeDescriptor();
            String string2 = this.methodName.getStringValue();
            String string3 = this.methodPrototype.getPrototypeString();
            StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + string3.length() + 2);
            stringBuilder.append(string);
            stringBuilder.append("->");
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            this.cachedMethodString = stringBuilder.toString();
        }
        return this.cachedMethodString;
    }

    public String getVirtualMethodString() {
        if (this.cachedVirtualMethodString == null) {
            String string = this.methodName.getStringValue();
            String string2 = this.methodPrototype.getPrototypeString();
            StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
            stringBuilder.append(string);
            stringBuilder.append(string2);
            this.cachedVirtualMethodString = stringBuilder.toString();
        }
        return this.cachedVirtualMethodString;
    }

    public ProtoIdItem getPrototype() {
        return this.methodPrototype;
    }

    public StringIdItem getMethodName() {
        return this.methodName;
    }

    public TypeIdItem getContainingClass() {
        return this.classType;
    }

    private void calcHashCode() {
        this.hashCode = this.classType.hashCode();
        this.hashCode = 31 * this.hashCode + this.methodPrototype.hashCode();
        this.hashCode = 31 * this.hashCode + this.methodName.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MethodIdItem methodIdItem = (MethodIdItem)object;
        return this.classType == methodIdItem.classType && this.methodPrototype == methodIdItem.methodPrototype && this.methodName == methodIdItem.methodName;
    }
}

