/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;
import org.jf.dexlib.Util.Utf8Utils;

public class StringDataItem
extends Item<StringDataItem> {
    private int hashCode = 0;
    private String stringValue;

    protected StringDataItem(DexFile dexFile) {
        super(dexFile);
    }

    private StringDataItem(DexFile dexFile, String string) {
        super(dexFile);
        this.stringValue = string;
    }

    public static StringDataItem internStringDataItem(DexFile dexFile, String string) {
        StringDataItem stringDataItem = new StringDataItem(dexFile, string);
        return dexFile.StringDataSection.intern(stringDataItem);
    }

    public static StringDataItem lookupStringDataItem(DexFile dexFile, String string) {
        StringDataItem stringDataItem = new StringDataItem(dexFile, string);
        return dexFile.StringDataSection.getInternedItem(stringDataItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        input.readUnsignedLeb128();
        this.stringValue = input.realNullTerminatedUtf8String();
    }

    @Override
    protected int placeItem(int n) {
        return n + Leb128Utils.unsignedLeb128Size(this.stringValue.length()) + Utf8Utils.stringToUtf8Bytes(this.stringValue).length + 1;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        byte[] byArray = Utf8Utils.stringToUtf8Bytes(this.stringValue);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate("string_size: 0x" + Integer.toHexString(this.stringValue.length()) + " (" + this.stringValue.length() + ")");
            annotatedOutput.writeUnsignedLeb128(this.stringValue.length());
            annotatedOutput.annotate(byArray.length + 1, "string_data: \"" + Utf8Utils.escapeString(this.stringValue) + "\"");
        } else {
            annotatedOutput.writeUnsignedLeb128(this.stringValue.length());
        }
        annotatedOutput.write(byArray);
        annotatedOutput.writeByte(0);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_STRING_DATA_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "string_data_item: \"" + Utf8Utils.escapeString(this.getStringValue()) + "\"";
    }

    @Override
    public int compareTo(StringDataItem stringDataItem) {
        return this.getStringValue().compareTo(stringDataItem.getStringValue());
    }

    public String getStringValue() {
        return this.stringValue;
    }

    private void calcHashCode() {
        this.hashCode = this.getStringValue().hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringDataItem stringDataItem = (StringDataItem)object;
        return this.getStringValue().equals(stringDataItem.getStringValue());
    }
}

