/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int n) {
        this.mKeys = new int[n];
        this.mValues = new Object[n];
        this.mSize = 0;
    }

    public E get(int n) {
        return this.get(n, null);
    }

    public E get(int n, E e) {
        int n2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 < 0 || this.mValues[n2] == DELETED) {
            return e;
        }
        return (E)this.mValues[n2];
    }

    public void delete(int n) {
        int n2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0 && this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int n) {
        this.delete(n);
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == DELETED) continue;
            if (i != n2) {
                nArray[n2] = nArray[i];
                objectArray[n2] = object;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public void put(int n, E e) {
        int n2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = e;
        } else {
            if ((n2 ^= 0xFFFFFFFF) < this.mSize && this.mValues[n2] == DELETED) {
                this.mKeys[n2] = n;
                this.mValues[n2] = e;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                n2 = ~SparseArray.binarySearch(this.mKeys, 0, this.mSize, n);
            }
            if (this.mSize >= this.mKeys.length) {
                int n3 = Math.max(this.mSize + 1, this.mKeys.length * 2);
                int[] nArray = new int[n3];
                Object[] objectArray = new Object[n3];
                System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
                this.mKeys = nArray;
                this.mValues = objectArray;
            }
            if (this.mSize - n2 != 0) {
                System.arraycopy(this.mKeys, n2, this.mKeys, n2 + 1, this.mSize - n2);
                System.arraycopy(this.mValues, n2, this.mValues, n2 + 1, this.mSize - n2);
            }
            this.mKeys[n2] = n;
            this.mValues[n2] = e;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public int indexOfKey(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, 0, this.mSize, n);
    }

    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != e) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int n, E e) {
        int n2;
        if (this.mSize != 0 && n <= this.mKeys[this.mSize - 1]) {
            this.put(n, e);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n2 = this.mSize) >= this.mKeys.length) {
            int n3 = Math.max(n2 + 1, this.mKeys.length * 2);
            int[] nArray = new int[n3];
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n2] = n;
        this.mValues[n2] = e;
        this.mSize = n2 + 1;
    }

    public void ensureCapacity(int n) {
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if (this.mKeys.length < n) {
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
    }

    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        if (n4 == n + n2) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) {
            return n4;
        }
        return ~n4;
    }

    public List<E> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.mValues));
    }
}

