/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.io.IOException;
import java.io.Writer;
import org.jf.dexlib.Util.Hex;

public final class Utf8Utils {
    private static char[] tempBuffer = null;

    public static byte[] stringToUtf8Bytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                byArray[n2] = (byte)c;
                ++n2;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2] = (byte)(c >> 6 & 0x1F | 0xC0);
                byArray[n2 + 1] = (byte)(c & 0x3F | 0x80);
                n2 += 2;
                continue;
            }
            byArray[n2] = (byte)(c >> 12 & 0xF | 0xE0);
            byArray[n2 + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            byArray[n2 + 2] = (byte)(c & 0x3F | 0x80);
            n2 += 3;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static String utf8BytesToString(byte[] byArray, int n, int n2) {
        if (tempBuffer == null || tempBuffer.length < n2) {
            tempBuffer = new char[n2];
        }
        char[] cArray = tempBuffer;
        int n3 = 0;
        int n4 = n;
        while (n2 > 0) {
            char c;
            int n5 = byArray[n4] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --n2;
                    if (n5 == 0) {
                        return Utf8Utils.throwBadUtf8(n5, n4);
                    }
                    c = (char)n5;
                    ++n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(n5, n4);
                    }
                    int n6 = byArray[n4 + 1] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    int n7 = (n5 & 0x1F) << 6 | n6 & 0x3F;
                    if (n7 != 0 && n7 < 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    c = (char)n7;
                    n4 += 2;
                    break;
                }
                case 14: {
                    if ((n2 -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(n5, n4);
                    }
                    int n6 = byArray[n4 + 1] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    int n7 = byArray[n4 + 2] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n7, n4 + 2);
                    }
                    int n8 = (n5 & 0xF) << 12 | (n6 & 0x3F) << 6 | n7 & 0x3F;
                    if (n8 < 2048) {
                        return Utf8Utils.throwBadUtf8(n7, n4 + 2);
                    }
                    c = (char)n8;
                    n4 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(n5, n4);
                }
            }
            cArray[n3] = c;
            ++n3;
        }
        return new String(cArray, 0, n3);
    }

    private static String throwBadUtf8(int n, int n2) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(n) + " at offset " + Hex.u4(n2));
    }

    public static void writeEscapedChar(Writer writer, char c) throws IOException {
        if (c >= ' ' && c < '\u007f') {
            if (c == '\'' || c == '\"' || c == '\\') {
                writer.write(92);
            }
            writer.write(c);
            return;
        }
        if (c <= '\u007f') {
            switch (c) {
                case '\n': {
                    writer.write("\\n");
                    return;
                }
                case '\r': {
                    writer.write("\\r");
                    return;
                }
                case '\t': {
                    writer.write("\\t");
                    return;
                }
            }
        }
        writer.write("\\u");
        writer.write(Character.forDigit(c >> 12, 16));
        writer.write(Character.forDigit(c >> 8 & 0xF, 16));
        writer.write(Character.forDigit(c >> 4 & 0xF, 16));
        writer.write(Character.forDigit(c & 0xF, 16));
    }

    /*
     * Unable to fully structure code
     */
    public static void writeEscapedString(Writer var0, String var1_1) throws IOException {
        block5: for (var2_2 = 0; var2_2 < var1_1.length(); ++var2_2) {
            var3_3 = var1_1.charAt(var2_2);
            if (var3_3 >= ' ' && var3_3 < '\u007f') {
                if (var3_3 == '\'' || var3_3 == '\"' || var3_3 == '\\') {
                    var0.write(92);
                }
                var0.write(var3_3);
                continue;
            }
            if (var3_3 > '\u007f') ** GOTO lbl-1000
            switch (var3_3) {
                case '\n': {
                    var0.write("\\n");
                    continue block5;
                }
                case '\r': {
                    var0.write("\\r");
                    continue block5;
                }
                case '\t': {
                    var0.write("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var0.write("\\u");
                    var0.write(Character.forDigit(var3_3 >> 12, 16));
                    var0.write(Character.forDigit(var3_3 >> 8 & 15, 16));
                    var0.write(Character.forDigit(var3_3 >> 4 & 15, 16));
                    var0.write(Character.forDigit(var3_3 & 15, 16));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeString(String var0) {
        var1_1 = var0.length();
        var2_2 = new StringBuilder(var1_1 * 3 / 2);
        block5: for (var3_3 = 0; var3_3 < var1_1; ++var3_3) {
            var4_4 = var0.charAt(var3_3);
            if (var4_4 >= ' ' && var4_4 < '\u007f') {
                if (var4_4 == '\'' || var4_4 == '\"' || var4_4 == '\\') {
                    var2_2.append('\\');
                }
                var2_2.append(var4_4);
                continue;
            }
            if (var4_4 > '\u007f') ** GOTO lbl-1000
            switch (var4_4) {
                case '\n': {
                    var2_2.append("\\n");
                    continue block5;
                }
                case '\r': {
                    var2_2.append("\\r");
                    continue block5;
                }
                case '\t': {
                    var2_2.append("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var2_2.append("\\u");
                    var2_2.append(Character.forDigit(var4_4 >> 12, 16));
                    var2_2.append(Character.forDigit(var4_4 >> 8 & 15, 16));
                    var2_2.append(Character.forDigit(var4_4 >> 4 & 15, 16));
                    var2_2.append(Character.forDigit(var4_4 & 15, 16));
                }
            }
        }
        return var2_2.toString();
    }
}

