/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConsoleUtil {
    public static int getConsoleWidth() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                return ConsoleUtil.attemptMode();
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return ConsoleUtil.attemptStty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 80;
    }

    private static int attemptStty() {
        String string = ConsoleUtil.attemptCommand(new String[]{"sh", "-c", "stty size < /dev/tty"});
        if (string == null) {
            return 80;
        }
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            return 80;
        }
        return Integer.parseInt(stringArray[1]);
    }

    private static int attemptMode() {
        String string = ConsoleUtil.attemptCommand(new String[]{"mode", "con"});
        if (string == null) {
            return 80;
        }
        Pattern pattern = Pattern.compile("Columns:[ \t]*(\\d+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return 80;
        }
        return Integer.parseInt(matcher.group(1));
    }

    private static String attemptCommand(String[] stringArray) {
        StringBuffer stringBuffer = null;
        try {
            String string;
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string);
            }
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

